/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.sftp;

import com.huawei.ism.common.bean.User;
import com.huawei.ism.connection.HisTLVConnection;
import com.huawei.ism.exception.IsmException;
import com.huawei.ism.tlv.TLV;
import com.huawei.ism.tlv.bean.Param;
import com.huawei.ism.tlv.bean.Record;
import com.huawei.ism.tool.obase.connection.mina.SshUtils;
import com.huawei.ism.tool.obase.utils.NetUtil;
import com.huawei.ism.tool.protocol.sftp.SftpTransfer;
import com.huawei.ism.util.VerifyUtil;
import com.huawei.sftp.HisSftpAccount;
import com.huawei.sftp.HisSftpTransferProgress;
import com.huawei.xve.utils.ConnManager;
import com.huawei.xve.utils.DeviceInfo;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.future.CancelOption;
import org.apache.sshd.sftp.client.SftpClient;
import org.apache.sshd.sftp.client.impl.DefaultSftpClientFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HisSftpTransfer {
    private static final Logger log = LoggerFactory.getLogger(HisSftpTransfer.class);
    public static final String SERVER_SPLITER = ":/";
    private static final int DEAFLUAT_PORT = 22;
    private static Map<String, Boolean> pingIpMap = new ConcurrentHashMap<String, Boolean>();
    private SftpClient channelSftp = null;
    private ClientSession session = null;
    private HisSftpTransferProgress sftpTansferProgress = new HisSftpTransferProgress();
    private int count = 0;
    private int timeout = 60;
    private int retry = 3;

    public HisSftpTransfer() {
    }

    public HisSftpTransfer(String serverIp, User user) {
        HisSftpAccount account = new HisSftpAccount(serverIp, user, 22);
        this.createSession(account);
    }

    public HisSftpTransfer(String serverIp, User user, int port) {
        HisSftpAccount account = new HisSftpAccount(serverIp, user, port);
        this.createSession(account);
    }

    public synchronized void setRetry(int retry) {
        this.retry = retry;
    }

    public synchronized void setTimeout(int tm) {
        this.timeout = tm;
    }

    public synchronized void closeConnection() {
        try {
            if (this.channelSftp != null) {
                this.channelSftp.close();
                this.channelSftp = null;
            }
            if (null != this.session) {
                this.session.close();
                this.session = null;
            }
        }
        catch (Exception e) {
            log.error("Close Sftp Error!", (Throwable)e);
        }
    }

    public synchronized Iterable<SftpClient.DirEntry> ls(String remotepath) {
        if (this.channelSftp == null) {
            throw new IsmException(1073949187L);
        }
        try {
            return this.channelSftp.listDir((SftpClient.Handle)this.channelSftp.openDir(remotepath));
        }
        catch (IOException e) {
            throw new IsmException(1073949187L, (Throwable)e);
        }
    }

    public int getCurrentStep() {
        long fileSize = this.sftpTansferProgress.getFileSize();
        long finishSize = this.sftpTansferProgress.getFinishSize();
        if (0L == fileSize) {
            return 0;
        }
        int currentStep = (int)(finishSize * 100L / fileSize);
        long tmp = finishSize * 100L % fileSize;
        if (tmp != 0L) {
            ++currentStep;
        }
        if (currentStep > 100) {
            currentStep = 100;
        }
        return currentStep;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void transferDirFromDevice(String arrayId, String serverPath, String localPath, User user) throws IsmException {
        log.info("transferFileFromDevice,serverDir:{};localDir {}", (Object)serverPath, (Object)localPath);
        int index = serverPath.indexOf(SERVER_SPLITER);
        String serverIp = serverPath.substring(0, index);
        String serverRelativePath = serverPath.substring(index + 1);
        try {
            DeviceInfo deviceInfo = ConnManager.getDeviceInfo(arrayId);
            HisSftpAccount account = new HisSftpAccount(serverIp, user, deviceInfo.getPort());
            this.createSession(account);
            Iterable entrys = this.channelSftp.listDir((SftpClient.Handle)this.channelSftp.openDir(serverRelativePath));
            for (SftpClient.DirEntry entry : entrys) {
                String fileName = entry.getFilename();
                try {
                    if (entry.getLongFilename().startsWith("dr")) continue;
                    this.transferFile(account, serverRelativePath + '/' + fileName, localPath, true);
                }
                finally {
                    this.closeConnection();
                }
            }
        }
        catch (IsmException e) {
            log.error("transferFileFromDevice fail once.user:{}", (Object)user);
            log.error("Sftp loadSftpUser Fail. serverIp:{}", (Object)serverIp);
            throw e;
        }
        catch (IOException e) {
            log.error("transferFileFromDevice fail once.user IOException:{}", (Throwable)e);
            throw new IsmException(1073949187L, (Throwable)e);
        }
        finally {
            this.closeConnection();
        }
        log.info("transferFileFromDevice over.");
    }

    public void transferFileFromDevice(String arrayId, String serverPath, String localPath) throws IsmException {
        log.info("transferFileFromDevice,The serverPath is: {};localPath is: {}", (Object)serverPath, (Object)localPath);
        int index = serverPath.indexOf(SERVER_SPLITER);
        if (-1 == index) {
            throw new IsmException(-1L);
        }
        String serverRelativePath = serverPath.substring(index + 1);
        this.transferFile(localPath, serverRelativePath);
        log.info("Returned file list information from OM: {}", (Object)serverRelativePath);
        log.info("transferFileFromDevice over.");
    }

    private synchronized void transferFile(String localPath, String serverRelativePath) {
        if (this.channelSftp == null) {
            throw new IsmException(1073949187L);
        }
        try {
            SftpTransfer.downloadFile((String)localPath, (String)serverRelativePath, (SftpClient)this.channelSftp);
        }
        catch (IOException e) {
            log.error("transferFile error ! sererPath:{} localPath:{}", new Object[]{serverRelativePath, localPath, e});
            throw new IsmException(1073949187L, (Throwable)e);
        }
    }

    public void transferFileFromDevice(String arrayId, String serverPath, String localPath, User user) throws IsmException {
        log.info("start to transferFile From Device,serverPath is: {} ;localPath is: {} ;The deviceId is: {}", new Object[]{serverPath.replaceFirst("/OSM", "/******"), localPath, arrayId});
        int index = serverPath.indexOf(SERVER_SPLITER);
        String serverIp = serverPath.substring(0, index);
        String serverRelativePath = serverPath.substring(index + 1);
        String[] ips = serverIp.split(",");
        int length = ips.length;
        try {
            HisSftpAccount account = null;
            if (ConnManager.getIsNewVersionHasManageIp(arrayId)) {
                log.info("The deviceInfo hos manage ip. Try to use end ip to sftp. Ip is: {}", (Object)ips[length - 1]);
                account = this.getNewSftpAccount(ips[length - 1], user, arrayId);
            } else {
                log.info("The deviceInfo hos no manage ip. Try to use fisrt ip to sftp. Ip is: {}", (Object)ips[0]);
                account = this.getNewSftpAccount(ips[0], user, arrayId);
            }
            this.transferFile(account, serverRelativePath, localPath, true);
        }
        catch (IsmException e) {
            log.error("Failed to sftp to serverIp.The exception is:", (Throwable)e);
            log.error("Try to sftp Use other serverIp.. Set the deviceInfo IsNewVersionHasManageIp false.");
            this.dealFailed(arrayId, ips, user, serverPath, localPath);
        }
        log.info("transferFileFromDevice over.");
    }

    private void dealFailed(String arrayId, String[] ips, User user, String serverPath, String localPath) {
        block4: {
            int length = ips.length;
            int index = serverPath.indexOf(SERVER_SPLITER);
            try {
                String serverRelativePath = serverPath.substring(index + 1);
                ConnManager.getDeviceInfo(arrayId).setIsNewVersionHasManageIp(false);
                HisSftpAccount accountaccount = this.getNewSftpAccount(ips[0], user, arrayId);
                this.transferFile(accountaccount, serverRelativePath, localPath, true);
            }
            catch (IsmException e1) {
                int copyIndex = serverPath.indexOf(",");
                String fileName = serverPath.substring(copyIndex + 1);
                String ip = ips[length - 1];
                String key = arrayId + "-" + ip;
                if (!pingIpMap.containsKey(key)) {
                    HisSftpTransfer.addIpToMap(22, ip, key, length);
                }
                if (!pingIpMap.containsKey(key) || pingIpMap.get(key).booleanValue()) break block4;
                log.info("the ip:{} is not reachable, try to change the ip from realtime", (Object)ip);
                String newPath = HisSftpTransfer.getNewFilePath(arrayId, fileName);
                if (newPath == null) {
                    return;
                }
                HisSftpAccount accountaccount = this.getNewSftpAccount(ips[0], user, arrayId);
                this.transferFile(accountaccount, newPath, localPath, true);
            }
        }
    }

    private static void addIpToMap(int port, String ip, String key, int length) {
        block2: {
            try {
                pingIpMap.put(key, length == 4 ? HisSftpTransfer.isSftpCanConnected(ip, port) : false);
            }
            catch (IsmException ee) {
                if (ee.getErrorId() != 1073949186L) break block2;
                throw ee;
            }
        }
    }

    private static String getNewFilePath(String arrayId, String fileName) {
        ArrayList<Param> params = new ArrayList<Param>(0);
        HisTLVConnection conn = ConnManager.getConnection(arrayId);
        Param copy = new Param(TLV.PERFORMANCE_STATISTIC_FILE.CMO_STATISTIC_FILE.getParamIndex(), TLV.PERFORMANCE_STATISTIC_FILE.CMO_STATISTIC_FILE.getParamType(), fileName);
        params.add(copy);
        List<Record> records = conn.getBatch(55847747632L, params);
        Iterator<Record> iterator = records.iterator();
        if (iterator.hasNext()) {
            Record record = iterator.next();
            int paramIndex1 = TLV.PERFORMANCE_STATISTIC_FILE.CMO_STATISTIC_FILE.getParamIndex();
            String file = record.getParamStrValue(paramIndex1);
            int newIndex = file.indexOf(SERVER_SPLITER);
            String newPath = file.substring(newIndex + 1);
            return newPath;
        }
        return null;
    }

    public static boolean isSftpCanConnected(String ip, int port) {
        if (null == ip || "".equals(ip)) {
            log.error("the param is empty");
            return false;
        }
        return NetUtil.isHostConnectable((String)ip, (int)port);
    }

    private HisSftpAccount getNewSftpAccount(String ipAddr, User userInfo, String deviceId) {
        DeviceInfo deviceInfo = ConnManager.getDeviceInfo(deviceId);
        HisSftpAccount account = new HisSftpAccount(ipAddr, userInfo, deviceInfo.getPort());
        return account;
    }

    public void transferFileToDevice(String arrayId, String localPath, String serverPath, User user) throws IsmException {
        log.info("transferFileToDevice,serverPath:{};localPath:{}", (Object)serverPath, (Object)localPath);
        int index = serverPath.indexOf(SERVER_SPLITER);
        String serverIp = serverPath.substring(0, index);
        String serverRelativePath = serverPath.substring(index + 1);
        try {
            DeviceInfo deviceInfo = ConnManager.getDeviceInfo(arrayId);
            HisSftpAccount account = new HisSftpAccount(serverIp, user, deviceInfo.getPort());
            this.transferFile(account, serverRelativePath, localPath, false);
        }
        catch (IsmException e) {
            log.error("transferFileToDevice error:{}", (Object)user);
            throw e;
        }
        finally {
            this.closeConnection();
        }
        log.info("transferFileToDevice over.");
    }

    private synchronized void transferFile(HisSftpAccount account, String serverRelativePath, String localPath, boolean getOrPut) throws IsmException {
        log.info("SftpTransfer transferFile.the parameter accountName is: {}", (Object)account.getUserName());
        try {
            this.createSession(account);
            if (VerifyUtil.isEmpty(this.channelSftp)) {
                log.error("channelSftp is null");
                throw new IsmException(1073949187L);
            }
            if (getOrPut) {
                SftpTransfer.downloadFile((String)localPath, (String)serverRelativePath, (SftpClient)this.channelSftp);
            } else {
                this.doUpload(serverRelativePath, localPath);
            }
        }
        catch (IsmException e) {
            log.error("Sftp Fail :{}", (Object)account, (Object)e);
            throw e;
        }
        catch (IOException e) {
            log.error("transferFile error ! sererPath:{}{} localPath:{} getOrPut:{}", new Object[]{account.getIpAddress(), serverRelativePath.replaceFirst("/OSM", "/******"), localPath, getOrPut, e});
            throw new IsmException(1073949187L, (Throwable)e);
        }
        log.info("SftpTransfer.transferFile {}{} over", (Object)(getOrPut ? "get " : "put "), (Object)serverRelativePath.replaceFirst("/OSM", "/******"));
    }

    public void doUpload(String serverPath, String localPath) throws IOException {
        SftpTransfer.uploadFile((String)localPath, (String)serverPath, (SftpClient)this.channelSftp);
    }

    private synchronized void createSession(HisSftpAccount account) throws IsmException {
        try {
            this.doCreatSession(account);
        }
        catch (IOException e) {
            this.handleExcption(e, account);
        }
    }

    private void handleExcption(IOException e, HisSftpAccount account) throws IsmException {
        ++this.count;
        log.error("try to connect to the sftp server failed, the {}th time.", (Object)this.count, (Object)e);
        if (this.count < this.retry) {
            this.createSession(account);
        }
        if (this.retry == this.count) {
            if (e.getMessage().equals("Auth fail") || e.getMessage().equals("Auth cancel")) {
                throw new IsmException(1073949186L, (Throwable)e);
            }
            throw new IsmException(1073949187L, (Throwable)e);
        }
    }

    private void doCreatSession(HisSftpAccount account) throws IOException {
        if (null != this.channelSftp) {
            log.info("account.getIpAddress: {}", (Object)account.getIpAddress());
            if (null != this.session && this.session.isOpen() && this.channelSftp.getSession().getConnectAddress().toString().contains(account.getIpAddress())) {
                log.info("the session is not null and Current ip has not changed.");
                this.count = 0;
                return;
            }
            log.info("the session is not null but Current ip has changed,so must to create new sftp channel.");
        }
        log.info("start to create new sftp channel.");
        this.session = SshUtils.getDefaultSession((String)account.getUserName(), (String)account.getIpAddress(), (int)account.getPort(), (String)account.getPassword());
        this.session.auth().verify((long)(this.timeout * 1000), new CancelOption[0]);
        this.channelSftp = DefaultSftpClientFactory.INSTANCE.createSftpClient(this.session);
        this.count = 0;
        log.info("end to create new sftp channel.");
    }

    public void s2300TransferFileFromDevice(String arrayId, String serverPath, String localPath, User user) throws IsmException {
        this.transferFileFromDevice(arrayId, serverPath, localPath, user);
    }
}

