/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.sftp;

import com.huawei.ism.common.resourcemanager.HisResourceManager;
import com.huawei.ism.connection.IConnection;
import com.huawei.ism.exception.IsmException;
import com.huawei.ism.tool.service.common.ToolThreadFactory;
import com.huawei.ism.util.CopyUtil;
import com.huawei.ism.util.StringUtils;
import com.huawei.ism.util.ThreadUtil;
import com.huawei.ism.util.VerifyUtil;
import com.huawei.sftp.AbstractSftp;
import com.huawei.sftp.ShellCMDExecutor;
import com.huawei.xve.MainDialog;
import com.huawei.xve.monitor.eservice.ResultHander;
import com.huawei.xve.monitor.eservice.task.DownloadIOTraceFileTask;
import com.huawei.xve.monitor.perfstat.PerfStatHistoryPane;
import com.huawei.xve.utils.DeviceInfo;
import com.huawei.xve.utils.IOTraceParam;
import com.huawei.xve.utils.IOTraceUtil;
import com.huawei.xve.utils.QuerInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class IOTraceSftp
extends AbstractSftp {
    private static final Logger LOGGER = Logger.getLogger(IOTraceSftp.class);
    private static final long LOOP_INTERVAL = TimeUnit.SECONDS.toMillis(30L);
    private static final long TEN_MINS = TimeUnit.MINUTES.toMillis(10L);
    private static final String SPLIT_ENTER = "\n";
    private static final String CHANGE_TO_DEVELOPER = "change user_mode current_mode user_mode=developer\n";
    private static final String DEVELOPER_CONFIRM = "DANGER: You are about to switch to the developer view.";
    private static final String DEVELOPER_CONFIRM_AGAIN = "Are you sure you really want to perform the operation?(y/n)";
    private static final String QUERY_LUN_INFO_PERF = "show lun general lun_id=";
    private static final String QUERY_LUN_INFO_END = "|filterColumn include columnList=Work\\sController";
    private static final String WORK_CONTROLLER = "Work Controller";
    private static final String LUN_NOT_EXIST_ERROR = "Error: The specified LUN does not exist.";
    private static final String QUERY_CPU_USAGE = "show performance controller controller_id_list=";
    private static final String CPU_USAGE_COLUMN = "CPU Usage(%)";
    private static final String ID_COLUMN = "ID";
    private static final String QUERY_IPS = "show upgrade package\n";
    private static final String IP_SPLIT = "HotPatch Version";
    private static final String NAME = "Name";
    private static final String IP = "IP";
    private static final String LEVEL = "Level";
    private static final String VERSION = "Current Version";
    private static final String SUPER_ADMIN = "Super_admin";
    private static final String ERROR = "Error";
    private static final String IOTRACE_PERF = "cache show obj ";
    private static final String IOTRACE_MID = " iotrace v ";
    private static final String IOTRACE_OBJ_NOT_FOUND_ERROR = "Obj not found";
    private static final String YES = "y\n";
    private static final String NO = "n\n";
    private static final String DEBUG = "debug\n";
    private static final String EXIT = "exit\n";
    private static final String SWITCH_OPEN = " 1 ";
    private static final String SWITCH_CLOSE = " 0 ";
    private static final String DEVELOPER_END_TAG = "developer:/>";
    private static final String MINISYSTEM = "minisystem\n";
    private static final String IPADDRESS_V4 = "(25[0-5]|2[0-4]\\d|[0-1]{1}\\d{2}|[1-9]{1}\\d{1}|[1-9])\\.(25[0-5]|2[0-4]\\d|[0-1]{1}\\d{2}|[1-9]{1}\\d{1}|[1-9]|0)\\.(25[0-5]|2[0-4]\\d|[0-1]{1}\\d{2}|[1-9]{1}\\d{1}|[1-9]|0)\\.(25[0-5]|2[0-4]\\d|[0-1]{1}\\d{2}|[1-9]{1}\\d{1}|\\d)";
    private static final String IOTRACE_COLLECT_MODE = " 0 ";
    private static final String QUERY_USER_AUTHORITY = "show user user_name=";
    private static final String SHOW_USER_USER_NAME = "show user user_name=%s%s";
    private Map<String, ShellCMDExecutor> shellMap = new HashMap<String, ShellCMDExecutor>();
    private Map<String, String> ipMap = new HashMap<String, String>();
    private Map<String, List<Long>> resMap = new HashMap<String, List<Long>>();
    private DeviceInfo di;
    private String userMode;
    private IConnection conn;
    private CountDownLatch countDownLatch;
    private String deviceVersion;
    private volatile boolean isRun = false;
    private volatile boolean isCollect = false;
    private volatile boolean isFinshed = false;
    private volatile boolean closeIOTraceSwitch = false;
    private volatile boolean immediateStop = false;

    public IOTraceSftp(DeviceInfo di, CountDownLatch countDownLatch) {
        super(di);
        this.di = di;
        this.userMode = di.getUserName() + ":/>";
        this.countDownLatch = countDownLatch;
    }

    public boolean isRun() {
        return this.isRun;
    }

    public String getDeviceVersion() {
        return this.deviceVersion;
    }

    public boolean isImmediateStop() {
        return this.immediateStop;
    }

    public void setImmediateStop(boolean isImmediateStop) {
        this.immediateStop = isImmediateStop;
    }

    public boolean isFinshed() {
        return this.isFinshed;
    }

    public void setFinshed(boolean isFinshedSign) {
        this.isFinshed = isFinshedSign;
    }

    public boolean isCollect() {
        return this.isCollect;
    }

    public void setCollect(boolean isCollectSign) {
        this.isCollect = isCollectSign;
    }

    public boolean isCloseIOTraceSwitch() {
        return this.closeIOTraceSwitch;
    }

    public Map<String, String> getIpMap() {
        return this.ipMap;
    }

    public Map<String, List<Long>> getResMap() {
        return this.resMap;
    }

    public void collectIOTrace() throws IsmException {
        if (!MainDialog.isRunByToolKit()) {
            ResultHander.getHander().update("progress", this.di.getIoTraceParam().getProgress(false) + "", true);
        }
        this.conn = IOTraceSftp.getConnection(this.di);
        if (null == this.conn) {
            throw new IsmException(102424L);
        }
        this.checkUserType();
        ShellCMDExecutor execute = this.getShellFromCache(this.di.getIp());
        this.queryAllIPs(execute);
        this.groupResByWorkSpace(execute);
        this.checkIPConnection();
        this.checkDeviceSpace();
        ToolThreadFactory.newDefaultThread((Runnable)new CollectIOTraceTask()).start();
    }

    private void checkDeviceSpace() {
        Iterator<String> it = this.resMap.keySet().iterator();
        List<String> errorIdList = this.di.getIoTraceParam().getErrorIdList();
        while (it.hasNext()) {
            String[] totalUseSizeInfos;
            String totalUseSize;
            String ctrlName = it.next();
            String ip = this.ipMap.get(ctrlName);
            ShellCMDExecutor execute = this.getShellFromCache(ip);
            this.switchToDeveloper(execute, true);
            this.execCmd(execute, EXIT);
            this.execCmd(execute, MINISYSTEM);
            String dir = IOTraceUtil.getSourceDirPath(this.di);
            this.execCmd(execute, "cd " + dir + SPLIT_ENTER);
            String result = this.execCmd(execute, "du -h\n");
            this.execCmd(execute, EXIT);
            this.execCmd(execute, YES);
            this.execCmd(execute, EXIT);
            String[] infos = result.split(SPLIT_ENTER);
            if (infos.length < 2 || IOTraceUtil.isCouldCreateFile(this.di, totalUseSize = (totalUseSizeInfos = infos[infos.length - 2].split("\t"))[0].trim())) continue;
            this.di.getIoTraceParam().getIOTraceErrMsg().setNotExportIPs(ip);
            this.clearErrorControlCache(errorIdList, ctrlName, ip);
            LOGGER.error((Object)("ip[" + ip + "] dir : " + dir + " useSize is" + totalUseSize));
        }
    }

    private void checkIPConnection() {
        Iterator<String> it = this.resMap.keySet().iterator();
        List<String> errorIdList = this.di.getIoTraceParam().getErrorIdList();
        while (it.hasNext()) {
            String ctrlName = it.next();
            String ip = this.ipMap.get(ctrlName);
            ShellCMDExecutor shell = this.getShellFromCache(ip);
            if (!VerifyUtil.isEmpty(shell)) continue;
            this.di.getIoTraceParam().getIOTraceErrMsg().setErrIPs(ip);
            List<Long> ids = this.clearErrorControlCache(errorIdList, ctrlName, ip);
            LOGGER.warn((Object)("can not connect to " + ip + ", download failed ids [" + ids.toString() + "]"));
        }
    }

    private List<Long> clearErrorControlCache(List<String> errorIdList, String ctrlName, String ip) {
        ShellCMDExecutor exe = this.shellMap.remove(ip);
        if (!VerifyUtil.isEmpty(exe)) {
            exe.release();
        }
        this.ipMap.remove(ctrlName);
        List<Long> ids = this.resMap.remove(ctrlName);
        for (Long id : ids) {
            errorIdList.add(id.toString());
        }
        return ids;
    }

    public void checkVersion(String version) throws IsmException {
        if (!IOTraceSftp.isSupportVersion(version)) {
            throw new IsmException(HisResourceManager.getString("IO_TRACE_DEVICE_NOT_SUPPORT"));
        }
    }

    public static boolean isSupportVersion(String version) {
        String v3r6Begin = HisResourceManager.getCfgProperties().getProperty("IOTRACE_V3R6_BEGIN_VERSION");
        if (PerfStatHistoryPane.isVersionAfter(version, v3r6Begin)) {
            return true;
        }
        String v3r3Begin = HisResourceManager.getCfgProperties().getProperty("IOTRACE_V3R3_BEGIN_VERSION");
        String common = v3r3Begin.substring(0, v3r3Begin.length() - 3);
        return version.contains(common) && PerfStatHistoryPane.isVersionAfter(version, v3r3Begin);
    }

    public ShellCMDExecutor getShellFromCache(String ip) throws IsmException {
        ShellCMDExecutor exe = this.shellMap.get(ip);
        try {
            if (VerifyUtil.isEmpty(exe)) {
                exe = this.initExec(ip);
            } else {
                exe.checkStatus();
            }
        }
        catch (IsmException e) {
            exe.release();
            exe = this.initExec(ip);
        }
        this.checkNull(exe);
        return exe;
    }

    private void checkNull(ShellCMDExecutor exe) {
        if (VerifyUtil.isEmpty(exe)) {
            LOGGER.error((Object)"ShellCMDExecutor is null.");
            throw new IsmException(HisResourceManager.getString("DEVICE_ERROR"));
        }
    }

    public void queryAllIPs(ShellCMDExecutor execute) throws IsmException {
        this.checkNull(execute);
        execute.isCMDReady();
        String result = this.execCmd(execute, QUERY_IPS);
        if (VerifyUtil.isEmpty(result) || !StringUtils.hasMatchStr(result, IPADDRESS_V4)) {
            LOGGER.error((Object)"query ip list failed.");
            throw new IsmException(HisResourceManager.getString("DEVICE_ERROR"));
        }
        String[] ips = result.split(IP_SPLIT);
        String[] ipInfo = ips[0].split(SPLIT_ENTER);
        int nameIndex = -1;
        int ipIndex = -1;
        int versionIndex = -1;
        for (String info : ipInfo) {
            if (!info.contains(NAME) || !info.contains(IP) || !info.contains(VERSION)) continue;
            nameIndex = info.indexOf(NAME);
            ipIndex = info.indexOf(IP);
            versionIndex = info.indexOf(VERSION);
            break;
        }
        if (!this.checkIndex(nameIndex, ipIndex, versionIndex)) {
            LOGGER.error((Object)"init ip list failed.");
            throw new IsmException(HisResourceManager.getString("DEVICE_ERROR"));
        }
        for (String info : ipInfo) {
            if (!StringUtils.hasMatchStr(info, IPADDRESS_V4)) continue;
            String name = this.findSpecialStr(info, nameIndex);
            String ip = this.findSpecialStr(info, ipIndex);
            this.deviceVersion = this.findSpecialStr(info, versionIndex);
            this.ipMap.put(name, ip);
        }
    }

    private String findSpecialStr(String source, int startIndex) {
        String substr = source.substring(startIndex);
        int endIndex = substr.indexOf(" ");
        if (endIndex < 0) {
            return "";
        }
        return substr.substring(0, endIndex).trim();
    }

    private boolean checkIndex(int ... indexs) {
        if (null == indexs) {
            return false;
        }
        for (int index : indexs) {
            if (index >= 0) continue;
            return false;
        }
        return true;
    }

    public void groupResByWorkSpace(ShellCMDExecutor execute) throws IsmException {
        IOTraceParam param = this.di.getIoTraceParam();
        List<Long> resIDList = param.getLunIDList();
        if (VerifyUtil.isEmpty(resIDList)) {
            LOGGER.error((Object)"resIDs is Empty.");
            throw new IsmException(HisResourceManager.getString("IO_TRACE_NOT_FOUND_RESOURCE"));
        }
        for (Long resID : resIDList) {
            String workSpace = this.queryWorkController(execute, resID);
            if (VerifyUtil.isEmpty(workSpace)) {
                param.getErrorIdList().add(resID.toString());
                LOGGER.error((Object)("The specified LUN does not exist. id : " + resID));
                continue;
            }
            this.putResMap(workSpace, resID);
        }
    }

    public void releaseAllShell() {
        if (VerifyUtil.isEmpty(this.shellMap)) {
            LOGGER.info((Object)"there is no shell need to release.");
            return;
        }
        for (Map.Entry<String, ShellCMDExecutor> en : this.shellMap.entrySet()) {
            ShellCMDExecutor shell = en.getValue();
            if (shell == null) continue;
            shell.release();
        }
    }

    private void putResMap(String workSpace, Long resID) {
        List<Long> resList = this.resMap.get(workSpace);
        if (null == resList) {
            resList = new ArrayList<Long>();
            this.resMap.put(workSpace, resList);
        }
        resList.add(resID);
    }

    private String queryWorkController(ShellCMDExecutor execute, long resId) {
        this.checkNull(execute);
        execute.isCMDReady();
        String queryWorkControlCmd = this.queryWorkControllerCMD(resId);
        String result = this.execCmd(execute, queryWorkControlCmd);
        if (VerifyUtil.isEmpty(result)) {
            LOGGER.error((Object)("query res info by id = " + resId + ", but get nothing."));
            return null;
        }
        if (result.contains(LUN_NOT_EXIST_ERROR)) {
            LOGGER.error((Object)("this res do not exist, id : " + resId));
            return null;
        }
        if (result.contains(ERROR)) {
            LOGGER.error((Object)("query res info failed. id : " + resId + " ,result[" + result + "]"));
            return null;
        }
        return this.processWorkSpaceStr(result);
    }

    private String processWorkSpaceStr(String result) {
        String[] strList;
        String workSpace = null;
        if (!result.contains(WORK_CONTROLLER)) {
            return workSpace;
        }
        for (String str : strList = result.split(SPLIT_ENTER)) {
            if (!str.contains(WORK_CONTROLLER)) continue;
            workSpace = str.split(":")[1].trim();
            break;
        }
        return workSpace;
    }

    private void checkUserType() throws IsmException {
        String[] userInfos;
        ShellCMDExecutor execute = this.initExec(this.di);
        if (execute == null) {
            LOGGER.error((Object)"execute value is null.");
            throw new IsmException("execute value is null.");
        }
        String userName = this.di.getUserName().trim();
        String cmd = String.format(Locale.ROOT, SHOW_USER_USER_NAME, QuerInfo.getUserName(this.di), SPLIT_ENTER);
        String result = this.execCmd(execute, cmd);
        if (VerifyUtil.isEmpty(result) || result.contains(ERROR)) {
            LOGGER.error((Object)("the user is illegality. userName = " + userName));
            throw new IsmException(HisResourceManager.getString("IO_TRACE_ILLEGAL_USER") + " : " + userName);
        }
        int lvIndex = -1;
        int nameIndex = -1;
        for (String info : userInfos = result.split(SPLIT_ENTER)) {
            if (!info.contains(NAME) || !info.contains(LEVEL)) continue;
            lvIndex = info.indexOf(LEVEL);
            nameIndex = info.indexOf(NAME);
            break;
        }
        if (!this.checkIndex(lvIndex)) {
            LOGGER.error((Object)"check user authority failed.");
            throw new IsmException(HisResourceManager.getString("DEVICE_ERROR"));
        }
        for (String info : userInfos) {
            String level;
            String name;
            if (!info.contains(userName) || info.contains(QUERY_USER_AUTHORITY) || info.trim().equals(this.userMode) || !userName.equals(name = this.findSpecialStr(info, nameIndex)) || LEVEL.equals(level = this.findSpecialStr(info, lvIndex))) continue;
            if (SUPER_ADMIN.equals(level)) break;
            throw new IsmException(HisResourceManager.getString("IO_TRACE_NOT_ENOUGH_AUTHORITY"));
        }
    }

    private void switchToDeveloper(ShellCMDExecutor execute, boolean isEnterDebug) throws IsmException {
        this.checkNull(execute);
        execute.isCMDReady();
        String result = this.execCmd(execute, CHANGE_TO_DEVELOPER);
        if (!VerifyUtil.isEmpty(result) && result.contains(DEVELOPER_END_TAG)) {
            if (!isEnterDebug) {
                this.execCmd(execute, EXIT);
            } else {
                this.execCmd(execute, DEBUG);
            }
            return;
        }
        if (VerifyUtil.isEmpty(result) || !result.contains(DEVELOPER_CONFIRM)) {
            LOGGER.error((Object)(this.di.getUserName() + "collect ioTrace failed."));
            throw new IsmException(HisResourceManager.getString("IO_TRACE_NOT_ENOUGH_AUTHORITY"));
        }
        if (!isEnterDebug) {
            this.execCmd(execute, NO);
            return;
        }
        String confirmInfo = this.execCmd(execute, YES);
        if (VerifyUtil.isEmpty(confirmInfo) || !confirmInfo.contains(DEVELOPER_CONFIRM_AGAIN)) {
            LOGGER.error((Object)(this.di.getUserName() + "collect ioTrace failed."));
            throw new IsmException(HisResourceManager.getString("DEVICE_ERROR"));
        }
        this.execCmd(execute, YES);
        this.execCmd(execute, DEBUG);
    }

    private String execCmd(ShellCMDExecutor execute, String Cmd) throws IsmException {
        this.checkNull(execute);
        execute.execCmd(Cmd, true);
        return execute.wait4Result(10000L);
    }

    private ShellCMDExecutor initExec(String ip) throws IsmException {
        ShellCMDExecutor exe = null;
        DeviceInfo deviceInfo = this.createDeviceInfo(ip);
        if (!VerifyUtil.isEmpty(deviceInfo)) {
            exe = this.initExec(deviceInfo);
        }
        return exe;
    }

    private ShellCMDExecutor initExec(DeviceInfo deviceInfo) throws IsmException {
        ShellCMDExecutor executor = null;
        try {
            executor = ShellCMDExecutor.getInstance(deviceInfo);
        }
        catch (IsmException e) {
            LOGGER.error((Object)("get shell executor failed. ip[" + deviceInfo.getIp() + "]"));
        }
        if (VerifyUtil.isEmpty(executor)) {
            return null;
        }
        executor.addEndTag(deviceInfo.getUserName() + ":/>");
        executor.addEndTag(deviceInfo.getUserName() + ":/diagnose>");
        executor.addEndTag("Storage: minisystem>");
        executor.addEndTag(DEVELOPER_END_TAG);
        executor.addEndTag("(y/n)");
        executor.addEndTag("(y/n)\n");
        executor.addEndTag("comma:");
        this.shellMap.put(deviceInfo.getIp(), executor);
        return executor;
    }

    private DeviceInfo createDeviceInfo(String ip) {
        if (ip.equals(this.di.getIp())) {
            return this.di;
        }
        DeviceInfo dev = CopyUtil.copyDevInfo(this.di, ip);
        if (!VerifyUtil.isEmpty(dev)) {
            dev.setIp(ip);
        }
        return dev;
    }

    private void startCollectIOTrace() throws IsmException {
        if (VerifyUtil.isEmpty(this.resMap)) {
            LOGGER.error((Object)"resMap is Empty.");
            throw new IsmException(HisResourceManager.getString("IO_TRACE_NOT_FOUND_RESOURCE"));
        }
        this.checkCPUUsage();
        for (Map.Entry<String, List<Long>> en : this.resMap.entrySet()) {
            List<Long> resList = en.getValue();
            if (VerifyUtil.isEmpty(resList)) continue;
            String ip = this.ipMap.get(en.getKey());
            ShellCMDExecutor exe = this.getShellFromCache(ip);
            if (VerifyUtil.isEmpty(exe)) {
                LOGGER.warn((Object)("connect to " + this.di.getIp() + "failed."));
                continue;
            }
            this.switchToDeveloper(exe, true);
            Iterator<Long> resIter = resList.iterator();
            while (resIter.hasNext()) {
                Long resId = resIter.next();
                this.openIOTraceSwitch(exe, resIter, resId, true);
            }
            this.backToLogin(exe);
        }
    }

    private void checkCPUUsage() {
        Set<String> keySet = this.resMap.keySet();
        String cmd = this.queryCPUUsage(keySet);
        ShellCMDExecutor exe = this.getShellFromCache(this.di.getIp());
        if (VerifyUtil.isEmpty(exe)) {
            LOGGER.warn((Object)("connect to " + this.di.getIp() + "failed."));
            return;
        }
        String result = this.execCmd(exe, cmd);
        if (VerifyUtil.isEmpty(result)) {
            LOGGER.error((Object)"get nothing when query controler cpu usage.");
            throw new IsmException(HisResourceManager.getString("DEVICE_ERROR"));
        }
        String[] columnList = result.split(SPLIT_ENTER);
        String cpuNum = null;
        for (String column : columnList) {
            if (!column.contains(CPU_USAGE_COLUMN)) continue;
            int last = column.indexOf(CPU_USAGE_COLUMN);
            String str = column.substring(0, last);
            int start = str.lastIndexOf(" ");
            cpuNum = str.substring(start + 1, str.length() - 1);
            break;
        }
        if (VerifyUtil.isEmpty(cpuNum)) {
            LOGGER.error((Object)"can not find controler cpu serial number.");
            throw new IsmException(HisResourceManager.getString("DEVICE_ERROR"));
        }
        String cpuUsageTable = this.execCmd(exe, cpuNum + SPLIT_ENTER);
        if (VerifyUtil.isEmpty(cpuUsageTable)) {
            LOGGER.error((Object)"can not find controler cpu usage data.");
            throw new IsmException(HisResourceManager.getString("DEVICE_ERROR"));
        }
        if (cpuUsageTable.contains(CPU_USAGE_COLUMN) && cpuUsageTable.contains(ID_COLUMN)) {
            this.checkMultsCpuUsage(keySet, cpuUsageTable);
            return;
        }
        this.checkSigleCpuUsage(keySet, cpuUsageTable);
    }

    private void checkSigleCpuUsage(Set<String> keySet, String cpuUsageTable) {
        String[] cpuUsages;
        for (String row : cpuUsages = cpuUsageTable.split(SPLIT_ENTER)) {
            if (!row.contains(CPU_USAGE_COLUMN)) continue;
            String cpuNumStr = row.split(":")[1].trim();
            this.checkCPUNum(new ArrayList<String>(keySet).get(0), cpuNumStr);
            break;
        }
    }

    private void checkMultsCpuUsage(Set<String> keySet, String cpuUsageTable) {
        String[] cpuUsages = cpuUsageTable.split(SPLIT_ENTER);
        int cpuIndex = -1;
        int idIndex = -1;
        for (String row : cpuUsages) {
            if (!row.contains(CPU_USAGE_COLUMN) || !row.contains(ID_COLUMN)) continue;
            cpuIndex = row.indexOf(CPU_USAGE_COLUMN);
            idIndex = row.indexOf(ID_COLUMN);
            break;
        }
        if (!this.checkIndex(cpuIndex, idIndex)) {
            LOGGER.error((Object)"query controler cpu usage data failed.");
            throw new IsmException(HisResourceManager.getString("DEVICE_ERROR"));
        }
        for (String row : cpuUsages) {
            String controlName;
            if (row.length() < idIndex || !keySet.contains(controlName = this.findSpecialStr(row, idIndex))) continue;
            String cpuStr = this.findSpecialStr(row, cpuIndex);
            this.checkCPUNum(controlName, cpuStr);
        }
    }

    private void checkCPUNum(String controlName, String cpuStr) {
        int cpu = -1;
        try {
            cpu = Integer.parseInt(cpuStr);
        }
        catch (NumberFormatException e) {
            LOGGER.error((Object)"parse number failed.", (Throwable)e);
        }
        if (cpu >= 60) {
            LOGGER.error((Object)("[" + controlName + "] cpu usage large is" + cpu + ", so stop collect task."));
            throw new IsmException(HisResourceManager.getString("IO_TRACE_CPU_TOO_HIGH"));
        }
    }

    private void stopCollectIOTrace() throws IsmException {
        if (VerifyUtil.isEmpty(this.resMap)) {
            LOGGER.error((Object)"resMap is Empty.");
            return;
        }
        for (Map.Entry<String, List<Long>> en : this.resMap.entrySet()) {
            List<Long> resList = en.getValue();
            if (VerifyUtil.isEmpty(resList)) continue;
            String ip = this.ipMap.get(en.getKey());
            ShellCMDExecutor exe = this.getShellFromCache(ip);
            if (VerifyUtil.isEmpty(exe)) {
                LOGGER.warn((Object)("connect to " + this.di.getIp() + "failed."));
                continue;
            }
            this.switchToDeveloper(exe, true);
            for (Long resId : resList) {
                this.closeIOTraceSwitch(exe, resId);
            }
            this.backToLogin(exe);
        }
    }

    private void openIOTraceSwitch(ShellCMDExecutor exe, Iterator<Long> resIter, Long resid, boolean isFirstOpen) {
        String startCMD = this.openIOTraceCmd(resid);
        String result = this.execCmd(exe, startCMD);
        if (!VerifyUtil.isEmpty(result) && (result.contains(IOTRACE_OBJ_NOT_FOUND_ERROR) || result.contains(ERROR))) {
            LOGGER.error((Object)("the res[id : " + resid + "] not found when open ioTrace switch, result[" + result + "]"));
            if (isFirstOpen) {
                this.di.getIoTraceParam().getErrorIdList().add(resid.toString());
                resIter.remove();
            }
        }
    }

    private void closeIOTraceSwitch(ShellCMDExecutor exe, Long resId) {
        String closeIOTraceCmd = this.closeIOTraceCmd(resId);
        String result = this.execCmd(exe, closeIOTraceCmd);
        if (!VerifyUtil.isEmpty(result) && result.contains(IOTRACE_OBJ_NOT_FOUND_ERROR)) {
            LOGGER.error((Object)("the res[id : " + resId + "] not found when close ioTrace switch, result[" + result + "]"));
        }
    }

    private boolean backToLogin(ShellCMDExecutor exe) {
        String result = this.execCmd(exe, SPLIT_ENTER);
        if (VerifyUtil.isEmpty(result) || result.contains(ERROR)) {
            LOGGER.error((Object)("back to login failed. result[" + result + "]"));
            return false;
        }
        if (result.endsWith(this.userMode)) {
            return true;
        }
        exe.execCmd(EXIT, true);
        return this.backToLogin(exe);
    }

    private String queryWorkControllerCMD(long resId) {
        StringBuffer cmd = new StringBuffer(QUERY_LUN_INFO_PERF);
        cmd.append(resId).append(QUERY_LUN_INFO_END).append(SPLIT_ENTER);
        return cmd.toString();
    }

    private String queryCPUUsage(Set<String> keys) {
        StringBuffer cmd = new StringBuffer(QUERY_CPU_USAGE);
        for (String contrlName : keys) {
            cmd.append(contrlName).append(",");
        }
        cmd.deleteCharAt(cmd.length() - 1);
        cmd.append(" times=1 ").append(SPLIT_ENTER);
        return cmd.toString();
    }

    private String openIOTraceCmd(long resId) {
        StringBuffer cmd = new StringBuffer(IOTRACE_PERF);
        cmd.append(resId).append(IOTRACE_MID).append(SWITCH_OPEN);
        String v3r6Begin = HisResourceManager.getCfgProperties().getProperty("IOTRACE_V3R6_BEGIN_VERSION");
        if (PerfStatHistoryPane.isVersionAfter(this.deviceVersion, v3r6Begin)) {
            cmd.append(" 0 ").append(this.getCollectTime());
        }
        cmd.append(SPLIT_ENTER);
        return cmd.toString();
    }

    private String closeIOTraceCmd(long resId) {
        StringBuffer cmd = new StringBuffer(IOTRACE_PERF);
        cmd.append(resId).append(IOTRACE_MID).append(" 0 ").append(SPLIT_ENTER);
        return cmd.toString();
    }

    private int getCollectTime() {
        int mins = this.di.getIoTraceParam().getDuration();
        int hours = mins / 60;
        if (hours >= 23) {
            return 23;
        }
        if (mins % 60 != 0) {
            return hours + 1;
        }
        return hours;
    }

    private boolean isStart() {
        return System.currentTimeMillis() >= this.di.getIoTraceParam().getStartTime();
    }

    public boolean isEnd() {
        return System.currentTimeMillis() >= this.di.getIoTraceParam().getEndTime();
    }

    public boolean isNeedReleaseShell() {
        long curr = System.currentTimeMillis();
        boolean isBeforeStart = this.di.getIoTraceParam().getStartTime() - curr > TEN_MINS;
        return isBeforeStart;
    }

    class CollectIOTraceTask
    implements Runnable {
        private List<DownloadIOTraceFileTask> downloadTaskList;

        CollectIOTraceTask() {
        }

        @Override
        public void run() {
            IOTraceSftp.this.isRun = true;
            boolean releaseFlag = true;
            while (IOTraceSftp.this.isRun) {
                if (IOTraceSftp.this.immediateStop) {
                    IOTraceSftp.this.isRun = false;
                    IOTraceSftp.this.isFinshed = true;
                    LOGGER.warn((Object)"do not start collect task, because clicked immediateStop.");
                    break;
                }
                if (releaseFlag && IOTraceSftp.this.isNeedReleaseShell()) {
                    releaseFlag = false;
                    IOTraceSftp.this.releaseAllShell();
                    LOGGER.warn((Object)"wait task start is too looooooooog, so release all shell.");
                }
                if (IOTraceSftp.this.isStart() && !IOTraceSftp.this.isEnd()) {
                    try {
                        IOTraceSftp.this.isCollect = true;
                        this.core();
                        continue;
                    }
                    catch (IsmException e) {
                        LOGGER.error((Object)"get fileList failed.", (Throwable)e);
                        IOTraceSftp.this.di.setIOTraceErrMsg(HisResourceManager.getString("DEVICE_ERROR"));
                        throw new IsmException(HisResourceManager.getString("DEVICE_ERROR"), (Throwable)e);
                    }
                    finally {
                        this.doSomeImportantWork();
                        continue;
                    }
                }
                if (IOTraceSftp.this.isEnd()) {
                    IOTraceSftp.this.releaseAllShell();
                    IOTraceSftp.this.isRun = false;
                    IOTraceSftp.this.isFinshed = true;
                    if (!LOGGER.isInfoEnabled()) break;
                    LOGGER.info((Object)("now large than end time, now : " + System.currentTimeMillis() + ", endTime : " + IOTraceSftp.this.di.getIoTraceParam().getEndTime()));
                    break;
                }
                ThreadUtil.sleep(LOOP_INTERVAL);
            }
        }

        private void doSomeImportantWork() {
            try {
                IOTraceSftp.this.stopCollectIOTrace();
            }
            catch (IsmException e) {
                LOGGER.error((Object)"close io trace switch failed.", (Throwable)e);
            }
            IOTraceSftp.this.closeIOTraceSwitch = true;
            IOTraceSftp.this.releaseAllShell();
            this.stopDownloadTask();
            IOTraceSftp.this.isCollect = false;
            IOTraceSftp.this.isRun = false;
            IOTraceSftp.this.countDownLatch.countDown();
            IOTraceSftp.this.isFinshed = true;
        }

        private void core() throws IsmException {
            long start = System.currentTimeMillis();
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)("iotrace collect task real start time : " + start));
            }
            this.initDownloadTask();
            IOTraceSftp.this.startCollectIOTrace();
            int count = 0;
            while (IOTraceSftp.this.isCollect && !IOTraceSftp.this.isEnd()) {
                if (!IOTraceSftp.this.di.getIoTraceParam().isHaveIOTraceFileProduce() && 0 < count) {
                    LOGGER.warn((Object)"no io trace file created, so stop collect task.");
                    throw new IsmException(HisResourceManager.getString("IO_TRACE_NO_FILE_CREATE"));
                }
                if (++count % 15 == 0) {
                    this.activityConn();
                }
                if (IOTraceSftp.this.immediateStop) {
                    LOGGER.info((Object)"immediate stop collect task.");
                    break;
                }
                ThreadUtil.sleep(TimeUnit.MINUTES.toMillis(1L));
            }
            long end = System.currentTimeMillis();
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)("iotrace collect task real end time : " + end));
                LOGGER.info((Object)("ioTrace task use time : " + (end - start)));
            }
        }

        private void activityConn() {
            Set contrlNameSet = IOTraceSftp.this.resMap.keySet();
            for (String name : contrlNameSet) {
                if (!IOTraceSftp.this.ipMap.containsKey(name)) continue;
                String ip = (String)IOTraceSftp.this.ipMap.get(name);
                ShellCMDExecutor exe = IOTraceSftp.this.getShellFromCache(ip);
                if (VerifyUtil.isEmpty(exe)) {
                    LOGGER.warn((Object)("connect to " + ip + "failed."));
                    continue;
                }
                exe.isCMDReady();
            }
        }

        private void initDownloadTask() {
            String parentFileName = IOTraceSftp.this.di.getIp() + "_" + IOTraceSftp.this.di.getDeviceID() + "_" + System.currentTimeMillis();
            IOTraceSftp.this.di.getIoTraceParam().setParentFileName(parentFileName);
            this.downloadTaskList = new ArrayList<DownloadIOTraceFileTask>();
            for (Map.Entry en : IOTraceSftp.this.resMap.entrySet()) {
                String controlName = (String)en.getKey();
                DownloadIOTraceFileTask downloadTask = new DownloadIOTraceFileTask(IOTraceSftp.this, IOTraceSftp.this.di, controlName);
                downloadTask.setName("Download-" + controlName + "-" + "Task");
                downloadTask.start();
                this.downloadTaskList.add(downloadTask);
                LOGGER.info((Object)"start Download Task!");
            }
        }

        private void stopDownloadTask() {
            if (this.hasDownloadTaskAlive()) {
                for (DownloadIOTraceFileTask task : this.downloadTaskList) {
                    task.setRun(false);
                }
                while (this.hasDownloadTaskAlive()) {
                    ThreadUtil.sleep(500L);
                }
            }
        }

        private boolean hasDownloadTaskAlive() {
            boolean result = false;
            if (VerifyUtil.isEmpty(this.downloadTaskList)) {
                return result;
            }
            for (DownloadIOTraceFileTask task : this.downloadTaskList) {
                if (!task.isAlive()) continue;
                result = true;
                break;
            }
            return result;
        }
    }
}

