/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.sftp;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.JProgressBar;
import org.apache.log4j.Logger;

public class JProgressBarNew
extends JProgressBar {
    private static final Logger LOGGER = Logger.getLogger(JProgressBarNew.class);
    private static final long serialVersionUID = 4910095123838381921L;
    private int max;
    private Map<Object, Integer> pers = new HashMap<Object, Integer>();
    private int lastValue = 0;
    private boolean running;

    public JProgressBarNew() {
    }

    public JProgressBarNew(int min, int max) {
        super(min, max);
    }

    public void process() {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                JProgressBarNew.this.taskDo();
            }
        });
        thread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread thread1, Throwable throwable) {
                LOGGER.error((Object)(thread1.getName() + ":" + throwable.getMessage()));
            }
        });
        thread.setName("JProgressBarNew-Thread-1");
        thread.start();
    }

    private void taskDo() {
        this.running = true;
        while (this.running) {
            if (this.getValue() == 100) {
                this.running = false;
                break;
            }
            if (!this.pers.isEmpty()) {
                this.flush();
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                LOGGER.error((Object)"process thread sleep failed.", (Throwable)e);
            }
        }
        this.flush();
        if (!this.running) {
            this.init();
        }
    }

    public void addTask(Object tag) {
        this.pers.put(tag, 0);
        this.max += this.getMaximum();
    }

    public boolean checkTask(Object tag) {
        return this.pers.containsKey(tag);
    }

    public synchronized void setValue(Object tag, int num) {
        this.pers.put(tag, num);
    }

    public void flush() {
        int count = 0;
        Set<Map.Entry<Object, Integer>> entrySet = this.pers.entrySet();
        for (Map.Entry<Object, Integer> en : entrySet) {
            Integer value = en.getValue();
            count += value.intValue();
        }
        int value = count * 100 / this.max;
        if (value > this.lastValue) {
            this.setValue(value);
            this.lastValue = value;
        }
    }

    public void init() {
        this.lastValue = 0;
        this.max = 0;
        this.pers.clear();
    }

    public void endProcess() {
        this.running = false;
    }
}

