/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.sftp;

import com.huawei.common.RunModelEnum;
import com.huawei.ism.common.resourcemanager.HisResourceManager;
import com.huawei.ism.connection.BaseConnection;
import com.huawei.ism.connection.HisRESTConnection;
import com.huawei.ism.exception.IsmException;
import com.huawei.ism.tlv.TLV;
import com.huawei.ism.tlv.TLVMsgDefine;
import com.huawei.ism.tlv.TLVNEW;
import com.huawei.ism.tlv.TLVUtils;
import com.huawei.ism.tlv.bean.Param;
import com.huawei.ism.tlv.bean.Record;
import com.huawei.ism.tlv.lang.IsmInteger;
import com.huawei.ism.tlv.lang.UnsignedInt32;
import com.huawei.ism.tlv.lang.UnsignedInt64;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.protocol.rest.RestConnectionManager;
import com.huawei.ism.tool.protocol.sftp.SftpTransfer;
import com.huawei.ism.tool.service.common.ToolThreadFactory;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.util.VerifyUtil;
import com.huawei.sftp.AbstractSftp;
import com.huawei.xve.MainDialog;
import com.huawei.xve.entity.StepDetail;
import com.huawei.xve.entity.TaskEnv;
import com.huawei.xve.monitor.eservice.ParamHander;
import com.huawei.xve.monitor.eservice.PermanentConnectionMannage;
import com.huawei.xve.monitor.eservice.ResultHander;
import com.huawei.xve.monitor.eservice.TimeRecord;
import com.huawei.xve.monitor.eservice.task.Task;
import com.huawei.xve.monitor.perfstat.PerfStatHistoryPane;
import com.huawei.xve.utils.ConnManager;
import com.huawei.xve.utils.DeviceInfo;
import com.huawei.xve.utils.DeviceVersion;
import com.huawei.xve.utils.DownloadTime;
import com.huawei.xve.utils.FileUtil;
import com.huawei.xve.utils.QuerInfo;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.swing.JProgressBar;
import org.apache.log4j.Logger;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.sftp.client.SftpClient;
import org.apache.sshd.sftp.common.SftpException;

public class PerfStatHisSftp
extends AbstractSftp {
    private static final Logger LOGGER = Logger.getLogger(PerfStatHisSftp.class);
    private static final String SERVER_SPLIT = ":/";
    private static final String ENCODING = "UTF-8";
    private static final String VIRTUAL_LINE = "|";
    private static final long REFRESH_TIME = 100L;
    private static final String FORMAT = "yyyyMMddHHmmss";
    private static final int DEFAULT_SIZE = 500;
    private static final Set<String> CANNOT_REACH_IPS = new HashSet<String>(10);
    private static final String DEFAULT_PATH = "/OSM/coffer_data/perf/perf_files/";
    private static final String DEFAULT_PATH_BY_TV1 = "/OSM/coffer_perf/perf_files/";
    private static final int CORE = 1;
    private static final String SPLIT = ",";
    private static final long DEAD_TIME = 60000L;
    private static final String SYMBOL1 = "_";
    private static final String SYMBOL2 = ".";
    private static final String SP = "SP";
    private static final long MILLISECOND_BASE = 1000L;
    private static final int RETRY_TIMES = 3;
    public static final UnsignedInt32 EXPORT_LOG_TYPE = new UnsignedInt32(9);
    public static final UnsignedInt32 EXPORT_LOG_TYPE_REALTIME = new UnsignedInt32(16);
    private final AtomicInteger downloaded = new AtomicInteger(0);
    private int fileSum;
    private final DeviceInfo di;
    private final ThreadGroup taskPool = new ThreadGroup("DownloadFileTaskPool");
    private JProgressBar jp;
    private volatile boolean wrong;
    private final AtomicInteger downloadFailed = new AtomicInteger(0);
    private int faultToleranceNum = 10;
    private final Map<String, SftpClient> sftpCache = new ConcurrentHashMap<String, SftpClient>();
    private static final Map<String, SftpClient> SFTP_CACHE_QUEUE = new ConcurrentHashMap<String, SftpClient>();
    private String oftenDeleteTemVersion = null;
    private Boolean isOftenDeleteTemVersion = null;
    private UnsignedInt32 type;
    private final Map<String, Boolean> downloadTaskRunningMap = new ConcurrentHashMap<String, Boolean>();
    private volatile boolean stop;
    private StepDetail detail;
    private final AtomicInteger downloadThreadNum = new AtomicInteger(0);
    CountDownLatch count = new CountDownLatch(1);
    private volatile boolean isFinished = false;
    private String errMsg;

    public PerfStatHisSftp(DeviceInfo di, UnsignedInt32 type) {
        super(di);
        this.di = di;
        this.type = type;
    }

    public PerfStatHisSftp(DeviceInfo di) {
        super(di);
        this.di = di;
    }

    public PerfStatHisSftp(DeviceInfo di, JProgressBar jp) {
        super(di);
        this.jp = jp;
        this.di = di;
    }

    public List<String> list(String ip) {
        ArrayList<String> allFiles = new ArrayList<String>(500);
        try {
            SftpClient sftp = this.connect(ip);
            Iterable entrys = sftp.listDir((SftpClient.Handle)sftp.openDir(DEFAULT_PATH));
            for (SftpClient.DirEntry entry : entrys) {
                if (entry.getFilename().startsWith("dr")) continue;
                allFiles.add(DEFAULT_PATH + entry.getFilename());
            }
        }
        catch (IOException e) {
            LOGGER.error((Object)("connet faild IP:" + ip), (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.error((Object)"", (Throwable)e);
        }
        return allFiles;
    }

    public void exportAll(TaskEnv env, StepDetail detail) {
        LOGGER.info((Object)"Start export perf file.");
        this.detail = detail;
        this.downloadTaskRunningMap.clear();
        this.fileSum = (int)env.getFileCount();
        this.di.getDownloadTime().init(this.fileSum);
        this.downloadTask(env.getPerfFiles(), env.getResultDir(), this.fileSum);
    }

    public void exportAll(Map<String, List<String>> fileMap, int needDownloadNum, String resultDir, StepDetail detail, int totalFileNUm) {
        this.detail = detail;
        this.fileSum = needDownloadNum;
        this.downloadTaskRunningMap.clear();
        this.di.getDownloadTime().init(totalFileNUm, needDownloadNum);
        this.downloadTask(fileMap, resultDir, needDownloadNum);
    }

    public void exportRealtimeFile(String localPath, Map<String, List<String>> map, int total) throws IsmException {
        LOGGER.warn((Object)"ExportAll HisData start.");
        if (map.isEmpty()) {
            return;
        }
        this.fileSum = total;
        this.di.getDownloadTime().setTotalFileNum(total);
        try {
            this.processTask();
            this.doDownloadRealtimeFile(map, localPath);
            if (this.count.await(10L, TimeUnit.SECONDS)) {
                LOGGER.info((Object)"Waiting for getProgress statistics thread end time exceeds 10s");
            }
        }
        catch (IsmException e) {
            throw e;
        }
        catch (Exception e) {
            LOGGER.error((Object)"", (Throwable)e);
        }
        LOGGER.info((Object)"ExportAll HisData finished.");
    }

    private void processTask() {
        ToolThreadFactory.newDefaultThread(this::process).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process() {
        ResultHander r = ResultHander.getHander();
        try {
            int curr = this.downloaded.intValue();
            while (true) {
                if (this.isFinished) {
                    if (this.downloadFailed.intValue() > 0) {
                        this.wrong = true;
                        this.errMsg = HisResourceManager.getString("CHANGE_MAINCTL_ESERVICE");
                    }
                    r.update("progress", "100", this.di.getDeviceID(), true);
                    break;
                }
                curr = this.downloaded.intValue();
                int i = curr * 100 / this.fileSum;
                r.update("progress", i + "", this.di.getDeviceID(), false);
                if (curr == this.fileSum) {
                    break;
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    LOGGER.error((Object)("the Complete Process is Interrupted by Thread.complete:" + curr + ",left:" + (this.fileSum - curr)), (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"", (Throwable)e);
        }
        finally {
            this.count.countDown();
        }
    }

    private void downloadTask(Map<String, List<String>> files, String localPath, int total) {
        if (files == null) {
            return;
        }
        Set<Map.Entry<String, List<String>>> entrySet = files.entrySet();
        for (Map.Entry<String, List<String>> en : entrySet) {
            List<String> list = en.getValue();
            Collections.sort(list);
            int res = total / 1;
            int ipCounts = Math.round((float)list.size() / (float)res);
            List<List<String>> dec = PerfStatHisSftp.decompose(list, ipCounts);
            String path = this.mkdir(localPath, en.getKey());
            this.executeThread(this.taskPool, dec, path, en.getKey());
        }
    }

    private String mkdir(String localPath, String ip) {
        String path = localPath + File.separator + FileUtil.formatIpForPath(ip);
        File file = new File(path);
        if (!file.exists() && !file.isDirectory()) {
            if (file.mkdir()) {
                return path;
            }
            LOGGER.error((Object)("create dir failed.name:" + file.getName()));
            return localPath;
        }
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doDownloadRealtimeFile(Map<String, List<String>> map, String localPath) {
        try {
            if (map == null || map.isEmpty()) {
                LOGGER.error((Object)"no file can be download.");
                return;
            }
            Set<Map.Entry<String, List<String>>> ipFiles = map.entrySet();
            DownloadTime dt = this.di.getDownloadTime();
            String initTime = dt.getRemainTimeStr();
            ResultHander.getHander().update("remainTime", initTime, this.di.getDeviceID(), true);
            String newDir = this.mkdir(localPath, FileUtil.formatIpForPath(this.di.getIp()) + this.di.getDeviceID());
            for (Map.Entry<String, List<String>> en : ipFiles) {
                this.downloadFiles(en.getValue(), newDir, en.getKey(), 0, PerfModel.REALTIME_PERF);
            }
        }
        catch (IsmException e) {
            throw e;
        }
        catch (Exception e) {
            LOGGER.error((Object)"", (Throwable)e);
        }
        finally {
            this.isFinished = true;
            this.rmTempFile();
        }
    }

    private void showErrorDialog(Window window) {
        if (this.downloadTaskRunningMap.values().stream().noneMatch(status -> status)) {
            if (this.downloadFailed.intValue() > this.faultToleranceNum) {
                LOGGER.error((Object)HisResourceManager.getString("CHANGE_MAINCTL"));
                DialogUtils.showErrorDialog((Window)window, (String)HisResourceManager.getString("CHANGE_MAINCTL"));
            } else {
                this.jp.setValue(100);
            }
        } else {
            LOGGER.error((Object)HisResourceManager.getString("REST_IO_EXCEPTION"));
            DialogUtils.showErrorDialog((Window)window, (String)HisResourceManager.getString("REST_IO_EXCEPTION"));
        }
        this.taskPool.interrupt();
    }

    public synchronized void rmTempFile() {
        if (this.di.getDeviceVersion() == DeviceVersion.TV1) {
            return;
        }
        BaseConnection conn = PerfStatHisSftp.getConnection(this.di);
        ArrayList<Param> tlvParams = new ArrayList<Param>();
        if (this.type == null) {
            this.type = EXPORT_LOG_TYPE;
        }
        Param clearType = new Param(TLV.LOG.CMO_EXPORT_TYPE.getParamIndex(), TLV.LOG.CMO_EXPORT_TYPE.getParamType(), (IsmInteger)this.type);
        tlvParams.add(clearType);
        try {
            conn.invoke(55847747604L, tlvParams);
            LOGGER.info((Object)"clear his_perf file success.");
        }
        catch (IsmException e) {
            LOGGER.error((Object)"clear his_perf file failed", (Throwable)e);
        }
    }

    private void executeThread(ThreadGroup group, List<List<String>> decompose, String localPath, String ip) {
        int fileBlochNumber = 0;
        for (List<String> task : decompose) {
            this.downloadThreadNum.incrementAndGet();
            Thread thread = new Thread(group, new ExportThread(task, localPath, ip, fileBlochNumber));
            thread.setUncaughtExceptionHandler((thread1, throwable) -> LOGGER.error((Object)(thread1.getName() + ":" + throwable.getMessage())));
            thread.start();
            ++fileBlochNumber;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadFiles(List<String> task, String localPath, String ip, int partNo, PerfModel perfModel) {
        String sftpNo = ip + partNo;
        try {
            SftpClient sftp = SFTP_CACHE_QUEUE.getOrDefault(sftpNo, null);
            if (sftp == null || !sftp.isOpen()) {
                sftp = this.getSftpRetry(ip);
            }
            this.sftpCache.put(sftpNo, sftp);
            DownloadTime dt = this.di.getDownloadTime();
            if (PerfModel.REALTIME_PERF.equals((Object)perfModel)) {
                this.downRealtimePerf(task, localPath, dt, sftpNo);
            } else {
                this.downHistoryPerf(task, localPath, dt, sftpNo);
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"downdow file occursed a problem.", (Throwable)e);
        }
        finally {
            this.downloadThreadNum.decrementAndGet();
            SftpClient sftp = this.sftpCache.get(sftpNo);
            PerfStatHisSftp.releaseConn(sftp);
            SFTP_CACHE_QUEUE.remove(sftpNo);
        }
    }

    private void downRealtimePerf(List<String> task, String localPath, DownloadTime dt, String sftpNo) {
        List<String> needCopyTask = this.downAndGetNeedCopyTask(task, localPath, dt, sftpNo);
        if (needCopyTask.isEmpty()) {
            return;
        }
        this.doNeedCopyTask(localPath, dt, sftpNo, needCopyTask);
    }

    private void doNeedCopyTask(String localPath, DownloadTime dt, String sftpNo, List<String> needCopyTask) {
        List<String> copyResults = this.batchCopyHisPerf(needCopyTask);
        if (copyResults.isEmpty()) {
            needCopyTask.forEach(file -> this.downOnePerfFile((String)file, localPath, dt, sftpNo, true));
        } else {
            copyResults.forEach(file -> this.downOnePerfFile((String)file, localPath, dt, sftpNo, false));
        }
    }

    private List<String> downAndGetNeedCopyTask(List<String> task, String localPath, DownloadTime dt, String sftpNo) {
        ArrayList<String> needCopyTask = new ArrayList<String>();
        task.forEach(filePath -> {
            if (filePath.contains(SERVER_SPLIT)) {
                needCopyTask.add((String)filePath);
            } else {
                this.downOnePerfFile((String)filePath, localPath, dt, sftpNo, filePath.contains(SERVER_SPLIT));
            }
        });
        return needCopyTask;
    }

    private List<String> batchCopyHisPerf(List<String> filePathList) {
        try {
            BaseConnection conn = PerfStatHisSftp.getConnection(this.di);
            String filePaths = String.join((CharSequence)VIRTUAL_LINE, filePathList);
            if (conn instanceof HisRESTConnection) {
                filePaths = URLEncoder.encode(filePaths, ENCODING);
            }
            ArrayList<Param> params = new ArrayList<Param>(0);
            Param copy = new Param(TLV.PERFORMANCE_STATISTIC_FILE.CMO_STATISTIC_FILE_LIST.getParamIndex(), TLV.PERFORMANCE_STATISTIC_FILE.CMO_STATISTIC_FILE_LIST.getParamType(), filePaths);
            params.add(copy);
            long cmd = 59594907810L;
            List<Record> records = conn.getBatch(cmd, params);
            return this.parseCopyHisPerfRecords(filePathList, records);
        }
        catch (Throwable e) {
            LOGGER.error((Object)("Batch copy perf file error, DeviceID is" + this.di.getDeviceID()), e);
            return new ArrayList<String>();
        }
    }

    private List<String> parseCopyHisPerfRecords(List<String> filePathList, List<Record> records) {
        List fileNameList = filePathList.stream().map(filePath -> filePath.substring(filePath.lastIndexOf("/"))).collect(Collectors.toList());
        ArrayList<String> copyFiles = new ArrayList<String>();
        for (Record record : records) {
            String file = record.getParamStrValue(TLV.PERFORMANCE_STATISTIC_FILE.CMO_STATISTIC_FILE.getParamIndex());
            String fileName = file.substring(file.lastIndexOf("/"));
            if (!fileNameList.contains(fileName)) continue;
            int index = file.indexOf(SERVER_SPLIT);
            copyFiles.add(file.substring(index + 1));
        }
        return copyFiles;
    }

    private void downHistoryPerf(List<String> task, String localPath, DownloadTime dt, String sftpNo) {
        for (String file : task) {
            if (this.stop) {
                LOGGER.error((Object)"The download task stops.");
                return;
            }
            this.downOnePerfFile(file, localPath, dt, sftpNo, file.contains(SERVER_SPLIT));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downOnePerfFile(String file, String localPath, DownloadTime dt, String sftpNo, boolean needCopy) {
        boolean isUseCopy = false;
        try {
            long start = System.currentTimeMillis();
            if (needCopy) {
                try {
                    isUseCopy = true;
                    file = this.getNewFilePath(file, PerfStatHisSftp.getConnection(this.di));
                }
                catch (Exception e) {
                    LOGGER.error((Object)("download failed, file name : " + file));
                    dt.getRemainingFileNum().decrementAndGet();
                    this.refreshRemainTime(dt);
                    this.rmTempFileBy(isUseCopy);
                    return;
                }
            }
            boolean success = this.download(file, localPath, sftpNo);
            long end = System.currentTimeMillis();
            if (success) {
                dt.setLastSuccessTime(end);
                if (MainDialog.getSceneMarker() == 1 && LOGGER.isInfoEnabled()) {
                    LOGGER.info((Object)("download success is " + file));
                }
            }
            this.saveDownloadTime(dt, start, end);
        }
        catch (SftpException e) {
            LOGGER.error((Object)"", (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.error((Object)("Down perf file error\uff0cDeviceID:" + this.di.getDeviceID()), (Throwable)e);
        }
        finally {
            dt.getRemainingFileNum().decrementAndGet();
            this.refreshRemainTime(dt);
            this.rmTempFileBy(isUseCopy);
        }
    }

    private void rmTempFileBy(boolean isUseCopy) {
        if (!isUseCopy) {
            return;
        }
        try {
            if (null == this.isOftenDeleteTemVersion) {
                String devVersion = this.di.getDevNode().getProductVersion();
                if (this.di.getdType().contains("Dorado")) {
                    this.isOftenDeleteTemVersion = false;
                    return;
                }
                if (null == this.oftenDeleteTemVersion) {
                    this.oftenDeleteTemVersion = HisResourceManager.getCfgProperties().getProperty("OFTEN_DELETE_TEM_VERSION");
                }
                this.isOftenDeleteTemVersion = this.oftenDeleteTemVersion.equals(devVersion) ? Boolean.valueOf(true) : Boolean.valueOf(!PerfStatHistoryPane.isVersionAfter(devVersion, this.oftenDeleteTemVersion));
            }
            if (this.isOftenDeleteTemVersion.booleanValue()) {
                this.rmTempFile();
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"Clean up temporary directory error.", (Throwable)e);
        }
    }

    private void saveDownloadTime(DownloadTime dt, long start, long end) {
        long downloadTime = end - start;
        dt.addDownloadTimes(downloadTime);
    }

    private void refreshRemainTime(DownloadTime dt) {
        int downloadCount = dt.addCount();
        if (System.currentTimeMillis() - dt.getLastSuccessTime() > 60000L) {
            LOGGER.error((Object)"Long time has no file download success,stop export.");
            this.stop = true;
            this.wrong = true;
        }
        if (downloadCount == dt.getTotalFileNum() || downloadCount % 10 == 0) {
            dt.refresh();
            String lastTime = dt.getRemainTimeStr();
            if (RunModelEnum.E_SERVICE == MainDialog.getRunModel()) {
                ResultHander.getHander().update("remainTime", lastTime, this.di.getDeviceID(), true);
            } else {
                this.detail.update(dt.getProgress(), lastTime);
            }
        }
    }

    private boolean download(String file, String localPath, String sftpNo) throws SftpException {
        try {
            if (file == null) {
                return false;
            }
            this.downloadRetry(file, localPath, this.di.getIp(), sftpNo);
            this.downloaded.getAndIncrement();
            return true;
        }
        catch (SftpException e) {
            LOGGER.error((Object)("download file failed.file:" + file));
            this.downloadFailed.getAndIncrement();
            throw e;
        }
        catch (IsmException e) {
            LOGGER.error((Object)("copy file to current dev failed.file:" + file), (Throwable)e);
            this.downloadFailed.getAndIncrement();
            throw e;
        }
        catch (Exception e) {
            this.downloadFailed.getAndIncrement();
            LOGGER.error((Object)("download file failed.file:" + file));
            throw e;
        }
    }

    private void downloadRetry(String file, String localPath, String ip, String sftpNo) throws SftpException {
        int reNum = 1;
        SftpClient sftp = null;
        do {
            try {
                sftp = this.sftpCache.get(sftpNo);
                if (null == sftp) {
                    return;
                }
                SftpTransfer.downloadFile((String)localPath, (String)file, (SftpClient)sftp);
                return;
            }
            catch (SftpException e) {
                if (e.getMessage().contains("No such file")) {
                    throw e;
                }
                LOGGER.error((Object)String.format(Locale.ROOT, "Download file failed.retry %d", reNum), (Throwable)e);
                ++reNum;
                PerfStatHisSftp.releaseConn(sftp);
                PerfStatHisSftp.sleepSomeTime(1000L);
                try {
                    sftp = this.connect(ip);
                    this.sftpCache.put(sftpNo, sftp);
                }
                catch (Exception e1) {
                    LOGGER.error((Object)"Downdow file occursed a problem.", (Throwable)e1);
                }
            }
            catch (IOException e) {
                ++reNum;
                LOGGER.error((Object)"Downdow file occursed a problem.", (Throwable)e);
            }
        } while (reNum < 3);
        throw new NullPointerException("Download file error.");
    }

    public static List<List<String>> decompose(List<String> ctlfiles, int counts) {
        int total = ctlfiles.size();
        ArrayList<List<String>> com = new ArrayList<List<String>>(counts);
        if (total < 500 || counts < 2) {
            com.add(ctlfiles);
            return com;
        }
        int count = (int)Math.ceil((float)total / (float)(counts + 1));
        for (int i = 0; i < counts + 1; ++i) {
            List<String> subList;
            if (counts > i) {
                subList = ctlfiles.subList(i * count, (i + 1) * count);
                com.add(subList);
                continue;
            }
            if (i * count == total) continue;
            subList = ctlfiles.subList(i * count, total);
            com.add(subList);
        }
        return com;
    }

    public static Map<String, List<String>> record2Que(List<Record> records, String deviceID) {
        SftpClient sftp;
        if (records == null || records.size() < 1) {
            return Collections.emptyMap();
        }
        ConcurrentHashMap<String, List<String>> files = new ConcurrentHashMap<String, List<String>>();
        DeviceInfo di = ConnManager.getDeviceInfo(deviceID);
        try {
            sftp = PerfStatHisSftp.connect(di.getIp(), di.getUserName(), di.getPassword(), di.getPort());
        }
        catch (Exception e) {
            LOGGER.error((Object)("failed to connect the sftp server.ip:" + di.getIp()));
            throw new IsmException(HisResourceManager.getString("CONNECTION_SSH_FAILED"), (Throwable)e);
        }
        SFTP_CACHE_QUEUE.put(di.getIp() + 0, sftp);
        boolean isIPV6Controller = PerfStatHisSftp.isIPV6Controller(deviceID);
        int nodeId = -2;
        if (isIPV6Controller) {
            nodeId = QuerInfo.querLocalNodeId(di);
        }
        for (Record record : records) {
            TLVNEW.PerformanceStatisticFile performanceStatisticFile = new TLVNEW.PerformanceStatisticFile();
            Map property = TLVUtils.record2Map((Record)record, (TLVMsgDefine)performanceStatisticFile);
            String file = (String)property.get(TLVNEW.PerformanceStatisticFile.CMO_STATISTIC_FILE);
            if (isIPV6Controller && PerfStatHisSftp.isLoginControlfile(file, deviceID, nodeId)) {
                PerfStatHisSftp.queryIPV6LoginControlFile(file, deviceID, files);
                continue;
            }
            PerfStatHisSftp.parse(file, deviceID, sftp, files);
        }
        return files;
    }

    private static boolean isLoginControlfile(String file, String deviceID, int nodeId) {
        if (nodeId == -2) {
            LOGGER.warn((Object)"The nodeId is incorrect.");
            return false;
        }
        String loginControllerNode = SP + nodeId;
        String[] strs = PerfStatHisSftp.checkFile(file);
        if (strs == null) {
            return false;
        }
        String controlNode = strs[1].split(deviceID + SYMBOL1)[1].split("_0")[0];
        return loginControllerNode.equals(controlNode);
    }

    private static void queryIPV6LoginControlFile(String file, String deviceID, Map<String, List<String>> filesList) {
        DeviceInfo di = ConnManager.getDeviceInfo(deviceID);
        DownloadTime downloadTime = di.getDownloadTime();
        List<String> list = filesList.get(di.getIp());
        String[] strs = PerfStatHisSftp.checkFile(file);
        if (strs == null) {
            return;
        }
        if (list == null) {
            list = PerfStatHisSftp.createListAndHoldControlFilePath(filesList, strs, di.getIp());
            PerfStatHisSftp.writeFile2DownloadTime(downloadTime);
        } else {
            list.add(strs[1]);
            PerfStatHisSftp.writeFile2DownloadTime(downloadTime);
        }
    }

    private static List<String> createListAndHoldControlFilePath(Map<String, List<String>> fileMap, String[] strs, String ip) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(strs[1]);
        fileMap.put(ip, list);
        return list;
    }

    private static boolean isIPV6Controller(String deviceID) {
        DeviceInfo di = ConnManager.getDeviceInfo(deviceID);
        return StringUtils.isIpv6Address((String)di.getIp()) && QuerInfo.querControllerSpecialIPV6(di);
    }

    private static Map<String, List<String>> record2QueNew(List<Record> records, String deviceID) {
        HashMap<String, List<String>> all = new HashMap<String, List<String>>();
        if (records == null || records.size() < 1) {
            return all;
        }
        DeviceInfo di = ConnManager.getDeviceInfo(deviceID);
        SftpClient sftp = PerfStatHisSftp.getSftpRetry(di);
        SFTP_CACHE_QUEUE.put(di.getIp() + 0, sftp);
        String lastCtl = null;
        long lastTime = 0L;
        for (Record record : records) {
            TLVNEW.PerformanceStatisticFile performanceStatisticFile;
            Map property = TLVUtils.record2Map((Record)record, (TLVMsgDefine)(performanceStatisticFile = new TLVNEW.PerformanceStatisticFile()));
            String file = (String)property.get(TLVNEW.PerformanceStatisticFile.CMO_STATISTIC_FILE);
            if (file == null || org.apache.commons.lang3.StringUtils.isBlank((CharSequence)file)) continue;
            int snIdx = file.indexOf(di.getDeviceID()) + di.getDeviceID().length() + 1;
            String thisCtl = file.substring(snIdx, file.indexOf(SYMBOL1, snIdx));
            if (thisCtl.equals(lastCtl)) {
                lastTime = 0L;
                continue;
            }
            lastCtl = thisCtl;
            long thisTime = Long.parseLong(property.get(TLVNEW.PerformanceStatisticFile.CMO_FILE_UPDATE_TIME).toString());
            if (thisTime < lastTime) continue;
            lastTime = thisTime;
            PerfStatHisSftp.parse(file, deviceID, sftp, all);
        }
        return all;
    }

    private static SftpClient getSftpRetry(DeviceInfo di) {
        int reNum;
        SftpClient sftp = null;
        for (reNum = 1; reNum < 4; ++reNum) {
            try {
                sftp = PerfStatHisSftp.connect(di.getIp(), di.getUserName(), di.getPassword(), di.getPort());
                break;
            }
            catch (IOException e) {
                LOGGER.error((Object)("jach failed time : " + reNum + ",ip:" + di.getIp()), (Throwable)e);
                PerfStatHisSftp.sleepSomeTime(2000L);
                continue;
            }
        }
        if (reNum >= 4) {
            throw new IsmException(HisResourceManager.getString("CONNECTION_SSH_FAILED"));
        }
        return sftp;
    }

    private SftpClient getSftpRetry(String ip) {
        int reNum;
        SftpClient sftp = null;
        for (reNum = 1; reNum < 4; ++reNum) {
            try {
                sftp = this.connect(ip);
                break;
            }
            catch (Exception e) {
                LOGGER.error((Object)("jach failed time : " + reNum + "ip:" + this.di.getIp()), (Throwable)e);
                PerfStatHisSftp.sleepSomeTime(2000L);
                continue;
            }
        }
        if (reNum >= 4) {
            throw new IsmException(HisResourceManager.getString("CONNECTION_SSH_FAILED"));
        }
        return sftp;
    }

    private static String[] getIps(String file, DownloadTime downloadTime, List<String> mainCtl, String str) {
        String[] ips = str.split(SPLIT);
        if (ips.length != 3) {
            mainCtl.add(file);
            PerfStatHisSftp.writeFile2DownloadTime(downloadTime);
            return null;
        }
        return ips;
    }

    private static String[] checkFile(String file) {
        if (VerifyUtil.isEmpty(file)) {
            LOGGER.error((Object)("valid file:" + file));
            return null;
        }
        String[] strs = file.split(":");
        if (strs.length != 2) {
            LOGGER.error((Object)("valid file:" + file));
            return null;
        }
        return strs;
    }

    private static void writeFile2DownloadTime(DownloadTime downloadTime) {
        downloadTime.getRemainingFileNum().getAndIncrement();
    }

    private static void parse(String file, String deviceID, SftpClient sftp, Map<String, List<String>> filesList) {
        try {
            String mainIP = ConnManager.getDeviceInfo(deviceID).getIp();
            String[] strs = PerfStatHisSftp.checkFile(file);
            if (strs == null) {
                return;
            }
            DownloadTime downloadTime = ConnManager.getDeviceInfo(deviceID).getDownloadTime();
            List mainCtl = filesList.computeIfAbsent(mainIP, key -> new ArrayList());
            int idx = strs[0].lastIndexOf(SPLIT);
            if (idx == -1) {
                return;
            }
            String[] ips = PerfStatHisSftp.getIps(file, downloadTime, mainCtl, strs[0]);
            if (ips == null) {
                return;
            }
            String ip = ips[ips.length - 1];
            if (CANNOT_REACH_IPS.contains(ip)) {
                String newFilePath = PerfStatHisSftp.getCopyFilePath(file, sftp, strs);
                if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)newFilePath)) {
                    mainCtl.add(newFilePath);
                    PerfStatHisSftp.writeFile2DownloadTime(downloadTime);
                }
                return;
            }
            List<String> list = filesList.get(ip);
            if (list == null) {
                list = PerfStatHisSftp.queryControlFilePath(PerfStatHisSftp.createParams(file, deviceID, sftp), filesList, strs, ips, ip);
                PerfStatHisSftp.writeFile2DownloadTime(downloadTime);
            } else {
                list.add(strs[1]);
                PerfStatHisSftp.writeFile2DownloadTime(downloadTime);
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"", (Throwable)e);
        }
    }

    private static List<String> queryControlFilePath(List<Object> params, Map<String, List<String>> fileMap, String[] strs, String[] ips, String ip) {
        ArrayList<String> list = new ArrayList<String>();
        String file = (String)params.get(0);
        String deviceID = (String)params.get(1);
        SftpClient sftp = (SftpClient)params.get(2);
        String dIp = ConnManager.getDeviceInfo(deviceID).getIp();
        if (ip.equals(dIp)) {
            list.add(strs[1]);
            fileMap.put(ip, list);
        } else {
            boolean sftpCanConnected = PerfStatHisSftp.isSftpCanConnected(ips[ips.length - 1], 22, 1000);
            if (!sftpCanConnected) {
                CANNOT_REACH_IPS.add(ip);
                List<String> main = fileMap.get(dIp);
                String newPath = PerfStatHisSftp.getCopyFilePath(file, sftp, strs);
                if (main == null) {
                    list.add(newPath);
                    fileMap.put(dIp, list);
                } else {
                    main.add(newPath);
                }
            } else {
                list.add(strs[1]);
                fileMap.put(ip, list);
            }
        }
        return list;
    }

    private static List<Object> createParams(Object ... params) {
        if (VerifyUtil.isEmpty(params)) {
            return new ArrayList<Object>();
        }
        return Arrays.asList(params);
    }

    public static String getCopyFilePath(String file, SftpClient sftp, String[] strs) {
        String newFilePath = PerfStatHisSftp.isFileExist(strs[1], sftp) ? strs[1] : file;
        return newFilePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isFileExist(String file, SftpClient sftp) {
        boolean exsit = true;
        InputStream in = null;
        try {
            in = sftp.read(file);
        }
        catch (IOException e) {
            if (MainDialog.getSceneMarker() == 1) {
                LOGGER.error((Object)("the file:" + file + ",is not exist"));
            }
            exsit = false;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    LOGGER.error((Object)"close io failed.");
                }
            }
        }
        return exsit;
    }

    public static Map<String, List<String>> queryStatFiles(String deviceID, long begin, long end) throws IsmException {
        DeviceInfo di = ConnManager.getDeviceInfo(deviceID);
        if (di.getDeviceVersion() == DeviceVersion.T18000) {
            return PerfStatHisSftp.queryT18000(di, begin, end);
        }
        if (di.getDeviceVersion() == DeviceVersion.TV1) {
            return PerfStatHisSftp.queryByTV1(di, begin, end);
        }
        return PerfStatHisSftp.query(di, begin, end);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, List<String>> queryByTV1(DeviceInfo di, long begin, long end) {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        List<String> ips = QuerInfo.querControllerIPByTV1(di);
        for (String string : ips) {
            List<String> result;
            ArrayList<String> arrayList = new ArrayList<String>();
            SftpClient sftp = null;
            try {
                sftp = PerfStatHisSftp.connect(string, di.getUserName(), di.getPassword(), di.getPort());
                Iterable entrys = sftp.listDir((SftpClient.Handle)sftp.openDir(DEFAULT_PATH_BY_TV1));
                for (SftpClient.DirEntry entry : entrys) {
                    if (entry.getFilename().startsWith("dr")) continue;
                    arrayList.add(DEFAULT_PATH_BY_TV1 + entry.getFilename());
                }
            }
            catch (Exception e) {
                try {
                    LOGGER.error((Object)"", (Throwable)e);
                }
                catch (Throwable throwable) {
                    PerfStatHisSftp.releaseConn(sftp);
                    throw throwable;
                }
                PerfStatHisSftp.releaseConn(sftp);
            }
            PerfStatHisSftp.releaseConn(sftp);
            if (arrayList.isEmpty() || (result = PerfStatHisSftp.filter(arrayList, begin, end)).isEmpty()) continue;
            map.put(string, result);
        }
        int fileCount = 0;
        for (Map.Entry entry : map.entrySet()) {
            fileCount += ((List)entry.getValue()).size();
        }
        AtomicInteger atomicInteger = new AtomicInteger(fileCount);
        di.getDownloadTime().setRemainingFileNum(atomicInteger);
        return map;
    }

    private static BaseConnection getPerConnection(DeviceInfo di) {
        BaseConnection conn = !PerfStatHisSftp.isSftpCanConnected(di.getIp(), 8080, 1000) ? new HisRESTConnection(di, true) : PermanentConnectionMannage.getInstance().getTlvConnection(di);
        return conn;
    }

    private static Map<String, List<String>> queryIntervalsPerfFileBy(DeviceInfo di, int intervals) {
        BaseConnection conn = PerfStatHisSftp.getPerConnection(di);
        List<Record> records = conn.getBatch(55847747608L, new ArrayList<Param>());
        if (records == null || records.isEmpty() || records.get(0).getParams() == null || records.get(0).getParams().isEmpty() || records.get(0).getParam(0).getValue() == null) {
            return null;
        }
        String time = records.get(0).getParam(0).getValue().toString();
        long endTime = Long.parseLong(time) * 1000L;
        long begin = endTime - (long)intervals;
        return PerfStatHisSftp.query(di, begin, endTime, conn);
    }

    public static Map<String, List<String>> querIntervalsPerfFileByPerConnection(DeviceInfo di, int intervals) {
        Map<String, List<String>> filesMap = null;
        try {
            PerfStatHisSftp.getPerConnection(di);
            filesMap = PerfStatHisSftp.queryIntervalsPerfFileBy(di, intervals);
        }
        catch (Exception e) {
            LOGGER.error((Object)("Permanent Connection query Intervals PerfFiles error :" + e));
        }
        if (filesMap == null || filesMap.isEmpty()) {
            PerfStatHisSftp.releaseTlvAndRest(di);
            PerfStatHisSftp.getConnectionRetryByLogin(di);
            filesMap = PerfStatHisSftp.queryIntervalsPerfFileBy(di, intervals);
        }
        PermanentConnectionMannage.getInstance().updateConnectionPool(di);
        return filesMap;
    }

    public static Map<String, List<String>> queryLatesthisPerfFiles(DeviceInfo di, int intervals) throws IsmException {
        HashMap<String, List<String>> latestHisPerfFile = new HashMap<String, List<String>>();
        ArrayList<String> latestFiles = new ArrayList<String>();
        Map<String, List<String>> filesMap = PerfStatHisSftp.querIntervalsPerfFileByPerConnection(di, intervals);
        if (filesMap == null) {
            LOGGER.error((Object)"filesMap is null.");
            return latestHisPerfFile;
        }
        TimeRecord.recordTaskTime(di);
        List<String> fi = filesMap.get(di.getIp());
        for (String file : fi) {
            try {
                String[] set = file.split(SERVER_SPLIT);
                String[] set2 = set[set.length - 1].split("/");
                String fileName = set2[set2.length - 1];
                String filePath = "/svp_data/PerfFile/" + fileName;
                latestFiles.add(filePath);
            }
            catch (Exception e) {
                LOGGER.error((Object)("File name is abnormal,IP is: " + di.getIp() + ",file is: " + file));
            }
        }
        latestHisPerfFile.put(di.getIp(), latestFiles);
        return latestHisPerfFile;
    }

    private static Map<String, List<String>> query(DeviceInfo di, long begin, long end) throws IsmException {
        BaseConnection conn = PerfStatHisSftp.getConnection(di);
        return PerfStatHisSftp.query(di, begin, end, conn);
    }

    private static List<Param> creatParams(DeviceInfo di, long begin, long end) {
        ArrayList<Object> params = null;
        if (di.getDeviceVersion() == DeviceVersion.V3R3) {
            params = new ArrayList<Param>();
            if (begin > 0L) {
                Param startTimePrm = new Param(TLVNEW.PerformanceStatisticFile.CMO_FILE_START_TIME.getParamIndex(), TLVNEW.PerformanceStatisticFile.CMO_FILE_START_TIME.getParamType(), (IsmInteger)new UnsignedInt64(begin /= 1000L));
                params.add(startTimePrm);
            }
            if (end > 0L) {
                Param endTimePrm = new Param(TLVNEW.PerformanceStatisticFile.CMO_FILE_END_TIME.getParamIndex(), TLVNEW.PerformanceStatisticFile.CMO_FILE_END_TIME.getParamType(), (IsmInteger)new UnsignedInt64(end /= 1000L));
                params.add(endTimePrm);
            }
            Param pagePrm = new Param(TLVNEW.PerformanceStatisticFile.CMO_FILE_NUM.getParamIndex(), TLVNEW.PerformanceStatisticFile.CMO_FILE_NUM.getParamType(), (IsmInteger)new UnsignedInt32(200));
            params.add(pagePrm);
        } else if (di.getDeviceVersion() == DeviceVersion.V3R1) {
            params = new ArrayList(0);
        }
        return params;
    }

    private static Map<String, List<String>> query(DeviceInfo di, long begin, long end, BaseConnection conn) throws IsmException {
        List<Param> params = PerfStatHisSftp.creatParams(di, begin, end);
        Param tagPrm = new Param(TLVNEW.PerformanceStatisticFile.CMO_FILE_TAG.getParamIndex(), TLVNEW.PerformanceStatisticFile.CMO_FILE_TAG.getParamType(), "");
        ArrayList<Record> dataList = new ArrayList<Record>();
        List<Record> datas = conn.getBatch(55847747632L, params);
        int maxFile = 10000;
        if (MainDialog.getSceneMarker() == 0) {
            di.setControllerNum(QuerInfo.querControllerNum(di));
            maxFile = di.getControllerNum() * 10000;
        }
        while (!datas.isEmpty() && dataList.size() < maxFile) {
            for (int i = 0; i < datas.size() - 1; ++i) {
                dataList.add(datas.get(i));
            }
            Record lastRecord = datas.get(datas.size() - 1);
            if (lastRecord.getParamValue(4095) != null) {
                long errorCode = ((IsmInteger)lastRecord.getParamValue(4095)).longValue();
                if (errorCode == 1L) break;
                throw new IsmException(errorCode);
            }
            if (TLVUtils.containTag((Record)lastRecord, (int)TLVNEW.PerformanceStatisticFile.CMO_FILE_TAG.getParamIndex())) {
                dataList.add(lastRecord);
                tagPrm.setValue(lastRecord.getParamValue(TLVNEW.PerformanceStatisticFile.CMO_FILE_TAG.getParamIndex()));
                if (params == null) {
                    LOGGER.error((Object)"params value is null!");
                    break;
                }
                datas = conn.getBatch(55847747632L, TLVUtils.addParam(params, (Param[])new Param[]{tagPrm}), false);
                continue;
            }
            dataList.add(lastRecord);
            break;
        }
        if (PerfStatHisSftp.supportEServiceAndCollectHisData()) {
            PerfStatHisSftp.checkFileSize(dataList);
        }
        return PerfStatHisSftp.record2Que(dataList, di.getDeviceID());
    }

    private static boolean supportEServiceAndCollectHisData() {
        return RunModelEnum.E_SERVICE == MainDialog.getRunModel() && Task.Mode.HIS == Task.getMode(ParamHander.getParam().getCollectMode());
    }

    private static void checkFileSize(List<Record> dataList) {
        if (dataList == null || dataList.isEmpty()) {
            return;
        }
        String workPath = ParamHander.getParam().getWorkPath();
        File file = new File(workPath);
        long systemSize = file.getFreeSpace();
        long downloadSize = 0L;
        for (Record record : dataList) {
            if (record == null || record.getFieldCount() == 0) continue;
            TLVNEW.PerformanceStatisticFile performanceStatisticFile = new TLVNEW.PerformanceStatisticFile();
            Map property = TLVUtils.record2Map((Record)record, (TLVMsgDefine)performanceStatisticFile);
            String fileSize = property.get(TLVNEW.PerformanceStatisticFile.CMO_FILE_UPDATE_SIZE).toString();
            long downloadFileSize = Long.parseLong(fileSize);
            downloadSize += downloadFileSize;
        }
        if ((systemSize -= 10240L) < (downloadSize *= 1024L)) {
            throw new IsmException(HisResourceManager.getString("EXPORT-DOWNLOAD-SPACE-ERROR"));
        }
    }

    private static Map<String, List<String>> queryT18000(DeviceInfo di, long begin, long end) {
        String ips = di.getIp();
        String[] ipList = ips.split(SPLIT);
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        for (String i : ipList) {
            List<String> cached = PerfStatHisSftp.list(i, di.getUserName(), di.getPassword(), di.getPort());
            ArrayList<String> fileList = new ArrayList<String>(cached.size());
            fileList.addAll(cached);
            List<String> result = PerfStatHisSftp.filter(fileList, begin, end);
            if (fileList.isEmpty()) continue;
            map.put(i, result);
        }
        return map;
    }

    private static List<String> filter(List<String> fileList, long begin, long end) {
        ArrayList<String> result = new ArrayList<String>();
        Iterator<String> iterator = fileList.iterator();
        SimpleDateFormat df = new SimpleDateFormat(FORMAT);
        String file = null;
        while (iterator.hasNext()) {
            try {
                file = iterator.next();
                String date = file.substring(file.lastIndexOf(SYMBOL1) + 1, file.lastIndexOf(SYMBOL2));
                long time = df.parse(date).getTime();
                if (!PerfStatHisSftp.isBetween(time, begin, end)) continue;
                result.add(file);
            }
            catch (Exception e) {
                LOGGER.error((Object)("filter file failed.file:" + file));
            }
        }
        return result;
    }

    private static boolean isBetween(long time, long begin, long end) {
        boolean flag = end > 0L ? time >= begin && time <= end : time >= begin;
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> list(String ip, String userName, String password, int port) {
        ArrayList<String> fileList = new ArrayList<String>(500);
        SftpClient sftp = null;
        try {
            sftp = PerfStatHisSftp.connect(ip, userName, password, port);
            Iterable entrys = sftp.listDir((SftpClient.Handle)sftp.openDir(DEFAULT_PATH));
            for (SftpClient.DirEntry entry : entrys) {
                if (entry.getFilename().startsWith("dr")) continue;
                fileList.add(DEFAULT_PATH_BY_TV1 + entry.getFilename());
            }
        }
        catch (SftpException e) {
            LOGGER.error((Object)("List file failed,IP: " + ip), (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.error((Object)"", (Throwable)e);
        }
        finally {
            if (sftp != null) {
                try {
                    ClientSession session = sftp.getSession();
                    sftp.close();
                    if (session != null) {
                        session.close();
                    }
                }
                catch (IOException e) {
                    LOGGER.error((Object)"", (Throwable)e);
                }
            }
        }
        return fileList;
    }

    public static Map<String, List<String>> queryRealtimePerfFiles(DeviceInfo device) {
        List<Record> records = null;
        try {
            records = PerfStatHisSftp.queryRealtimePerfFilesByPermanentCon(device);
        }
        catch (Exception e) {
            LOGGER.error((Object)("Permanent Connection query Realtime PerfFiles error :" + e));
        }
        if (records == null || records.isEmpty()) {
            PerfStatHisSftp.releaseTlvAndRest(device);
            records = PerfStatHisSftp.queryRealtimePerfFilesByCreatCon(device);
        }
        PermanentConnectionMannage.getInstance().updateConnectionPool(device);
        TimeRecord.recordTaskTime(device);
        return PerfStatHisSftp.record2QueNew(records, device.getDeviceID());
    }

    private static void releaseTlvAndRest(DeviceInfo device) {
        if (device.hasTlvConn()) {
            device.getConn().close();
            device.setConn(null);
        } else {
            RestConnectionManager.releaseConn((DevNode)device.getDevNode());
        }
    }

    private static BaseConnection getConnectionRetryByLogin(DeviceInfo device) {
        BaseConnection conn;
        if (device == null) {
            return null;
        }
        try {
            conn = PerfStatHisSftp.getConnectionRetry(device);
        }
        catch (IsmException e) {
            LOGGER.error((Object)"", (Throwable)e);
            if (1077949061L == e.getErrorId()) {
                throw new IsmException(HisResourceManager.getString("REST_AUTH_FAILED"), 1077949061L);
            }
            throw new IsmException(HisResourceManager.getString("REST_IO_EXCEPTION"));
        }
        return conn;
    }

    private static List<Record> queryRealtimePerfFilesByCreatCon(DeviceInfo device) {
        BaseConnection conn = PerfStatHisSftp.getConnectionRetryByLogin(device);
        if (null == conn) {
            LOGGER.error((Object)("Failed to get device's stat files, conn IS NULL:" + device.getDeviceID()));
            return null;
        }
        return conn.getBatch(55847747748L, new ArrayList<Param>());
    }

    private static List<Record> queryRealtimePerfFilesByPermanentCon(DeviceInfo device) {
        ArrayList<Param> params;
        BaseConnection conn = PerfStatHisSftp.getPerConnection(device);
        List<Record> records = conn.getBatch(55847747748L, params = new ArrayList<Param>());
        if (records != null && !records.isEmpty()) {
            AbstractSftp.getConnCache().put(device.getDeviceID(), conn);
        }
        return records;
    }

    private static BaseConnection getConnectionRetry(DeviceInfo device) {
        int reNum;
        BaseConnection conn = null;
        for (reNum = 1; reNum < 4; ++reNum) {
            try {
                conn = PerfStatHisSftp.getConnection(device);
                break;
            }
            catch (IsmException e) {
                if (1077949061L == e.getErrorId() || 1077987870L == e.getErrorId()) {
                    throw new IsmException(HisResourceManager.getString("REST_AUTH_FAILED"), 1077949061L);
                }
                LOGGER.error((Object)("try to connect ,retry time : " + reNum + ",DeviceInfo IP is:" + device.getIp()));
                PerfStatHisSftp.sleepSomeTime(2000L);
                continue;
            }
            catch (Exception e) {
                LOGGER.error((Object)("try to connect ,retry time : " + reNum + ",DeviceInfo IP is:" + device.getIp()));
                PerfStatHisSftp.sleepSomeTime(2000L);
            }
        }
        if (reNum >= 4) {
            throw new IsmException(HisResourceManager.getString("REST_IO_EXCEPTION"));
        }
        return conn;
    }

    private static void sleepSomeTime(long sleep) {
        try {
            Thread.sleep(sleep);
        }
        catch (InterruptedException e) {
            LOGGER.error((Object)"Thread.sleep appear abnormal", (Throwable)e);
        }
    }

    private String getNewFilePath(String fileName, BaseConnection conn) throws IsmException {
        ArrayList<Param> params = new ArrayList<Param>(0);
        Param copy = new Param(TLV.PERFORMANCE_STATISTIC_FILE.CMO_STATISTIC_FILE.getParamIndex(), TLV.PERFORMANCE_STATISTIC_FILE.CMO_STATISTIC_FILE.getParamType(), fileName);
        params.add(copy);
        long cmd = this.type == null || this.type == EXPORT_LOG_TYPE ? 55847747632L : 55847747748L;
        List<Record> records = conn.getBatch(cmd, params);
        Iterator<Record> iterator = records.iterator();
        if (iterator.hasNext()) {
            Record record = iterator.next();
            int paramIndex1 = TLV.PERFORMANCE_STATISTIC_FILE.CMO_STATISTIC_FILE.getParamIndex();
            String file = record.getParamStrValue(paramIndex1);
            int newIndex = file.indexOf(SERVER_SPLIT);
            return file.substring(newIndex + 1);
        }
        return null;
    }

    public boolean isDownloadWrong() {
        return this.wrong;
    }

    public void setWrong(boolean wrong) {
        this.wrong = wrong;
    }

    public String getMsg() {
        return this.errMsg;
    }

    public void setStop(boolean stop) {
        this.stop = stop;
    }

    public static void releasePerfSftpCacheByRecordQueue() {
        for (SftpClient sftp : SFTP_CACHE_QUEUE.values()) {
            PerfStatHisSftp.releaseConn(sftp);
        }
    }

    public boolean isStop() {
        return this.stop;
    }

    public AtomicInteger getDownloaded() {
        return this.downloaded;
    }

    public ThreadGroup getTaskPool() {
        return this.taskPool;
    }

    public AtomicInteger getDownloadFailed() {
        return this.downloadFailed;
    }

    public AtomicInteger getDownloadThreadNum() {
        return this.downloadThreadNum;
    }

    private static enum PerfModel {
        HISTORY_PERF,
        REALTIME_PERF;

    }

    class ExportThread
    implements Runnable {
        private final List<String> task;
        private final String ip;
        private final String localPath;
        int fileBlockNumber;

        public ExportThread(List<String> task, String localPath, String ip, int num) {
            this.task = task;
            this.localPath = localPath;
            this.ip = ip;
            this.fileBlockNumber = num;
        }

        @Override
        public void run() {
            PerfStatHisSftp.this.downloadTaskRunningMap.put(this.ip + this.fileBlockNumber, true);
            PerfStatHisSftp.this.downloadFiles(this.task, this.localPath, this.ip, this.fileBlockNumber, PerfModel.HISTORY_PERF);
            PerfStatHisSftp.this.downloadTaskRunningMap.put(this.ip + this.fileBlockNumber, false);
        }
    }
}

