/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.sftp;

import com.huawei.xve.entity.StepDetail;
import com.huawei.xve.utils.DownloadTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProgressUpdateByDownload
extends Thread {
    private static final int REF_INTERVAL = 3000;
    private volatile int progressInitialValue;
    private volatile int progressPieceLength;
    private volatile boolean taskFinish = false;
    private static final Logger LOGGER = LoggerFactory.getLogger(ProgressUpdateByDownload.class);
    private long totalTime = 600L;
    private int num = 0;
    private StepDetail detail;

    public ProgressUpdateByDownload(StepDetail detail, int startProgress, int progressPieceLength) {
        this.progressInitialValue = startProgress;
        this.progressPieceLength = progressPieceLength;
        this.detail = detail;
    }

    @Override
    public void run() {
        while (!this.taskFinish) {
            try {
                Thread.sleep(3000L);
                ++this.num;
                int nowLength = ProgressUpdateByDownload.calcProgressProgressive(this.num, this.progressPieceLength);
                int nowProgress = this.progressInitialValue + nowLength;
                long presentLastTime = this.totalTime - this.totalTime * (long)nowLength / (long)this.progressPieceLength;
                int oldValue = this.detail.getProgress();
                if (oldValue > nowProgress) {
                    LOGGER.warn("Old getProgress is {} and now {}", (Object)oldValue, (Object)nowProgress);
                    continue;
                }
                this.detail.update(nowProgress, DownloadTime.timeLeftToString(presentLastTime));
            }
            catch (InterruptedException e) {
                LOGGER.error("Thread sleep error");
            }
        }
    }

    private static int calcProgressProgressive(int current, int max) {
        double speed = 30.0;
        double block = speed * 2.0;
        int quotient = (int)((double)current / speed);
        int leftover = (int)((double)current % speed);
        if (quotient < 1) {
            return (int)((double)leftover / block * (double)max);
        }
        double undone = 1.0;
        for (int i = 0; i < quotient; ++i) {
            undone *= 2.0;
        }
        double rulst = 1.0 - 1.0 / undone + (double)leftover * (1.0 / undone) / block;
        return (int)(rulst * (double)max);
    }

    public void setTaskFinish(boolean taskFinish) {
        this.taskFinish = taskFinish;
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException e) {
            LOGGER.warn("Interrupted sleep.");
        }
    }

    public void initTotalTime(long totalTime) {
        this.totalTime = totalTime;
    }

    public void reset(int progressInitialValue, int progressPieceLength) {
        this.progressInitialValue = progressInitialValue;
        this.progressPieceLength = progressPieceLength;
        this.num = 0;
    }

    public int getCurrentMaxPro() {
        return this.progressInitialValue + this.progressPieceLength;
    }
}

