/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.sftp;

import com.huawei.ism.common.resourcemanager.HisResourceManager;
import com.huawei.ism.exception.IsmException;
import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.service.common.ToolThreadFactory;
import com.huawei.ism.util.VerifyUtil;
import com.huawei.sftp.AbstractSftp;
import com.huawei.sftp.WorkloadSftp;
import com.huawei.xve.utils.DeviceInfo;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.nio.charset.Charset;
import java.time.Duration;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.apache.sshd.client.channel.ChannelShell;
import org.apache.sshd.client.channel.ClientChannelEvent;
import org.apache.sshd.common.future.CancelOption;
import org.apache.sshd.common.session.Session;

public class ShellCMDExecutor {
    private static final Logger LOGGER = Logger.getLogger(ShellCMDExecutor.class);
    public static final Set<String> END_TAGS = new HashSet<String>();
    protected static final int QUERY_RATE = 10;
    private static Map<DeviceInfo, ShellCMDExecutor> instance;
    private static final int TMOUT = 30000;
    private static final String CHARSET = "UTF-8";
    private static final String SPECILE_END_TAG = "Are you sure to exit?(y/n)";
    private static final CharSequence CMD_EXEC_FAILED;
    private static final CharSequence CMD_EXEC_PROCESS_FAILED;
    private ChannelShell shell;
    private DeviceInfo di;
    private String userMode;
    private ByteArrayOutputStream out = null;
    private final ByteArrayOutputStream stdout = new ByteArrayOutputStream();
    private final ByteArrayOutputStream stderr = new ByteArrayOutputStream();
    private PipedInputStream pis = null;
    private OutputStream stdin = null;
    private boolean login = false;
    private boolean active = true;

    private ShellCMDExecutor(DeviceInfo di) throws IsmException {
        this.di = di;
        this.userMode = di.getUserName() + ":/>";
        try {
            this.shell = AbstractSftp.connectWithShell(di);
        }
        catch (Exception e) {
            LOGGER.error((Object)"get ssh connet failed", (Throwable)e);
            throw new IsmException(HisResourceManager.getString("CONNECTION_SSH_FAILED"), (Throwable)e);
        }
        this.init();
        this.monitor();
    }

    public static ShellCMDExecutor getInstance(DeviceInfo di) throws IsmException {
        if (instance.containsKey(di) && instance.get(di) != null) {
            return instance.get(di);
        }
        ShellCMDExecutor exec = new ShellCMDExecutor(di);
        instance.put(di, exec);
        return exec;
    }

    public static ShellCMDExecutor getCache(DeviceInfo di) throws IsmException {
        return instance.get(di);
    }

    public void addEndTag(String endTag) {
        END_TAGS.add(endTag);
    }

    public void setLogin(boolean login) {
        this.login = login;
    }

    public boolean isLogin() {
        return this.login;
    }

    private void init() throws IsmException {
        try {
            this.out = new ByteArrayOutputStream();
            this.shell.setPtyType("bash");
            this.shell.setPtyLines(Integer.MAX_VALUE);
            this.shell.setUsePty(true);
            this.shell.setIn((InputStream)this.pis);
            this.shell.setOut((OutputStream)this.stdout);
            this.shell.setErr((OutputStream)this.stderr);
            this.shell.open().verify(30000L, TimeUnit.SECONDS, new CancelOption[0]);
            this.stdin = this.shell.getInvertedIn();
        }
        catch (IOException e) {
            LOGGER.error((Object)"create outstream failed.", (Throwable)e);
            throw new IsmException(HisResourceManager.getString("SSH_IO_EXCEPTION"), (Throwable)e);
        }
    }

    public void checkStatus() throws IsmException {
        if (this.shell == null || this.shell.isEofSent() || this.shell.isEofSignalled() || this.shell.isClosed()) {
            this.release();
            throw new IsmException(HisResourceManager.getString("CONNECT_INVALID"));
        }
    }

    public void execCmd(String cmd) throws IsmException {
        this.checkStatus();
        try {
            this.stdin.write(cmd.getBytes(Charset.defaultCharset()));
            this.stdin.flush();
            this.shell.waitFor(EnumSet.of(ClientChannelEvent.OPENED), Duration.ofSeconds(10L));
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)("CMD:" + cmd));
            }
        }
        catch (IOException e) {
            LOGGER.error((Object)"create outstream failed.", (Throwable)e);
            throw new IsmException(HisResourceManager.getString("SSH_IO_EXCEPTION"), (Throwable)e);
        }
    }

    public void execCmd(String cmd, boolean isFlush) {
        if (isFlush) {
            this.out = new ByteArrayOutputStream();
        }
        this.execCmd(cmd);
    }

    public String wait4Result(long timeout) throws IsmException {
        this.checkStatus();
        boolean isEnd = false;
        long tmout = 0L;
        long beginTime = System.currentTimeMillis();
        StringBuffer sb = new StringBuffer();
        String temp = null;
        try {
            while (!isEnd && tmout < 30000L) {
                if (this.out.size() > 0) {
                    temp = new String(this.out.toByteArray(), 0, this.out.size(), CHARSET);
                    sb.append(temp);
                    this.out.reset();
                    isEnd = this.isEnd(isEnd, temp);
                }
                this.sleep(100L);
                tmout = System.currentTimeMillis() - beginTime;
            }
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)("result:" + sb.toString()));
            }
        }
        catch (IOException e) {
            LOGGER.error((Object)"Io error:", (Throwable)e);
            throw new IsmException(HisResourceManager.getString("SSH_IO_EXCEPTION"), (Throwable)e);
        }
        if (!isEnd) {
            throw new IsmException(HisResourceManager.getString("WORKLOAD_ERROR_EXPORT_TMOUT"));
        }
        String ret = sb.toString();
        if (ret.contains(CMD_EXEC_FAILED)) {
            throw new IsmException(WorkloadSftp.getErrorMap().get(0L));
        }
        if (ret.contains(CMD_EXEC_PROCESS_FAILED)) {
            throw new IsmException(WorkloadSftp.getErrorMap().get(0L));
        }
        if (VerifyUtil.isEmpty(sb.toString())) {
            throw new IsmException(WorkloadSftp.getErrorMap().get(0L));
        }
        return ret;
    }

    private String appendResultInfo(StringBuffer sb, String lastResult, String temp) {
        if (!temp.equals(lastResult)) {
            if (!VerifyUtil.isEmpty(temp)) {
                sb.append(temp);
            }
            lastResult = temp;
        }
        return lastResult;
    }

    private boolean isEnd(boolean isEnd, String temp) {
        for (String end : END_TAGS) {
            if (!temp.endsWith(end) && !temp.contains(SPECILE_END_TAG)) continue;
            isEnd = true;
            break;
        }
        return isEnd;
    }

    private void sleep(long time) {
        try {
            Thread.sleep(time);
        }
        catch (Exception e) {
            LOGGER.error((Object)"sleep error:", (Throwable)e);
        }
    }

    public void release() {
        try {
            StreamUtils.closeStream((OutputStream)this.stdin, null);
            StreamUtils.closeStream((OutputStream)this.stdout, null);
            StreamUtils.closeStream((OutputStream)this.stderr, null);
            StreamUtils.closeStream(null, (InputStream)this.pis);
            if (this.out != null) {
                this.out.close();
                this.out = null;
            }
            if (this.shell != null) {
                this.shell.close();
                Session session = this.shell.getSession();
                if (session != null) {
                    session.close();
                }
                this.shell = null;
            }
            instance.remove(this.di);
        }
        catch (IOException e) {
            LOGGER.error((Object)"close failed.", (Throwable)e);
        }
    }

    public String isCMDReady() throws IsmException {
        this.execCmd("\n", true);
        String ret = this.wait4Result(30000L);
        if (ret == null || !ret.endsWith(this.userMode)) {
            throw new IsmException(HisResourceManager.getString("DEVICE_ERROR"));
        }
        return ret;
    }

    private void monitor() {
        ToolThreadFactory.newDefaultThread((Runnable)new Runnable(){

            @Override
            public void run() {
                while (ShellCMDExecutor.this.active) {
                    if (null == ShellCMDExecutor.this.shell || ShellCMDExecutor.this.shell.isEofSent() || ShellCMDExecutor.this.shell.isClosed()) {
                        LOGGER.error((Object)"ShellChannel  seems close or EOF or EXIT_SIGNAL happened!!");
                        ShellCMDExecutor.this.active = false;
                        return;
                    }
                    try {
                        ShellCMDExecutor.this.appendResult();
                    }
                    catch (IOException e) {
                        LOGGER.error((Object)"<ssh>read stdout / stderr failed...", (Throwable)e);
                    }
                    catch (Exception e) {
                        ShellCMDExecutor.this.active = false;
                    }
                    ShellCMDExecutor.this.sleep(10L);
                }
            }
        }).start();
    }

    private void appendResult() throws IOException {
        byte[] stdString = this.getStdString();
        if (stdString.length == 0) {
            return;
        }
        this.out.write(stdString);
        this.out.flush();
    }

    private byte[] getStdString() {
        byte[] content = this.stdout.toByteArray();
        this.stdout.reset();
        return content;
    }

    static {
        END_TAGS.add("admin:/>");
        END_TAGS.add("miniSystem:/>");
        END_TAGS.add("Storage:~ # ");
        END_TAGS.add("Storage: minisystem> ");
        END_TAGS.add(":/>");
        instance = new HashMap<DeviceInfo, ShellCMDExecutor>();
        CMD_EXEC_FAILED = "Command execution failed";
        CMD_EXEC_PROCESS_FAILED = "Error: Failed to process the message";
    }
}

