/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.sftp;

import com.huawei.ftdsanalysis.analysis.iorecord.WorkloadParser;
import com.huawei.ism.common.resourcemanager.HisResourceManager;
import com.huawei.ism.connection.BaseConnection;
import com.huawei.ism.exception.IsmException;
import com.huawei.ism.tlv.TLV;
import com.huawei.ism.tlv.TLVMsgDefine;
import com.huawei.ism.tlv.TLVUtils;
import com.huawei.ism.tlv.bean.Param;
import com.huawei.ism.tlv.bean.Record;
import com.huawei.ism.tlv.lang.IsmInteger;
import com.huawei.ism.tlv.lang.UnsignedInt32;
import com.huawei.ism.tool.base.utils.ZipUtils;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.protocol.sftp.SftpTransfer;
import com.huawei.ism.tool.service.common.ToolThreadFactory;
import com.huawei.ism.ui.swing.dialog.HisDialogUtils;
import com.huawei.ism.util.VerifyUtil;
import com.huawei.sftp.AbstractSftp;
import com.huawei.sftp.JProgressBarNew;
import com.huawei.sftp.ShellCMDExecutor;
import com.huawei.util.HisCliUtil;
import com.huawei.xve.monitor.perfstat.WorkloadBatchExportDialog;
import com.huawei.xve.monitor.perfstat.WorkloadBatchExportLayout;
import com.huawei.xve.monitor.perfstat.WorkloadBatchPraseNew;
import com.huawei.xve.monitor.perfstat.WorkloadExportDialog;
import com.huawei.xve.monitor.perfstat.WorkloadExportLayout;
import com.huawei.xve.utils.DeviceInfo;
import com.huawei.xve.utils.FileUtil;
import com.huawei.xve.utils.QuerInfo;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.JDialog;
import org.apache.sshd.sftp.client.SftpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import utils.FilesUtil;

public class WorkBatchloadSftp
extends AbstractSftp {
    private static final Logger log = LoggerFactory.getLogger(WorkBatchloadSftp.class);
    public static final long SLEEP_TIME = 15000L;
    public static final String NOT_DOWNLOAD = "not_download";
    public static final String IS_DOWNLOAD = "is_download";
    protected static final String VERSION_FILE = "version.nmap";
    protected static final String FILEPATH = "/OSM/coffer_data/ftds/record/";
    protected static final String ZIP = ".zip";
    protected static final String ERROR_TYPE_TITLE = HisResourceManager.getString("ERROR_TYPE_TITLE");
    protected static final UnsignedInt32 EEXPORT_LOG_TYPE = new UnsignedInt32(25);
    protected static final String ERROR_FILE = HisResourceManager.getString("ERROR_FILE");
    protected static final String LOGIN_SHOWUSER = "show user |filterRow column=Name predict=equal_to value=";
    protected static final String PKG_CMD = "show file export_path file_type=workload \n";
    protected static final String PKG_RSLT_CMD = "show file package_result file_type=workload \n";
    protected static final String PKG_PATH_CMD = "show file notification file_type=workload controller_id=";
    protected static final String PKG_RM_CMD = "delete file filetype=workload controller_id=";
    protected static final String PART_EXPORT_TAG = "Partly Exported";
    protected static final CharSequence PART_SUCC_TAG = "Partially Successful";
    protected static final String SPLIT_BLANK = "  +";
    protected static final String SPLIT_ENTER = "\n";
    protected WorkloadBatchExportDialog workloadBatchExportDialog;
    protected WorkloadBatchPraseNew batchPraseWindow;
    protected String[] rltColName = new String[]{"Total Result", "Controller ID", "Single Result"};
    protected static final String SUCC_TAG = "Successful";
    protected static final String CMD_EXEC_SUCC = "Command executed successfully";
    protected static final String FAILD_TAG = "Export Failed";
    protected static final String PATH_TAG = "File Path :";
    protected static final String SYSTEM_BUSY = "Error: System is exporting files";
    protected static final String STR_BLANK = "";
    protected static Map<Long, String> errorMap = HisCliUtil.errorMap;
    protected List<String> nodeIDs = new ArrayList<String>();
    protected ShellCMDExecutor execute = null;
    protected boolean isFinishedPkg = false;
    protected String errMsg;
    protected boolean isWrong = false;
    protected Map<String, String> pkgPath = new HashMap<String, String>();
    protected Map<String, String> nodes = new HashMap<String, String>();
    protected List<Map<?, ?>> nodesInfo = new ArrayList();
    protected BaseConnection conn;
    protected JProgressBarNew jp = new JProgressBarNew();
    protected String localPath;
    protected Map<String, String> failedNode = new HashMap<String, String>();
    protected WorkloadExportDialog window;
    protected WorkloadBatchExportDialog batchWindow;
    protected String userMode;
    protected WorkloadExportLayout workloadLayout;
    protected WorkloadBatchExportLayout workloadBatchLayout;

    public WorkBatchloadSftp(DeviceInfo di) throws IsmException {
        super(di);
        this.userMode = di.getUserName() + ":/>";
    }

    public WorkBatchloadSftp(DeviceInfo di, WorkloadBatchExportDialog batchWindow) throws IsmException {
        super(di);
        this.userMode = di.getUserName() + ":/>";
    }

    public WorkBatchloadSftp(DeviceInfo di, WorkloadBatchExportDialog workloadBatchExportDialog, WorkloadBatchPraseNew batchPraseWindow) throws IsmException {
        this(di);
        this.workloadBatchExportDialog = workloadBatchExportDialog;
        this.batchPraseWindow = batchPraseWindow;
    }

    public Map<String, String> getFailedNode() {
        return this.failedNode;
    }

    protected void initExec() throws IsmException {
        if (this.execute != null) {
            return;
        }
        this.execute = ShellCMDExecutor.getInstance(this.getDi());
        this.execute.addEndTag(this.getDi().getUserName() + ":/>");
    }

    protected void sshVersionBatchDown() {
        if (this.nodeIDs.size() < 1) {
            return;
        }
        this.doBatchDownloadTaskBySsh();
    }

    protected void sshVersionDown() {
        if (this.nodeIDs.size() < 1) {
            log.error("there is no file to be download.");
            HisDialogUtils.showErrorDialog((JDialog)((Object)this.window), HisResourceManager.getString("WORKLOAD_NOFILE"));
            return;
        }
        this.jp.process();
        this.doDownloadTaskBySsh();
    }

    protected void doBatchDownloadTaskBySsh() {
        try {
            if (!this.execute.isLogin()) {
                return;
            }
            log.info("NODES:{}", this.nodeIDs);
            for (String node : this.nodeIDs) {
                try {
                    this.download(node);
                }
                catch (IsmException e) {
                    log.error("download or parse file failed.node:{}", (Object)node, (Object)e);
                    this.sendRmCMDBySSH(node);
                }
                catch (Exception e) {
                    log.error(STR_BLANK, (Throwable)e);
                    this.sendRmCMDBySSH(node);
                }
            }
        }
        catch (IsmException e) {
            log.error("doDownload failed. ", (Throwable)e);
        }
    }

    protected void doDownloadTaskBySsh() {
        ToolThreadFactory.newDefaultThread((Runnable)new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    if (!WorkBatchloadSftp.this.execute.isLogin()) {
                        return;
                    }
                    log.info("NODES:{}", WorkBatchloadSftp.this.nodeIDs);
                    for (String node : WorkBatchloadSftp.this.nodeIDs) {
                        try {
                            WorkBatchloadSftp.this.downloadAndParse(node);
                        }
                        catch (IsmException e) {
                            log.error("download or parse file failed.node:{}", (Object)node, (Object)e);
                            HisDialogUtils.showErrorDialog((JDialog)((Object)WorkBatchloadSftp.this.window), e.getErrorMessage());
                        }
                        catch (Exception e) {
                            log.error(WorkBatchloadSftp.STR_BLANK, (Throwable)e);
                        }
                    }
                }
                catch (IsmException e) {
                    log.error("doDownload failed. ", (Throwable)e);
                    HisDialogUtils.showErrorDialog((JDialog)((Object)WorkBatchloadSftp.this.window), e.getErrorMessage());
                }
                finally {
                    WorkBatchloadSftp.this.jp.endProcess();
                    WorkBatchloadSftp.this.workloadLayout.getSaveToBtn().setEnabled(true);
                }
            }
        }).start();
    }

    protected void download(String node) throws IsmException {
        try {
            this.execute.execCmd(PKG_PATH_CMD + node + SPLIT_ENTER, true);
            String result = this.execute.wait4Result(10000L).trim();
            if (result == null || !result.contains(PATH_TAG)) {
                log.warn("send downloadCMD recieve a error.node:{} ,result:{}", (Object)node, (Object)result);
                throw new IsmException(node + ":" + HisResourceManager.getString("WORKLOAD_GETFILE_FAILED"));
            }
            int tagIdx = result.indexOf(PATH_TAG);
            result = result.substring(tagIdx, result.indexOf(SPLIT_ENTER, tagIdx)).replace("\r", STR_BLANK).replace(SPLIT_ENTER, STR_BLANK);
            this.download(result, this.localPath, node);
            this.sendRmCMDBySSH(node);
            String exportCount = String.valueOf(Integer.valueOf(this.workloadBatchLayout.getExportCount()) + 1);
            this.workloadBatchLayout.setExportCount(exportCount);
            ArrayList<String> str = new ArrayList<String>();
            str.add(result);
            str.add(this.localPath);
            str.add(node);
            this.batchPraseWindow.notify(str);
        }
        catch (IsmException e) {
            log.error("get CMD result failed.", (Throwable)e);
            throw e;
        }
    }

    protected void downloadAndParse(String node) throws IsmException {
        try {
            this.execute.execCmd(PKG_PATH_CMD + node + SPLIT_ENTER, true);
            String result = this.execute.wait4Result(10000L).trim();
            if (result == null || !result.contains(PATH_TAG)) {
                log.warn("send downloadCMD recieve a error.node:{} ,result:{}", (Object)node, (Object)result);
                throw new IsmException(node + ":" + HisResourceManager.getString("WORKLOAD_GETFILE_FAILED"));
            }
            int tagIdx = result.indexOf(PATH_TAG);
            result = result.substring(tagIdx, result.indexOf(SPLIT_ENTER, tagIdx)).replace("\r", STR_BLANK).replace(SPLIT_ENTER, STR_BLANK);
            this.download(result, this.localPath, node);
            this.sendRmCMDBySSH(node);
            this.parseFile(result, this.localPath, node);
        }
        catch (IsmException e) {
            log.error("get CMD result failed.", (Throwable)e);
            throw e;
        }
    }

    public List<Object> isExported() {
        ArrayList<Object> list = new ArrayList<Object>();
        this.initExec();
        String temp = STR_BLANK;
        if (!this.execute.isLogin()) {
            temp = this.execute.wait4Result(60000L);
            this.execute.execCmd(LOGIN_SHOWUSER + this.getDi().getUserName() + SPLIT_ENTER, true);
            temp = this.execute.wait4Result(1L);
            this.checkPower(temp);
        } else {
            temp = this.execute.isCMDReady();
        }
        if (!temp.endsWith(this.userMode)) {
            this.isWrong = true;
            this.errMsg = HisResourceManager.getString("WORKLOAD_ERROR_CHECKUSERORDEVICE");
            list.add(false);
            list.add(this.errMsg);
            return list;
        }
        this.execute.setLogin(true);
        this.execute.execCmd(PKG_CMD, true);
        temp = this.execute.wait4Result(10000L);
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)temp)) {
            this.errMsg = errorMap.get(0L);
        } else {
            if (temp.contains(SYSTEM_BUSY)) {
                this.errMsg = errorMap.get(1077949108L);
                list.add(false);
                list.add(this.errMsg);
                return list;
            }
            if (temp.contains("Error: The disk space is insufficient") || temp.contains("Error: The disk capacity is insufficient")) {
                this.isWrong = true;
                this.errMsg = HisResourceManager.getString("WORKLOAD_ERROR_1073793316");
            } else if (!temp.contains(CMD_EXEC_SUCC)) {
                this.isWrong = true;
                this.errMsg = errorMap.get(0L);
            }
        }
        list.add(true);
        return list;
    }

    public synchronized void batchPkgLogFileBySSH() {
        try {
            this.isFinishedPkg = false;
            this.isWrong = false;
            this.initExec();
            String temp = STR_BLANK;
            if (!this.execute.isLogin()) {
                temp = this.execute.wait4Result(60000L);
                this.execute.execCmd(LOGIN_SHOWUSER + this.getDi().getUserName() + SPLIT_ENTER, true);
                temp = this.execute.wait4Result(1L);
                this.checkPower(temp);
            } else {
                temp = this.execute.isCMDReady();
            }
            if (!temp.endsWith(this.userMode)) {
                this.isWrong = true;
                this.errMsg = HisResourceManager.getString("WORKLOAD_ERROR_CHECKUSERORDEVICE");
                return;
            }
            this.execute.setLogin(true);
            this.execute.execCmd(PKG_CMD, true);
            temp = this.execute.wait4Result(10000L);
            if (!this.cliRetCheck(temp)) {
                log.error("Cmd ret check not pass.");
                return;
            }
            this.waitPkgFinish();
        }
        catch (IsmException e) {
            log.error("pkgError.", (Throwable)e);
            this.isWrong = true;
            this.errMsg = e.getErrorMessage();
        }
        catch (Exception e) {
            log.error(STR_BLANK, (Throwable)e);
        }
    }

    protected void waitPkgFinish() {
        long time = System.currentTimeMillis();
        while (!this.isFinishedPkg && !this.isWrong) {
            String ret = STR_BLANK;
            this.execute.execCmd(PKG_RSLT_CMD, true);
            ret = this.execute.wait4Result(10000L);
            if (ret.contains(this.rltColName[0]) && ret.contains(this.rltColName[1]) && ret.contains(this.rltColName[2])) {
                int idx = ret.indexOf(this.rltColName[0]);
                String[] line = (ret = ret.substring(idx).replace(ret.substring(ret.indexOf(this.userMode, idx)), STR_BLANK)).split(SPLIT_ENTER);
                String[] col1 = line[2].trim().split(SPLIT_BLANK);
                if (col1[0].contains(SUCC_TAG) || col1[0].contains(PART_EXPORT_TAG)) {
                    this.regSuccNode(line);
                    if (this.nodeIDs.size() < 1) {
                        this.isWrong = true;
                        this.errMsg = errorMap.get(0L);
                        log.warn("no file but success from the recieve\uff1a{}", (Object)ret);
                        break;
                    }
                    this.isFinishedPkg = true;
                    break;
                }
                if (col1[0].contains(FAILD_TAG)) {
                    this.regSuccNode(line);
                    log.error("pkg failed:{}", (Object)ret);
                    this.errMsg = errorMap.get(1077949118L);
                    this.isWrong = true;
                    break;
                }
            }
            this.sleep(15000L);
            if (System.currentTimeMillis() - time <= 100000L) continue;
            this.isWrong = true;
            this.errMsg = HisResourceManager.getString("WORKLOAD_GET_RESULT_TMOUT");
            break;
        }
    }

    protected boolean cliRetCheck(String ret) {
        String msg = HisCliUtil.cliRetCheck(ret);
        if (!StringUtils.isNULLStr((String)msg)) {
            this.isWrong = true;
            this.errMsg = msg;
            return false;
        }
        return true;
    }

    public void pkgLogFileBySSH() {
        try {
            this.initExec();
            String temp = STR_BLANK;
            if (!this.execute.isLogin()) {
                temp = this.execute.wait4Result(60000L);
                this.execute.execCmd(LOGIN_SHOWUSER + this.getDi().getUserName() + SPLIT_ENTER, true);
                temp = this.execute.wait4Result(1L);
                this.checkPower(temp);
            } else {
                temp = this.execute.isCMDReady();
            }
            if (!temp.endsWith(this.userMode)) {
                this.isWrong = true;
                this.errMsg = HisResourceManager.getString("WORKLOAD_ERROR_CHECKUSERORDEVICE");
                return;
            }
            this.execute.setLogin(true);
            this.execute.execCmd(PKG_CMD, true);
            temp = this.execute.wait4Result(10000L);
            if (!this.cliRetCheck(temp)) {
                log.error("Cli ret check not pass.");
                return;
            }
            this.waitPkgFinish();
        }
        catch (IsmException e) {
            log.error("pkgError.", (Throwable)e);
            this.isWrong = true;
            this.errMsg = e.getErrorMessage();
        }
        catch (Exception e) {
            log.error(STR_BLANK, (Throwable)e);
        }
    }

    protected void checkPower(String temp) throws IsmException {
        if (temp.contains("does not exist or has an incorrect format") || temp.contains("command not found")) {
            throw new IsmException(HisResourceManager.getString("DEVICE_ERROR"));
        }
        try {
            boolean isSuperAdmin = QuerInfo.checkPermissionBySuper(temp);
            if (!isSuperAdmin) {
                throw new IsmException(HisResourceManager.getString("WORKLOAD_ERROR_1077949058"));
            }
        }
        catch (IsmException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IsmException(HisResourceManager.getString("DEVICE_ERROR"));
        }
    }

    public void closeExec() {
        this.execute.release();
    }

    protected void regSuccNode(String[] line) {
        String[] col = null;
        for (int i = 2; i < line.length; ++i) {
            col = line[i].trim().split(SPLIT_BLANK);
            if (line[i].contains(SUCC_TAG) || line[i].contains(PART_SUCC_TAG)) {
                try {
                    if (col[1] == null || STR_BLANK.equals(col[1])) continue;
                    this.nodeIDs.add(col[1]);
                }
                catch (Exception e) {
                    log.error("get nodeId from succesful node result failed.", (Throwable)e);
                }
                continue;
            }
            try {
                this.failedNode.put(col[1], col[2]);
                continue;
            }
            catch (Exception e) {
                log.error("failedNode put failed.", (Throwable)e);
                return;
            }
        }
    }

    protected void sleep(long time) {
        try {
            Thread.sleep(time);
        }
        catch (Exception e) {
            log.error("sleep error:", (Throwable)e);
        }
    }

    public void pkg() throws Exception {
        if (this.getDi().getdVersion().contains("V300R003C10")) {
            this.pkgLogFile();
        } else {
            this.pkgLogFileBySSH();
        }
    }

    public void batchPkg() throws Exception {
        if (this.getDi().getdVersion().contains("V300R003C10")) {
            this.pkgLogFile();
        } else {
            this.batchPkgLogFileBySSH();
        }
    }

    public void pkgLogFile() throws Exception {
        this.getConnection();
        if (this.conn == null) {
            throw new IOException("cant get connection from this device.please check network and try again.");
        }
        final ArrayList<Param> tlvParams = new ArrayList<Param>();
        Param workloadPara = new Param(TLV.LOG.CMO_EXPORT_TYPE.getParamIndex(), TLV.LOG.CMO_EXPORT_TYPE.getParamType(), (IsmInteger)EEXPORT_LOG_TYPE);
        tlvParams.add(workloadPara);
        this.conngetBatch(tlvParams);
        if (this.isWrong) {
            return;
        }
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() throws IsmException {
                List<Record> records = null;
                while (!WorkBatchloadSftp.this.isFinishedPkg && !WorkBatchloadSftp.this.isWrong) {
                    try {
                        records = WorkBatchloadSftp.this.conn.getBatch(55847747607L, tlvParams);
                        WorkBatchloadSftp.this.parseRecord(records);
                    }
                    catch (IsmException e) {
                        WorkBatchloadSftp.this.isWrong = true;
                        WorkBatchloadSftp.this.errMsg = WorkBatchloadSftp.this.getErrorMsg(e);
                    }
                    catch (Exception e) {
                        WorkBatchloadSftp.this.isWrong = true;
                        log.error("parse failed.execute PACKAGE_ALARM_OR_LOG");
                        WorkBatchloadSftp.this.errMsg = errorMap.get(0L);
                    }
                    finally {
                        try {
                            if (WorkBatchloadSftp.this.isFinishedPkg || WorkBatchloadSftp.this.isWrong) continue;
                            Thread.sleep(15000L);
                        }
                        catch (InterruptedException e1) {
                            log.error("interrupt Pkging thread faild.", (Throwable)e1);
                        }
                    }
                }
            }
        });
        thread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread thread1, Throwable throwable) {
                log.error("{}:{}", (Object)thread1.getName(), (Object)throwable.getMessage());
            }
        });
        thread.setName("WorkBatchloadSftp-Thread-1");
        thread.start();
    }

    private void conngetBatch(List<Param> tlvParams) {
        try {
            this.conn.getBatch(55847747606L, tlvParams);
        }
        catch (IsmException e) {
            if (e.getErrorId() == 1077949069L) {
                this.conn = WorkBatchloadSftp.reConnection(this.getDi());
                this.conn.getBatch(55847747606L, tlvParams);
            }
            this.isWrong = true;
            this.errMsg = this.getErrorMsg(e);
        }
    }

    private void getConnection() {
        try {
            this.conn = WorkBatchloadSftp.getConnection(this.getDi());
        }
        catch (Exception e) {
            this.isWrong = true;
            this.errMsg = HisResourceManager.getString("CONNECTION_GET_FAILED");
        }
    }

    protected String getErrorMsg(IsmException e) {
        String msg = errorMap.get(e.getErrorId());
        if (VerifyUtil.isEmpty(msg)) {
            msg = errorMap.get(0L);
        }
        return msg;
    }

    protected void parseRecord(List<Record> records) throws IsmException {
        log.info("records:{}", records);
        TLV.LOG log = null;
        Map property = null;
        long result = -1L;
        for (Record record : records) {
            long single;
            log = new TLV.LOG();
            property = TLVUtils.record2Map((Record)record, (TLVMsgDefine)log);
            String nodeName = (String)property.get(TLV.LOG.CMO_EXPORT_NODE_NAME);
            Object status = property.get(TLV.LOG.CMO_EXPORT_RESUTT);
            if (status != null) {
                result = this.parse2Long(status);
            }
            if (result == 1077949118L) {
                throw new IsmException(result);
            }
            if (result == 83887409L) break;
            Object singleNodeRst = property.get(TLV.LOG.CMO_EXPORT_SINGLENODE_RESULT);
            if (singleNodeRst == null || (single = this.parse2Long(singleNodeRst)) != 0L && single != 2L) continue;
            if (!this.jp.checkTask(nodeName)) {
                this.jp.addTask(nodeName);
            }
            this.nodesInfo.add(property);
        }
        if (result == 0L || result == 1077949111L) {
            this.isFinishedPkg = true;
        }
    }

    protected long parse2Long(Object status) {
        try {
            return Long.parseLong(status.toString());
        }
        catch (Exception e) {
            log.error("{}", status, (Object)e);
            return -1L;
        }
    }

    public void sendDownCMD(String path, WorkloadExportDialog exportDialog, WorkloadExportLayout layout) {
        this.workloadLayout = layout;
        this.window = exportDialog;
        this.localPath = path;
        if (this.getDi().getdVersion().trim().contains("V300R003C10")) {
            this.tlvVersionDown();
        } else {
            this.sshVersionDown();
        }
    }

    public void sendBatchExportDownCMD(String path, WorkloadBatchExportDialog exportDialog, WorkloadBatchExportLayout layout) {
        this.workloadBatchLayout = layout;
        this.batchWindow = exportDialog;
        this.createKocalPath(path);
        this.sshVersionBatchDown();
    }

    protected void createKocalPath(String path) {
        this.localPath = path;
    }

    protected void tlvVersionDown() {
        if (this.nodesInfo.isEmpty()) {
            log.error("there is no file to be download.");
            HisDialogUtils.showErrorDialog((JDialog)((Object)this.window), HisResourceManager.getString("WORKLOAD_NOFILE"));
            return;
        }
        this.doDownloadTask();
    }

    protected void doDownloadTask() {
        ToolThreadFactory.newDefaultThread(() -> {
            for (Map<?, ?> node : this.nodesInfo) {
                try {
                    this.getDownloadPath(node);
                }
                catch (IsmException e) {
                    log.error("GetDownloadPath failed.nodeInfo:{} ", node);
                    HisDialogUtils.showErrorDialog((JDialog)((Object)this.window), e.getErrorMessage());
                }
                catch (Exception e) {
                    log.error("GetDownloadPath failed.nodeInfo:{} ", node);
                }
            }
            this.jp.endProcess();
            this.workloadLayout.getSaveToBtn().setEnabled(true);
        }).start();
    }

    protected void getDownloadPath(Map<?, ?> property) throws IsmException {
        String node = (String)property.get(TLV.LOG.CMO_EXPORT_NODE_NAME);
        if (VerifyUtil.isEmpty(node)) {
            log.error("InnerError:{}", property);
            return;
        }
        ArrayList<Param> tlvParams = new ArrayList<Param>();
        Param nodeName = new Param(TLV.LOG.CMO_EXPORT_NODE_NAME.getParamIndex(), TLV.LOG.CMO_EXPORT_NODE_NAME.getParamType(), node);
        Param type = new Param(TLV.LOG.CMO_EXPORT_TYPE.getParamIndex(), TLV.LOG.CMO_EXPORT_TYPE.getParamType(), (IsmInteger)EEXPORT_LOG_TYPE);
        tlvParams.add(nodeName);
        tlvParams.add(type);
        List<Record> records = null;
        try {
            records = this.conn.getBatch(55847747751L, tlvParams);
        }
        catch (Exception e) {
            HisDialogUtils.showErrorDialog((JDialog)((Object)this.window), node + ":" + HisResourceManager.getString("WORKLOAD_GETFILE_FAILED"));
            return;
        }
        this.downloadAndParse(records, node);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean download(String serverpath, String path, String node) throws IsmException {
        boolean flag = false;
        serverpath = serverpath.substring(serverpath.lastIndexOf(":") + 1).trim();
        SftpClient ch = null;
        try {
            ch = this.connect(this.getDi().getIp());
            SftpTransfer.downloadFile((String)path, (String)serverpath, (SftpClient)ch);
            flag = true;
        }
        catch (IOException e) {
            try {
                log.error("get ssh connect failed.", (Throwable)e);
                throw new IsmException(HisResourceManager.getString("CONNECTION_SSH_DOWNLOAD_FAILED"));
                catch (Exception e2) {
                    log.error("download {} to {} failed", new Object[]{serverpath, this.localPath, e2});
                    throw new IsmException(errorMap.get(0L));
                }
            }
            catch (Throwable throwable) {
                WorkBatchloadSftp.releaseConn(ch);
                throw throwable;
            }
        }
        WorkBatchloadSftp.releaseConn(ch);
        return flag;
    }

    protected void sendRmCMDBySSH(String node) throws IsmException {
        this.execute.execCmd(PKG_RM_CMD + node + SPLIT_ENTER, true);
        String ret = this.execute.wait4Result(1000L);
        if (!ret.contains(CMD_EXEC_SUCC)) {
            throw new IsmException(node + ":" + HisResourceManager.getString("WORKLOAD_DEVFILE_CLEAR"));
        }
    }

    protected void sendRmCMD(String node) {
        ArrayList<Param> tlvParams = new ArrayList<Param>();
        Param nodeName = new Param(1, TLV.LOG.CMO_EXPORT_NODE_NAME.getParamType(), node);
        Param type = new Param(TLV.LOG.CMO_EXPORT_TYPE.getParamIndex(), TLV.LOG.CMO_EXPORT_TYPE.getParamType(), (IsmInteger)EEXPORT_LOG_TYPE);
        tlvParams.add(type);
        tlvParams.add(nodeName);
        try {
            this.conn.getBatch(55847747604L, tlvParams);
        }
        catch (IsmException e) {
            log.error("clear log failed.node:{}", (Object)node, (Object)e);
            HisDialogUtils.showErrorDialog((JDialog)((Object)this.window), node + ":" + HisResourceManager.getString("WORKLOAD_DEVFILE_CLEAR"));
        }
    }

    protected void downloadAndParse(List<Record> records, String node) throws IsmException {
        String path = records.get(0).getParamStrValue(TLV.LOG.CMO_EXPORT_SINGLENODE_PATH.getParamIndex());
        try {
            this.download(path, this.localPath, node);
            this.sendRmCMD(node);
        }
        catch (IsmException e) {
            log.error(e.getErrorMessage(), (Throwable)e);
            throw e;
        }
        this.parseFile(path, this.localPath, node);
    }

    protected void parseFile(String source, String dest, String processTag) {
        String fileName = source.substring(source.lastIndexOf("/") + 1).trim();
        File file = new File(dest + File.separator + fileName);
        if (!file.exists()) {
            log.error("File download failed.{}", (Object)FilesUtil.getCanonicalPath((File)file));
            HisDialogUtils.showErrorDialog((JDialog)((Object)this.window), processTag + ":" + fileName + HisResourceManager.getString("WORKLOAD_DOWNLOAD_FAILED"));
            return;
        }
        this.jp.setString(processTag + ":" + HisResourceManager.getString("WORKLOAD_UNZIP"));
        try {
            String tarDest = dest + File.separator + "temp_" + Thread.currentThread().getId() + "_" + System.currentTimeMillis();
            String csvDest = dest + File.separator + processTag;
            File destFile = new File(tarDest + FILEPATH);
            try {
                ZipUtils.decompressTarGzFile((File)file, (String)tarDest);
            }
            catch (Exception e) {
                log.error("unzip {} to {} failed.", new Object[]{file, tarDest, e});
                HisDialogUtils.showErrorDialog((JDialog)((Object)this.window), fileName + HisResourceManager.getString("WORKLOAD_UNZIP_FAILED"));
                this.jp.setString(fileName + HisResourceManager.getString("WORKLOAD_UNZIP_FAILED"));
                return;
            }
            this.jp.setString(HisResourceManager.getString("WORKLOAD_PARSING"));
            File[] listFiles = destFile.listFiles();
            File mapFile = new File(destFile + File.separator + VERSION_FILE);
            if (!mapFile.exists()) {
                log.error("{} doesn't contain Map file\uff1a{}", (Object)file.getCanonicalPath(), (Object)VERSION_FILE);
            }
            if (listFiles == null) {
                return;
            }
            WorkloadParser.parse(destFile, csvDest, processTag);
            List<List<Object>> errMsgs = WorkloadParser.getErrMsgs();
            this.jp.setValue(processTag, 100);
            if (WorkloadParser.isParseExcption()) {
                String[] title = new String[]{ERROR_TYPE_TITLE, ERROR_FILE};
                HisDialogUtils.showMultiErrorDialog((Window)((Object)this.window), processTag + ":" + HisResourceManager.getString("WORKLOAD_PARSE_FAILED_RESULT"), title, errMsgs);
                this.jp.setString(processTag + ":" + HisResourceManager.getString("WORKLOAD_PARSE_FAILED"));
                FileUtil.deleteDir(tarDest);
                return;
            }
            this.compressFile(dest, processTag, csvDest, tarDest);
        }
        catch (Exception e) {
            log.error("parse file occused a problem.", (Throwable)e);
        }
    }

    protected void compressFile(String dest, String processTag, String csvDest, String tarDest) {
        this.jp.setString(processTag + ":" + HisResourceManager.getString("WORKLOAD_PARSE_PACKAGE"));
        try {
            HashSet<String> filter = new HashSet<String>();
            filter.add("/" + processTag + "/*");
            ZipUtils.compressByAnt((String)dest, (String)(processTag + ZIP), filter);
            this.jp.setString(processTag + ":" + HisResourceManager.getString("WORKLOAD_PACKAGE_CLEAR"));
            FileUtil.deleteDir(csvDest);
            FileUtil.deleteDir(tarDest);
            this.jp.setString(processTag + ":" + HisResourceManager.getString("WORKLOAD_SUCC"));
        }
        catch (Exception e) {
            HisDialogUtils.showErrorDialog((JDialog)((Object)this.window), processTag + ":" + HisResourceManager.getString("WORKLOAD_PACKAGE_FAILED"));
            this.jp.setString(processTag + ":" + HisResourceManager.getString("WORKLOAD_PACKAGE_FAILED"));
            log.error("compress csv file failed.", (Throwable)e);
        }
    }

    public String getErrMsg() {
        return this.errMsg;
    }

    public boolean isWrong() {
        return this.isWrong;
    }

    public boolean isFinished() {
        return this.isFinishedPkg;
    }

    public Map<String, String> getPkgPath() {
        return this.pkgPath;
    }

    public Map<String, String> getNodes() {
        return this.nodes;
    }

    public static Map<Long, String> getErrorMap() {
        return errorMap;
    }
}

