/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.sftp;

import com.huawei.ism.common.resourcemanager.HisResourceManager;
import com.huawei.ism.exception.IsmException;
import com.huawei.ism.ui.swing.dialog.HisDialogUtils;
import com.huawei.sftp.JProgressBarNew;
import com.huawei.sftp.WorkBatchloadSftp;
import com.huawei.xve.monitor.perfstat.WorkloadExportDialog;
import com.huawei.xve.utils.DeviceInfo;
import javax.swing.JDialog;
import org.apache.log4j.Logger;

public class WorkloadSftp
extends WorkBatchloadSftp {
    private static final Logger LOGGER = Logger.getLogger(WorkloadSftp.class);

    public WorkloadSftp(DeviceInfo di, WorkloadExportDialog window) throws IsmException {
        super(di);
        this.userMode = di.getUserName() + ":/>";
    }

    public WorkloadSftp(DeviceInfo di, JProgressBarNew jp, WorkloadExportDialog window) throws IsmException {
        this(di, window);
        this.jp = jp;
    }

    @Override
    protected void regSuccNode(String[] line) {
        String[] col = null;
        for (int i = 2; i < line.length; ++i) {
            col = line[i].trim().split("  +");
            if (line[i].contains("Successful") || line[i].contains(PART_SUCC_TAG)) {
                try {
                    if (col[1] == null || "".equals(col[1])) continue;
                    this.nodeIDs.add(col[1]);
                    this.jp.addTask(col[1]);
                }
                catch (Exception e) {
                    LOGGER.error((Object)"get nodeId from succesful node result failed.", (Throwable)e);
                }
                continue;
            }
            try {
                this.failedNode.put(col[1], col[2]);
                continue;
            }
            catch (Exception e) {
                LOGGER.error((Object)"failedNode put failed.", (Throwable)e);
                return;
            }
        }
    }

    @Override
    protected void tlvVersionDown() {
        if (this.nodesInfo.isEmpty()) {
            LOGGER.error((Object)"there is no file to be download.");
            HisDialogUtils.showErrorDialog((JDialog)((Object)this.window), HisResourceManager.getString("WORKLOAD_NOFILE"));
            return;
        }
        this.jp.process();
        this.doDownloadTask();
    }

    @Override
    public boolean download(String serverpath, String path, String node) throws IsmException {
        this.jp.setString(node + ":" + HisResourceManager.getString("WORKLOAD_DOWNLOADING"));
        return super.download(serverpath, path, node);
    }
}

