/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.util;

import com.huawei.ism.tool.file.SecurityUtils;
import com.huawei.ism.ui.module.perfhis.util.TarUtils;
import java.io.File;
import java.io.IOException;
import java.security.SecureRandom;
import org.apache.log4j.Logger;

public class HisUtil {
    private static final Logger LOGGER = Logger.getLogger(HisUtil.class);

    public static String decompress(String fileName) {
        if (fileName.endsWith("tgz") || fileName.endsWith("bz2")) {
            File file = new File(fileName);
            String tmpDir = System.getProperty("java.io.tmpdir");
            String extractedFileName = TarUtils.extract(file, tmpDir);
            String newExtractedFileName = HisUtil.appendTimeToFileName(extractedFileName);
            return newExtractedFileName;
        }
        LOGGER.error((Object)"the file format is not supported");
        return fileName;
    }

    public static void compress(String inputFileName, String outputFileName) {
        TarUtils.compress(new File(inputFileName), outputFileName);
    }

    private static String appendTimeToFileName(String fileName) {
        File file = new File(fileName);
        if (!file.exists()) {
            return null;
        }
        String newFileName = "";
        if (fileName.lastIndexOf(".") != -1) {
            String prefixalName = fileName.substring(0, fileName.lastIndexOf("."));
            String suffixalName = fileName.substring(fileName.lastIndexOf("."));
            newFileName = prefixalName + '_' + System.currentTimeMillis() + suffixalName;
        } else {
            newFileName = fileName + '_' + System.currentTimeMillis();
        }
        File newFile = new File(newFileName);
        if (file.renameTo(newFile)) {
            String path = null;
            try {
                path = newFile.getCanonicalPath();
            }
            catch (IOException e) {
                LOGGER.error((Object)"get path error.", (Throwable)e);
                return path;
            }
            return path;
        }
        return null;
    }

    public static double getSecureRandom() {
        SecureRandom random = (SecureRandom)SecurityUtils.createSecureRandom().orElseThrow(() -> new IllegalStateException("getSecureRandom failed."));
        return random.nextDouble();
    }
}

