/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.xve;

import com.huawei.common.RunModelEnum;
import com.huawei.ism.common.bean.DeviceTypeIsm;
import com.huawei.ism.common.resourcemanager.HisResourceManager;
import com.huawei.ism.connection.ConnectionManager;
import com.huawei.ism.connection.HisTLVConnectionImpl;
import com.huawei.ism.exception.IsmException;
import com.huawei.ism.thread.ThreadPoolManager;
import com.huawei.ism.tool.base.ui.dialogs.HelpTitleFrame;
import com.huawei.ism.tool.base.utils.FilePathUtils;
import com.huawei.ism.tool.base.utils.SceneUtils;
import com.huawei.ism.tool.base.utils.SystemEnvUtil;
import com.huawei.ism.tool.base.utils.crypto.EserviceKmcAesCrypterManager;
import com.huawei.ism.tool.framework.init.FrameworkInitiator;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.utils.FileUtils;
import com.huawei.ism.ui.swing.dialog.ProgressDialog;
import com.huawei.ism.ui.swing.plaf.IsmLookAndFeel;
import com.huawei.ism.ui.swing.plaf.IsmPlafUtils;
import com.huawei.ism.ui.swing.plaf.armor.ArmorLookAndFeel;
import com.huawei.ism.ui.swing.plaf.unify.UnifyLookAndFeel;
import com.huawei.ism.util.SwingUtil;
import com.huawei.ism.util.Utils;
import com.huawei.sftp.AbstractSftp;
import com.huawei.sftp.PerfStatHisSftp;
import com.huawei.sftp.ShellCMDExecutor;
import com.huawei.xve.MainPane;
import com.huawei.xve.monitor.eservice.PerfstatHander;
import com.huawei.xve.monitor.eservice.PermanentConnectionMannage;
import com.huawei.xve.monitor.eservice.TimeRecord;
import com.huawei.xve.monitor.perfstat.PerfStatHistoryPane;
import com.huawei.xve.utils.ConnManager;
import com.huawei.xve.utils.HisPerfstatUtil;
import java.awt.Dimension;
import java.awt.Window;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileLock;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.slf4j.Logger;

public class MainDialog
extends HelpTitleFrame {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(MainDialog.class);
    public static final String CONFIG_PATH = "config.hisPerfStat.common";
    private static final long serialVersionUID = 5958460711323262795L;
    private static final Dimension MIN_DIMENSION = new Dimension(928, 706);
    private static MainDialog mainDialog = null;
    private static FileLock toolLock;
    private static FileOutputStream fos;
    private static Locale local;
    private static RunModelEnum runModel;
    private static int sceneMarker;

    public MainDialog() {
        this.initLayout();
        this.setSize(MIN_DIMENSION);
        this.setResizable(false);
        this.setDefaultCloseOperation(2);
        this.setLocationRelativeTo(null);
    }

    public static int getSceneMarker() {
        return sceneMarker;
    }

    public void doHelpActionWork() {
        if (HisPerfstatUtil.isSupportA800Scene()) {
            FileUtils.openHelpFile((String)"hisPerfStat\\A800_hisPerfStat", (Window)((Object)this), (String)".chm");
            return;
        }
        FileUtils.openHelpFile((String)"hisPerfStat\\hisPerfStat", (Window)((Object)this), (String)".chm");
    }

    private void initLayout() {
        MainPane mainPane = new MainPane((JPanel)((Object)new PerfStatHistoryPane(this.getDeviceIDList())));
        this.add(mainPane);
        this.setTitle(HisResourceManager.getString("monitor_term_historyPerformanceMonitor_button"));
        ImageIcon image = new ImageIcon(System.getProperty("user.dir") + "/hisPerfstat.png");
        this.setIconImage(image.getImage());
    }

    public static MainDialog getDialog() {
        return mainDialog;
    }

    public void dispose() {
        this.logout();
    }

    public static void exitSystem() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    PerfStatHisSftp.releasePerfSftpCacheByRecordQueue();
                    MainDialog.releaseLock();
                }
                catch (Exception e) {
                    LOGGER.error("", (Throwable)e);
                }
                finally {
                    Utils.exitSystem();
                }
            }
        };
        ThreadPoolManager.getInstance().executeAndLogException(runnable);
    }

    public void logout() {
        final ProgressDialog progressDialog = new ProgressDialog((Window)((Object)this), HisResourceManager.getString("EXITING_TEXT"), 220);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    MainDialog.releaseLock();
                    if (ConnManager.getDeviceIDList().size() > 0 && ConnManager.getDeviceInfo(ConnManager.getDeviceIDList().get(0)).isLogin()) {
                        LOGGER.info("start to logout device");
                        ConnManager.getConnection(ConnManager.getDeviceIDList().get(0)).close();
                        LOGGER.info("end to logout device");
                    }
                    AbstractSftp.releaseAllCacheConn();
                    this.closeShell();
                    PerfStatHisSftp.releasePerfSftpCacheByRecordQueue();
                }
                catch (Exception e) {
                    LOGGER.error("", (Throwable)e);
                }
                finally {
                    MainDialog.this.closeProgressDialog((JDialog)progressDialog);
                    Utils.exitSystem();
                }
            }

            private void closeShell() {
                for (String id : ConnManager.getDeviceIDList()) {
                    ShellCMDExecutor executor = ShellCMDExecutor.getCache(ConnManager.getDeviceInfo(id));
                    if (executor == null) continue;
                    executor.release();
                }
            }
        };
        ThreadPoolManager.getInstance().executeAndLogException(runnable);
        progressDialog.setVisible(true);
    }

    private void closeProgressDialog(final JDialog progressDialog) {
        SwingUtil.runInEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                progressDialog.setVisible(false);
                progressDialog.dispose();
            }
        });
    }

    private List<String> getDeviceIDList() {
        return ConnManager.getDeviceIDList();
    }

    public static void init(String[] args) {
        IsmPlafUtils.setLocale((Locale)local);
        try {
            UIManager.setLookAndFeel((LookAndFeel)MainDialog.createNewLookAndFeel());
            JFrame.setDefaultLookAndFeelDecorated(true);
            JDialog.setDefaultLookAndFeelDecorated(true);
        }
        catch (UnsupportedLookAndFeelException e) {
            LOGGER.error("", (Throwable)e);
        }
        ConnectionManager.getInstance().registerConnectionClass(DeviceTypeIsm.C3.name(), HisTLVConnectionImpl.class);
        HisResourceManager.init();
        HisResourceManager.registerPropertyFile(CONFIG_PATH, MainDialog.class.getClassLoader());
        HisResourceManager.setLocale(local);
        try {
            ConnManager.init(args);
            FrameworkInitiator.init();
            MainDialog.registExceptionHandler();
        }
        catch (IsmException e) {
            throw new IsmException(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.error("registExceptionHandler fail", (Throwable)e);
        }
        mainDialog = new MainDialog();
    }

    private static IsmLookAndFeel createNewLookAndFeel() {
        return MainDialog.isSupportA800Scene() ? new ArmorLookAndFeel() : new UnifyLookAndFeel();
    }

    private static boolean isSupportA800Scene() {
        return SceneUtils.isScene() && SceneUtils.isSpecialScence((String)System.getenv("jsonScene"), (String[])new String[]{"Troubleshooting"}) && SceneUtils.isSpecialScence((String)SceneUtils.getCurrentSubScene(), (String[])new String[]{"IntelligentCompute_A800_History"});
    }

    private static void registExceptionHandler() {
        boolean success;
        Date date = new Date();
        SimpleDateFormat simple = new SimpleDateFormat("yyyyMMddHHmmss");
        File root = new File(SystemEnvUtil.getDefaultUserDir() + File.separatorChar + "logs");
        if (!root.exists() && !(success = root.mkdirs())) {
            LOGGER.error("Make log dir error");
        }
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread thread, Throwable throwable) {
                LOGGER.error("{}-{}-{}", new Object[]{thread.getName(), thread.getPriority(), thread.getContextClassLoader(), throwable});
            }
        });
    }

    private static boolean lock() {
        try {
            fos = new FileOutputStream("runningFlag");
            FileLock lock = fos.getChannel().tryLock();
            if (null != lock) {
                toolLock = lock;
                return true;
            }
        }
        catch (IOException e) {
            LOGGER.error("lock fail ", (Throwable)e);
        }
        return false;
    }

    private static void releaseLock() {
        if (toolLock != null) {
            try {
                toolLock.release();
            }
            catch (IOException e) {
                LOGGER.error("", (Throwable)e);
            }
        }
        if (fos != null) {
            try {
                fos.close();
            }
            catch (IOException e) {
                LOGGER.error("", (Throwable)e);
            }
        }
    }

    public static void main(String[] args) throws Exception {
        LOGGER.info("start hisperfstat.!");
        if (args != null && "-callTool=cloudservice".equals(args[0])) {
            TimeRecord.recordMainTime();
            sceneMarker = 1;
            MainDialog.setRunModel(RunModelEnum.E_SERVICE);
            MainDialog.initWithEService(args);
        } else {
            local = args != null && args.length > 0 && "en".equals(args[0]) ? Locale.ENGLISH : Locale.CHINA;
            try {
                MainDialog.init(args);
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage());
                return;
            }
            mainDialog.setVisible(true);
        }
    }

    public static RunModelEnum getRunModel() {
        return runModel;
    }

    public static void setRunModel(RunModelEnum runModel) {
        MainDialog.runModel = runModel;
    }

    public static boolean isRunByToolKit() {
        return RunModelEnum.TOOLKIT == runModel;
    }

    private static void initWithEService(String[] args) {
        ConnectionManager.getInstance().registerConnectionClass(DeviceTypeIsm.C3.name(), HisTLVConnectionImpl.class);
        HisResourceManager.init();
        HisResourceManager.registerPropertyFile(CONFIG_PATH, MainDialog.class.getClassLoader());
        FrameworkInitiator.init();
        EserviceKmcAesCrypterManager.setKmcConfigPath((String[])args);
        try {
            MainDialog.registExceptionHandler();
            MainDialog.check(args);
            ConnManager.initWithEService(args);
            PermanentConnectionMannage.getInstance();
            PerfstatHander.handle();
            PermanentConnectionMannage.getInstance().updateLocalXml();
        }
        catch (IsmException e) {
            LOGGER.error("", (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.error("registExceptionHandler fail", (Throwable)e);
        }
        finally {
            MainDialog.exitSystem();
        }
    }

    private static void check(String[] args) {
        if (args.length < 3) {
            throw new IsmException("invalid param!");
        }
        try {
            String taskFilePath = args[1].substring(args[1].indexOf(61) + 1, args[1].length());
            File file = new File(FilePathUtils.filterPath((String)taskFilePath));
            if (!file.exists()) {
                LOGGER.error("taskFile is not exists.");
                throw new IsmException("taskFile is not exists.");
            }
        }
        catch (IsmException e) {
            throw e;
        }
        catch (Exception e) {
            LOGGER.error("", (Throwable)e);
            throw new IsmException("invalid param!");
        }
    }

    static {
        runModel = RunModelEnum.TOOLKIT;
        sceneMarker = 0;
    }
}

