/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.xve.entity;

import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.xve.entity.Status;
import java.util.Date;
import java.util.Observable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StepDetail
extends Observable {
    private static final Logger log = LoggerFactory.getLogger(StepDetail.class);
    private final double factor;
    private final String devId;
    private String startTime = "";
    private String endTime = "";
    private String errMsg = "";
    private String name;
    private int progress;
    private Status status = Status.WAITING;
    private String remainingDesc;

    public void init() {
        this.progress = 0;
        this.status = Status.WAITING;
        this.errMsg = "";
        this.remainingDesc = "";
        this.startTime = "";
        this.endTime = "";
        this.update();
    }

    public void fail(String msg) {
        this.progress = 100;
        this.errMsg = msg;
        this.status = Status.FAILED;
        this.endTime = this.getFormatDate();
        log.info("Task exec failed : {} ", (Object)this);
        this.update();
    }

    public void running() {
        this.status = Status.RUNNING;
        this.startTime = this.getFormatDate();
        this.update();
    }

    public void success() {
        this.progress = 100;
        this.status = Status.SUCCESS;
        this.errMsg = "";
        this.endTime = this.getFormatDate();
        this.update();
    }

    public void partSuccess(String msg) {
        this.progress = 100;
        this.status = Status.PART_SUCCESS;
        this.errMsg = msg;
        this.endTime = this.getFormatDate();
        this.update();
    }

    public void update(int pro) {
        this.update(pro, "");
    }

    public void update(int pro, String desc) {
        this.remainingDesc = desc;
        if (pro < this.progress || pro > 100) {
            log.warn("Can not update pro form {} to {} .", (Object)this.progress, (Object)pro);
            return;
        }
        this.progress = pro;
        this.update();
    }

    private void update() {
        this.setChanged();
        this.notifyObservers(this);
    }

    public boolean isRunning() {
        return this.status == Status.RUNNING;
    }

    public boolean isAbnormal() {
        return this.status == Status.PART_SUCCESS || this.status == Status.FAILED;
    }

    public double getProgressWithFactor() {
        return (double)this.progress * this.factor;
    }

    private String getFormatDate() {
        return StringUtils.formatDate((Object)new Date(), (String)"yyyy-MM-dd HH:mm:ss");
    }

    public StepDetail(double factor, String devId) {
        this.factor = factor;
        this.devId = devId;
    }

    public double getFactor() {
        return this.factor;
    }

    public String getDevId() {
        return this.devId;
    }

    public String getStartTime() {
        return this.startTime;
    }

    public String getEndTime() {
        return this.endTime;
    }

    public String getErrMsg() {
        return this.errMsg;
    }

    public String getName() {
        return this.name;
    }

    public int getProgress() {
        return this.progress;
    }

    public Status getStatus() {
        return this.status;
    }

    public String getRemainingDesc() {
        return this.remainingDesc;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public void setErrMsg(String errMsg) {
        this.errMsg = errMsg;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setProgress(int progress) {
        this.progress = progress;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public void setRemainingDesc(String remainingDesc) {
        this.remainingDesc = remainingDesc;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StepDetail)) {
            return false;
        }
        StepDetail other = (StepDetail)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getFactor(), other.getFactor()) != 0) {
            return false;
        }
        if (this.getProgress() != other.getProgress()) {
            return false;
        }
        String this$devId = this.getDevId();
        String other$devId = other.getDevId();
        if (this$devId == null ? other$devId != null : !this$devId.equals(other$devId)) {
            return false;
        }
        String this$startTime = this.getStartTime();
        String other$startTime = other.getStartTime();
        if (this$startTime == null ? other$startTime != null : !this$startTime.equals(other$startTime)) {
            return false;
        }
        String this$endTime = this.getEndTime();
        String other$endTime = other.getEndTime();
        if (this$endTime == null ? other$endTime != null : !this$endTime.equals(other$endTime)) {
            return false;
        }
        String this$errMsg = this.getErrMsg();
        String other$errMsg = other.getErrMsg();
        if (this$errMsg == null ? other$errMsg != null : !this$errMsg.equals(other$errMsg)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Status this$status = this.getStatus();
        Status other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)((Object)this$status)).equals((Object)other$status)) {
            return false;
        }
        String this$remainingDesc = this.getRemainingDesc();
        String other$remainingDesc = other.getRemainingDesc();
        return !(this$remainingDesc == null ? other$remainingDesc != null : !this$remainingDesc.equals(other$remainingDesc));
    }

    protected boolean canEqual(Object other) {
        return other instanceof StepDetail;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $factor = Double.doubleToLongBits(this.getFactor());
        result = result * 59 + (int)($factor >>> 32 ^ $factor);
        result = result * 59 + this.getProgress();
        String $devId = this.getDevId();
        result = result * 59 + ($devId == null ? 43 : $devId.hashCode());
        String $startTime = this.getStartTime();
        result = result * 59 + ($startTime == null ? 43 : $startTime.hashCode());
        String $endTime = this.getEndTime();
        result = result * 59 + ($endTime == null ? 43 : $endTime.hashCode());
        String $errMsg = this.getErrMsg();
        result = result * 59 + ($errMsg == null ? 43 : $errMsg.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Status $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)((Object)$status)).hashCode());
        String $remainingDesc = this.getRemainingDesc();
        result = result * 59 + ($remainingDesc == null ? 43 : $remainingDesc.hashCode());
        return result;
    }

    public String toString() {
        return "StepDetail(factor=" + this.getFactor() + ", devId=" + this.getDevId() + ", startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ", errMsg=" + this.getErrMsg() + ", name=" + this.getName() + ", progress=" + this.getProgress() + ", status=" + (Object)((Object)this.getStatus()) + ", remainingDesc=" + this.getRemainingDesc() + ")";
    }
}

