/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.xve.entity;

import com.huawei.xve.entity.Status;
import com.huawei.xve.entity.StepDetail;
import com.huawei.xve.entity.TaskEnv;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskDetail
extends Observable
implements Observer {
    private static final Logger log = LoggerFactory.getLogger(TaskDetail.class);
    private int progress;
    private String errMsg;
    private Status status = Status.WAITING;
    private List<StepDetail> subTasks;
    private TaskEnv env;

    public TaskDetail(TaskEnv env, List<StepDetail> subTasks) {
        this.env = env;
        this.subTasks = subTasks;
        subTasks.forEach(subTask -> subTask.addObserver(this));
        this.addObserver(env.getObs());
    }

    public void init() {
        this.progress = 0;
        this.status = Status.WAITING;
        this.errMsg = "";
        this.update();
    }

    public void running() {
        this.status = Status.RUNNING;
        this.update();
    }

    public void success() {
        this.status = Status.SUCCESS;
        this.progress = 100;
        this.errMsg = "";
        this.update();
    }

    public void partSuccess(String msg) {
        this.status = Status.PART_SUCCESS;
        this.progress = 100;
        this.errMsg = msg;
        this.update();
    }

    private void updateProgress() {
        int oldPro = this.progress;
        int newPro = this.calcPro();
        if (oldPro == newPro) {
            return;
        }
        this.progress = newPro;
        this.setChanged();
    }

    public void fail(String msg) {
        this.errMsg = msg;
        this.status = Status.FAILED;
        this.setChanged();
        this.notifyObservers(this);
    }

    public void updateStatus(Status status) {
        if (this.status == status) {
            return;
        }
        this.status = status;
        this.setChanged();
        this.notifyObservers(this);
    }

    @Override
    public void update(Observable o, Object arg) {
        this.updateProgress();
        this.notifyObservers(this);
    }

    private int calcPro() {
        return (int)this.subTasks.stream().mapToDouble(StepDetail::getProgressWithFactor).sum();
    }

    private void update() {
        this.setChanged();
        this.notifyObservers(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TaskDetail)) {
            return false;
        }
        TaskDetail other = (TaskDetail)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getProgress() != other.getProgress()) {
            return false;
        }
        String this$errMsg = this.getErrMsg();
        String other$errMsg = other.getErrMsg();
        if (this$errMsg == null ? other$errMsg != null : !this$errMsg.equals(other$errMsg)) {
            return false;
        }
        Status this$status = this.getStatus();
        Status other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)((Object)this$status)).equals((Object)other$status)) {
            return false;
        }
        List<StepDetail> this$subTasks = this.getSubTasks();
        List<StepDetail> other$subTasks = other.getSubTasks();
        if (this$subTasks == null ? other$subTasks != null : !((Object)this$subTasks).equals(other$subTasks)) {
            return false;
        }
        TaskEnv this$env = this.getEnv();
        TaskEnv other$env = other.getEnv();
        return !(this$env == null ? other$env != null : !this$env.equals(other$env));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TaskDetail;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getProgress();
        String $errMsg = this.getErrMsg();
        result = result * 59 + ($errMsg == null ? 43 : $errMsg.hashCode());
        Status $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)((Object)$status)).hashCode());
        List<StepDetail> $subTasks = this.getSubTasks();
        result = result * 59 + ($subTasks == null ? 43 : ((Object)$subTasks).hashCode());
        TaskEnv $env = this.getEnv();
        result = result * 59 + ($env == null ? 43 : $env.hashCode());
        return result;
    }

    public int getProgress() {
        return this.progress;
    }

    public String getErrMsg() {
        return this.errMsg;
    }

    public Status getStatus() {
        return this.status;
    }

    public List<StepDetail> getSubTasks() {
        return this.subTasks;
    }

    public TaskEnv getEnv() {
        return this.env;
    }

    public void setProgress(int progress) {
        this.progress = progress;
    }

    public void setErrMsg(String errMsg) {
        this.errMsg = errMsg;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public void setSubTasks(List<StepDetail> subTasks) {
        this.subTasks = subTasks;
    }

    public void setEnv(TaskEnv env) {
        this.env = env;
    }

    public String toString() {
        return "TaskDetail(progress=" + this.getProgress() + ", errMsg=" + this.getErrMsg() + ", status=" + (Object)((Object)this.getStatus()) + ", subTasks=" + this.getSubTasks() + ", env=" + this.getEnv() + ")";
    }
}

