/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.xve.entity;

import com.huawei.xve.entity.ExportParam;
import com.huawei.xve.server.IUIObserver;
import com.huawei.xve.utils.DeviceInfo;
import com.huawei.xve.utils.FileUtil;
import com.huawei.xve.utils.HisPerfstatUtil;
import java.io.File;
import java.util.List;
import java.util.Map;

public class TaskEnv {
    private final DeviceInfo deviceInfo;
    private ExportParam param;
    private final IUIObserver obs;
    private Map<String, List<String>> perfFiles;
    private String a800ResultDir;

    public long getFileCount() {
        if (this.perfFiles == null) {
            return 0L;
        }
        return this.perfFiles.values().stream().mapToLong(List::size).sum();
    }

    public String getResultDir() {
        return this.param.getResultDir() + File.separator + FileUtil.formatIpForPath(this.deviceInfo.getIp());
    }

    public String getDmeResultDir() {
        if (HisPerfstatUtil.isa800Dme(this.deviceInfo)) {
            return String.join((CharSequence)File.separator, this.a800ResultDir, "hyperscale");
        }
        return String.join((CharSequence)File.separator, this.a800ResultDir, "zone", FileUtil.formatIpForPath(this.deviceInfo.getIp()));
    }

    public String getDpcResultDir() {
        return this.deviceInfo.isA800Cluster() ? String.join((CharSequence)File.separator, this.a800ResultDir, "dataturbo") : this.a800ResultDir;
    }

    TaskEnv(DeviceInfo deviceInfo, ExportParam param, IUIObserver obs, Map<String, List<String>> perfFiles, String a800ResultDir) {
        this.deviceInfo = deviceInfo;
        this.param = param;
        this.obs = obs;
        this.perfFiles = perfFiles;
        this.a800ResultDir = a800ResultDir;
    }

    public static TaskEnvBuilder builder() {
        return new TaskEnvBuilder();
    }

    public DeviceInfo getDeviceInfo() {
        return this.deviceInfo;
    }

    public ExportParam getParam() {
        return this.param;
    }

    public IUIObserver getObs() {
        return this.obs;
    }

    public Map<String, List<String>> getPerfFiles() {
        return this.perfFiles;
    }

    public String getA800ResultDir() {
        return this.a800ResultDir;
    }

    public void setParam(ExportParam param) {
        this.param = param;
    }

    public void setPerfFiles(Map<String, List<String>> perfFiles) {
        this.perfFiles = perfFiles;
    }

    public void setA800ResultDir(String a800ResultDir) {
        this.a800ResultDir = a800ResultDir;
    }

    public static class TaskEnvBuilder {
        private DeviceInfo deviceInfo;
        private ExportParam param;
        private IUIObserver obs;
        private Map<String, List<String>> perfFiles;
        private String a800ResultDir;

        TaskEnvBuilder() {
        }

        public TaskEnvBuilder deviceInfo(DeviceInfo deviceInfo) {
            this.deviceInfo = deviceInfo;
            return this;
        }

        public TaskEnvBuilder param(ExportParam param) {
            this.param = param;
            return this;
        }

        public TaskEnvBuilder obs(IUIObserver obs) {
            this.obs = obs;
            return this;
        }

        public TaskEnvBuilder perfFiles(Map<String, List<String>> perfFiles) {
            this.perfFiles = perfFiles;
            return this;
        }

        public TaskEnvBuilder a800ResultDir(String a800ResultDir) {
            this.a800ResultDir = a800ResultDir;
            return this;
        }

        public TaskEnv build() {
            return new TaskEnv(this.deviceInfo, this.param, this.obs, this.perfFiles, this.a800ResultDir);
        }

        public String toString() {
            return "TaskEnv.TaskEnvBuilder(deviceInfo=" + this.deviceInfo + ", param=" + this.param + ", obs=" + this.obs + ", perfFiles=" + this.perfFiles + ", a800ResultDir=" + this.a800ResultDir + ")";
        }
    }
}

