/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.xve.monitor.eservice;

import com.huawei.ism.common.resourcemanager.HisResourceManager;
import com.huawei.ism.exception.IsmException;
import com.huawei.ism.tool.base.utils.AESEncrypt;
import com.huawei.ism.tool.base.utils.XmlUtils;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.User;
import com.huawei.ism.tool.obase.utils.NetUtil;
import com.huawei.xve.monitor.eservice.ResultHander;
import com.huawei.xve.monitor.perfstat.PerfStatHistoryPane;
import com.huawei.xve.utils.ConnManager;
import com.huawei.xve.utils.DeviceInfo;
import com.huawei.xve.utils.DeviceVersion;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParamHander {
    private static final Logger log = LoggerFactory.getLogger(ParamHander.class);
    private static final org.apache.log4j.Logger LOGGER = org.apache.log4j.Logger.getLogger(ParamHander.class);
    private static final String LANGUAGE_TAG = "language";
    private static final String WORKPATH_TAG = "workPath";
    private static final String DEVLIST_TAG = "deviceList";
    private static final String PARAM_TAG = "paramList";
    private static Param param;
    private final Element xmlElement;

    public ParamHander(InputStream ins) {
        try {
            this.xmlElement = XmlUtils.getSaxReader().read(ins).getRootElement();
        }
        catch (Exception e) {
            LOGGER.error((Object)"parse xml error.", (Throwable)e);
            throw new IsmException("parse xml error.");
        }
    }

    public void initLanguage() {
        String lan = this.xmlElement.elementText(LANGUAGE_TAG);
        if ("en".equals(lan)) {
            HisResourceManager.setLocale(Locale.ENGLISH);
        } else {
            HisResourceManager.setLocale(Locale.CHINA);
        }
    }

    public void initWorkPath() {
        String work = this.xmlElement.elementText(WORKPATH_TAG);
        if (StringUtils.isBlank((CharSequence)work)) {
            throw new IsmException("no workpath set.");
        }
        File file = new File(work);
        if (!file.isDirectory() && !file.mkdirs()) {
            throw new IsmException("mkdirs failed!.");
        }
        ResultHander.init(work);
        if (ConnManager.getDeviceIDList().isEmpty()) {
            throw new IsmException("no device found.");
        }
        param.setWorkPath(work);
    }

    public String checkDevIps(String[] deviceIps, int portInt) {
        int timeout = 5000;
        for (String ip : deviceIps) {
            if (!NetUtil.isPortCanReach((String)ip, (int)portInt, (int)5000)) continue;
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)("try to connection" + ip + "success."));
            }
            return ip;
        }
        LOGGER.error((Object)"All ip cannot connection!.");
        return deviceIps[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void regDevices(String sec) {
        List selectNodes = this.xmlElement.element(DEVLIST_TAG).elements();
        if (!selectNodes.isEmpty()) {
            int size = Integer.max(selectNodes.size(), 20);
            ExecutorService service = Executors.newFixedThreadPool(size);
            try {
                for (Element node : selectNodes) {
                    service.execute(() -> this.parseDevInfo(node, sec));
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)"Parse devInfo error.", (Throwable)e);
            }
            finally {
                service.shutdown();
                try {
                    service.awaitTermination(5L, TimeUnit.MINUTES);
                }
                catch (InterruptedException e) {
                    LOGGER.error((Object)"Wait task termination error.");
                }
            }
        }
    }

    private void parseDevInfo(Element e, String sec) {
        try {
            String deviceID = e.attributeValue("serialNo");
            String deviceIP = e.attributeValue("devIP");
            String[] deviceIps = deviceIP.split(";");
            String port = e.attributeValue("port");
            int portInt = 22;
            if (null != port && !port.isEmpty()) {
                portInt = Integer.parseInt(port);
            }
            if (deviceIps.length > 1) {
                deviceIP = this.checkDevIps(deviceIps, portInt);
            }
            String userName = e.attributeValue("username");
            String pwd = e.attributeValue("password");
            String publicKeyPath = e.attributeValue("publicKeyPath");
            String publicKeyPwd = e.attributeValue("publicKeyPwd");
            String deviceType = e.attributeValue("deviceType");
            String devVersion = e.attributeValue("devVersion");
            DeviceInfo di = new DeviceInfo();
            DevNode devNode = new DevNode();
            User user = new User(AESEncrypt.decrypt((String)userName, (String)sec), AESEncrypt.decrypt((String)pwd, (String)sec));
            devNode.setLoginUser(user);
            devNode.setSshHostKey(AESEncrypt.decrypt((String)e.attributeValue("sshHostKey"), (String)sec));
            devNode.setVerifySshHostKey(Boolean.valueOf(AESEncrypt.decrypt((String)e.attributeValue("isVerifySshHostKey"), (String)sec)).booleanValue());
            devNode.setVerifyCertificate(Boolean.parseBoolean(AESEncrypt.decrypt((String)e.attributeValue("isVerifyCert"), (String)sec)));
            di.setDevNode(devNode);
            di.setDeviceID(deviceID);
            di.setDeviceName(deviceIP + "_" + deviceID);
            di.setIp(deviceIP);
            di.setPort(portInt);
            di.setPubKey(AESEncrypt.decrypt((String)publicKeyPwd, (String)sec));
            di.setPubKeyFile(AESEncrypt.decrypt((String)publicKeyPath, (String)sec));
            di.setdVersion(devVersion);
            di.setDeviceVersion(DeviceVersion.getDeviceVersion(devVersion, deviceType));
            di.setdType(deviceType);
            if (PerfStatHistoryPane.isVersionAfter(devVersion, "V300R002") || di.getdType().contains("Dorado") || di.getdType().contains("OceanProtect")) {
                ConnManager.setDeviceInfo(di);
            } else {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info((Object)("This device does not support:" + di.getDeviceID()));
                }
                ConnManager.setNotSupportDeviceInfo(di);
            }
        }
        catch (Exception ex) {
            LOGGER.error((Object)"parse dev info error.", (Throwable)ex);
        }
    }

    public void initParam() {
        List params = this.xmlElement.element(PARAM_TAG).elements();
        param = new Param();
        for (Element e : params) {
            this.initValue(e);
        }
    }

    public static Param getParam() {
        return param;
    }

    private void initValue(Element e) {
        if (null == e) {
            LOGGER.warn((Object)"null Element.");
            return;
        }
        String elementAttValue = e.attributeValue("key");
        switch (elementAttValue = elementAttValue == null ? "" : elementAttValue.trim()) {
            case "collectMode": {
                param.setCollectMode(e.attributeValue("value"));
                break;
            }
            case "interval": {
                try {
                    param.setInterval(Integer.parseInt(e.attributeValue("value")));
                }
                catch (NumberFormatException e1) {
                    LOGGER.error((Object)"NumberFormatException");
                }
                break;
            }
            case "startTime": {
                param.setStartTime(e.attributeValue("value"));
                break;
            }
            case "endTime": {
                param.setEndTime(e.attributeValue("value"));
                break;
            }
            case "resources": {
                param.setResources(e.attributeValue("value"));
                break;
            }
            case "metrics": {
                param.setMetrics(e.attributeValue("value"));
                break;
            }
            case "duration": {
                param.setDuration(e.attributeValue("value"));
                break;
            }
            case "collectRecentDays": {
                try {
                    param.setRecentDays(Integer.parseInt(e.attributeValue("value")));
                }
                catch (NumberFormatException exception) {
                    LOGGER.error((Object)"NumberFormatException", (Throwable)exception);
                }
                break;
            }
            default: {
                LOGGER.warn((Object)("unsupport param:" + e.attributeValue("key")));
            }
        }
    }

    public static class Param {
        private String collectMode;
        private int interval;
        private String startTime;
        private String endTime;
        private String resources;
        private String metrics;
        private String workPath;
        private String duration;
        private int recentDays;

        private Param() {
        }

        public void setRecentDays(int recentDays) {
            if (!this.isLegalTime(recentDays)) {
                log.error("The collection days are not within the specified range. RecentDays is {}", (Object)recentDays);
                throw new IsmException(HisResourceManager.getString("eservice.remote.perfstat.recent.days.error"));
            }
            this.recentDays = recentDays;
        }

        public String getDuration() {
            return this.duration;
        }

        public void setDuration(String duration) {
            this.duration = duration;
        }

        public String getWorkPath() {
            return this.workPath;
        }

        public void setWorkPath(String workPath) {
            this.workPath = workPath;
        }

        public String getCollectMode() {
            return this.collectMode;
        }

        public void setCollectMode(String collectMode) {
            this.collectMode = collectMode;
        }

        public int getInterval() {
            return this.interval;
        }

        public void setInterval(int interval) {
            this.interval = interval;
        }

        public String getStartTime() {
            return this.startTime;
        }

        public void setStartTime(String startTime) {
            this.startTime = startTime;
        }

        public String getEndTime() {
            return this.endTime;
        }

        public void setEndTime(String endTime) {
            this.endTime = endTime;
        }

        public String getResources() {
            return this.resources;
        }

        public void setResources(String resources) {
            this.resources = resources;
        }

        public String getMetrics() {
            return this.metrics;
        }

        public void setMetrics(String metrics) {
            this.metrics = metrics;
        }

        private boolean isLegalTime(int recentDays) {
            return recentDays > 0 && recentDays < 16;
        }

        public int getRecentDays() {
            return this.recentDays;
        }
    }
}

