/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.xve.monitor.eservice;

import com.huawei.xve.monitor.eservice.ParamHander;
import com.huawei.xve.monitor.eservice.ResultHander;
import com.huawei.xve.monitor.eservice.task.ProcessTask;
import com.huawei.xve.monitor.eservice.task.Task;
import com.huawei.xve.utils.ConnManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.log4j.Logger;

public class PerfstatHander {
    private static final Logger LOGGER = Logger.getLogger(PerfstatHander.class);
    private static int threadNum = 10;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void handle() {
        ParamHander.Param param = ParamHander.getParam();
        if (param == null) {
            LOGGER.error((Object)"no param init.");
            return;
        }
        int succs = 0;
        List<String> ids = ConnManager.getDeviceIDList();
        Task.Mode mode = Task.getMode(param.getCollectMode());
        Task task = null;
        ProcessTask processTask = new ProcessTask();
        ExecutorService executorService = Executors.newFixedThreadPool(threadNum);
        ArrayList<Future<String>> resultList = new ArrayList<Future<String>>();
        HashMap<Future<String>, String> mapFuture = new HashMap<Future<String>, String>();
        for (String id : ids) {
            task = new Task(id, mode, processTask);
            Future<String> result = executorService.submit(task);
            mapFuture.put(result, id);
            resultList.add(result);
        }
        try {
            processTask.process(resultList, mapFuture);
            succs = processTask.getSuccess();
            ResultHander.getHander().close();
            ResultHander.getHander().setCloseMark(true);
            processTask.doZip();
            ResultHander.getHander().setCloseMark(false);
            ResultHander.getHander().update("status", "finished", false);
        }
        catch (Throwable throwable) {
            ResultHander.getHander().close();
            ResultHander.getHander().setCloseMark(true);
            processTask.doZip();
            ResultHander.getHander().setCloseMark(false);
            ResultHander.getHander().update("status", "finished", false);
            ResultHander.getHander().update("result", succs > 0 ? "success" : "failed", false);
            String msg = succs > 0 ? (succs == resultList.size() ? "" : "part succs") : "all failed";
            ResultHander.getHander().update("errMsg", msg, true);
            ResultHander.getHander().close();
            ResultHander.getHander().setCloseMark(true);
            throw throwable;
        }
        ResultHander.getHander().update("result", succs > 0 ? "success" : "failed", false);
        String msg = succs > 0 ? (succs == resultList.size() ? "" : "part succs") : "all failed";
        ResultHander.getHander().update("errMsg", msg, true);
        ResultHander.getHander().close();
        ResultHander.getHander().setCloseMark(true);
    }

    static {
        try {
            ResourceBundle sysBundle = ResourceBundle.getBundle("config.hisPerfStat.hisConfig");
            threadNum = Integer.parseInt(sysBundle.getString("realTime.perf.dev.thread.num"));
        }
        catch (Exception e) {
            LOGGER.warn((Object)"Init dev thread err,use default value");
        }
        LOGGER.info((Object)String.format(Locale.ROOT, "Init dev thread num %d", threadNum));
    }
}

