/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.xve.monitor.eservice;

import com.huawei.ism.common.bean.User;
import com.huawei.ism.common.resourcemanager.HisResourceManager;
import com.huawei.ism.connection.HisTLVConnection;
import com.huawei.ism.exception.IsmException;
import com.huawei.ism.tool.base.utils.AESEncrypt;
import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.base.utils.SystemEnvUtil;
import com.huawei.ism.tool.base.utils.XmlUtils;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.protocol.rest.RestConnection;
import com.huawei.ism.tool.protocol.rest.RestConnectionManager;
import com.huawei.xve.utils.ConnManager;
import com.huawei.xve.utils.DeviceInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hc.client5.http.cookie.Cookie;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

public class PermanentConnectionMannage {
    private static final Logger LOGGER = Logger.getLogger(PermanentConnectionMannage.class);
    private Map<String, RestInfo> restInfoPool = new ConcurrentHashMap<String, RestInfo>();
    private Map<String, TlvInfo> tlvInfoPool = new ConcurrentHashMap<String, TlvInfo>();
    private boolean needUpdate = false;
    private static final String FILE_NAME = "PermanentConnection.xml";
    private static final String FILE_PATH = SystemEnvUtil.getDefaultUserDir() + File.separator + "configuration" + File.separator + "PermanentConnection.xml";
    private static final String CONNECTIONS = "connections";
    private static final String CONNECTION = "connection";
    private static final String NAME = "name";
    private static final String TYPE = "type";
    private static final String SN = "SN";
    private static final String LEVEL = "level";
    private static final String SESSION = "session";
    private static final String TOKEN = "token";
    private static final String REST = "rest";
    private static final String TLV = "tlv";
    private static final String COOKIE = "cookie";
    private static final String ID = "id";
    private static final String USERSTATE = "userState";
    private static final String PWDCHANGETIME = "pwdChangeTime";
    private static PermanentConnectionMannage permanentConnectionMannage = new PermanentConnectionMannage();

    private PermanentConnectionMannage() {
        this.init();
    }

    public static PermanentConnectionMannage getInstance() {
        return permanentConnectionMannage;
    }

    private void init() {
        File localXml = new File(FILE_PATH);
        if (localXml.exists()) {
            this.parsLocalXml();
        } else {
            this.needUpdate = true;
        }
    }

    public RestConnection getRestConnection(DevNode dev) throws ToolException {
        String sn = dev.getDeviceSerialNumber();
        if (this.restInfoPool.containsKey(sn) && dev.getLoginUser().getUserName().equals(this.restInfoPool.get(sn).name)) {
            RestInfo restInfo = this.restInfoPool.get(sn);
            return RestConnectionManager.getRestConnectionBySession((DevNode)dev, (String)restInfo.session, (String)restInfo.token, (int)restInfo.level, (List)restInfo.cookieInfoList);
        }
        RestConnection restConn = RestConnectionManager.getRestConnectionThrowLoginError((DevNode)dev);
        return restConn;
    }

    public void updateConnectionPool(DeviceInfo device) {
        if (device == null) {
            return;
        }
        try {
            if (device.hasTlvConn()) {
                this.addTlvInfo(device);
            } else {
                this.addRestInfo(device);
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"update Connection Pool error.", (Throwable)e);
        }
    }

    public HisTLVConnection getTlvConnection(DeviceInfo device) {
        String deviceID = device.getDeviceID();
        if (this.tlvInfoPool.containsKey(deviceID) && device.getUserName().equals(this.tlvInfoPool.get(deviceID).name)) {
            device.creatConn(true);
            return device.getConn();
        }
        HisTLVConnection conn = ConnManager.getConnection(device.getDeviceID());
        return conn;
    }

    public User authenticateByTlvInfo(DeviceInfo device, HisTLVConnection conn) {
        if (this.tlvInfoPool.containsKey(device.getDeviceID())) {
            TlvInfo tlvInfo = this.tlvInfoPool.get(device.getDeviceID());
            return conn.authenticateByTlvInfo(tlvInfo.session, tlvInfo.level, tlvInfo.id, tlvInfo.userState, tlvInfo.pwdChangeTime);
        }
        User user = conn.authenticate();
        return user;
    }

    private void updateRestInfo(DeviceInfo device) throws ToolException {
        RestConnection conn = RestConnectionManager.getRestConnectionThrowLoginError((DevNode)device.getDevNode());
        String sn = conn.getDevNode().getDeviceSerialNumber();
        String session = conn.getSession().getSessionID();
        String token = conn.getSession().getToken();
        int level = this.getLevel(conn);
        List cookieList = conn.getSession().getCookieStore().getCookies();
        if (cookieList != null && !cookieList.isEmpty()) {
            ArrayList<Map<String, String>> cookieInfoList = new ArrayList<Map<String, String>>();
            for (Cookie cookie : cookieList) {
                HashMap<String, String> cookieInfo = new HashMap<String, String>();
                cookieInfo.put(NAME, cookie.getName());
                cookieInfo.put("value", cookie.getValue());
                cookieInfoList.add(cookieInfo);
            }
            RestInfo restInfo = new RestInfo(device.getUserName(), session, token, level, cookieInfoList);
            this.needUpdate = true;
            this.restInfoPool.put(sn, restInfo);
        }
    }

    private int getLevel(RestConnection conn) {
        int level = conn.getLevel();
        int roleId = conn.getRoleId();
        if (this.checkLevelAdminOrSuperAdmin(roleId)) {
            return roleId;
        }
        return level;
    }

    private void addRestInfo(DeviceInfo device) throws ToolException {
        RestConnection conn = RestConnectionManager.getRestConnectionThrowLoginError((DevNode)device.getDevNode());
        if (!this.isRestConValidFromCollectionPool(conn)) {
            return;
        }
        String sn = conn.getDevNode().getDeviceSerialNumber();
        String session = conn.getSession().getSessionID();
        if (this.restInfoPool.containsKey(sn) && this.restInfoPool.get(sn).session.equals(session)) {
            return;
        }
        this.updateRestInfo(device);
    }

    private boolean isRestConValidFromCollectionPool(RestConnection conn) {
        if (conn.getDevNode() != null && conn.getSession() != null && conn.getSession().getHttpClient() != null && conn.getSession().getCookieStore() != null) {
            String sn = conn.getDevNode().getDeviceSerialNumber();
            String session = conn.getSession().getSessionID();
            if (!StringUtils.isNULLStr((String)sn) && !StringUtils.isNULLStr((String)session)) {
                return true;
            }
        }
        return false;
    }

    private void addTlvInfo(DeviceInfo device) {
        if (this.tlvInfoPool.containsKey(device.getDeviceID()) && this.tlvInfoPool.get(device.getDeviceID()).session.equals(device.getConn().getSessionKey())) {
            return;
        }
        this.updateTlvInfo(device);
    }

    private void updateTlvInfo(DeviceInfo device) {
        User user = device.getUser();
        TlvInfo tlvInfo = new TlvInfo(device.getUserName(), device.getConn().getSessionKey(), user.getLevel().getValue(), user.getID(), user.getStatus().getValue(), user.getPwdChangeTime());
        this.needUpdate = true;
        this.tlvInfoPool.put(device.getDeviceID(), tlvInfo);
    }

    public void checkPermission(DeviceInfo di) throws IsmException {
        String deviceID = di.getDeviceID();
        boolean isAdminOrSuperAdmin = false;
        isAdminOrSuperAdmin = this.tlvInfoPool.containsKey(deviceID) ? this.checkLevelAdminOrSuperAdmin(this.tlvInfoPool.get(deviceID).level) : (this.restInfoPool.containsKey(deviceID) ? this.checkLevelAdminOrSuperAdmin(this.restInfoPool.get(deviceID).level) : di.isBelongSuperAdmin().booleanValue());
        if (!isAdminOrSuperAdmin) {
            LOGGER.error((Object)("Insufficient permissions ,devIp:" + di.getIp()));
            throw new IsmException(HisResourceManager.getString("PERMISSION_NOT_SUPERADMIN"));
        }
    }

    private boolean checkLevelAdminOrSuperAdmin(int level) {
        return level == 1 || level == 2 || level == 13;
    }

    private void parsLocalXml() {
        File file = new File(FILE_PATH);
        try (FileInputStream ins = new FileInputStream(file);){
            Document document = XmlUtils.getSaxReader().read((InputStream)ins);
            Element xmlElement = document.getRootElement();
            List selectNodes = xmlElement.elements(CONNECTION);
            for (Element e : selectNodes) {
                String type = e.attributeValue(TYPE);
                String sn = e.attributeValue(SN);
                if (type.equals(REST)) {
                    List cookieElementList = e.elements(COOKIE);
                    ArrayList<Map<String, String>> cookieInfoList = new ArrayList<Map<String, String>>();
                    for (Element cookieElement : cookieElementList) {
                        HashMap<String, String> cookieInfo = new HashMap<String, String>();
                        cookieInfo.put(NAME, AESEncrypt.decrypt((String)cookieElement.attributeValue(NAME)));
                        cookieInfo.put("value", AESEncrypt.decrypt((String)cookieElement.attributeValue("value")));
                        cookieInfoList.add(cookieInfo);
                    }
                    RestInfo restInfo = new RestInfo(AESEncrypt.decrypt((String)e.attributeValue(NAME)), AESEncrypt.decrypt((String)e.attributeValue(SESSION)), AESEncrypt.decrypt((String)e.attributeValue(TOKEN)), Integer.parseInt(e.attributeValue(LEVEL)), cookieInfoList);
                    this.restInfoPool.put(sn, restInfo);
                    continue;
                }
                if (!type.equals(TLV)) continue;
                TlvInfo tlvInfo = new TlvInfo(AESEncrypt.decrypt((String)e.attributeValue(NAME)), AESEncrypt.decrypt((String)e.attributeValue(SESSION)), Integer.parseInt(e.attributeValue(LEVEL)), e.attributeValue(ID), Integer.parseInt(e.attributeValue(USERSTATE)), Long.parseLong(e.attributeValue(PWDCHANGETIME)));
                this.tlvInfoPool.put(sn, tlvInfo);
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"parse xml error.", (Throwable)e);
            throw new IsmException("parse xml error.");
        }
    }

    public void updateLocalXml() {
        if (!this.needUpdate) {
            return;
        }
        Document doc = this.connectionInfoToDoc();
        this.writeXmlFile(doc, FILE_PATH);
    }

    private Document connectionInfoToDoc() {
        Element connectionElement;
        Document paramDoc = DocumentHelper.createDocument();
        Element root = paramDoc.addElement(CONNECTIONS);
        for (String sn : this.restInfoPool.keySet()) {
            connectionElement = root.addElement(CONNECTION);
            RestInfo restInfo = this.restInfoPool.get(sn);
            connectionElement.addAttribute(SN, sn);
            connectionElement.addAttribute(NAME, AESEncrypt.encrypt((String)restInfo.name));
            connectionElement.addAttribute(TYPE, REST);
            connectionElement.addAttribute(SESSION, AESEncrypt.encrypt((String)restInfo.session));
            connectionElement.addAttribute(TOKEN, AESEncrypt.encrypt((String)restInfo.token));
            connectionElement.addAttribute(LEVEL, restInfo.level + "");
            List cookieInfoList = restInfo.cookieInfoList;
            for (Map cookieInfo : cookieInfoList) {
                connectionElement.addElement(COOKIE).addAttribute(NAME, AESEncrypt.encrypt((String)((String)cookieInfo.get(NAME)))).addAttribute("value", AESEncrypt.encrypt((String)((String)cookieInfo.get("value"))));
            }
        }
        for (String sn : this.tlvInfoPool.keySet()) {
            connectionElement = root.addElement(CONNECTION);
            TlvInfo tlvInfo = this.tlvInfoPool.get(sn);
            connectionElement.addAttribute(SN, sn);
            connectionElement.addAttribute(NAME, AESEncrypt.encrypt((String)tlvInfo.name));
            connectionElement.addAttribute(TYPE, TLV);
            connectionElement.addAttribute(SESSION, AESEncrypt.encrypt((String)tlvInfo.session));
            connectionElement.addAttribute(LEVEL, tlvInfo.level + "");
            connectionElement.addAttribute(USERSTATE, tlvInfo.userState + "");
            connectionElement.addAttribute(PWDCHANGETIME, tlvInfo.pwdChangeTime + "");
        }
        return paramDoc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeXmlFile(Document doc, String filepath) {
        XMLWriter output = null;
        OutputFormat format = OutputFormat.createPrettyPrint();
        format.setEncoding("UTF-8");
        format.setSuppressDeclaration(false);
        format.setIndent(true);
        format.setIndent("    ");
        format.setNewlines(true);
        FileOutputStream fop = null;
        OutputStreamWriter osw = null;
        try {
            fop = new FileOutputStream(filepath);
            osw = new OutputStreamWriter((OutputStream)fop, "UTF-8");
            output = new XMLWriter((Writer)osw, format);
            output.write(doc);
            output.flush();
        }
        catch (IOException e) {
            LOGGER.error((Object)"Write Xml File error :", (Throwable)e);
        }
        finally {
            if (output != null) {
                try {
                    output.close();
                }
                catch (IOException e) {
                    output = null;
                }
            }
            if (null != osw) {
                try {
                    osw.close();
                }
                catch (IOException e) {
                    LOGGER.error((Object)"OutputStreamWriter close error :", (Throwable)e);
                }
            }
            StreamUtils.closeStream((OutputStream)fop, null);
        }
    }

    private class TlvInfo {
        private String session = null;
        private int level = 0;
        private String id = null;
        private String name = null;
        private int userState;
        private long pwdChangeTime;

        public TlvInfo(String name, String sessionID, int level, String id, int userState, long pwdChangeTime) {
            this.name = name;
            this.session = sessionID;
            this.level = level;
            this.id = id;
            this.userState = userState;
            this.pwdChangeTime = pwdChangeTime;
        }
    }

    private class RestInfo {
        private String session = null;
        private String token = null;
        private int level = 0;
        private String name = null;
        private List<Map<String, String>> cookieInfoList = new ArrayList<Map<String, String>>();

        public RestInfo(String name, String sessionID, String token, int level, List<Map<String, String>> cookieInfoList) {
            this.name = name;
            this.session = sessionID;
            this.token = token;
            this.level = level;
            this.cookieInfoList = cookieInfoList;
        }
    }
}

