/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.xve.monitor.eservice;

import com.huawei.ism.common.resourcemanager.HisResourceManager;
import com.huawei.xve.utils.ConnManager;
import com.huawei.xve.utils.DeviceInfo;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;

public class ResultHander {
    private static final Logger LOGGER = Logger.getLogger(ResultHander.class);
    public static final String PROGRESS = "progress";
    public static final String STATUS = "status";
    public static final String UPDATETIME = "updateTime";
    public static final String RESULT = "result";
    public static final String SUCC = "success";
    public static final String FAILED = "failed";
    public static final String ERRMSG = "errMsg";
    public static final String DEVICE = "device";
    public static final String SERIALNO = "serialNo";
    public static final String WAITING = "waiting";
    public static final String RUNNING = "running";
    public static final String FINISHED = "finished";
    public static final String REMAINTIME = "remainTime";
    public static final String ERRORID = "errorId";
    private static ResultHander ins;
    private static final String RESULT_FILE = "Progress.xml";
    private BufferedWriter bw;
    private volatile boolean closeMark = false;
    Element root;
    private String xmlPath;
    Document doc;

    private ResultHander() {
    }

    public boolean isCloseMark() {
        return this.closeMark;
    }

    public void setCloseMark(boolean closeMark) {
        this.closeMark = closeMark;
    }

    public static ResultHander getHander() {
        return ins;
    }

    public static void init(String workpath) {
        ins = new ResultHander();
        ins.initResultXml(workpath);
    }

    private void initResultXml(String workpath) {
        OutputFormat format = OutputFormat.createPrettyPrint();
        format.setEncoding("utf-8");
        this.doc = DocumentHelper.createDocument();
        this.root = this.doc.addElement(PROGRESS);
        this.root.addAttribute(STATUS, "");
        this.root.addAttribute(PROGRESS, "0");
        String time = this.getTime();
        this.root.addAttribute(UPDATETIME, time);
        this.root.addAttribute(RESULT, "");
        this.root.addAttribute(ERRMSG, "");
        Element device = null;
        List<String> deviceIDList = ConnManager.getDeviceIDList();
        DeviceInfo di = null;
        for (String id : deviceIDList) {
            di = ConnManager.getDeviceInfo(id);
            device = this.root.addElement(DEVICE);
            this.addDeviceAttribute(time, device, di);
        }
        Element notSupporDevice = null;
        List<String> notSupporDeviceIDList = ConnManager.getNotSupporDeviceIDList();
        DeviceInfo notSupporDi = null;
        if (!notSupporDeviceIDList.isEmpty()) {
            for (String id : notSupporDeviceIDList) {
                notSupporDi = ConnManager.getNotSupportDeviceInfo(id);
                notSupporDevice = this.root.addElement(DEVICE);
                notSupporDevice.addAttribute(SERIALNO, notSupporDi.getDeviceID());
                notSupporDevice.addAttribute(STATUS, FINISHED);
                notSupporDevice.addAttribute(PROGRESS, "100");
                notSupporDevice.addAttribute(UPDATETIME, time);
                notSupporDevice.addAttribute(RESULT, FAILED);
                notSupporDevice.addAttribute(ERRMSG, HisResourceManager.getString("DEVICE-NOT-SUPPOR-HISTORY-PERFSTAT"));
                notSupporDevice.addAttribute(ERRORID, "");
                notSupporDevice.addAttribute(REMAINTIME, HisResourceManager.getString("EXPORT-DOWNLOAD-FAILED"));
            }
        }
        if (deviceIDList.isEmpty()) {
            this.root.attribute(STATUS).setValue(FINISHED);
            this.root.attribute(RESULT).setValue(FAILED);
            this.root.attribute(ERRMSG).setValue("no device found.");
        } else {
            this.root.attribute(STATUS).setValue(RUNNING);
        }
        this.xmlPath = workpath + File.separator + RESULT_FILE;
        this.flush(true);
    }

    private void addDeviceAttribute(String time, Element device, DeviceInfo di) {
        device.addAttribute(SERIALNO, di.getDeviceID());
        device.addAttribute(STATUS, WAITING);
        device.addAttribute(PROGRESS, "0");
        device.addAttribute(UPDATETIME, time);
        device.addAttribute(RESULT, "");
        device.addAttribute(ERRMSG, "");
        device.addAttribute(ERRORID, "");
        device.addAttribute(REMAINTIME, HisResourceManager.getString("EXPORT-DOWNLOAD-REMAINTIME"));
    }

    public synchronized void update(String key, String value, String deviceId, boolean isFlush) {
        Iterator devices = this.root.elementIterator(DEVICE);
        Element dev = null;
        while (devices.hasNext()) {
            dev = (Element)devices.next();
            if (!deviceId.equals(dev.attributeValue(SERIALNO))) continue;
            dev.attribute(key).setValue(value);
            if (!isFlush) break;
            dev.attribute(UPDATETIME).setValue(this.getTime());
            this.updateTotalTime();
            break;
        }
        this.flush(isFlush);
    }

    public synchronized void update(String key, String value, boolean isFlush) {
        this.root.attribute(key).setValue(value);
        if (isFlush) {
            this.root.attribute(UPDATETIME).setValue(this.getTime());
        }
        this.flush(isFlush);
    }

    private synchronized void updateTotalTime() {
        this.root.attribute(UPDATETIME).setValue(this.getTime());
    }

    private String getTime() {
        return System.currentTimeMillis() + "";
    }

    private void flush(boolean isFlush) {
        if (this.closeMark) {
            return;
        }
        if (isFlush) {
            this.bw = null;
            try {
                this.bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.xmlPath, false), "UTF-8"));
                this.bw.write(this.doc.asXML());
                this.bw.flush();
            }
            catch (Exception e) {
                LOGGER.error((Object)"", (Throwable)e);
            }
            finally {
                this.close();
            }
        }
    }

    public void close() {
        try {
            if (this.bw != null) {
                this.bw.close();
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"", (Throwable)e);
        }
    }
}

