/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.xve.monitor.eservice;

import com.huawei.json.JSONArray;
import com.huawei.json.JSONObject;
import com.huawei.xve.utils.DeviceInfo;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Date;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class TimeRecord {
    private static final Logger LOGGER = Logger.getLogger(TimeRecord.class);
    private static JSONArray taskJson = new JSONArray();
    private static String startTime = null;

    public static void recordMainTime() {
        Date date = new Date();
        startTime = date.getTime() + "";
    }

    public static synchronized void recordTaskTime(DeviceInfo di) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("IP", di.getIp());
        map.put("SN", di.getDeviceID());
        Date date = new Date();
        map.put("QueryTime", date.getTime() + "");
        taskJson.put(map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exportFile(String path) {
        JSONObject exportJson = new JSONObject();
        exportJson.put("StartTime", (Object)startTime);
        exportJson.put("Tasks", (Object)taskJson);
        BufferedWriter bw = null;
        try {
            File file = new File(path);
            if (!file.createNewFile()) {
                LOGGER.error((Object)"TimeRecord file creat fail");
            }
            bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
            bw.write(exportJson.toString());
            bw.flush();
        }
        catch (Exception e) {
            LOGGER.error((Object)"", (Throwable)e);
        }
        finally {
            try {
                if (bw != null) {
                    bw.close();
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)"", (Throwable)e);
            }
        }
    }
}

