/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.xve.monitor.eservice.task;

import com.huawei.ism.common.resourcemanager.HisResourceManager;
import com.huawei.ism.exception.IsmException;
import com.huawei.ism.tool.protocol.sftp.SftpTransfer;
import com.huawei.ism.util.ThreadUtil;
import com.huawei.ism.util.VerifyUtil;
import com.huawei.sftp.AbstractSftp;
import com.huawei.sftp.IOTraceSftp;
import com.huawei.xve.MainDialog;
import com.huawei.xve.monitor.eservice.ResultHander;
import com.huawei.xve.utils.DeviceInfo;
import com.huawei.xve.utils.FileUtil;
import com.huawei.xve.utils.IOTraceUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.sftp.client.SftpClient;

public class DownloadIOTraceFileTask
extends Thread {
    private static final Logger LOGGER = Logger.getLogger(DownloadIOTraceFileTask.class);
    private static final String IOTRACE_FILE_PREFIX = "cache_trace_";
    private static final long ONE_FILE_DEFAULT_SIZE = 0x200000L;
    private static final int CACHE_MAX_NUM = 8;
    private Map<String, SftpClient> sftpMap = new HashMap<String, SftpClient>();
    private Map<String, List<String>> downloadFileMap = new HashMap<String, List<String>>();
    private DeviceInfo di;
    private IOTraceSftp ioTraceSftp;
    private String contrlName;
    private String downloadPath;
    private volatile boolean isRun = true;

    public DownloadIOTraceFileTask(IOTraceSftp ioTraceSftp, DeviceInfo di, String contrlName) {
        this.ioTraceSftp = ioTraceSftp;
        this.di = di;
        this.contrlName = contrlName;
    }

    public void setRun(boolean isRunSign) {
        this.isRun = isRunSign;
    }

    @Override
    public void run() {
        int failCount = 0;
        try {
            this.beforeCollectTask();
            while (this.isRun && this.ioTraceSftp.isCollect() && !this.ioTraceSftp.isEnd()) {
                failCount = this.core(failCount);
                this.stop(failCount);
            }
            while (!this.ioTraceSftp.isCloseIOTraceSwitch()) {
                ThreadUtil.sleep(500L);
            }
            this.afterStopCollect();
            if (!MainDialog.isRunByToolKit()) {
                this.refreshResult();
            }
        }
        catch (IsmException e) {
            throw new IsmException(e.getErrorMessage());
        }
        catch (Exception e) {
            LOGGER.error((Object)"download io trace files failed.", (Throwable)e);
            throw new IsmException(HisResourceManager.getString("IO_TRACE_DOWNLOAD_FAILED"), (Throwable)e);
        }
        finally {
            this.deleteFile4OneControl();
            this.releaseAllConn();
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)("download task finished by " + this.contrlName));
            }
        }
    }

    private void refreshResult() {
        ResultHander.getHander().update("progress", this.di.getIoTraceParam().getProgress(false) + "", this.di.getDeviceID(), true);
        ResultHander.getHander().update("errorId", this.di.getIoTraceParam().getErrorIdList().toString(), this.di.getDeviceID(), true);
    }

    private void beforeCollectTask() {
        this.deleteFile4OneControl();
    }

    private void stop(int failCount) throws IsmException {
        if (failCount >= 3) {
            LOGGER.error((Object)"download files failed multiple times, so stop download task.");
            throw new IsmException(HisResourceManager.getString("DEVICE_ERROR"));
        }
        if (failCount > 0) {
            ThreadUtil.sleep(10000L);
        }
    }

    private int core(int failCount) {
        try {
            this.queryFileAndDownload(false);
            failCount = 0;
        }
        catch (IOException e) {
            LOGGER.error((Object)("[" + this.contrlName + "] get sftp channel failed. failCount = " + ++failCount), (Throwable)e);
        }
        catch (IsmException e) {
            this.di.setIOTraceErrMsg(e.getErrorMessage());
            throw new IsmException(e.getErrorMessage());
        }
        catch (Exception e) {
            LOGGER.error((Object)("[" + this.contrlName + "] download failed. failCount = " + ++failCount), (Throwable)e);
        }
        return failCount;
    }

    private void afterStopCollect() throws IOException, IsmException {
        this.queryFileAndDownload(true);
    }

    private void queryFileAndDownload(boolean isDownLastFile) throws IOException, IsmException {
        String localPath = this.di.getIoTraceParam().getLocalPath();
        List<Long> resList = this.ioTraceSftp.getResMap().get(this.contrlName);
        if (this.checkResList(resList)) {
            return;
        }
        String ip = this.ioTraceSftp.getIpMap().get(this.contrlName);
        SftpClient sftp = this.getSftpFromCache(ip);
        if (VerifyUtil.isEmpty(sftp)) {
            LOGGER.warn((Object)("get ChannelSftp failed by " + ip));
            return;
        }
        if (this.mkDownloadDir(localPath, ip)) {
            return;
        }
        boolean isHaveFileToDownload = false;
        Iterable entrys = sftp.listDir((SftpClient.Handle)sftp.openDir(IOTraceUtil.getSourceFilePath(this.di)));
        for (SftpClient.DirEntry ele : entrys) {
            ArrayList<String> tempFilePathList = new ArrayList<String>();
            ArrayList<SftpClient.DirEntry> tempList = new ArrayList<SftpClient.DirEntry>();
            Long resId = ele.hashCode();
            this.getTempFileInfo(entrys, Long.valueOf(ele.hashCode()), tempFilePathList, tempList);
            if (VerifyUtil.isEmpty(tempFilePathList)) continue;
            this.di.getIoTraceParam().setHaveIOTraceFileProduce(true);
            List<String> downloadFileList = this.findNeedDownloadFileList(tempFilePathList, this.contrlName, resId, isDownLastFile);
            if (VerifyUtil.isEmpty(downloadFileList)) continue;
            if (!this.checkSystemDirSize(downloadFileList, localPath)) {
                LOGGER.error((Object)"system have not enough space.");
                throw new IsmException(HisResourceManager.getString("IO_TRACE_SYSTEM_NOT_ENOUGH_SPACE"));
            }
            isHaveFileToDownload = true;
            List<String> successList = this.download(sftp, downloadFileList, this.downloadPath);
            if (isDownLastFile || VerifyUtil.isEmpty(successList)) continue;
            this.putFileListToCache(successList, this.contrlName, resId);
        }
        if (!isHaveFileToDownload) {
            isHaveFileToDownload = false;
            ThreadUtil.sleep(TimeUnit.SECONDS.toMillis(1L));
        }
    }

    private boolean mkDownloadDir(String localPath, String ip) {
        if (VerifyUtil.isEmpty(this.downloadPath)) {
            String parentFileName = this.di.getIoTraceParam().getParentFileName();
            this.downloadPath = localPath + File.separator + parentFileName + File.separator + FileUtil.formatIpForPath(ip);
        }
        if (!FileUtil.mkdirs(this.downloadPath)) {
            LOGGER.error((Object)("mkdir failed for ip [" + ip + "]"));
            return true;
        }
        return false;
    }

    private void getTempFileInfo(Iterable<SftpClient.DirEntry> fileList, Long resId, List<String> tempFilePathList, List<SftpClient.DirEntry> tempList) {
        for (SftpClient.DirEntry ele : fileList) {
            if (!ele.getLongFilename().contains(IOTRACE_FILE_PREFIX + resId)) continue;
            String filePath = this.generateFilePath(ele);
            tempFilePathList.add(filePath);
            tempList.add(ele);
        }
    }

    private boolean checkResList(List<Long> resList) {
        if (VerifyUtil.isEmpty(resList)) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)("controller [" + this.contrlName + "] have not any active lun for collect ioTrace."));
            }
            ThreadUtil.sleep(TimeUnit.SECONDS.toMillis(5L));
            return true;
        }
        return false;
    }

    private boolean checkSystemDirSize(List<String> downloadFileList, String localPath) {
        File file = new File(localPath);
        long systemSize = file.getFreeSpace();
        long fileSize = (long)downloadFileList.size() * 0x200000L;
        return fileSize <= systemSize;
    }

    private void putFileListToCache(List<String> fileList, String contrllorName, Long resId) {
        String key = this.generateDownloadFileMapKey(contrllorName, resId);
        List<String> downloadFileList = this.downloadFileMap.get(key);
        if (VerifyUtil.isEmpty(downloadFileList) && !VerifyUtil.isEmpty(fileList)) {
            this.downloadFileMap.put(key, fileList);
            return;
        }
        downloadFileList.addAll(fileList);
        this.sort(downloadFileList);
        if (8 < downloadFileList.size()) {
            int cleanSize = downloadFileList.size() - 8;
            for (int i = 0; i < cleanSize; ++i) {
                downloadFileList.remove(0);
            }
        }
    }

    private List<String> download(SftpClient sftp, List<String> downloadFileList, String downloadPathParam) {
        ArrayList<String> successFileList = new ArrayList<String>();
        for (String path : downloadFileList) {
            boolean success = this.download(sftp, path, downloadPathParam);
            if (!success) continue;
            successFileList.add(path);
            this.di.getIoTraceParam().incrementDownloadFileNum();
        }
        return successFileList;
    }

    private boolean download(SftpClient sftp, String filePath, String localPath) {
        try {
            if (filePath == null) {
                return false;
            }
            SftpTransfer.downloadFile((String)localPath, (String)filePath, (SftpClient)sftp);
            return true;
        }
        catch (IOException e) {
            LOGGER.error((Object)("download file failed.file:" + filePath), (Throwable)e);
            return false;
        }
    }

    private List<String> findNeedDownloadFileList(List<String> tempFileList, String contrllorName, Long resId, boolean isdownLastFile) {
        String key;
        List<String> downloadList;
        this.sort(tempFileList);
        if (!isdownLastFile) {
            tempFileList.remove(tempFileList.size() - 1);
        }
        if (VerifyUtil.isEmpty(downloadList = this.downloadFileMap.get(key = this.generateDownloadFileMapKey(contrllorName, resId)))) {
            return tempFileList;
        }
        ArrayList<String> needDownloadFileList = new ArrayList<String>();
        for (String path : tempFileList) {
            if (downloadList.contains(path)) continue;
            needDownloadFileList.add(path);
        }
        return needDownloadFileList;
    }

    private SftpClient getSftpFromCache(String ip) throws IOException {
        SftpClient sftp = this.sftpMap.get(ip);
        if (VerifyUtil.isEmpty(sftp)) {
            sftp = AbstractSftp.connect(ip, this.di.getUserName(), this.di.getPassword(), this.di.getPort());
            this.sftpMap.put(ip, sftp);
        }
        if (sftp == null || !sftp.isOpen()) {
            this.releaseSftp(sftp);
            sftp = AbstractSftp.connect(ip, this.di.getUserName(), this.di.getPassword(), this.di.getPort());
            this.sftpMap.put(ip, sftp);
        }
        return sftp;
    }

    private void sort(List<String> fileList) {
        Collections.sort(fileList, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                if (o1.length() > o2.length()) {
                    return 1;
                }
                if (o1.length() < o2.length()) {
                    return -1;
                }
                return o1.compareTo(o2);
            }
        });
    }

    private String generateDownloadFileMapKey(String contrllorNameString, Long resId) {
        return contrllorNameString + "-" + resId;
    }

    private String generateFilePath(SftpClient.DirEntry ele) {
        return IOTraceUtil.getSourceFilePath(this.di) + ele.getFilename();
    }

    private void deleteFile4OneControl() {
        String ip = this.ioTraceSftp.getIpMap().get(this.contrlName);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)("start delete file on device[" + ip + "]"));
        }
        try {
            SftpClient sftp = this.getSftpFromCache(ip);
            Iterable entrys = sftp.listDir((SftpClient.Handle)sftp.openDir(IOTraceUtil.getSourceFilePath(this.di)));
            for (SftpClient.DirEntry ele : entrys) {
                if (!ele.getLongFilename().contains(IOTRACE_FILE_PREFIX)) continue;
                String filePath = this.generateFilePath(ele);
                sftp.remove(filePath);
                if (!LOGGER.isInfoEnabled()) continue;
                LOGGER.info((Object)("delete file path : " + filePath));
            }
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)("end delete file on device[" + ip + "]"));
            }
        }
        catch (IOException e) {
            LOGGER.error((Object)("get sftp failed when delete file on contrller[" + ip + "]."), (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.error((Object)("delete file failed on contrller[" + ip + "]."), (Throwable)e);
        }
    }

    private void releaseAllConn() {
        for (Map.Entry<String, SftpClient> en : this.sftpMap.entrySet()) {
            SftpClient sftp = en.getValue();
            this.releaseSftp(sftp);
        }
    }

    private void releaseSftp(SftpClient sftp) {
        if (sftp != null) {
            try {
                ClientSession session = sftp.getSession();
                sftp.close();
                if (session != null) {
                    session.close();
                }
            }
            catch (IOException e) {
                LOGGER.error((Object)"", (Throwable)e);
            }
        }
    }
}

