/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.xve.monitor.eservice.task;

import com.huawei.ism.common.resourcemanager.HisResourceManager;
import com.huawei.ism.tool.base.utils.OSCmdUtils;
import com.huawei.xve.monitor.eservice.ParamHander;
import com.huawei.xve.monitor.eservice.ResultHander;
import com.huawei.xve.monitor.eservice.TimeRecord;
import com.huawei.xve.utils.ConnManager;
import com.huawei.xve.utils.DeviceInfo;
import com.huawei.xve.utils.FileUtil;
import com.huawei.xve.utils.RunningDataCollect;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;
import utils.FilesUtil;

public class ProcessTask {
    private static final Logger LOGGER = Logger.getLogger(ProcessTask.class);
    private AtomicInteger atomicInteger = new AtomicInteger(0);

    public void process(List<Future<String>> resultList, Map<Future<String>, String> map) {
        int total = resultList.size();
        for (Future<String> future : resultList) {
            try {
                future.get(120L, TimeUnit.MINUTES);
            }
            catch (TimeoutException e) {
                LOGGER.error((Object)"This task has exceeded the maximum time", (Throwable)e);
                String fid = map.get(future);
                future.cancel(true);
                ResultHander.getHander().update("status", "finished", fid, false);
                ResultHander.getHander().update("result", "failed", fid, false);
                ResultHander.getHander().update("remainTime", "120s", fid, false);
                ResultHander.getHander().update("remainTime", HisResourceManager.getString("EXPORT-DOWNLOAD-FAILED"), fid, false);
                ResultHander.getHander().update("errMsg", HisResourceManager.getString("TIME_OUT_ERROR"), fid, true);
            }
            catch (Exception e) {
                LOGGER.error((Object)"", (Throwable)e);
            }
        }
        ResultHander.getHander().update("progress", "100", true);
    }

    public synchronized void updateTaskStatus() {
        this.atomicInteger.incrementAndGet();
    }

    public int getSuccess() {
        return this.atomicInteger.get();
    }

    public void doZip() {
        List<String> ids;
        String tempPath = ParamHander.getParam().getWorkPath() + "\\tmp";
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)("clear temp dir : " + tempPath));
        }
        if (!FileUtil.deleteDir(tempPath)) {
            LOGGER.error((Object)("Delete temp file is false,file name is : " + tempPath));
        }
        if ((ids = ConnManager.getDeviceIDList()).isEmpty()) {
            return;
        }
        DeviceInfo di = ConnManager.getDeviceInfo(ids.get(0));
        ArrayList<String> rmDirs = new ArrayList<String>();
        String workPath = ParamHander.getParam().getWorkPath();
        String destName = "PerfResult_1_" + new SimpleDateFormat("yyyyMMddkkmmss").format(new Date()) + ".7z";
        if (di.isEServiceHisCollect()) {
            destName = di.getIp() + ".7z";
            RunningDataCollect.collect(di, workPath);
        }
        String zipExe = System.getProperty("user.dir") + File.separator + "7za.exe";
        StringBuilder sb = this.getworkPathSb(zipExe, destName, workPath);
        int fileSuccessNum = ids.size();
        fileSuccessNum = this.deleteEmptyFile(ids, rmDirs, workPath, fileSuccessNum);
        String timeRecordFile = workPath + File.separator + "TimeRecord.json";
        TimeRecord.exportFile(timeRecordFile);
        if (fileSuccessNum > 0) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)("7z cmd:" + sb.toString()));
            }
            try {
                LOGGER.info((Object)"Start of compression");
                String cmdRusult = OSCmdUtils.executeCmdOnWindows((String)sb.toString(), null, (String)workPath, (int)300);
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info((Object)("Compression rusult is :" + cmdRusult));
                }
                LOGGER.info((Object)"End of compression");
            }
            catch (Exception e) {
                LOGGER.error((Object)"", (Throwable)e);
            }
        } else {
            LOGGER.info((Object)"All tasks failed,No data back!");
        }
        this.deleteSourceFile(rmDirs);
        File runningData = new File(workPath + File.separator + "Running_Data");
        if (runningData.exists()) {
            FileUtil.deleteDir(FilesUtil.getCanonicalPath((File)runningData));
        }
    }

    private int deleteEmptyFile(List<String> ids, List<String> rmDirs, String workPath, int fileSuccessNum) {
        for (String id : ids) {
            DeviceInfo di = ConnManager.getDeviceInfo(id);
            rmDirs.add(di.getIp() + di.getDeviceID());
            StringBuilder file = new StringBuilder();
            file.append(workPath);
            file.append(File.separator);
            file.append(di.getIp() + di.getDeviceID());
            File f = new File(file.toString());
            if (f.exists()) {
                if (f.listFiles() == null || f.listFiles().length != 0) continue;
                --fileSuccessNum;
                f.delete();
                continue;
            }
            --fileSuccessNum;
        }
        return fileSuccessNum;
    }

    private StringBuilder getworkPathSb(String zipExe, String destName, String workPath) {
        StringBuilder sb = new StringBuilder();
        sb.append('\"').append(zipExe).append('\"').append(' ').append("a").append(' ').append('\"').append(destName).append('\"').append(' ').append('\"').append(workPath).append("\\\\").append('\"').append(' ');
        return sb;
    }

    private void deleteSourceFile(List<String> rmDirs) {
        File delete = null;
        String sourceDir = ParamHander.getParam().getWorkPath();
        for (String dir : rmDirs) {
            delete = new File(sourceDir + File.separator + dir);
            if (!delete.exists()) continue;
            FileUtil.deleteDir(sourceDir + File.separator + dir);
        }
    }
}

