/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.xve.monitor.eservice.task;

import com.huawei.ism.common.resourcemanager.HisResourceManager;
import com.huawei.ism.exception.IsmException;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.utils.DeviceTypeUtil;
import com.huawei.ism.util.VerifyUtil;
import com.huawei.sftp.PerfStatHisSftp;
import com.huawei.xve.monitor.eservice.ParamHander;
import com.huawei.xve.monitor.eservice.PermanentConnectionMannage;
import com.huawei.xve.monitor.eservice.ResultHander;
import com.huawei.xve.monitor.eservice.task.ProcessTask;
import com.huawei.xve.monitor.parsing.ParseFile;
import com.huawei.xve.utils.ConnManager;
import com.huawei.xve.utils.DeviceInfo;
import com.huawei.xve.utils.QuerInfo;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Task
implements Callable<String> {
    private static final Logger log = LoggerFactory.getLogger(Task.class);
    private static final org.apache.log4j.Logger LOGGER = org.apache.log4j.Logger.getLogger(Task.class);
    private String deviceId;
    private Mode mode;
    private ProcessTask process;
    private volatile boolean finished = false;
    PerfStatHisSftp sf;

    public Task(String deviceId, Mode mode, ProcessTask process) {
        this.deviceId = deviceId;
        this.mode = mode;
        this.process = process;
    }

    public static Mode getMode(String mode) {
        if ("realCollect".equals(mode)) {
            return Mode.REALTIME;
        }
        if ("hisCollect".equals(mode)) {
            return Mode.HIS;
        }
        if ("ioTrace".equals(mode)) {
            return Mode.IOTRACE;
        }
        throw new IsmException("unsupport mode.");
    }

    private void checkDev() {
        DeviceInfo di = ConnManager.getDeviceInfo(this.deviceId);
        if (VerifyUtil.isEmpty(di.getUserName()) || VerifyUtil.isEmpty(di.getPassword()) || VerifyUtil.isEmpty(di.getdVersion())) {
            LOGGER.error((Object)("invalid param.devIp:" + di.getIp() + ",devID:" + this.deviceId));
            throw new IsmException(HisResourceManager.getString("PARAM_INVALID"));
        }
    }

    @Override
    public String call() throws Exception {
        try {
            this.checkDev();
            this.collectingPerformanceFiles(this.mode);
            ResultHander.getHander().update("status", "finished", this.deviceId, false);
            ResultHander.getHander().update("result", "success", this.deviceId, true);
            this.process.updateTaskStatus();
        }
        catch (IsmException e) {
            LOGGER.error((Object)"", (Throwable)e);
            ResultHander.getHander().update("status", "finished", this.deviceId, false);
            ResultHander.getHander().update("result", "failed", this.deviceId, false);
            ResultHander.getHander().update("errMsg", e.getErrorMessage(), this.deviceId, true);
            ResultHander.getHander().update("remainTime", HisResourceManager.getString("EXPORT-DOWNLOAD-FAILED"), this.deviceId, false);
        }
        catch (Exception e) {
            LOGGER.error((Object)"", (Throwable)e);
            ResultHander.getHander().update("status", "finished", this.deviceId, false);
            ResultHander.getHander().update("result", "failed", this.deviceId, false);
            ResultHander.getHander().update("errMsg", e.getMessage(), this.deviceId, true);
            ResultHander.getHander().update("remainTime", HisResourceManager.getString("EXPORT-DOWNLOAD-FAILED"), this.deviceId, false);
        }
        finally {
            this.finished = true;
        }
        return this.deviceId;
    }

    private void collectingPerformanceFiles(Mode srcMode) throws IsmException {
        if (srcMode == Mode.REALTIME) {
            this.realtime();
        } else if (srcMode == Mode.HIS) {
            this.history();
        }
    }

    private void history() {
        DeviceInfo di = ConnManager.getDeviceInfo(this.deviceId);
        di.setEServiceHisCollect(true);
        this.sf = new PerfStatHisSftp(di, PerfStatHisSftp.EXPORT_LOG_TYPE);
        long endTime = this.getEndTime(di);
        long startTime = endTime - (long)(ParamHander.getParam().getRecentDays() * 86400000);
        String tmpdeviceId = di.getDeviceID();
        Map<String, List<String>> files = PerfStatHisSftp.queryStatFiles(tmpdeviceId, startTime, endTime);
        if (files == null || files.isEmpty()) {
            throw new IsmException(HisResourceManager.getString("NO_HISTORY_FILE_FOUND"));
        }
        PermanentConnectionMannage.getInstance().checkPermission(di);
        this.doDownload(files, di);
        if (this.sf.isDownloadWrong()) {
            throw new IsmException(this.sf.getMsg());
        }
    }

    private long getEndTime(DeviceInfo di) {
        long endTime;
        try {
            endTime = QuerInfo.querTime(di);
        }
        catch (IsmException e) {
            log.error("Failed to query the device time. Use the current system time to collect historical performance files.", (Throwable)e);
            endTime = System.currentTimeMillis();
        }
        return endTime;
    }

    private void realtime() {
        DeviceInfo di = ConnManager.getDeviceInfo(this.deviceId);
        this.sf = new PerfStatHisSftp(di, PerfStatHisSftp.EXPORT_LOG_TYPE_REALTIME);
        Map<String, List<String>> files = null;
        files = DeviceTypeUtil.hasSVPModule((DevNode)di.getDevNode()) ? PerfStatHisSftp.queryLatesthisPerfFiles(di, 1020000) : PerfStatHisSftp.queryRealtimePerfFiles(di);
        if (files == null || files.isEmpty()) {
            throw new IsmException(HisResourceManager.getString("NO_REALTIME_FILE_FOUND"));
        }
        PermanentConnectionMannage.getInstance().checkPermission(di);
        this.doDownload(files, di);
        this.doParse(di);
        if (this.sf.isDownloadWrong()) {
            throw new IsmException(this.sf.getMsg());
        }
    }

    private void doParse(DeviceInfo di) {
        String sourcePath = ParamHander.getParam().getWorkPath() + File.separator + di.getIp() + di.getDeviceID();
        ParseFile pf = new ParseFile(di);
        try {
            pf.doPaserHisPerfFiles(sourcePath);
        }
        catch (IOException e) {
            LOGGER.error((Object)("Parsing failure,IP: " + di.getIp()), (Throwable)e);
        }
    }

    private void doDownload(Map<String, List<String>> files, DeviceInfo di) {
        int total = 0;
        Set<Map.Entry<String, List<String>>> entrySet = files.entrySet();
        for (Map.Entry<String, List<String>> en : entrySet) {
            total += en.getValue().size();
        }
        this.sf.exportRealtimeFile(ParamHander.getParam().getWorkPath(), files, total);
    }

    public boolean isFinished() {
        return this.finished;
    }

    public static enum Mode {
        REALTIME,
        HIS,
        IOTRACE;

    }
}

