/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.xve.monitor.parsing;

import com.huawei.ism.common.resourcemanager.HisResourceManager;
import com.huawei.ism.exception.IsmException;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.DeviceTypeUtil;
import com.huawei.json.JSONArray;
import com.huawei.json.JSONException;
import com.huawei.json.JSONObject;
import com.huawei.xve.monitor.eservice.ParamHander;
import com.huawei.xve.monitor.parsing.GFCommon;
import com.huawei.xve.monitor.parsing.PerfStatHisFileInfo;
import com.huawei.xve.monitor.parsing.PerfStatHisObject;
import com.huawei.xve.utils.DeviceInfo;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import org.apache.log4j.Logger;
import org.apache.tools.tar.TarEntry;
import org.apache.tools.tar.TarInputStream;
import utils.FilesUtil;

public class ParseFile {
    private static final Logger LOGGER = Logger.getLogger(ParseFile.class);
    public static final long LONG_ZERO = 0L;
    public static final long LONG_ONE = 1L;
    public static final String DATA_TLV_MAP_STRING = "\"Map\":{";
    public static final String DATA_TLV_OBJ_SPLIT = "]},";
    private static final int TOOBIG = 524288000;
    private static final String PERF_END = "tgz";
    private int archive;
    private DeviceInfo di;

    public ParseFile(DeviceInfo di) {
        this.initParams(di);
    }

    private void initParams(DeviceInfo deviceInfo) {
        ParamHander.Param param = ParamHander.getParam();
        this.archive = param.getInterval();
        this.di = deviceInfo;
    }

    public void doPaserHisPerfFiles(String path) throws IOException {
        List<File> fileList = ParseFile.getHisPerfFile(path);
        for (File file : fileList) {
            String extractedFileName = null;
            extractedFileName = ParseFile.decompress(file.getCanonicalPath());
            String fileName = file.getName();
            if (null == extractedFileName) {
                return;
            }
            this.queryPerfStatHisFileInfo(path, extractedFileName, fileName);
        }
    }

    public static String getNodeName(String path) {
        String[] strings = path.split("PerfData_")[1].split("_");
        return strings[4];
    }

    public static String getFileTimes(String path) {
        String[] strings = path.split("PerfData_")[1].split("_");
        return strings[6];
    }

    public void queryPerfStatHisFileInfo(String path, String filepathName, String FileName) {
        PerfStatHisFileInfo perfStatHisFileInfo = new PerfStatHisFileInfo();
        File file = new File(filepathName);
        perfStatHisFileInfo.setFileName(filepathName);
        perfStatHisFileInfo.setSize(file.length());
        perfStatHisFileInfo.setTgzFileName(FileName);
        RandomAccessFile raf = null;
        try {
            raf = ParseFile.open(filepathName);
            byte[] headerBuf = new byte[337];
            raf.readFully(headerBuf);
            int dataLength = ParseFile.parseFileBaseInfo(perfStatHisFileInfo, headerBuf);
            boolean continueRead = Boolean.TRUE;
            while (continueRead && raf.getFilePointer() < raf.length()) {
                continueRead = this.queryPerfStatHisFileInfo(path, perfStatHisFileInfo, raf, dataLength);
            }
        }
        catch (IOException e) {
            LOGGER.error((Object)"read data error:", (Throwable)e);
            throw new IsmException(HisResourceManager.getString("HIS_FILE_PARSE_ERROR"));
        }
        catch (Exception e) {
            LOGGER.error((Object)"performance history file error :", (Throwable)e);
            throw new IsmException(HisResourceManager.getString("HIS_FILE_PARSE_ERROR"));
        }
        finally {
            ParseFile.close(raf);
        }
    }

    public boolean queryPerfStatHisFileInfo(String path, PerfStatHisFileInfo perfStatHisFileInfo, RandomAccessFile raf, int dataLength) {
        long minStartTime = perfStatHisFileInfo.getStartTime();
        long maxEndTime = perfStatHisFileInfo.getEndTime();
        FileOutputStream fos = null;
        OutputStreamWriter osw = null;
        BufferedWriter writer = null;
        try {
            String jsonString = ParseFile.perfStatHisFileTlvHeaderParser(raf);
            if (this.jsonStringisNull(perfStatHisFileInfo, jsonString)) {
                boolean bl = false;
                return bl;
            }
            int mapStart = jsonString.indexOf(DATA_TLV_MAP_STRING) + DATA_TLV_MAP_STRING.length();
            String[] stringObjTypes = jsonString.substring(mapStart).split(DATA_TLV_OBJ_SPLIT);
            ArrayList<String> objTypes = new ArrayList<String>();
            ParseFile.addDatatypes(stringObjTypes, objTypes);
            JSONObject jsonObject = new JSONObject(jsonString);
            long dataStartTime = Long.valueOf(jsonObject.getString("StartTime").trim()) * 1000L;
            long dataEndTime = Long.valueOf(jsonObject.getString("EndTime").trim()) * 1000L;
            int controllerId = Integer.valueOf(jsonObject.getString("CtrlID").trim());
            int period = Integer.valueOf(jsonObject.getString("Archive").trim()) * 1000;
            long[] tlvInfo = new long[]{dataStartTime, dataEndTime, controllerId};
            minStartTime = ParseFile.getMinStartTime(minStartTime, dataStartTime);
            maxEndTime = ParseFile.getMaxEndTime(maxEndTime, dataEndTime);
            if (this.checkTime(perfStatHisFileInfo, minStartTime, maxEndTime)) {
                boolean bl = Boolean.FALSE;
                return bl;
            }
            String mainjsonString = this.perfStatHisFileTvlBodyParser(perfStatHisFileInfo, raf, jsonObject, objTypes, dataLength);
            String txtName = this.getTxtName(perfStatHisFileInfo);
            fos = new FileOutputStream(path + File.separator + txtName, (boolean)Boolean.TRUE);
            osw = new OutputStreamWriter((OutputStream)fos, "UTF8");
            writer = new BufferedWriter(osw);
            writer.write(mainjsonString);
            writer.flush();
            ParseFile.deleteSingleFile(path + File.separator + perfStatHisFileInfo.getTgzFileName());
            this.setPerfStatHisFileInfo(perfStatHisFileInfo, minStartTime, maxEndTime, period, tlvInfo);
            this.closeStream(fos, osw, writer);
        }
        catch (IOException e) {
            LOGGER.error((Object)"read file fail:", (Throwable)e);
        }
        catch (JSONException e) {
            LOGGER.error((Object)("performance history file json parse error:" + e.getMessage()));
            throw new IsmException(HisResourceManager.getString("HIS_FILE_PARSE_ERROR"));
        }
        catch (Exception e) {
            LOGGER.error((Object)("performance history file json parse error:" + e.getMessage()));
            throw new IsmException(HisResourceManager.getString("HIS_FILE_PARSE_ERROR"));
        }
        finally {
            this.closeStream(fos, osw, writer);
        }
        return true;
    }

    private void setPerfStatHisFileInfo(PerfStatHisFileInfo perfStatHisFileInfo, long minStartTime, long maxEndTime, int period, long[] tlvInfo) {
        perfStatHisFileInfo.getTlvInfos().add(tlvInfo);
        perfStatHisFileInfo.setPeriod(period);
        perfStatHisFileInfo.setStartTime(minStartTime);
        perfStatHisFileInfo.setEndTime(maxEndTime - (long)period);
    }

    private void closeStream(FileOutputStream fos, OutputStreamWriter osw, BufferedWriter writer) {
        ParseFile.closeQuietly(writer);
        ParseFile.closeQuietly(osw);
        ParseFile.closeQuietly(fos);
    }

    private String getTxtName(PerfStatHisFileInfo perfStatHisFileInfo) {
        String txtName = perfStatHisFileInfo.getTgzFileName().replace(".tgz", "");
        String[] namearray = txtName.split("_");
        txtName = this.getTxtName(perfStatHisFileInfo, namearray);
        return txtName;
    }

    private boolean checkTime(PerfStatHisFileInfo perfStatHisFileInfo, long minStartTime, long maxEndTime) {
        if (maxEndTime - minStartTime > 86400000L) {
            LOGGER.warn((Object)("File time too looooooooooooooong, file name: " + perfStatHisFileInfo.getFileName() + ", start time: " + minStartTime + ", end time: " + maxEndTime));
            return true;
        }
        return false;
    }

    private boolean jsonStringisNull(PerfStatHisFileInfo perfStatHisFileInfo, String jsonString) {
        if (null == jsonString) {
            LOGGER.error((Object)("read file fail. JSON STRING IS NULL,CompressedFileName:" + perfStatHisFileInfo.getCompressedFileName()));
            return true;
        }
        return false;
    }

    private String getTxtName(PerfStatHisFileInfo perfStatHisFileInfo, String[] namearray) {
        String txtName = namearray.length <= 5 ? perfStatHisFileInfo.getTgzFileName().replace(".tgz", ".txt") : (namearray.length == 10 || namearray.length == 8 && DeviceTypeUtil.hasSVPModule((DevNode)this.di.getDevNode()) ? "perf_" + namearray[4] + "_" + namearray[5] + "_" + namearray[namearray.length - 1] + ".txt" : "perf_" + namearray[3] + "_" + namearray[4] + "_" + namearray[namearray.length - 1] + ".txt");
        return txtName;
    }

    public static void closeQuietly(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException ioe) {
            LOGGER.error((Object)"close io error.", (Throwable)ioe);
        }
    }

    public static boolean deleteSingleFile(String path) {
        boolean flag = false;
        File file = new File(path);
        if (!file.exists()) {
            return flag;
        }
        boolean deleted = file.delete();
        if (!deleted) {
            throw new SecurityException();
        }
        return flag;
    }

    private String perfStatHisFileTvlBodyParser(PerfStatHisFileInfo perfStatHisFileInfo, RandomAccessFile raf, JSONObject jsonObject, List<String> objTypes, int dataLength) throws IOException, JSONException {
        long dataStartTime = Long.valueOf(jsonObject.getString("StartTime").trim()) * 1000L;
        long dataEndTime = Long.valueOf(jsonObject.getString("EndTime").trim()) * 1000L;
        int period = Integer.valueOf(jsonObject.getString("Archive").trim()) * 1000;
        JSONObject objectMap = jsonObject.getJSONObject("Map");
        HashMap<Integer, List<String>> objTypeToNamesTmp = new HashMap<Integer, List<String>>();
        HashMap<Integer, List<String>> objTypeToIdsTmp = new HashMap<Integer, List<String>>();
        HashMap<Integer, List<Integer>> objTypeToDataTypesTmp = new HashMap<Integer, List<Integer>>();
        HashMap<Integer, List<Integer>> objTypeToDataTypesTmpNfs = new HashMap<Integer, List<Integer>>();
        LinkedList<Integer> objectTypesTmp = new LinkedList<Integer>();
        int periodDataLength = 0;
        periodDataLength = this.getPeriodDataLength(objTypes, dataLength, objectMap, objTypeToNamesTmp, objTypeToIdsTmp, objTypeToDataTypesTmp, objTypeToDataTypesTmpNfs, objectTypesTmp, periodDataLength);
        ParseFile.mergeObjectTypeToMapping(perfStatHisFileInfo.getObjectTypeToIdsMapping(), objTypeToIdsTmp);
        ParseFile.mergeObjectTypeToMapping(perfStatHisFileInfo.getObjectTypeToNamesMapping(), objTypeToNamesTmp);
        ParseFile.mergeObjectTypeToDataTypesMapping(perfStatHisFileInfo.getObjectTypeToDataTypeMapping(), objTypeToDataTypesTmp);
        ParseFile.mergeObjectTypes(perfStatHisFileInfo.getObjectTypes(), objectTypesTmp);
        byte[] periodDataBuf = new byte[periodDataLength];
        int offset = 0;
        JSONArray mainJsonArray = new JSONArray();
        for (long currPeriodDataTime = dataStartTime; currPeriodDataTime < dataEndTime; currPeriodDataTime += (long)period) {
            raf.readFully(periodDataBuf);
            offset = 0;
            JSONObject mainListJson = new JSONObject();
            JSONObject dataListJson = new JSONObject();
            mainListJson.put("data", (Object)dataListJson);
            mainListJson.put("timestamp", currPeriodDataTime / 1000L);
            mainListJson.put("archive", this.archive);
            mainJsonArray.put((Object)mainListJson);
            this.forEachObjectTypes(perfStatHisFileInfo, dataLength, period, objTypeToNamesTmp, objTypeToIdsTmp, objTypeToDataTypesTmpNfs, objectTypesTmp, periodDataBuf, offset, currPeriodDataTime, dataListJson);
        }
        return mainJsonArray.toString();
    }

    private void forEachObjectTypes(PerfStatHisFileInfo perfStatHisFileInfo, int dataLength, int period, Map<Integer, List<String>> objTypeToNamesTmp, Map<Integer, List<String>> objTypeToIdsTmp, Map<Integer, List<Integer>> objTypeToDataTypesTmpNfs, List<Integer> objectTypesTmp, byte[] periodDataBuf, int offset, long currPeriodDataTime, JSONObject dataListJson) throws IOException {
        for (Integer objType : objectTypesTmp) {
            Map<Integer, List<PerfStatHisObject>> dataMap = perfStatHisFileInfo.getObjectTypeToDatasMapping();
            List<PerfStatHisObject> dataList = dataMap.get(objType);
            if (dataList == null) {
                dataList = new ArrayList<PerfStatHisObject>();
                dataMap.put(objType, dataList);
            }
            JSONObject dataJson = new JSONObject();
            dataListJson.put(objType.toString(), (Object)dataJson);
            List<String> resIds = objTypeToIdsTmp.get(objType);
            List<String> names = objTypeToNamesTmp.get(objType);
            List<Integer> dataTypeEnum = objTypeToDataTypesTmpNfs.get(objType);
            JSONArray columnArray = new JSONArray();
            JSONArray valueArray = new JSONArray();
            if (!resIds.isEmpty()) {
                columnArray.put((Object)"id");
                columnArray.put((Object)"name");
            }
            dataJson.put("column", (Object)columnArray);
            dataJson.put("value", (Object)valueArray);
            offset = this.getDataSourceOffset(dataLength, period, periodDataBuf, offset, currPeriodDataTime, objType, dataList, resIds, names, dataTypeEnum, columnArray, valueArray);
        }
    }

    private int getPeriodDataLength(List<String> objTypes, int dataLength, JSONObject objectMap, Map<Integer, List<String>> objTypeToNamesTmp, Map<Integer, List<String>> objTypeToIdsTmp, Map<Integer, List<Integer>> objTypeToDataTypesTmp, Map<Integer, List<Integer>> objTypeToDataTypesTmpNfs, List<Integer> objectTypesTmp, int periodDataLength) {
        for (String objectTypeString : objTypes) {
            Integer objectType = 0;
            try {
                objectType = Integer.parseInt(objectTypeString);
            }
            catch (Exception e) {
                LOGGER.error((Object)"conversion failed:", (Throwable)e);
            }
            JSONObject objectTypeMap = objectMap.getJSONObject(objectTypeString);
            List<String> resIds = ParseFile.getResIds(objectTypeMap);
            List<String> names = ParseFile.getNames(objectTypeMap);
            List<Integer> dataTypes = ParseFile.getDataTypes(objectTypeMap);
            objTypeToIdsTmp.put(objectType, resIds);
            objTypeToNamesTmp.put(objectType, names);
            objTypeToDataTypesTmp.put(objectType, dataTypes);
            objTypeToDataTypesTmpNfs.put(objectType, dataTypes);
            objectTypesTmp.add(objectType);
            periodDataLength += resIds.size() * dataTypes.size() * dataLength;
        }
        return periodDataLength;
    }

    private int getDataSourceOffset(int dataLength, int period, byte[] periodDataBuf, int offset, long currPeriodDataTime, Integer objType, List<PerfStatHisObject> dataList, List<String> resIds, List<String> names, List<Integer> dataTypeEnum, JSONArray columnArray, JSONArray valueArray) throws IOException {
        for (int i = 0; i < resIds.size(); ++i) {
            boolean isRecordColumn = i == 0;
            JSONArray dealtailDataArray = new JSONArray();
            PerfStatHisObject perfStatHisObject = new PerfStatHisObject();
            perfStatHisObject.setPeriod(period);
            perfStatHisObject.setObjectType(objType);
            perfStatHisObject.setDataTypes(dataTypeEnum);
            perfStatHisObject.setResId(resIds.get(i));
            perfStatHisObject.setName(names.get(i));
            perfStatHisObject.setStartTime(currPeriodDataTime);
            valueArray.put((Object)dealtailDataArray);
            ParseFile.getDataSource(offset, periodDataBuf, dataLength, perfStatHisObject, columnArray, dealtailDataArray, isRecordColumn);
            dataList.add(perfStatHisObject);
            offset += dataLength * dataTypeEnum.size();
        }
        return offset;
    }

    private static void getDataSource(int offset, byte[] periodDataBuf, int dataLength, PerfStatHisObject perfStatHisObject, JSONArray columnArray, JSONArray valueArray, List<String> listMetrics, boolean isRecordColumn) throws IOException, JSONException {
        List<Integer> dataTypes = perfStatHisObject.getDataTypes();
        int[] intValues = new int[dataTypes.size()];
        valueArray.put((Object)perfStatHisObject.getResId());
        valueArray.put((Object)perfStatHisObject.getName());
        int valueindex = 0;
        int curindex = 0;
        for (Integer d : dataTypes) {
            if (d != null) {
                byte[] valueBuf = new byte[dataLength];
                System.arraycopy(periodDataBuf, offset + curindex * dataLength, valueBuf, 0, valueBuf.length);
                intValues[valueindex] = GFCommon.bytes2int(valueBuf, false);
                if (listMetrics == null) {
                    if (isRecordColumn) {
                        columnArray.put((Object)d);
                    }
                    valueArray.put(intValues[valueindex]);
                } else if (listMetrics.contains(d.toString())) {
                    if (isRecordColumn) {
                        columnArray.put((Object)d);
                    }
                    valueArray.put(intValues[valueindex]);
                }
                ++valueindex;
            }
            ++curindex;
        }
    }

    private static void getDataSource(int offset, byte[] periodDataBuf, int dataLength, PerfStatHisObject perfStatHisObject, JSONArray columnArray, JSONArray valueArray, boolean isRecordColumn) throws IOException, JSONException {
        ParseFile.getDataSource(offset, periodDataBuf, dataLength, perfStatHisObject, columnArray, valueArray, null, isRecordColumn);
    }

    private static Map<Integer, List<String>> mergeObjectTypeToMapping(Map<Integer, List<String>> destMapping, Map<Integer, List<String>> srcMapping) {
        for (Map.Entry<Integer, List<String>> entry : srcMapping.entrySet()) {
            Integer objectType = entry.getKey();
            if (destMapping.keySet().contains(objectType)) {
                List<String> destNames = destMapping.get(objectType);
                List<String> srcNames = srcMapping.get(objectType);
                ParseFile.addName2Map(destMapping, objectType, destNames, srcNames);
                continue;
            }
            destMapping.put(objectType, srcMapping.get(objectType));
        }
        return destMapping;
    }

    private static Map<Integer, List<Integer>> mergeObjectTypeToDataTypesMapping(Map<Integer, List<Integer>> destMapping, Map<Integer, List<Integer>> srcMapping) {
        for (Map.Entry<Integer, List<Integer>> entry : srcMapping.entrySet()) {
            Integer objectType = entry.getKey();
            if (destMapping.keySet().contains(objectType)) {
                List<Integer> destDataTypes = destMapping.get(objectType);
                List<Integer> srcDataTypes = srcMapping.get(objectType);
                ParseFile.addDataType2destMap(destMapping, objectType, destDataTypes, srcDataTypes);
                continue;
            }
            destMapping.put(objectType, srcMapping.get(objectType));
        }
        return destMapping;
    }

    private static List<Integer> mergeObjectTypes(List<Integer> destObjectTypes, List<Integer> srcObjectTypes) {
        for (Integer objectType : srcObjectTypes) {
            if (destObjectTypes.contains(objectType)) continue;
            destObjectTypes.add(objectType);
        }
        return destObjectTypes;
    }

    private static void addDataType2destMap(Map<Integer, List<Integer>> destMapping, Integer objectType, List<Integer> destDataTypes, List<Integer> srcDataTypes) {
        for (Integer srcDataType : srcDataTypes) {
            if (destDataTypes.contains(srcDataType)) continue;
            destMapping.get(objectType).add(srcDataType);
        }
    }

    private static void addName2Map(Map<Integer, List<String>> destMapping, Integer objectType, List<String> destNames, List<String> srcNames) {
        for (String srcName : srcNames) {
            if (destNames.contains(srcName)) continue;
            destMapping.get(objectType).add(srcName);
        }
    }

    private static List<String> getResIds(JSONObject objectTypeMap) throws JSONException {
        JSONArray jsonArray;
        try {
            jsonArray = objectTypeMap.getJSONArray("IDs");
        }
        catch (JSONException e) {
            jsonArray = objectTypeMap.getJSONArray("Names");
        }
        LinkedList<String> names = new LinkedList<String>();
        for (int i = 0; i < jsonArray.length(); ++i) {
            names.add(jsonArray.getString(i));
        }
        return names;
    }

    private static List<String> getNames(JSONObject objectTypeMap) throws JSONException {
        JSONArray jsonArray = objectTypeMap.getJSONArray("Names");
        LinkedList<String> names = new LinkedList<String>();
        for (int i = 0; i < jsonArray.length(); ++i) {
            names.add(jsonArray.getString(i));
        }
        return names;
    }

    private static List<Integer> getDataTypes(JSONObject objectTypeMap) throws JSONException {
        JSONArray dataTypesJSONArray = objectTypeMap.getJSONArray("DataTypes");
        LinkedList<Integer> dataTypes = new LinkedList<Integer>();
        for (int j = 0; j < dataTypesJSONArray.length(); ++j) {
            dataTypes.add(dataTypesJSONArray.getInt(j));
        }
        return dataTypes;
    }

    private static void addDatatypes(String[] stringObjTypes, List<String> objTypes) {
        for (int i = 0; i < stringObjTypes.length; ++i) {
            int index = stringObjTypes[i].indexOf(":{");
            if (-1 == index) continue;
            String objType = stringObjTypes[i].substring(0, index);
            objType = objType.replaceAll("\"", "").trim();
            objTypes.add(objType);
        }
    }

    private static String perfStatHisFileTlvHeaderParser(RandomAccessFile raf) throws IOException {
        int skipLen = raf.skipBytes(4);
        if (skipLen != 4) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)("parse file fail,skip=4,skipLen=" + skipLen));
            }
            return null;
        }
        byte[] tlvLenBuf = new byte[4];
        raf.readFully(tlvLenBuf);
        int tlvLength = GFCommon.bytes2int(tlvLenBuf, false);
        if (tlvLength <= 8) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)("parse file fail, zero byte left.fileLen:" + raf.length() + " current tlv length:" + tlvLength + " current file pointer:" + raf.getFilePointer()));
            }
            return null;
        }
        if (tlvLength > 0x2000000) {
            LOGGER.error((Object)("The file is exceed file lenth\uff1a" + tlvLength));
            return null;
        }
        String json = null;
        try {
            byte[] jsonByteBuf = new byte[tlvLength - 8];
            raf.readFully(jsonByteBuf);
            json = new String(jsonByteBuf, "UTF-8").trim();
        }
        catch (Exception e) {
            LOGGER.error((Object)"Failed to process file:", (Throwable)e);
        }
        return json;
    }

    protected static int parseFileBaseInfo(PerfStatHisFileInfo perfStatHisFileInfo, byte[] headerBuf) throws UnsupportedEncodingException {
        byte[] checkCodeBuf = new byte[32];
        System.arraycopy(headerBuf, 0, checkCodeBuf, 0, checkCodeBuf.length);
        perfStatHisFileInfo.setCheckCode(new String(checkCodeBuf, "UTF-8"));
        byte[] versionBuf = new byte[4];
        System.arraycopy(headerBuf, 32, versionBuf, 0, versionBuf.length);
        perfStatHisFileInfo.setVersion(GFCommon.bytes2int(versionBuf, false));
        byte[] deviceSnBuf = new byte[256];
        System.arraycopy(headerBuf, 36, deviceSnBuf, 0, deviceSnBuf.length);
        perfStatHisFileInfo.setDeviceSN(new String(deviceSnBuf, "UTF-8").trim());
        byte[] deviceNameBuf = new byte[41];
        System.arraycopy(headerBuf, 292, deviceNameBuf, 0, deviceNameBuf.length);
        perfStatHisFileInfo.setDeviceName(new String(deviceNameBuf, "UTF-8").trim());
        byte[] dataLengthBuf = new byte[4];
        System.arraycopy(headerBuf, 333, dataLengthBuf, 0, dataLengthBuf.length);
        int dataLength = GFCommon.bytes2int(dataLengthBuf, false);
        perfStatHisFileInfo.setDataLength(dataLength);
        return dataLength;
    }

    protected static RandomAccessFile open(String fileName) throws FileNotFoundException {
        RandomAccessFile randomAccessFile = new RandomAccessFile(fileName, "rw");
        return randomAccessFile;
    }

    protected static void close(RandomAccessFile randomAccessFile) {
        if (randomAccessFile != null) {
            try {
                randomAccessFile.close();
            }
            catch (IOException e) {
                LOGGER.error((Object)"close performance history file error:", (Throwable)e);
            }
        }
    }

    public static String decompress(String fileName) {
        if (fileName.endsWith(PERF_END) || fileName.endsWith("bz2")) {
            File file = new File(fileName);
            String tmpDir = ParamHander.getParam().getWorkPath() + "\\tmp";
            String extractedFileName = null;
            String newExtractedFileName = "";
            for (int reNum = 1; reNum < 4; ++reNum) {
                try {
                    extractedFileName = ParseFile.extract(file, tmpDir);
                    newExtractedFileName = ParseFile.appendTimeToFileName(extractedFileName);
                    break;
                }
                catch (Exception e) {
                    LOGGER.error((Object)("call decompress error,reNum is :" + reNum + " ,file name is " + fileName), (Throwable)e);
                    continue;
                }
            }
            return newExtractedFileName;
        }
        return fileName;
    }

    public static List<File> getHisPerfFile(String filepath) {
        File file = new File(filepath);
        ArrayList<File> fileList = new ArrayList<File>();
        String srcpath = null;
        try {
            srcpath = file.getCanonicalPath();
        }
        catch (IOException e1) {
            LOGGER.error((Object)"History_performance_files path get failed");
        }
        if (srcpath != null && !file.isDirectory() && srcpath.endsWith(PERF_END) && !ParseFile.validateDir(srcpath)) {
            fileList.add(file);
        } else if (file.isDirectory()) {
            String[] filelist = file.list();
            if (filelist == null) {
                return fileList;
            }
            for (int i = 0; i < filelist.length; ++i) {
                File readfile = new File(filepath + File.separator + filelist[i]);
                String canonicalPath = null;
                try {
                    canonicalPath = readfile.getCanonicalPath();
                }
                catch (IOException e) {
                    LOGGER.error((Object)"History_performance_files path get failed");
                }
                if (canonicalPath != null && !readfile.isDirectory() && canonicalPath.endsWith(PERF_END) && !ParseFile.validateDir(canonicalPath)) {
                    fileList.add(readfile);
                    continue;
                }
                if (!readfile.isDirectory()) continue;
                ParseFile.getHisPerfFile(filepath + File.separator + filelist[i]);
            }
        }
        return fileList;
    }

    public static boolean validateDir(String srcpath) {
        boolean result1 = null != srcpath && !"".equals(srcpath);
        boolean result2 = null != srcpath && srcpath.indexOf("\"") < 0 && srcpath.indexOf("|") < 0 && srcpath.indexOf("?") < 0;
        boolean result3 = null != srcpath && srcpath.indexOf("*") < 0 && srcpath.indexOf("<") < 0 && srcpath.indexOf(">") < 0;
        return !result1 || !result2 || !result3;
    }

    private static String checkFile(File tempFile) {
        boolean deleted;
        String retName = FilesUtil.getCanonicalPath((File)tempFile);
        if (tempFile.exists() && !(deleted = tempFile.delete())) {
            throw new SecurityException();
        }
        return retName;
    }

    public static String extract(File file, String outputDir) {
        String retName = "";
        TarInputStream in = null;
        BufferedInputStream bis = null;
        FileInputStream fileInputStream = null;
        GZIPInputStream inputStream = null;
        try {
            TarEntry entry;
            fileInputStream = new FileInputStream(file);
            inputStream = new GZIPInputStream(fileInputStream);
            in = new TarInputStream((InputStream)inputStream);
            byte[] tmpArray = new byte[1];
            int entries = 0;
            while ((entry = in.getNextEntry()) != null) {
                LOGGER.info((Object)String.format(Locale.ENGLISH, "Extracting: %s", entry));
                if (ParseFile.validateDir(outputDir)) {
                    throw new ToolException(HisResourceManager.getString("DIR_IS_INVALID"));
                }
                File tempFileFolder = new File(outputDir);
                boolean result = true;
                ParseFile.mkTempFileFolder(file, outputDir, tempFileFolder, result);
                File tempFile = new File(outputDir + File.separator + file.getName() + System.currentTimeMillis());
                retName = ParseFile.checkFile(tempFile);
                bis = new BufferedInputStream((InputStream)in);
                entries = ParseFile.writeFile(bis, tmpArray, entries, tempFile);
            }
        }
        catch (Exception e) {
            try {
                LOGGER.error((Object)"", (Throwable)e);
                throw new IsmException("", (Throwable)e);
            }
            catch (Throwable throwable) {
                ParseFile.closeInputStream(bis);
                ParseFile.closeInputStream(in);
                ParseFile.closeGZIPInputStream(inputStream);
                ParseFile.closeFileInputStream(fileInputStream);
                throw throwable;
            }
        }
        ParseFile.closeInputStream(bis);
        ParseFile.closeInputStream((InputStream)in);
        ParseFile.closeGZIPInputStream(inputStream);
        ParseFile.closeFileInputStream(fileInputStream);
        return retName;
    }

    private static int writeFile(BufferedInputStream bis, byte[] tmpArray, int entries, File tempFile) throws IOException {
        int total = 0;
        try (FileOutputStream outputStream = new FileOutputStream(tempFile);
             BufferedOutputStream bos = new BufferedOutputStream(outputStream);){
            total = ParseFile.doWriteFile(bis, tmpArray, bos);
        }
        catch (IOException e) {
            LOGGER.error((Object)"write failed");
            throw e;
        }
        ParseFile.exceedMaxNumber(++entries);
        LOGGER.info((Object)String.format(Locale.ENGLISH, "total: %s", total));
        return entries;
    }

    private static void mkTempFileFolder(File file, String outputDir, File tempFileFolder, boolean result) throws ToolException {
        if (!tempFileFolder.exists()) {
            result = tempFileFolder.mkdirs();
        }
        if (!result && !tempFileFolder.exists()) {
            LOGGER.error((Object)"Directory does not exist, but creation failed");
        }
        if (ParseFile.validateDir(outputDir + File.separator + file.getName() + System.currentTimeMillis())) {
            throw new ToolException(HisResourceManager.getString("DIR_IS_INVALID"));
        }
    }

    private static int doWriteFile(BufferedInputStream bis, byte[] tmpArray, BufferedOutputStream bos) throws IOException {
        int count;
        int total = 0;
        while (total <= 524288000 && (count = bis.read(tmpArray)) != -1) {
            bos.write(tmpArray, 0, count);
            if ((total += count) <= 524288000) continue;
            throw new IllegalStateException("File being extracted is huge.");
        }
        bos.flush();
        return total;
    }

    public static void exceedMaxNumber(int entries) {
        if (entries > 1024) {
            throw new IllegalStateException("Too many files to unzip.");
        }
    }

    private static void closeInputStream(InputStream in) {
        try {
            if (in != null) {
                in.close();
            }
        }
        catch (IOException e) {
            LOGGER.error((Object)"close Stream error:", (Throwable)e);
        }
    }

    private static void closeOutputStream(OutputStream out) {
        try {
            if (out != null) {
                out.close();
            }
        }
        catch (IOException e) {
            LOGGER.error((Object)"close Stream error:", (Throwable)e);
        }
    }

    private static void closeGZIPInputStream(GZIPInputStream in) {
        try {
            if (in != null) {
                in.close();
            }
        }
        catch (IOException e) {
            LOGGER.error((Object)"close GZIPInputStream error:", (Throwable)e);
        }
    }

    private static void closeFileInputStream(FileInputStream fileInputStream) {
        try {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
        }
        catch (IOException e) {
            LOGGER.error((Object)"close Stream error:", (Throwable)e);
        }
    }

    private static void closeFileOutputStream(FileOutputStream fileOutputStream) {
        try {
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
        }
        catch (IOException e) {
            LOGGER.error((Object)"close Stream error:", (Throwable)e);
        }
    }

    private static String appendTimeToFileName(String fileName) {
        File file = new File(fileName);
        if (!file.exists()) {
            return null;
        }
        String newFileName = "";
        if (fileName.lastIndexOf(".") != -1) {
            String prefixalName = fileName.substring(0, fileName.lastIndexOf("."));
            String suffixalName = fileName.substring(fileName.lastIndexOf("."));
            newFileName = prefixalName + '_' + System.currentTimeMillis() + suffixalName;
        } else {
            newFileName = fileName + '_' + System.currentTimeMillis();
        }
        File newFile = new File(newFileName);
        if (file.renameTo(newFile)) {
            try {
                return newFile.getCanonicalPath();
            }
            catch (IOException e) {
                LOGGER.error((Object)"get path error.", (Throwable)e);
                return null;
            }
        }
        return null;
    }

    private static long getMaxEndTime(long maxEndTime, long dataEndTime) {
        return Math.max(maxEndTime, dataEndTime);
    }

    private static long getMinStartTime(long minStartTime, long dataStartTime) {
        if (minStartTime == 0L) {
            return dataStartTime;
        }
        return Math.min(minStartTime, dataStartTime);
    }
}

