/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.xve.monitor.perfstat;

import com.huawei.ism.common.resourcemanager.HisResourceManager;
import com.huawei.ism.ui.swing.dialog.HisDialogUtils;
import com.huawei.ism.ui.swing.dialog.HisWarningDialog;
import com.huawei.ism.ui.templets.IsmDialog;
import com.huawei.ism.util.Pair;
import com.huawei.ism.util.SwingUtil;
import com.huawei.ism.util.Utils;
import com.huawei.xve.monitor.perfstat.BatchExportTypeChooseLayout;
import com.huawei.xve.utils.ConnManager;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JDialog;

public class BatchExportTypeChooseDialog
extends IsmDialog {
    public static final int DEFAULT = -1;
    public static final int WORKLOAD = 1;
    public static final int HIS = 0;
    public static final int WBATCHEXPORT = 2;
    public static final int IOTRACE = 3;
    private static final long serialVersionUID = -4383148098227809501L;
    private int chooseType;
    private BatchExportTypeChooseLayout layout;
    private Window parent;
    private String workloadExportType;
    private List<String> deviceIDs = null;

    public BatchExportTypeChooseDialog(Window parent, String workloadExportType, List<String> deviceIDs) {
        super(parent, "", new IsmDialog.ECommonButton[]{IsmDialog.ECommonButton.Close});
        this.workloadExportType = workloadExportType;
        this.doUILayout();
        this.addHandler();
        this.setResizable(false);
        this.setModal(true);
        this.pack();
        this.chooseType = -2;
        this.parent = parent;
        this.deviceIDs = deviceIDs;
        this.setSize(new Dimension(200, 120));
        SwingUtil.putParentCenter((Window)((Object)this), (Window)parent);
        SwingUtil.setCloseWhenEscKeyPressed((JDialog)((Object)this));
        this.setTitle(Utils.transferStringToUpper((String)HisResourceManager.getString("export_type_choose")));
        this.getRootPane().setDefaultButton(this.getButtonBy(IsmDialog.ECommonButton.Close));
        this.getButtonBy(IsmDialog.ECommonButton.Close).requestFocus();
    }

    private void addHandler() {
        this.layout.getOkBtn().addActionListener(this.createExportDialogListener());
    }

    private ActionListener createExportDialogListener() {
        ActionListener lis = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Pair selectedItem = (Pair)BatchExportTypeChooseDialog.this.layout.getSelectedExportTypeBox().getSelectedItem();
                Integer key = (Integer)selectedItem.getKey();
                BatchExportTypeChooseDialog.this.chooseType = key;
                if (BatchExportTypeChooseDialog.this.chooseType == 2) {
                    HisWarningDialog dialog = HisDialogUtils.showcreateDialog((Window)((Object)BatchExportTypeChooseDialog.this), HisResourceManager.getString("EXPORT-WORKLOADBATCH-HIGH-ALERT"));
                    if (0 == dialog.getValue()) {
                        BatchExportTypeChooseDialog.this.setVisible(false);
                    }
                } else if (BatchExportTypeChooseDialog.this.chooseType == 0) {
                    BatchExportTypeChooseDialog.this.promptByV2R2();
                    BatchExportTypeChooseDialog.this.setVisible(false);
                } else {
                    BatchExportTypeChooseDialog.this.setVisible(false);
                }
            }
        };
        return lis;
    }

    private void promptByV2R2() {
        ArrayList<String> temp = new ArrayList<String>();
        if (this.isPrompt(temp)) {
            HisWarningDialog dialog = HisDialogUtils.createContinueDialog((JDialog)((Object)this), HisResourceManager.getString("EXPORT_PERF_MULTIPLE_PROMPT"));
            if (1 == dialog.getValue() || -1 == dialog.getValue()) {
                return;
            }
            for (String sn : temp) {
                this.deviceIDs.remove(sn);
            }
        }
    }

    private boolean isPrompt(List<String> temp) {
        boolean pro = false;
        if (this.deviceIDs.size() < 2) {
            return pro;
        }
        Iterator<String> iterator = this.deviceIDs.iterator();
        String sn = null;
        while (iterator.hasNext()) {
            sn = iterator.next();
            String version = ConnManager.getDeviceInfo(sn).getdVersion();
            if (!version.contains("V200R002C00")) continue;
            pro = true;
            temp.add(sn);
        }
        return pro;
    }

    private void doUILayout() {
        this.layout = new BatchExportTypeChooseLayout(this.workloadExportType);
        this.setLayout(new BorderLayout());
        this.add(this.layout, "Center");
    }

    public Window getWindow() {
        return this.parent;
    }

    public Integer getChooseType() {
        return this.chooseType;
    }

    protected void processWindowEvent(WindowEvent event) {
        if (event.getID() == 201) {
            this.chooseType = -2;
        }
        super.processWindowEvent(event);
    }
}

