/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.xve.monitor.perfstat;

import com.huawei.ism.common.resourcemanager.HisResourceManager;
import com.huawei.ism.exception.IsmException;
import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.tool.framework.platform.common.data.UserOpTaskResult;
import com.huawei.ism.tool.service.common.ToolThreadFactory;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.dialog.WarningDialog;
import com.huawei.ism.ui.templets.IsmDialog;
import com.huawei.ism.util.CopyUtil;
import com.huawei.ism.util.SwingUtil;
import com.huawei.ism.util.ThreadUtil;
import com.huawei.ism.util.UCD;
import com.huawei.ism.util.Utils;
import com.huawei.ism.util.VerifyUtil;
import com.huawei.sftp.IOTraceSftp;
import com.huawei.tool.framwork.util.func.LocalHostUtil;
import com.huawei.xve.monitor.perfstat.ExploreButtonListener;
import com.huawei.xve.monitor.perfstat.IOTraceExportLayout;
import com.huawei.xve.utils.ConnManager;
import com.huawei.xve.utils.DeviceInfo;
import com.huawei.xve.utils.HisUserOpToolData;
import com.huawei.xve.utils.IOTaceErrMsg;
import com.huawei.xve.utils.IOTraceParam;
import com.huawei.xve.utils.QuerInfo;
import com.huawei.xve.utils.UserBehaviorUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class IOTraceExportDialog
extends IsmDialog {
    private static final Logger LOGGER = Logger.getLogger(IOTraceExportDialog.class);
    private static final long ONE_MIN_MINILLES = 60000L;
    private static final long TWO_HOUR_MINILLES = 0x6DDD00L;
    private final List<String> deviceIDList;
    private IOTraceExportLayout layout = null;
    private String filePath = QuerInfo.getSceneCollectDir();
    private IOTraceSftp ioTraceSftp;
    private boolean isShowDialog = true;

    public IOTraceExportDialog(List<String> deviceIDList, Window parent) {
        super(parent, "", new IsmDialog.ECommonButton[]{IsmDialog.ECommonButton.Close});
        this.deviceIDList = deviceIDList;
        this.doUILayout();
        this.addHandler();
        this.setResizable(false);
        this.setModal(true);
        this.pack();
        this.setSize(new Dimension(520, 500));
        SwingUtil.putParentCenter((Window)((Object)this), (Window)parent);
        SwingUtil.setCloseWhenEscKeyPressed((JDialog)((Object)this));
        this.setTitle(Utils.transferStringToUpper((String)HisResourceManager.getString("IO_TRACE_EXPORT_TITLE")));
        this.getRootPane().setDefaultButton(null);
        this.addWindowListener(this.getWindowListener());
        this.getButtonBy(IsmDialog.ECommonButton.Close).addActionListener(this.getCloseButtonListener());
    }

    private ActionListener getCloseButtonListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IOTraceExportDialog.this.closeWindow();
            }
        };
    }

    private WindowListener getWindowListener() {
        WindowListener lis = new WindowListener(){

            @Override
            public void windowClosing(WindowEvent e) {
                IOTraceExportDialog.this.closeWindow();
            }

            @Override
            public void windowOpened(WindowEvent e) {
            }

            @Override
            public void windowIconified(WindowEvent e) {
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
            }

            @Override
            public void windowClosed(WindowEvent e) {
            }

            @Override
            public void windowActivated(WindowEvent e) {
            }
        };
        return lis;
    }

    private void closeWindow() {
        if (VerifyUtil.isEmpty(this.ioTraceSftp) || this.ioTraceSftp.isFinshed()) {
            this.setVisible(false);
            this.dispose();
            return;
        }
        WarningDialog choose = DialogUtils.showYesNoDialog((Window)((Object)this.getWindow()), (String)HisResourceManager.getString("IO_TRACE_CLOSE_WINDOW"));
        if (choose.getValue() == 1) {
            this.setDefaultCloseOperation(0);
            return;
        }
        LOGGER.info((Object)"user force close window, so stop collect task.");
        this.isShowDialog = false;
        this.ioTraceSftp.setImmediateStop(true);
        this.setVisible(false);
        this.dispose();
    }

    private void addHandler() {
        this.layout.getSaveToBtn().addActionListener(this.getSaveListener());
        this.layout.getStopToBtn().addActionListener(this.getStopListener());
        this.layout.getReset().addActionListener(this.getResetListener());
        this.layout.getStartTime().addMouseListener(this.getMouseListener(this.layout.getStartTime(), this.layout.getHideStartTime()));
        this.layout.getEndTime().addMouseListener(this.getMouseListener(this.layout.getEndTime(), this.layout.getHideEndTime()));
        this.layout.getExploreBtn().addActionListener(new ExploreButtonListener());
    }

    private ActionListener getResetListener() {
        ActionListener lis = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IOTraceExportDialog.this.layout.getStartTime().setText("");
                IOTraceExportDialog.this.layout.getEndTime().setText("");
                IOTraceExportDialog.this.layout.getHideStartTime().setText("");
                IOTraceExportDialog.this.layout.getHideEndTime().setText("");
            }
        };
        return lis;
    }

    private MouseListener getMouseListener(final JTextField jt, final JTextField hideJT) {
        final JPopupMenu popup = new JPopupMenu();
        MouseListener lis = new MouseListener(){

            @Override
            public void mouseEntered(MouseEvent e) {
                String text = jt.getText();
                if (VerifyUtil.isEmpty(text) || !IOTraceExportDialog.this.isFormatTime(jt, hideJT)) {
                    return;
                }
                popup.removeAll();
                JPanel infoPanel = IOTraceExportDialog.this.createInfoPanel(hideJT.getText());
                popup.add((Component)infoPanel, "Center");
                popup.show(jt, jt.getWidth(), jt.getHeight());
            }

            @Override
            public void mouseExited(MouseEvent e) {
                popup.setVisible(false);
                popup.removeAll();
            }

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        };
        return lis;
    }

    private JPanel createInfoPanel(String tips) {
        JPanel infoPanel = new JPanel();
        infoPanel.setLayout(new BorderLayout());
        infoPanel.add(new JLabel(tips));
        return infoPanel;
    }

    private ActionListener getSaveListener() {
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DeviceInfo di = null;
                try {
                    di = IOTraceExportDialog.this.addInfo2Device();
                    di.getHisUserData().setExportDataType(HisUserOpToolData.ExportDataTypeEnum.EXPORTIOTRACEDATA.getValue());
                    di.getHisUserData().setTaskStartTime(System.currentTimeMillis());
                    di.getHisUserData().setTaskResult(UserOpTaskResult.FAILED);
                    IOTraceExportDialog.this.refreshDownloadFileCount(di, true);
                    List result = AsyncExcutor.execute((Window)((Object)IOTraceExportDialog.this.getWindow()), (boolean)true, (long)0L, (Callable[])new Callable[]{new GetIOTraceFiles(di)});
                    IOTraceExportDialog.this.doAsyncResult(result);
                }
                catch (IsmException e1) {
                    UserBehaviorUtil.recordUserOpData(di, UserOpTaskResult.FAILED, HisUserOpToolData.ExportDataTypeEnum.EXPORTIOTRACEDATA);
                    DialogUtils.showErrorDialog((JDialog)((Object)IOTraceExportDialog.this.getWindow()), (String)e1.getMessage());
                    return;
                }
                IOTraceExportDialog.this.layout.getSaveToBtn().setEnabled(false);
                IOTraceExportDialog.this.layout.getStopToBtn().setEnabled(true);
            }
        };
        return listener;
    }

    private void doAsyncResult(List<?> result) {
        for (Object o : result) {
            if (!(o instanceof IsmException)) continue;
            throw (IsmException)((Object)o);
        }
    }

    protected DeviceInfo addInfo2Device() throws IsmException {
        JTextField startTime = this.layout.getStartTime();
        JTextField endTime = this.layout.getEndTime();
        JTextField hideStartTime = this.layout.getHideStartTime();
        JTextField hideEndTime = this.layout.getHideEndTime();
        if (VerifyUtil.isMultiEmpty(startTime, endTime, hideStartTime, hideStartTime) || VerifyUtil.isEmpty(startTime.getText()) || VerifyUtil.isEmpty(endTime.getText()) || !this.isFormatTime(startTime, endTime, hideStartTime, hideEndTime)) {
            throw new IsmException(HisResourceManager.getString("IO_TRACE_ILLEGAL_TIME"));
        }
        long begin = 0L;
        try {
            begin = hideStartTime != null && !"".equals(hideStartTime.getText()) ? this.layout.getdFormat().parse(hideStartTime.getText()).getTime() : 0L;
        }
        catch (ParseException e1) {
            LOGGER.error((Object)"parse starttime faild.", (Throwable)e1);
        }
        long end = 0L;
        try {
            end = hideEndTime != null && !"".equals(hideEndTime.getText()) ? this.layout.getdFormat().parse(hideEndTime.getText()).getTime() : 0L;
        }
        catch (ParseException e1) {
            LOGGER.error((Object)"parse endtime faild.", (Throwable)e1);
        }
        this.checkTimes(begin, end);
        DeviceInfo di = ConnManager.getDeviceInfo(this.layout.getSelectedDeviceID());
        if (VerifyUtil.isEmpty(di)) {
            throw new IsmException(HisResourceManager.getString("IO_TRACE_NOT_FOUND_DEVICE"));
        }
        int dur = this.getDur(begin, end);
        String ids = this.layout.getLunIDs().getText();
        this.checkLUNID(ids);
        ids = ids.replaceAll("\n", "");
        ids = ids.replaceAll(" ", "");
        IOTraceParam ioTraceParam = new IOTraceParam();
        ioTraceParam.setStartTime(begin);
        ioTraceParam.setDuration(dur);
        ioTraceParam.setLunIDList(ids);
        ioTraceParam.setLocalPath(this.filePath);
        di.setIoTraceParam(ioTraceParam);
        return di;
    }

    private boolean isFormatTime(JTextField startTime, JTextField endTime, JTextField hideStartTime, JTextField hideEndTime) {
        return this.isFormatTime(startTime, hideStartTime) || this.isFormatTime(endTime, hideEndTime);
    }

    private boolean isFormatTime(JTextField time, JTextField initTime) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            sdf.parse(time.getText());
        }
        catch (ParseException e) {
            LOGGER.error((Object)("parse date failed. time = " + time));
            return false;
        }
        String[] times = initTime.getText().split(" ");
        if (!time.getText().equals(times[0])) {
            initTime.setText(time.getText() + " " + times[1]);
        }
        return true;
    }

    private void checkTimes(long begin, long end) {
        if (begin == 0L || end == 0L) {
            throw new IsmException(HisResourceManager.getString("IO_TRACE_ILLEGAL_TIME"));
        }
        if (begin > end) {
            throw new IsmException(HisResourceManager.getString("EXPORT-FILE.TXT.QUERY_ERROR"));
        }
        long curr = System.currentTimeMillis();
        if (end < curr) {
            throw new IsmException(HisResourceManager.getString("IO_TRACE_END_TIME_ERR"));
        }
        if (curr - begin >= 0x6DDD00L) {
            throw new IsmException(HisResourceManager.getString("IO_TRACE_START_TIME_ERR"));
        }
        if (end - begin > 0x6DDD00L) {
            throw new IsmException(HisResourceManager.getString("IO_TRACE_TIME_TWO_HOUR_ERR"));
        }
    }

    private void checkLUNID(String ids) {
        if (VerifyUtil.isEmpty(ids)) {
            throw new IsmException(HisResourceManager.getString("IO_TRACE_LUN_ENPTY_ERR"));
        }
        String[] idArr = ids.split(",");
        if (10 < idArr.length) {
            throw new IsmException(HisResourceManager.getString("IO_TRACE_LUN_MAX_NUM_ERR"));
        }
    }

    private int getDur(long begin, long end) {
        int dur = (int)((end - begin) / 60000L);
        if (0L != (end - begin) % 60000L) {
            return dur + 1;
        }
        return dur;
    }

    private ActionListener getStopListener() {
        ActionListener lis = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DeviceInfo deviceInf = ConnManager.getDeviceInfo(IOTraceExportDialog.this.layout.getSelectedDeviceID());
                deviceInf.getHisUserData().setExportDataType(HisUserOpToolData.ExportDataTypeEnum.EXPORTIOTRACEDATA.getValue());
                UserBehaviorUtil.recordUserOpData(deviceInf, UserOpTaskResult.IN_COMPLETE);
                IOTraceExportDialog.this.ioTraceSftp.setImmediateStop(true);
                DialogUtils.showInfoDialog((JDialog)((Object)IOTraceExportDialog.this.getWindow()), (String)HisResourceManager.getString("IO_TRACE_STOP_COLLECT_TASK"));
            }
        };
        return lis;
    }

    private void setBtnStatusWhenError() {
        if (!VerifyUtil.isEmpty(this.filePath)) {
            this.layout.getSaveToBtn().setEnabled(true);
        } else {
            this.layout.getSaveToBtn().setEnabled(false);
            this.layout.getSaveToBtn().setEnabled(true);
        }
        this.layout.getStopToBtn().setEnabled(false);
    }

    private void doUILayout() {
        List<String> deviceIDLists = this.getDeviceIDList();
        this.layout = new IOTraceExportLayout(deviceIDLists);
        this.layout.setBorder(UCD.createEmptyBorder());
        this.getDialogContentPane().add(this.layout);
    }

    private List<String> getDeviceIDList() {
        return this.deviceIDList;
    }

    private void refreshDownloadFileCount(DeviceInfo di, boolean reSet) {
        int count = di.getIoTraceParam().getDownloadFileNum().get();
        if (reSet) {
            count = 0;
        }
        this.layout.getDownloadCount().setText(count + "");
        this.layout.getDownloadCount().repaint();
    }

    public void monitorIOTraceCollect(final IOTraceSftp ioTraceSftpObj, final DeviceInfo di) {
        ToolThreadFactory.newDefaultThread((Runnable)new Runnable(){

            @Override
            public void run() {
                ThreadUtil.sleep(500L);
                int times = 0;
                while (ioTraceSftpObj.isRun()) {
                    if (!ioTraceSftpObj.isCollect() && !ioTraceSftpObj.isImmediateStop()) {
                        IOTraceExportDialog.this.refreshCollectStatus(HisResourceManager.getString("IO_TRACE_WAIT_COLLECT"), ++times);
                    } else if (ioTraceSftpObj.isCollect() && !ioTraceSftpObj.isImmediateStop()) {
                        IOTraceExportDialog.this.refreshCollectStatus(HisResourceManager.getString("IO_TRACE_BEING_COLLECT"), ++times);
                    } else {
                        IOTraceExportDialog.this.refreshCollectStatus(HisResourceManager.getString("IO_TRACE_STOP_COLLECT"), ++times);
                    }
                    IOTraceExportDialog.this.refreshDownloadFileCount(di, false);
                    ThreadUtil.sleep(TimeUnit.SECONDS.toMillis(1L));
                }
                IOTraceExportDialog.this.refreshDownloadFileCount(di, false);
                if (IOTraceExportDialog.this.isShowDialog) {
                    this.showErrorMsg(di);
                }
                IOTraceExportDialog.this.setBtnStatusWhenError();
                IOTraceExportDialog.this.refreshFinshStatus(di);
            }

            private void showErrorMsg(DeviceInfo di2) {
                IOTaceErrMsg ioTraceErrMsg = di2.getIoTraceParam().getIOTraceErrMsg();
                String errIPs = ioTraceErrMsg.getErrIPs();
                String notExportIPs = ioTraceErrMsg.getNotExportIPs();
                if (!VerifyUtil.isEmpty(di2.getIOTraceErrMsg())) {
                    DialogUtils.showErrorDialog((JDialog)((Object)IOTraceExportDialog.this.getWindow()), (String)di2.getIOTraceErrMsg());
                } else if (!VerifyUtil.isEmpty(errIPs)) {
                    DialogUtils.showErrorDialog((JDialog)((Object)IOTraceExportDialog.this.getWindow()), (String)("ip[" + errIPs + "]" + HisResourceManager.getString("IO_TRACE_CONNECT_IP_FAILED")));
                } else if (!VerifyUtil.isEmpty(notExportIPs)) {
                    DialogUtils.showErrorDialog((JDialog)((Object)IOTraceExportDialog.this.getWindow()), (String)("ip[" + notExportIPs + "]" + HisResourceManager.getString("IO_TRACE_CONTROL_NOT_ENOUGH")));
                } else if (0 != di2.getIoTraceParam().getErrorIdList().size()) {
                    DialogUtils.showErrorDialog((JDialog)((Object)IOTraceExportDialog.this.getWindow()), (String)(HisResourceManager.getString("IO_TRACE_ERROR_LUN_ID") + di2.getIoTraceParam().getErrorIdList().toString()));
                }
            }
        }).start();
    }

    protected void refreshFinshStatus(DeviceInfo di) {
        JLabel collectStatus = this.layout.getCollectStatus();
        String errIPs = di.getIoTraceParam().getIOTraceErrMsg().getErrIPs();
        String notExportIPs = di.getIoTraceParam().getIOTraceErrMsg().getNotExportIPs();
        int errIds = di.getIoTraceParam().getErrorIdList().size();
        int downloadCount = di.getIoTraceParam().getDownloadFileNum().get();
        if (VerifyUtil.isEmpty(di.getIOTraceErrMsg()) && !this.isPartSuccess(errIPs, notExportIPs, errIds)) {
            UserBehaviorUtil.recordUserOpData(di, UserOpTaskResult.SUCCESS);
            collectStatus.setText(HisResourceManager.getString("IO_TRACE_COLLECT_SUCCESS"));
        } else if (VerifyUtil.isEmpty(di.getIOTraceErrMsg()) && downloadCount != 0 && this.isPartSuccess(errIPs, notExportIPs, errIds)) {
            UserBehaviorUtil.recordUserOpData(di, UserOpTaskResult.SUCCESS);
            collectStatus.setText(HisResourceManager.getString("IO_TRACE_PART_COLLECT_SUCCESS"));
        } else {
            UserBehaviorUtil.recordUserOpData(di, UserOpTaskResult.FAILED);
            collectStatus.setText(HisResourceManager.getString("IO_TRACE_COLLECT_FAILED"));
        }
        this.layout.getPoins().setText("");
    }

    private boolean isPartSuccess(String errIPs, String notExportIPs, int errIds) {
        return !VerifyUtil.isEmpty(errIPs) || !VerifyUtil.isEmpty(notExportIPs) || 0 != errIds || this.ioTraceSftp.isImmediateStop();
    }

    private void refreshCollectStatus(String showMsg, int time) {
        this.layout.getCollectStatus().setText(showMsg);
        this.refreshPoints(time);
    }

    private void refreshPoints(int time) {
        int count = time % 3;
        if (count == 0) {
            count = 3;
        }
        StringBuffer points = new StringBuffer();
        for (int i = 0; i < count; ++i) {
            points.append(".");
        }
        this.layout.getPoins().setText(points.toString());
    }

    private IOTraceExportDialog getWindow() {
        return this;
    }

    public String getCurrentDeviceID() {
        return this.layout.getSelectedDeviceID();
    }

    private class GetIOTraceFiles
    implements Callable<Integer> {
        private DeviceInfo di;

        public GetIOTraceFiles(DeviceInfo di) {
            this.di = this.checkDevice(di);
        }

        @Override
        public Integer call() {
            try {
                CountDownLatch countDownLatch = new CountDownLatch(1);
                IOTraceExportDialog.this.ioTraceSftp = new IOTraceSftp(this.di, countDownLatch);
                IOTraceExportDialog.this.ioTraceSftp.collectIOTrace();
                IOTraceExportDialog.this.monitorIOTraceCollect(IOTraceExportDialog.this.ioTraceSftp, this.di);
            }
            catch (IsmException e) {
                UserBehaviorUtil.recordUserOpData(this.di, UserOpTaskResult.FAILED);
                LOGGER.error((Object)"", (Throwable)e);
                throw e;
            }
            return null;
        }

        private DeviceInfo checkDevice(DeviceInfo deviceInfo) {
            if (!LocalHostUtil.isRunInSvp()) {
                return deviceInfo;
            }
            String[] ips = deviceInfo.getIp().split(",");
            DeviceInfo cloneDI = CopyUtil.copyDevInfo(deviceInfo, ips[0]);
            return cloneDI;
        }
    }
}

