/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.xve.monitor.perfstat;

import com.huawei.ism.common.resourcemanager.HisResourceManager;
import com.huawei.ism.ui.swing.LayoutConstants;
import com.huawei.ism.ui.swing.calendarpicker.CalendarPickerInterface;
import com.huawei.ism.ui.swing.calendarpicker.CalendarPickerPopup;
import com.huawei.ism.ui.swing.plaf.IsmFontFactory;
import com.huawei.ism.util.Pair;
import com.huawei.ism.util.UCD;
import com.huawei.xve.utils.ConnManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import org.apache.log4j.Logger;

public class IOTraceExportLayout
extends JPanel {
    private static final Logger LOGGER = Logger.getLogger(IOTraceExportLayout.class);
    private JComboBox<Pair<String, String>> selectedDeviceComboBox = null;
    private List<String> deviceIDList;
    private JLabel descLabel;
    private JLabel downloadCount;
    private JLabel errorMessageJL;
    private JLabel collectStatus;
    private JLabel poins;
    private JButton saveToBtn;
    private JButton stopToBtn;
    private JButton exploreBtn;
    private String errorMessage = "";
    private String exportCount = "0";
    private JButton reset;
    private JComponent timeSel;
    private JTextField startTime;
    private JTextField hideStartTime;
    private JTextField endTime;
    private JTextField hideEndTime;
    private JTextArea lunIDs;
    private DateFormat dFormat = new SimpleDateFormat("yyyy-MM-dd kk:mm:ss");

    public IOTraceExportLayout(List<String> deviceIDList) {
        this.deviceIDList = deviceIDList;
        this.doLayoutUI();
        this.setDeviceInfo();
    }

    public JLabel getCollectStatus() {
        return this.collectStatus;
    }

    public JLabel getPoins() {
        return this.poins;
    }

    public String getExportCount() {
        return this.exportCount;
    }

    public void setExportCount(String exportCount) {
        this.downloadCount.setText(exportCount);
        this.exportCount = exportCount;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessageJL.setText(errorMessage);
        this.errorMessage = errorMessage;
    }

    public JButton getSaveToBtn() {
        return this.saveToBtn;
    }

    public JButton getStopToBtn() {
        return this.stopToBtn;
    }

    public JButton getExploreBtn() {
        return this.exploreBtn;
    }

    public void setTimeSel(JComponent timeSel) {
        this.timeSel = timeSel;
    }

    public JComponent getTimeSel() {
        return this.timeSel;
    }

    public JButton getReset() {
        return this.reset;
    }

    public JTextField getStartTime() {
        return this.startTime;
    }

    public JTextField getEndTime() {
        return this.endTime;
    }

    public JTextArea getLunIDs() {
        return this.lunIDs;
    }

    public synchronized DateFormat getdFormat() {
        return this.dFormat;
    }

    public JLabel getDownloadCount() {
        return this.downloadCount;
    }

    public void setDownloadCount(JLabel downloadCount) {
        this.downloadCount = downloadCount;
    }

    private void doLayoutUI() {
        this.createComponents();
        this.layoutComponents();
    }

    private void createComponents() {
        this.selectedDeviceComboBox = new JComboBox();
        this.descLabel = new JLabel(HisResourceManager.getString("IO_TRACE_EXPORT_DESC"));
        this.reset = new JButton(HisResourceManager.getString("EXPORT-FILE.TXT.QUERY_RESET"));
        this.startTime = new JTextField(6);
        this.startTime.setPreferredSize(new Dimension(6, 20));
        this.endTime = new JTextField(6);
        this.endTime.setPreferredSize(new Dimension(6, 20));
        this.hideStartTime = new JTextField();
        this.hideEndTime = new JTextField();
        this.lunIDs = new JTextArea(2, 24);
        this.lunIDs.setLineWrap(true);
        this.lunIDs.setPreferredSize(new Dimension(24, 20));
        this.saveToBtn = new JButton(HisResourceManager.getString("EXPORT_FILE.TXT.EXPORT"));
        this.saveToBtn.setEnabled(true);
        this.stopToBtn = new JButton(HisResourceManager.getString("EXPORT_FILE.TXT.STOPEXPORT"));
        this.stopToBtn.setEnabled(false);
        this.exploreBtn = new JButton(HisResourceManager.getString("EXPORT_FILE.TXT.EXPLORE"));
        this.exploreBtn.setEnabled(true);
    }

    private void layoutComponents() {
        UCD.setJComponentWidth(this.selectedDeviceComboBox, (int)250);
        UCD.setJComponentWidth((JComponent)this.startTime, (int)150);
        UCD.setJComponentWidth((JComponent)this.endTime, (int)150);
        UCD.setJComponentWidth((JComponent)this.lunIDs, (int)250);
        JLabel arrayLabel = new JLabel(HisResourceManager.getString("LOGICALARRAYSPROPERTYPANE.ARRAYNAME") + ":");
        arrayLabel.setFont(IsmFontFactory.getBold12Font());
        Box deviceComponent = UCD.buildHBoxLeft((int)0, (Component[])new Component[]{arrayLabel, this.selectedDeviceComboBox, Box.createGlue()});
        deviceComponent.setBorder(UCD.getCompoundBorder((Border)UCD.createTableTitleBorder((String)HisResourceManager.getString("ABSTRACTTABBEDPROPERTYPANE_DEVICEINFO")), (Border)new EmptyBorder(4, 0, 8, 0)));
        JLabel lunIDLabel = new JLabel(HisResourceManager.getString("IO_TRACE_LUN_IDS_LABEL") + ":");
        this.lunIDs.setBorder(UCD.getEtchedLineBorder());
        JLabel helpTip = new JLabel(HisResourceManager.getString("IO_TRACE_HELP_TIPS"));
        JLabel startLabel = new JLabel(HisResourceManager.getString("EXPORT-FILE.IO.QUERY_STARTTIME") + ":");
        JLabel endLabel = new JLabel(HisResourceManager.getString("EXPORT-FILE.IO.QUERY_ENDTIME") + ":");
        JButton startBtn = new JButton();
        startBtn.setPreferredSize(new Dimension(60, 20));
        startBtn.setText(HisResourceManager.getString("EXPORT-FILE.TXT.QUERY_CHOOSE"));
        startBtn.addActionListener(new TimeChooserListener(startBtn, this.startTime, this.hideStartTime));
        JButton endBtn = new JButton();
        endBtn.setPreferredSize(new Dimension(60, 20));
        endBtn.setText(HisResourceManager.getString("EXPORT-FILE.TXT.QUERY_CHOOSE"));
        endBtn.addActionListener(new TimeChooserListener(endBtn, this.endTime, this.hideEndTime));
        this.timeSel = UCD.buildVBoxTop((int)LayoutConstants.LINE_MARGIN_PIXEL, (Component[])new Component[]{UCD.buildHBoxLeft((int)0, (Component[])new Component[]{Box.createHorizontalStrut(12), startLabel, this.startTime, startBtn, Box.createHorizontalStrut(7), endLabel, this.endTime, endBtn, this.reset}), UCD.buildHBoxLeft((int)0, (Component[])new Component[]{Box.createHorizontalStrut(12), lunIDLabel, this.lunIDs}), UCD.buildHBoxLeft((int)0, (Component[])new Component[]{Box.createHorizontalStrut(12), helpTip})});
        this.timeSel.setBorder(UCD.getCompoundBorder((Border)UCD.createTableTitleBorder((String)HisResourceManager.getString("EXPORT-FILE.TXT.QUERY_TITLE")), (Border)new EmptyBorder(4, 0, 8, 0)));
        Box wholeBox = null;
        this.collectStatus = new JLabel();
        this.poins = new JLabel();
        Box status = UCD.buildHBoxLeft((int)0, (Component[])new Component[]{Box.createHorizontalStrut(12), this.collectStatus, this.poins});
        this.downloadCount = new JLabel(this.exportCount);
        Box files = UCD.buildHBoxLeft((int)0, (Component[])new Component[]{Box.createHorizontalStrut(12), new JLabel(HisResourceManager.getString("EXPORT-FILE.TXT.DOWNLOAD_FILES") + ":"), this.downloadCount});
        this.errorMessageJL = new JLabel(this.errorMessage);
        wholeBox = UCD.buildVBoxTop((int)LayoutConstants.LINE_MARGIN_PIXEL, (Component[])new Component[]{UCD.buildHBoxLeft((Component[])new Component[]{this.descLabel}), deviceComponent, this.timeSel, UCD.buildHBoxLeft((Component[])new Component[]{status}), UCD.buildHBoxLeft((Component[])new Component[]{files}), UCD.buildHBoxCentert((Component[])new Component[]{this.errorMessageJL}), UCD.buildHBoxRight((Component[])new Component[]{this.saveToBtn, this.stopToBtn, this.exploreBtn})});
        this.setLayout(new BorderLayout());
        this.add((Component)wholeBox, "Center");
    }

    private void setDeviceInfo() {
        Pair arrayPair = null;
        for (String deviceID : this.deviceIDList) {
            arrayPair = new Pair((Object)deviceID, (Object)ConnManager.getDeviceName(deviceID));
            this.selectedDeviceComboBox.addItem((Pair<String, String>)arrayPair);
        }
    }

    public JComboBox getSelectedDeviceCombBox() {
        return this.selectedDeviceComboBox;
    }

    public String getSelectedDeviceID() {
        Pair selectedPair = (Pair)this.selectedDeviceComboBox.getSelectedItem();
        return (String)selectedPair.getKey();
    }

    public synchronized Date parse1(String str) throws ParseException {
        return this.dFormat.parse(str);
    }

    public synchronized String format1(Date date) {
        return this.dFormat.format(date);
    }

    public JTextField getHideStartTime() {
        return this.hideStartTime;
    }

    public JTextField getHideEndTime() {
        return this.hideEndTime;
    }

    private class TimeChooserListener
    implements ActionListener {
        private JButton curr;
        private JTextField currentText;
        private JTextField hideTime;

        public TimeChooserListener(JButton currentBtn, JTextField currentText, JTextField hideTime) {
            this.curr = currentBtn;
            this.currentText = currentText;
            this.hideTime = hideTime;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CalendarPickerPopup cPicker = CalendarPickerPopup.getInstance();
            Calendar cal = Calendar.getInstance();
            try {
                cal.setTime(IOTraceExportLayout.this.parse1("2000-1-1 00:00:00"));
            }
            catch (ParseException e1) {
                LOGGER.error((Object)e1);
            }
            cPicker.show(cal, Calendar.getInstance(), (Component)this.curr, CalendarPickerPopup.initParam((int)0, (int)(this.curr.getY() + this.curr.getHeight()), (boolean)true, (boolean)false));
            cPicker.addCallBackClass(new CalendarPickerInterface(){

                @Override
                public void callback(Calendar cal) {
                    String time = IOTraceExportLayout.this.format1(cal.getTime());
                    String[] subTimes = time.split(" ");
                    TimeChooserListener.this.currentText.setText(subTimes[0]);
                    TimeChooserListener.this.hideTime.setText(time);
                }
            });
        }
    }
}

