/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.xve.monitor.perfstat;

import com.huawei.ism.common.Framework;
import com.huawei.ism.common.bean.HisPerfStatObjectType;
import com.huawei.ism.common.bean.impl.IDataTypeEnum;
import com.huawei.ism.common.bean.impl.IObjectTypeEnum;
import com.huawei.ism.common.bean.impl.IPerfStatObject;
import com.huawei.ism.common.resourcemanager.HisResourceManager;
import com.huawei.ism.exception.IsmException;
import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.ui.module.perfhis.HisTools;
import com.huawei.ism.ui.module.perfhis.TimeSeriesChart;
import com.huawei.ism.ui.module.perfhis.XYTimeSeriesData;
import com.huawei.ism.ui.module.perfhis.pojo.HisPerfStatHisFileInfo;
import com.huawei.ism.ui.module.perfhis.pojo.HisPerfStatHisObject;
import com.huawei.ism.ui.module.perfhis.service.PerfStatHisFileService;
import com.huawei.ism.ui.module.perfhis.util.ColorContainer;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.table.DefaultTableRow;
import com.huawei.ism.ui.swing.table.IsmTableCell;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.ism.ui2.perfstat.AdvancePerfStatXYToolTipGenerator;
import com.huawei.ism.ui2.perfstat.NormalPerfStatXYToolTipGenerator;
import com.huawei.ism.ui2.perfstat.PerfStatRealTimeLayout;
import com.huawei.ism.ui2.perfstat.util.PerfStatUtil;
import com.huawei.ism.ui2.perfstat.util.TickableTree;
import com.huawei.ism.ui2.perfstat.util.TickableTreeNode;
import com.huawei.ism.util.CommonUtil;
import com.huawei.ism.util.Pair;
import com.huawei.ism.util.SwingUtil;
import com.huawei.ism.util.UCD;
import com.huawei.xve.monitor.perfstat.PerfStatObject;
import com.huawei.xve.monitor.perfstat.XVEPerfStatObject;
import com.huawei.xve.monitor.perfstat.impl.XVEDataTypeEnum;
import com.huawei.xve.monitor.perfstat.impl.XVEObjectTypeEnum;
import com.huawei.xve.utils.PerfStatUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseMotionAdapter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.data.time.TimeSeries;

public class PerfStatHisDetailFrame
extends JFrame {
    private static final long serialVersionUID = 1L;
    private static final double DOUBLE_BUNMBER = 1.0E-6;
    private static final String PANE_NAME = "PerfStatHisDetailFrame";
    private JLayeredPane layeredPane;
    private JPanel maskPanel = new JPanel();
    private PerfStatRealTimeLayout layout;
    private transient HisPerfStatHisFileInfo perfStatHisFileInfo = null;
    private JButton closeButton;
    private JPanel content;
    private List<HisPerfStatObjectType> objectTypes;
    private Map<HisPerfStatObjectType.HisObjectTypeEnum, List<HisPerfStatObjectType.HisDataTypeEnum>> objectTypeToDataTypesMapping;
    private Map<HisPerfStatObjectType.HisObjectTypeEnum, List<TableRow>> objectTypeToNamesTableRowMapping;
    private Map<String, Double> currentScales = new HashMap<String, Double>(0);
    private Map<String, Double> optimizedScales = new HashMap<String, Double>(0);
    private transient ColorContainer colorContainer = new ColorContainer();
    private transient XVEObjectTypeEnum advancePreviousSelectedObjectType;
    XVEObjectTypeEnum normalPreviousSelectedObjectType;
    private Map<HisPerfStatObjectType.HisObjectTypeEnum, List<String>> objectTypeToNamesMapping;
    private Map<HisPerfStatObjectType.HisObjectTypeEnum, List<HisPerfStatObjectType.HisDataTypeEnum>> objectTypeToSelectedDataTypeMapping = new HashMap<HisPerfStatObjectType.HisObjectTypeEnum, List<HisPerfStatObjectType.HisDataTypeEnum>>(0);
    private Set<IPerfStatObject> normalSelectedObjectSet = new HashSet<IPerfStatObject>(5);
    private Map<HisPerfStatObjectType.HisObjectTypeEnum, DefaultMutableTreeNode> advanceObjectTypeToObjectsMapping = new HashMap<HisPerfStatObjectType.HisObjectTypeEnum, DefaultMutableTreeNode>(0);
    private Map<HisPerfStatObjectType.HisObjectTypeEnum, DefaultMutableTreeNode> advanceObjectTypeToDataTypeTreeNodeMapping = new HashMap<HisPerfStatObjectType.HisObjectTypeEnum, DefaultMutableTreeNode>(0);
    private Map<HisPerfStatObjectType.HisObjectTypeEnum, DefaultMutableTreeNode> normalObjectTypeToObjectsMapping = new HashMap<HisPerfStatObjectType.HisObjectTypeEnum, DefaultMutableTreeNode>(0);
    private Map<HisPerfStatObjectType.HisObjectTypeEnum, DefaultMutableTreeNode> normalObjectTypeToDataTypeTreeNodeMapping = new HashMap<HisPerfStatObjectType.HisObjectTypeEnum, DefaultMutableTreeNode>(0);

    public PerfStatHisDetailFrame(String title, HisPerfStatHisFileInfo hisFileobj) {
        this.setTitle(title);
        this.perfStatHisFileInfo = hisFileobj;
        this.initLayout();
        this.addHandler();
        this.initData();
        this.setResizable(true);
        this.setMinimumSize(new Dimension(920, 660));
        this.setSize(new Dimension(920, 660));
        SwingUtil.setCloseWhenEscKeyPressed((JFrame)this);
    }

    private void addHandler() {
        this.addComponentListener(this.createComponentAdapter());
        this.layout.getAdvanceObjectTypeComboBox().addItemListener(this.createAdvanceObjectTypeComboBoxListener());
        this.layout.getAdvanceDataTypeComboBox().addItemListener(this.createDataTypeComboBoxListener());
        this.layout.getAdvanceObjectsTree().addTreeSelectionListener(this.createAdvanceObjectTreeSelectionListener());
        this.layout.getAdvanceDataTypeTree().addTreeTickListener(this.createAdvanceDataTypeTickTreeListener());
        this.layout.getAdvanceObjectsTree().addTreeTickListener(this.createAdvanceObjectTreeTickListener());
        this.layout.getNormalObjectTypeComboBox().addItemListener(this.createNormalObjectTypeComboBoxListener());
        this.layout.getNormalObjectsTree().addTreeSelectionListener(this.createNormalObjectTreeSelectionListener());
        this.layout.getNormalDataTypeTree().addTreeTickListener(this.createNormalDataTypeTickTreeListener());
        this.layout.getNormalObjectsTree().addTreeTickListener(this.createNormalObjectTreeTickListener());
        this.maskPanel.addMouseListener(new MouseAdapter(){});
        this.maskPanel.addKeyListener(new KeyAdapter(){});
        this.maskPanel.addMouseMotionListener(new MouseMotionAdapter(){});
    }

    private ComponentAdapter createComponentAdapter() {
        ComponentAdapter adapter = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                PerfStatHisDetailFrame.this.content.setBounds(0, 0, componentEvent.getComponent().getBounds().width, componentEvent.getComponent().getBounds().height - 30);
                PerfStatHisDetailFrame.this.maskPanel.setBounds(0, 0, componentEvent.getComponent().getBounds().width, componentEvent.getComponent().getBounds().height - 30);
                PerfStatHisDetailFrame.this.content.revalidate();
                PerfStatHisDetailFrame.this.content.repaint();
            }
        };
        return adapter;
    }

    private TickableTree.TreeTickListener createAdvanceDataTypeTickTreeListener() {
        TickableTree.TreeTickListener listener = new TickableTree.TreeTickListener(){

            public void treeTicked(TickableTree.TreeTickEvent tickEvent) {
                PerfStatHisDetailFrame.this.treeTickDo(tickEvent);
            }
        };
        return listener;
    }

    protected void treeTickDo(TickableTree.TreeTickEvent tickEvent) {
        TickableTreeNode node = tickEvent.getCurrentNode();
        HisPerfStatObjectType.HisDataTypeEnum tickDataType = ((XVEDataTypeEnum)((Pair)node.getUserObject()).getKey()).getRealValue();
        IPerfStatObject adv = this.layout.getAdvanceSelectedPerfStatObjectInTree();
        if (adv == null) {
            return;
        }
        HisPerfStatObjectType.HisObjectTypeEnum selectObjectType = ((XVEObjectTypeEnum)adv.getObjectType()).getRealValue();
        List tickNodeList = this.layout.getAdvanceObjectsTree().getTickedTreeNodes();
        ArrayList<HisPerfStatObjectType.HisDataTypeEnum> selectedDataTypes = new ArrayList<HisPerfStatObjectType.HisDataTypeEnum>(0);
        if (!this.objectTypeToSelectedDataTypeMapping.containsKey((Object)selectObjectType)) {
            this.objectTypeToSelectedDataTypeMapping.put(selectObjectType, selectedDataTypes);
        }
        if (node.isTicked()) {
            List<TableRow> newRowList = this.getNewRows(selectObjectType, tickDataType, tickNodeList);
            if (newRowList == null || newRowList.isEmpty()) {
                this.objectTypeToSelectedDataTypeMapping.get((Object)selectObjectType).add(tickDataType);
                return;
            }
            if (this.isTooManyStatItemsAdvance(newRowList.size())) {
                node.setTicked(false);
                return;
            }
            this.objectTypeToSelectedDataTypeMapping.get((Object)selectObjectType).add(tickDataType);
            this.addAdvanceStatItems(selectObjectType, newRowList, this.objectTypeToSelectedDataTypeMapping.get((Object)selectObjectType));
        } else {
            this.objectTypeToSelectedDataTypeMapping.get((Object)selectObjectType).remove((Object)tickDataType);
            selectedDataTypes.clear();
            selectedDataTypes.add(tickDataType);
            List<TableRow> removeRowList = this.getRemoveTableRows(selectObjectType, selectedDataTypes, tickNodeList);
            this.removeLegendRows(removeRowList);
        }
    }

    private TickableTree.TreeTickListener createNormalDataTypeTickTreeListener() {
        TickableTree.TreeTickListener listener = new TickableTree.TreeTickListener(){

            public void treeTicked(TickableTree.TreeTickEvent tickEvent) {
                TickableTreeNode node = tickEvent.getCurrentNode();
                XVEDataTypeEnum xveTickDataType = (XVEDataTypeEnum)((Pair)node.getUserObject()).getKey();
                HisPerfStatObjectType.HisDataTypeEnum tickDataType = xveTickDataType.getRealValue();
                IPerfStatObject sel = PerfStatHisDetailFrame.this.layout.getNormalSelectedPerfStatObjectInTree();
                if (sel == null) {
                    return;
                }
                HisPerfStatObjectType.HisObjectTypeEnum selectObjectType = ((XVEObjectTypeEnum)sel.getObjectType()).getRealValue();
                ArrayList<HisPerfStatObjectType.HisDataTypeEnum> dataTypeEnumList = new ArrayList<HisPerfStatObjectType.HisDataTypeEnum>();
                dataTypeEnumList.add(tickDataType);
                List tickNodeList = PerfStatHisDetailFrame.this.layout.getNormalObjectsTree().getTickedTreeNodes();
                if (node.isTicked()) {
                    PerfStatHisDetailFrame.this.addNormalStatItems(selectObjectType, tickNodeList, dataTypeEnumList);
                } else {
                    PerfStatHisDetailFrame.this.removeNormalStatItems(selectObjectType, tickNodeList, dataTypeEnumList, true);
                }
            }
        };
        return listener;
    }

    private void removeLegendRows(List<TableRow> rows) {
        IsmTableCell.ColorTableCell colorLabelCell = null;
        Color color = null;
        String key = null;
        for (TableRow tableRow : rows) {
            this.layout.getTableMode().removeRow(new TableRow[]{tableRow});
            colorLabelCell = (IsmTableCell.ColorTableCell)tableRow.getValueAt(0);
            color = colorLabelCell.getColor();
            this.colorContainer.releaseColor(color);
            key = (String)tableRow.getIdentifier();
            this.layout.getStatViewPanel().removeSeriesByKey(key);
            this.setLineColor();
        }
    }

    private void removeNormalStatItems(HisPerfStatObjectType.HisObjectTypeEnum objectType, List<TickableTreeNode> nodes, List<HisPerfStatObjectType.HisDataTypeEnum> dataTypes, boolean isRemoveable) {
        for (HisPerfStatObjectType.HisDataTypeEnum dataType : dataTypes) {
            for (TickableTreeNode node : nodes) {
                PerfStatObject temp = new PerfStatObject();
                temp.setObjectType(objectType);
                temp.setDataType(dataType);
                temp.setText((String)((Pair)node.getUserObject()).getValue());
                this.layout.getNormalPerfStatPanel().removeSeriesByKey((IPerfStatObject)new XVEPerfStatObject(temp), isRemoveable);
            }
        }
        this.layout.getNormalPerfStatPanel().refreshPanel();
    }

    private List<TableRow> getRemoveTableRows(HisPerfStatObjectType.HisObjectTypeEnum selectObjectType, List<HisPerfStatObjectType.HisDataTypeEnum> tickDataTypeList, List<TickableTreeNode> tickTreeNodeList) {
        String rowKey = null;
        int index = 0;
        Pair pair = null;
        ArrayList<Object> names = new ArrayList<Object>(0);
        for (TickableTreeNode node : tickTreeNodeList) {
            pair = (Pair)node.getUserObject();
            names.add(pair.getValue());
        }
        ArrayList<TableRow> removeRows = new ArrayList<TableRow>(0);
        for (String string : names) {
            for (HisPerfStatObjectType.HisDataTypeEnum tickDataType : tickDataTypeList) {
                rowKey = HisTools.generateStatItemKey(selectObjectType, string, tickDataType);
                index = this.layout.getTableMode().getRowIndex((Object)rowKey);
                if (index < 0) continue;
                removeRows.add(this.layout.getTableMode().getRow(index));
            }
        }
        return removeRows;
    }

    private boolean isTooManyStatItemsAdvance(int newRowCount) {
        if (newRowCount + this.layout.getTableMode().getRowCount() > 16) {
            this.setAlwaysOnTop(true);
            DialogUtils.showErrorDialog((Window)this, (String)HisResourceManager.getStringWithParams("perf.warning.tooManyStatItem", String.valueOf(16)));
            this.setAlwaysOnTop(false);
            return true;
        }
        return false;
    }

    private boolean isTooManyStatItemsNormal() {
        if (this.normalSelectedObjectSet.size() >= 5) {
            this.setAlwaysOnTop(true);
            DialogUtils.showErrorDialog((Window)this, (String)HisResourceManager.getStringWithParams("perf.warning.tooManyStatItem.normal", String.valueOf(5)));
            this.setAlwaysOnTop(false);
            return true;
        }
        return false;
    }

    public final Frame getParentWindow() {
        return Framework.getInstance().getMainFrame();
    }

    private List<TableRow> getNewRows(HisPerfStatObjectType.HisObjectTypeEnum selectObjectType, HisPerfStatObjectType.HisDataTypeEnum tickDataType, List<TickableTreeNode> tickTreeNodeList) {
        ArrayList<String> names = new ArrayList<String>(0);
        Pair pair = null;
        for (TickableTreeNode node : tickTreeNodeList) {
            pair = (Pair)node.getUserObject();
            names.add((String)pair.getValue());
        }
        if (this.layout.getTableMode().getRowCount() == 0) {
            return this.createTableRow(names);
        }
        ArrayList<TableRow> newRows = new ArrayList<TableRow>(0);
        String rowKey = null;
        int index = 0;
        for (TableRow row : this.createTableRow(names)) {
            rowKey = HisTools.generateStatItemKey(selectObjectType, row.getValueAt(0).toString(), tickDataType);
            index = this.layout.getTableMode().getRowIndex((Object)rowKey);
            if (index >= 0) continue;
            newRows.add(row);
        }
        if (newRows.isEmpty()) {
            return null;
        }
        return newRows;
    }

    private List<TableRow> createTableRow(List<String> names) {
        ArrayList<TableRow> rows = new ArrayList<TableRow>(names.size());
        DefaultTableRow row = null;
        for (String name : names) {
            row = new DefaultTableRow(1, (Object)name);
            row.setValueAt(0, name);
            rows.add((TableRow)row);
        }
        return rows;
    }

    private TickableTree.TreeTickListener createAdvanceObjectTreeTickListener() {
        TickableTree.TreeTickListener listener = new TickableTree.TreeTickListener(){

            public void treeTicked(TickableTree.TreeTickEvent tickEvent) {
                TickableTreeNode tickNode = tickEvent.getCurrentNode();
                HisPerfStatObjectType.HisObjectTypeEnum objectType = ((XVEPerfStatObject)((Pair)tickNode.getUserObject()).getKey()).getRealValue().getObjectType();
                List tickNodeList = new ArrayList<TickableTreeNode>(0);
                List dataTypeList = (List)PerfStatHisDetailFrame.this.objectTypeToSelectedDataTypeMapping.get((Object)objectType);
                if (tickNode.isTicked()) {
                    if (dataTypeList == null || dataTypeList.isEmpty()) {
                        return;
                    }
                    if (PerfStatHisDetailFrame.this.isTooManyStatItemsAdvance(dataTypeList.size())) {
                        tickNode.setTicked(false);
                        return;
                    }
                    tickNodeList = PerfStatHisDetailFrame.this.layout.getAdvanceObjectsTree().getTickedTreeNodes();
                    ArrayList<Object> names = new ArrayList<Object>(0);
                    Pair pair = null;
                    for (TickableTreeNode node : tickNodeList) {
                        pair = (Pair)node.getUserObject();
                        names.add(pair.getValue());
                    }
                    PerfStatHisDetailFrame.this.addAdvanceStatItems(objectType, PerfStatHisDetailFrame.this.createTableRow(names), dataTypeList);
                } else {
                    tickNodeList.add(tickNode);
                    if (dataTypeList == null || dataTypeList.isEmpty()) {
                        return;
                    }
                    List removeTableRow = PerfStatHisDetailFrame.this.getRemoveTableRows(objectType, dataTypeList, tickNodeList);
                    PerfStatHisDetailFrame.this.removeLegendRows(removeTableRow);
                }
            }
        };
        return listener;
    }

    private TickableTree.TreeTickListener createNormalObjectTreeTickListener() {
        TickableTree.TreeTickListener listener = new TickableTree.TreeTickListener(){

            public void treeTicked(TickableTree.TreeTickEvent tickEvent) {
                TickableTreeNode tickNode = tickEvent.getCurrentNode();
                IPerfStatObject perfStatObject = (IPerfStatObject)((Pair)tickNode.getUserObject()).getKey();
                HisPerfStatObjectType.HisObjectTypeEnum objectType = ((XVEPerfStatObject)perfStatObject).getRealValue().getObjectType();
                ArrayList<TickableTreeNode> tickNodeList = new ArrayList<TickableTreeNode>(0);
                tickNodeList.add(tickNode);
                DefaultMutableTreeNode dataTypeNode = (DefaultMutableTreeNode)PerfStatHisDetailFrame.this.normalObjectTypeToDataTypeTreeNodeMapping.get((Object)objectType);
                List dataTypeList = PerfStatHisDetailFrame.this.getTickedDataTypes(dataTypeNode);
                if (tickNode.isTicked()) {
                    if (dataTypeList == null || dataTypeList.isEmpty()) {
                        PerfStatHisDetailFrame.this.normalSelectedObjectSet.add(perfStatObject);
                        return;
                    }
                    if (PerfStatHisDetailFrame.this.isTooManyStatItemsNormal()) {
                        tickNode.setTicked(false);
                        return;
                    }
                    PerfStatHisDetailFrame.this.normalSelectedObjectSet.add(perfStatObject);
                    PerfStatHisDetailFrame.this.addNormalStatItems(objectType, tickNodeList, dataTypeList);
                } else {
                    PerfStatHisDetailFrame.this.normalSelectedObjectSet.remove(perfStatObject);
                    PerfStatHisDetailFrame.this.removeNormalStatItems(objectType, tickNodeList, dataTypeList, PerfStatUtil.existCurrentObjectType((IObjectTypeEnum)perfStatObject.getObjectType(), (Set)PerfStatHisDetailFrame.this.normalSelectedObjectSet));
                }
            }
        };
        return listener;
    }

    private List<HisPerfStatObjectType.HisDataTypeEnum> getTickedDataTypes(DefaultMutableTreeNode dataTypesNode) {
        ArrayList<HisPerfStatObjectType.HisDataTypeEnum> dataTypes = new ArrayList<HisPerfStatObjectType.HisDataTypeEnum>();
        if (dataTypesNode != null) {
            Enumeration<TreeNode> allNodes = dataTypesNode.breadthFirstEnumeration();
            while (allNodes.hasMoreElements()) {
                TickableTreeNode tickableTreeNode;
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)allNodes.nextElement();
                if (!(node instanceof TickableTreeNode) || !(tickableTreeNode = (TickableTreeNode)node).isTicked()) continue;
                IDataTypeEnum dataType = (IDataTypeEnum)((Pair)((TickableTreeNode)node).getUserObject()).getKey();
                dataTypes.add(((XVEDataTypeEnum)dataType).getRealValue());
            }
        }
        return dataTypes;
    }

    private DefaultMutableTreeNode getAdvanceDataTypesNode(XVEObjectTypeEnum objectType) {
        DefaultMutableTreeNode root = this.advanceObjectTypeToDataTypeTreeNodeMapping.get((Object)objectType.getRealValue());
        if (root == null) {
            root = new DefaultMutableTreeNode("root");
        }
        return root;
    }

    private DefaultMutableTreeNode getNormalDataTypesNode(XVEObjectTypeEnum objectType) {
        DefaultMutableTreeNode root = this.normalObjectTypeToDataTypeTreeNodeMapping.get((Object)objectType.getRealValue());
        if (root == null) {
            root = new DefaultMutableTreeNode("root");
        }
        return root;
    }

    private TreeSelectionListener createAdvanceObjectTreeSelectionListener() {
        TreeSelectionListener listener = new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                XVEPerfStatObject perfStatObject = (XVEPerfStatObject)PerfStatHisDetailFrame.this.layout.getAdvanceSelectedPerfStatObjectInTree();
                if (perfStatObject != null) {
                    XVEObjectTypeEnum objectTypeEnum = (XVEObjectTypeEnum)perfStatObject.getObjectType();
                    if (!objectTypeEnum.equals(PerfStatHisDetailFrame.this.advancePreviousSelectedObjectType)) {
                        PerfStatHisDetailFrame.this.advancePreviousSelectedObjectType = objectTypeEnum;
                        DefaultMutableTreeNode dataTypesNode = PerfStatHisDetailFrame.this.getAdvanceDataTypesNode(objectTypeEnum);
                        PerfStatHisDetailFrame.this.layout.setAdvanceDataTypes(dataTypesNode, (IObjectTypeEnum)objectTypeEnum);
                    }
                } else {
                    PerfStatHisDetailFrame.this.advancePreviousSelectedObjectType = null;
                    PerfStatHisDetailFrame.this.layout.setAdvanceDataTypes(new DefaultMutableTreeNode("root"), null);
                }
            }
        };
        return listener;
    }

    private TreeSelectionListener createNormalObjectTreeSelectionListener() {
        TreeSelectionListener listener = new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                XVEPerfStatObject perfStatObject = (XVEPerfStatObject)PerfStatHisDetailFrame.this.layout.getNormalSelectedPerfStatObjectInTree();
                if (perfStatObject != null) {
                    XVEObjectTypeEnum objectTypeEnum = (XVEObjectTypeEnum)perfStatObject.getObjectType();
                    if (!objectTypeEnum.equals(PerfStatHisDetailFrame.this.normalPreviousSelectedObjectType)) {
                        PerfStatHisDetailFrame.this.normalPreviousSelectedObjectType = objectTypeEnum;
                        DefaultMutableTreeNode dataTypesNode = PerfStatHisDetailFrame.this.getNormalDataTypesNode(objectTypeEnum);
                        PerfStatHisDetailFrame.this.layout.setNormalDataTypes(dataTypesNode, (IObjectTypeEnum)objectTypeEnum);
                    }
                } else {
                    PerfStatHisDetailFrame.this.normalPreviousSelectedObjectType = null;
                    PerfStatHisDetailFrame.this.layout.setNormalDataTypes(new DefaultMutableTreeNode("root"), null);
                }
            }
        };
        return listener;
    }

    private ItemListener createDataTypeComboBoxListener() {
        ItemListener listener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                PerfStatHisDetailFrame.this.layout.refreshAdvanceDataTypes();
            }
        };
        return listener;
    }

    private ItemListener createAdvanceObjectTypeComboBoxListener() {
        ItemListener listener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getID() == 701 && itemEvent.getStateChange() == 1) {
                    PerfStatHisDetailFrame.this.setAdvanceObjects();
                }
            }
        };
        return listener;
    }

    private ItemListener createNormalObjectTypeComboBoxListener() {
        ItemListener listener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getID() == 701 && itemEvent.getStateChange() == 1) {
                    PerfStatHisDetailFrame.this.clearNormalChart();
                    PerfStatHisDetailFrame.this.setNormalObjects();
                }
            }
        };
        return listener;
    }

    private void setAdvanceObjects() {
        XVEObjectTypeEnum objectType = (XVEObjectTypeEnum)this.layout.getAdvanceSelectedObjectType();
        if (objectType == null) {
            return;
        }
        DefaultMutableTreeNode objectsNode = this.advanceObjectTypeToObjectsMapping.get((Object)objectType.getRealValue());
        this.layout.setAdvanceObjects(objectsNode);
    }

    private void setNormalObjects() {
        XVEObjectTypeEnum objectType = (XVEObjectTypeEnum)this.layout.getNormalSelectedObjectType();
        if (objectType == null) {
            return;
        }
        DefaultMutableTreeNode objectsNode = this.normalObjectTypeToObjectsMapping.get((Object)objectType.getRealValue());
        this.layout.setNormalObjects(objectsNode);
    }

    private void initLayout() {
        this.initComponent();
        this.content = new JPanel();
        this.content.setLayout(new BorderLayout());
        this.layout.setBorder(UCD.createEmptyBorder());
        this.content.add((Component)this.layout);
        JComponent bottomBox = this.createBottomContainer();
        this.content.add((Component)bottomBox, "South");
        this.layeredPane = new JLayeredPane();
        this.layeredPane.setOpaque(false);
        this.layeredPane.add((Component)this.content, (Object)200);
        this.content.setBounds(0, 0, 920, 630);
        this.maskPanel.setOpaque(false);
        this.maskPanel.setBounds(0, 0, 920, 660);
        this.add(this.layeredPane);
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PerfStatHisDetailFrame.this.dispose();
            }
        });
        this.setIconImage(HisResourceManager.getImage("performance.png").getImage());
        this.layout.getPeriodValueLabel().setText("" + this.perfStatHisFileInfo.getPeriod() / 1000);
        this.layout.getStatViewPanel().setToolTipGenerator((XYToolTipGenerator)this.createAdvancePerfStatGenerator());
        this.layout.getNormalPerfStatPanel().setToolTipGenerator(this.createNormalPerfStatGenerator());
    }

    public void setMask(boolean isShowMask) {
        if (isShowMask) {
            this.layeredPane.add((Component)this.maskPanel, (Object)2000);
            this.maskPanel.requestFocusInWindow();
        } else {
            this.layeredPane.remove(this.maskPanel);
        }
        this.layeredPane.validate();
        this.layeredPane.repaint();
    }

    private AdvancePerfStatXYToolTipGenerator createAdvancePerfStatGenerator() {
        AdvancePerfStatXYToolTipGenerator generator = new AdvancePerfStatXYToolTipGenerator(HisTools.generateDateFormat(this.layout.getStatViewPanel().getTimeZone()), NumberFormat.getInstance(), this.layout.getTableMode(), this.currentScales);
        return generator;
    }

    private NormalPerfStatXYToolTipGenerator createNormalPerfStatGenerator() {
        NormalPerfStatXYToolTipGenerator generator = new NormalPerfStatXYToolTipGenerator(this.layout.getNormalPerfStatPanel(), HisTools.generateDateFormat(this.layout.getNormalPerfStatPanel().getTimeZone()), NumberFormat.getInstance());
        return generator;
    }

    private void initComponent() {
        this.layout = new PerfStatRealTimeLayout((Frame)this, PANE_NAME);
        this.closeButton = new JButton(HisResourceManager.getString("COMMON.TXT.CLOSE"));
    }

    private JComponent createBottomContainer() {
        Box wholeBox = Box.createVerticalBox();
        JButton[] closeAndHelp = new JButton[]{this.closeButton};
        Box buttonBox = UCD.buildButtonBoxRight((JButton[][])new JButton[][]{closeAndHelp});
        buttonBox.setBorder(UCD.createEmptyBorder((int)8));
        wholeBox.add(Box.createVerticalStrut(4));
        JSeparator separator = new JSeparator(0);
        wholeBox.add(separator);
        wholeBox.add(buttonBox);
        return wholeBox;
    }

    private DefaultMutableTreeNode createTreeNode(HisPerfStatObjectType objectType, List<String> names) {
        if (names == null || names.isEmpty()) {
            return new DefaultMutableTreeNode("root");
        }
        DefaultMutableTreeNode parentNode = new DefaultMutableTreeNode(objectType.getType().getDescription());
        Pair pair = null;
        TickableTreeNode node = null;
        PerfStatObject perfStatObject = null;
        for (String name : names) {
            perfStatObject = new PerfStatObject();
            perfStatObject.setObjectType(objectType.getType());
            pair = new Pair((Object)new XVEPerfStatObject(perfStatObject), (Object)name);
            node = new TickableTreeNode((Object)pair);
            parentNode.add((MutableTreeNode)node);
        }
        return parentNode;
    }

    private void initObjectTypeToObjectsMapping() {
        List<String> names = null;
        for (HisPerfStatObjectType object : this.objectTypes) {
            HisPerfStatObjectType.HisObjectTypeEnum objectType = object.getType();
            names = this.objectTypeToNamesMapping.get((Object)objectType);
            DefaultMutableTreeNode treeNode = this.createTreeNode(object, names);
            this.advanceObjectTypeToObjectsMapping.put(objectType, treeNode);
            this.normalObjectTypeToObjectsMapping.put(objectType, this.cloneTreeNode(treeNode));
        }
    }

    private void initObjectTypeToDataTypeTreeNodeMapping() {
        Map<HisPerfStatObjectType.HisObjectTypeEnum, List<HisPerfStatObjectType.HisDataTypeEnum>> mapping = this.objectTypeToDataTypesMapping;
        Set<Map.Entry<HisPerfStatObjectType.HisObjectTypeEnum, List<HisPerfStatObjectType.HisDataTypeEnum>>> entries = mapping.entrySet();
        for (Map.Entry<HisPerfStatObjectType.HisObjectTypeEnum, List<HisPerfStatObjectType.HisDataTypeEnum>> entry : entries) {
            TickableTreeNode treeNode = PerfStatUtil.createDataTypeTreeNode(this.changeDataTypeEnum(entry.getValue()));
            HisPerfStatObjectType.HisObjectTypeEnum objectType = entry.getKey();
            this.advanceObjectTypeToDataTypeTreeNodeMapping.put(objectType, (DefaultMutableTreeNode)treeNode);
            DefaultMutableTreeNode cloneTreeNode = this.cloneDataTypeTreeNode((DefaultMutableTreeNode)treeNode, objectType);
            if (cloneTreeNode == null) {
                return;
            }
            this.tickAllNode(cloneTreeNode);
            this.normalObjectTypeToDataTypeTreeNodeMapping.put(objectType, cloneTreeNode);
        }
    }

    private List<IDataTypeEnum> changeDataTypeEnum(List<HisPerfStatObjectType.HisDataTypeEnum> list) {
        ArrayList<IDataTypeEnum> result = new ArrayList<IDataTypeEnum>();
        for (HisPerfStatObjectType.HisDataTypeEnum dataType : list) {
            result.add(new XVEDataTypeEnum(dataType));
        }
        return result;
    }

    private DefaultMutableTreeNode cloneTreeNode(DefaultMutableTreeNode node) {
        DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)node.clone();
        int size = node.getChildCount();
        for (int i = 0; i < size; ++i) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getChildAt(i);
            parentNode.add(this.cloneTreeNode(child));
        }
        return parentNode;
    }

    private void tickAllNode(DefaultMutableTreeNode treeNode) {
        if (treeNode instanceof TickableTreeNode && !"root".equals(treeNode.getUserObject())) {
            ((TickableTreeNode)treeNode).setTicked(true);
        }
        int size = treeNode.getChildCount();
        for (int i = 0; i < size; ++i) {
            this.tickAllNode((DefaultMutableTreeNode)treeNode.getChildAt(i));
        }
    }

    private DefaultMutableTreeNode cloneDataTypeTreeNode(DefaultMutableTreeNode node, HisPerfStatObjectType.HisObjectTypeEnum objectType) {
        Pair pair;
        DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)node.clone();
        if (parentNode instanceof TickableTreeNode && !"root".equals(parentNode.getUserObject()) && !this.layout.isBasicDataType((IDataTypeEnum)(pair = (Pair)((TickableTreeNode)parentNode).getUserObject()).getKey(), (IObjectTypeEnum)new XVEObjectTypeEnum(objectType))) {
            return null;
        }
        int size = node.getChildCount();
        for (int i = 0; i < size; ++i) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getChildAt(i);
            DefaultMutableTreeNode cloneDataTypeTreeNode = this.cloneDataTypeTreeNode(child, objectType);
            if (cloneDataTypeTreeNode == null) continue;
            parentNode.add(cloneDataTypeTreeNode);
        }
        return parentNode;
    }

    private void initData() {
        this.setDesc();
        ArrayList<Pair> deviceIDPairs = new ArrayList<Pair>(1);
        deviceIDPairs.add(new Pair((Object)this.perfStatHisFileInfo.getDeviceSN(), (Object)this.perfStatHisFileInfo.getDeviceName()));
        this.layout.setDeviceNames(deviceIDPairs);
        List<HisPerfStatObjectType.HisObjectTypeEnum> objectTypeEnums = this.perfStatHisFileInfo.getObjectTypes();
        Map<HisPerfStatObjectType.HisObjectTypeEnum, List<HisPerfStatObjectType.HisDataTypeEnum>> objectTypeToDataTypeMapping = this.perfStatHisFileInfo.getObjectTypeToDataTypeMapping();
        LinkedList<HisPerfStatObjectType> perfStatObjectTypes = new LinkedList<HisPerfStatObjectType>();
        ArrayList<HisPerfStatObjectType.HisDataTypeEnum> dataTypes = null;
        HisPerfStatObjectType perfStatObjectType = null;
        for (HisPerfStatObjectType.HisObjectTypeEnum hisObjectTypeEnum : objectTypeEnums) {
            dataTypes = new ArrayList<HisPerfStatObjectType.HisDataTypeEnum>(0);
            for (HisPerfStatObjectType.HisDataTypeEnum dataType : objectTypeToDataTypeMapping.get((Object)hisObjectTypeEnum)) {
                if (dataTypes.contains((Object)dataType)) continue;
                dataTypes.add(dataType);
            }
            perfStatObjectType = new HisPerfStatObjectType();
            perfStatObjectType.setType(hisObjectTypeEnum);
            perfStatObjectType.addDataTypeList(dataTypes);
            if ("--".equals(hisObjectTypeEnum.getDescription())) continue;
            perfStatObjectTypes.add(perfStatObjectType);
        }
        this.objectTypes = perfStatObjectTypes;
        this.objectTypeToNamesMapping = new HashMap<HisPerfStatObjectType.HisObjectTypeEnum, List<String>>(0);
        this.deleteDuplicateName();
        this.objectTypeToNamesTableRowMapping = new HashMap<HisPerfStatObjectType.HisObjectTypeEnum, List<TableRow>>(0);
        for (HisPerfStatObjectType hisPerfStatObjectType : this.objectTypes) {
            this.createObjectTypeToNamesTableRowMapping(hisPerfStatObjectType.getType(), this.objectTypeToNamesMapping);
        }
        this.objectTypeToDataTypesMapping = new HashMap<HisPerfStatObjectType.HisObjectTypeEnum, List<HisPerfStatObjectType.HisDataTypeEnum>>(0);
        for (HisPerfStatObjectType hisPerfStatObjectType : this.objectTypes) {
            this.objectTypeToDataTypesMapping.put(hisPerfStatObjectType.getType(), hisPerfStatObjectType.getDataTypeList());
        }
        this.initObjectTypeToObjectsMapping();
        this.initObjectTypeToDataTypeTreeNodeMapping();
        this.setOjectTypeComboBoxData(this.objectTypes);
        List<Pair<String, String>> list = PerfStatUtils.getDefaultCategories();
        this.layout.getAdvanceDataTypeComboBox().removeAllItems();
        for (Pair<String, String> temp : list) {
            this.layout.getAdvanceDataTypeComboBox().addItem(temp);
        }
    }

    private void deleteDuplicateName() {
        ArrayList<String> names = null;
        for (Map.Entry<HisPerfStatObjectType.HisObjectTypeEnum, List<String>> entry : this.perfStatHisFileInfo.getObjectTypeToNamesMapping().entrySet()) {
            names = new ArrayList<String>(0);
            for (String name : entry.getValue()) {
                if (names.contains(name)) continue;
                names.add(name);
            }
            this.objectTypeToNamesMapping.put(entry.getKey(), names);
        }
    }

    private void createObjectTypeToNamesTableRowMapping(HisPerfStatObjectType.HisObjectTypeEnum objectType, Map<HisPerfStatObjectType.HisObjectTypeEnum, List<String>> objectTypeToNamesMappings) {
        ArrayList<DefaultTableRow> objNameTableRows = new ArrayList<DefaultTableRow>(0);
        List<String> names = objectTypeToNamesMappings.get((Object)objectType);
        DefaultTableRow row = null;
        for (String name : names) {
            if ("Default Group".equals(name)) {
                name = HisResourceManager.getString("DefaultGroup");
            }
            row = new DefaultTableRow(PerfStatUtil.getObjectAndDataTypeNameTableColNames().length, (Object)name, (Object)name);
            row.setValueAt(0, name);
            objNameTableRows.add(row);
        }
        this.objectTypeToNamesTableRowMapping.put(objectType, objNameTableRows);
    }

    private void setOjectTypeComboBoxData(List<HisPerfStatObjectType> statItems) {
        HisPerfStatObjectType.HisObjectTypeEnum type = null;
        Pair item = null;
        for (HisPerfStatObjectType statItem : statItems) {
            type = statItem.getType();
            item = new Pair((Object)new XVEObjectTypeEnum(type), (Object)type.getDescription());
            if ("--".equals(type.getDescription())) continue;
            this.layout.getAdvanceObjectTypeComboBox().addItem(item);
            this.layout.getNormalObjectTypeComboBox().addItem(item);
        }
    }

    public void addAdvanceStatItems(HisPerfStatObjectType.HisObjectTypeEnum objType, List<TableRow> objectTableRows, List<HisPerfStatObjectType.HisDataTypeEnum> dataTypes) {
        this.addLegendRows(objType, objectTableRows, dataTypes);
        this.updateChart();
    }

    public void addNormalStatItems(final HisPerfStatObjectType.HisObjectTypeEnum objectType, final List<TickableTreeNode> nodes, final List<HisPerfStatObjectType.HisDataTypeEnum> dataTypes) {
        AsyncExcutor.execute((Window)this, (Callable[])new Callable[]{new Callable<Boolean>(){

            @Override
            public Boolean call() {
                PerfStatHisDetailFrame.this.synAddNormalStatItems(objectType, nodes, dataTypes);
                return true;
            }
        }});
    }

    private void synAddNormalStatItems(HisPerfStatObjectType.HisObjectTypeEnum objectType, List<TickableTreeNode> nodes, List<HisPerfStatObjectType.HisDataTypeEnum> dataTypes) {
        this.layout.getNormalPerfStatPanel().getMainPanel().setVisible(false);
        for (HisPerfStatObjectType.HisDataTypeEnum dataType : dataTypes) {
            for (TickableTreeNode node : nodes) {
                List<HisPerfStatHisObject> perStatObjs;
                try {
                    ArrayList<HisPerfStatObjectType.HisDataTypeEnum> tmpTypesList = new ArrayList<HisPerfStatObjectType.HisDataTypeEnum>();
                    tmpTypesList.add(dataType);
                    ArrayList<String> objectNames = new ArrayList<String>(1);
                    objectNames.add((String)((Pair)node.getUserObject()).getValue());
                    perStatObjs = PerfStatHisFileService.queryPerfStatHisObject(this.perfStatHisFileInfo, objectType, objectNames, tmpTypesList, 150L);
                    this.setNormalAxisX(perStatObjs);
                }
                catch (IsmException ismException) {
                    DialogUtils.showErrorDialog((Window)this, (String)ismException.getErrorMessage());
                    return;
                }
                Collection<XYTimeSeriesData> datas = this.getSeriesData(dataType, perStatObjs);
                XVEPerfStatObject temp = new XVEPerfStatObject(new PerfStatObject());
                temp.setObjectType(new XVEObjectTypeEnum(objectType));
                temp.setDataType(new XVEDataTypeEnum(dataType));
                temp.setText((String)((Pair)node.getUserObject()).getValue());
                temp.setColor(node.getColor());
                this.layout.getNormalPerfStatPanel().addData((IPerfStatObject)temp, datas);
            }
        }
        this.layout.getNormalPerfStatPanel().getMainPanel().setVisible(true);
    }

    private Collection<XYTimeSeriesData> getSeriesData(HisPerfStatObjectType.HisDataTypeEnum dataType, List<HisPerfStatHisObject> perStatObjs) {
        double maxValue = 0.0;
        ArrayList<XYTimeSeriesData> datas = new ArrayList<XYTimeSeriesData>();
        for (HisPerfStatHisObject hisSimpleObject : perStatObjs) {
            List<int[]> dataTypeAndData = hisSimpleObject.getData();
            long iStart = hisSimpleObject.getStartTime();
            for (int i = 0; i < dataTypeAndData.size(); ++i) {
                int longValue;
                int[] data = dataTypeAndData.get(i);
                if (null == data || data.length < 1 || (longValue = data[0]) == 0xFFFFFF) continue;
                maxValue = (double)longValue > maxValue ? (double)longValue : maxValue;
                double doubleValue = longValue;
                if (dataType == HisPerfStatObjectType.HisDataTypeEnum.AVERAGE_READ_IO || dataType == HisPerfStatObjectType.HisDataTypeEnum.AVERAGE_WRITE_IO || dataType == HisPerfStatObjectType.HisDataTypeEnum.AVERAGE_IO_SIZE) {
                    doubleValue /= 1024.0;
                    maxValue /= 1024.0;
                }
                if (doubleValue == 0.0) {
                    doubleValue = 1.0E-6;
                }
                boolean isExists = false;
                for (XYTimeSeriesData seriesData : datas) {
                    if (seriesData.getValueX() != iStart) continue;
                    isExists = true;
                    seriesData.setValueY(doubleValue);
                }
                if (!isExists) {
                    datas.add(new XYTimeSeriesData(iStart, Double.valueOf(doubleValue)));
                }
                iStart += (long)hisSimpleObject.getPeriod();
            }
        }
        return datas;
    }

    private void setLineColor() {
        List rows = this.layout.getTableMode().getAllRows();
        TableRow row = null;
        String key = null;
        IsmTableCell.ColorTableCell colorLabelCell = null;
        Color color = null;
        for (int i = 0; i < rows.size(); ++i) {
            row = (TableRow)rows.get(i);
            key = (String)row.getIdentifier();
            colorLabelCell = (IsmTableCell.ColorTableCell)row.getValueAt(0);
            color = colorLabelCell.getColor();
            this.layout.getStatViewPanel().setSeriesColor((Comparable)((Object)key), color);
        }
    }

    private void updateChart() {
        List allRows = this.layout.getTableMode().getAllRows();
        TimeSeriesChart seriesChart = this.layout.getStatViewPanel();
        Pair dataTypePair = null;
        IDataTypeEnum dataType = null;
        String key = null;
        for (TableRow tableRow : allRows) {
            dataTypePair = (Pair)tableRow.getValueAt(4);
            dataType = (IDataTypeEnum)dataTypePair.getKey();
            key = tableRow.getValueAt(1) + "" + '_' + tableRow.getValueAt(2) + '_' + dataType.getDescription();
            if (seriesChart.getSeries((Comparable)((Object)key)) != null) continue;
            this.processOneRow(seriesChart, tableRow);
        }
        this.setLineColor();
    }

    private void processOneRow(TimeSeriesChart seriesChart, TableRow tableRow) {
        Pair dataTypePair = (Pair)tableRow.getValueAt(4);
        HisPerfStatObjectType.HisDataTypeEnum dataType = ((XVEDataTypeEnum)dataTypePair.getKey()).getRealValue();
        String key = tableRow.getValueAt(1) + "" + '_' + tableRow.getValueAt(2) + '_' + dataType.getDescription();
        String objectName = (String)tableRow.getValueAt(1);
        if (HisResourceManager.getString("DefaultGroup").equals(objectName)) {
            objectName = "Default Group";
        }
        ArrayList<String> statObjNames = new ArrayList<String>(0);
        statObjNames.add((String)tableRow.getValueAt(2));
        List perStatObjs = null;
        try {
            ArrayList<HisPerfStatObjectType.HisDataTypeEnum> tmpTypesList = new ArrayList<HisPerfStatObjectType.HisDataTypeEnum>(0);
            tmpTypesList.add(dataType);
            PerfStatHisFileService.QueryPerfStatHisObjectTask task = new PerfStatHisFileService.QueryPerfStatHisObjectTask(this.perfStatHisFileInfo, (HisPerfStatObjectType.HisObjectTypeEnum)((Object)tableRow.getUserObject()), statObjNames, tmpTypesList, 150L);
            AsyncExcutor.execute((Window)this, (Callable[])new Callable[]{task});
            if (!task.isExecuteSucess()) {
                Exception exception = task.getException();
                DialogUtils.showErrorDialog((Frame)this, (Throwable)exception);
                return;
            }
            perStatObjs = (List)task.getExecuteResult();
            this.setAdvanceAxisX(perStatObjs);
        }
        catch (IsmException ismException) {
            DialogUtils.showErrorDialog((Window)this, (String)ismException.getErrorMessage());
            return;
        }
        double maxValue = 0.0;
        ArrayList<XYTimeSeriesData> datas = new ArrayList<XYTimeSeriesData>(0);
        maxValue = this.processOneRow1(dataType, perStatObjs, maxValue, datas);
        double scale = PerfStatHisDetailFrame.calculateScale(maxValue);
        this.calculateDatas(datas, scale);
        this.optimizedScales.put(key, scale);
        this.currentScales.put(key, scale);
        seriesChart.addData(key, datas);
        IsmTableCell.ComboBoxCell cell = (IsmTableCell.ComboBoxCell)tableRow.getValueAt(3);
        cell.setRendererItem((Object)(" (" + HisTools.convertScaleToString(scale) + ')'));
    }

    private double processOneRow1(HisPerfStatObjectType.HisDataTypeEnum dataType, List<HisPerfStatHisObject> perStatObjs, double maxValue, Collection<XYTimeSeriesData> datas) {
        for (HisPerfStatHisObject hisSimpleObject : perStatObjs) {
            double maxValueTmp = this.processOneRow2(dataType, hisSimpleObject, maxValue, datas);
            maxValue = maxValue > maxValueTmp ? maxValue : maxValueTmp;
        }
        return maxValue;
    }

    private double processOneRow2(HisPerfStatObjectType.HisDataTypeEnum dataType, HisPerfStatHisObject hisSimpleObject, double maxValue, Collection<XYTimeSeriesData> datas) {
        List<int[]> dataTypeAndData = hisSimpleObject.getData();
        long iStart = hisSimpleObject.getStartTime();
        int[] data = null;
        int longValue = 0;
        for (int i = 0; i < dataTypeAndData.size(); ++i) {
            data = dataTypeAndData.get(i);
            if (null == data || data.length < 1 || (longValue = data[0]) == 0xFFFFFF) continue;
            maxValue = (double)longValue > maxValue ? (double)longValue : maxValue;
            double doubleValue = longValue;
            if (dataType == HisPerfStatObjectType.HisDataTypeEnum.AVERAGE_READ_IO || dataType == HisPerfStatObjectType.HisDataTypeEnum.AVERAGE_WRITE_IO || dataType == HisPerfStatObjectType.HisDataTypeEnum.AVERAGE_IO_SIZE) {
                doubleValue /= 1024.0;
                maxValue /= 1024.0;
            }
            boolean isExists = false;
            for (XYTimeSeriesData seriesData : datas) {
                if (seriesData.getValueX() != iStart) continue;
                isExists = true;
                seriesData.setValueY(doubleValue);
            }
            if (!isExists) {
                datas.add(new XYTimeSeriesData(iStart, Double.valueOf(doubleValue)));
            }
            iStart += (long)hisSimpleObject.getPeriod();
        }
        return maxValue;
    }

    private void setAdvanceAxisX(List<HisPerfStatHisObject> perStatObjs) {
        long firstTimePoint = -1L;
        long lastTimePoint = -1L;
        long time = 0L;
        for (HisPerfStatHisObject perfStatHisObject : perStatObjs) {
            if (firstTimePoint > perfStatHisObject.getStartTime() || firstTimePoint == -1L) {
                firstTimePoint = perfStatHisObject.getStartTime();
            }
            if (lastTimePoint >= (time = perfStatHisObject.getStartTime() + (long)(perfStatHisObject.getData().size() * perfStatHisObject.getPeriod()))) continue;
            lastTimePoint = time;
        }
        if (lastTimePoint - firstTimePoint > 172800000L) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("MM-dd HH:mm:ss");
            this.layout.getStatViewPanel().setDateAxisFormat((DateFormat)dateFormat);
        }
    }

    private void setNormalAxisX(List<HisPerfStatHisObject> perStatObjs) {
        long firstTimePoint = -1L;
        long lastTimePoint = -1L;
        long time = 0L;
        for (HisPerfStatHisObject perfStatHisObject : perStatObjs) {
            if (firstTimePoint > perfStatHisObject.getStartTime() || firstTimePoint == -1L) {
                firstTimePoint = perfStatHisObject.getStartTime();
            }
            if (lastTimePoint >= (time = perfStatHisObject.getStartTime() + (long)(perfStatHisObject.getData().size() * perfStatHisObject.getPeriod()))) continue;
            lastTimePoint = time;
        }
        if (lastTimePoint - firstTimePoint > 172800000L) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("MM-dd HH:mm:ss");
            this.layout.getNormalPerfStatPanel().setDateAxisFormat(dateFormat);
        }
    }

    private void calculateDatas(Collection<XYTimeSeriesData> datas, double scale) {
        for (XYTimeSeriesData timeSeriesData : datas) {
            double temp = timeSeriesData.getValueY() * scale;
            timeSeriesData.setValueY(temp);
        }
    }

    public static double calculateScale(double maxValue) {
        double rt = 1.0;
        if (maxValue <= 100.0) {
            return rt;
        }
        double result = 100.0 / maxValue;
        BigDecimal bd = new BigDecimal(result);
        for (int i = 1; i < Integer.MAX_VALUE; ++i) {
            if (bd.movePointRight(i).abs().compareTo(BigDecimal.valueOf(1L)) <= 0) continue;
            rt = BigDecimal.valueOf(rt).movePointLeft(i).doubleValue();
            break;
        }
        return rt;
    }

    private void addLegendRows(HisPerfStatObjectType.HisObjectTypeEnum objType, List<TableRow> objectTableRows, List<HisPerfStatObjectType.HisDataTypeEnum> dataTypes) {
        for (TableRow objectTableRow : objectTableRows) {
            for (HisPerfStatObjectType.HisDataTypeEnum dataType : dataTypes) {
                this.addOneLegend(objType, objectTableRow, dataType);
            }
        }
    }

    private void addOneLegend(HisPerfStatObjectType.HisObjectTypeEnum objType, TableRow objectTableRow, HisPerfStatObjectType.HisDataTypeEnum dataType) {
        String key = HisTools.generateStatItemKey(objType, objectTableRow.getValueAt(0).toString(), dataType);
        int index = this.layout.getTableMode().getRowIndex((Object)key);
        if (index == -1) {
            DefaultTableRow row = new DefaultTableRow(6, (Object)objType, (Object)key);
            IsmTableCell.ColorTableCell colorLabelCell = new IsmTableCell.ColorTableCell();
            colorLabelCell.setColor(this.colorContainer.getColor());
            IsmTableCell.ComboBoxCell cell = HisTools.createScaleTableCell();
            JComboBox comboBox = (JComboBox)cell.getEditor().getComponent();
            ChangeScaleListener changeScaleListener = new ChangeScaleListener(key);
            comboBox.addItemListener(changeScaleListener);
            Pair dataTypePair = new Pair((Object)new XVEDataTypeEnum(dataType), (Object)dataType.getDescription());
            row.setValueAt(0, colorLabelCell);
            row.setValueAt(1, objType.getDescription());
            row.setValueAt(2, objectTableRow.getValueAt(0).toString());
            row.setValueAt(3, cell);
            row.setValueAt(4, dataTypePair);
            row.setValueAt(5, dataType.getUnitDesc(CommonUtil.isXVEDevice()));
            this.layout.getTableMode().addRow(new TableRow[]{row});
        }
    }

    private void changeScale(JComboBox comboBox, String key) {
        Pair selectItem = (Pair)comboBox.getSelectedItem();
        double newScale = (Double)selectItem.getKey();
        TableRow row = this.layout.getTableMode().getTableRowBy((Object)key);
        if (row == null) {
            return;
        }
        IsmTableCell.ComboBoxCell cell = (IsmTableCell.ComboBoxCell)row.getValueAt(3);
        if (newScale != 0.0) {
            cell.setRendererItem(null);
        } else {
            newScale = this.optimizedScales.get(key);
            cell.setRendererItem((Object)(" (" + HisTools.convertScaleToString(newScale) + ')'));
        }
        TimeSeriesChart seriesChart = this.layout.getStatViewPanel();
        TimeSeries timeSeries = seriesChart.getOrCreate((Comparable)((Object)key));
        double currentScale = this.currentScales.get(key);
        HisTools.scaleTimeSeries(timeSeries, currentScale, newScale);
        this.currentScales.put(key, newScale);
        seriesChart.repaint();
    }

    private void setDesc() {
        String desc = HisResourceManager.getString("perfstat.history.desc.all");
        this.layout.setNormalDesc(desc);
        this.layout.setAdvanceDesc(desc);
    }

    private void clearNormalChart() {
        List list = this.layout.getNormalObjectsTree().getTickedTreeNodes();
        for (TickableTreeNode node : list) {
            node.setTicked(false);
        }
        this.layout.getNormalObjectsTree().releaseAllColor();
        this.layout.getNormalPerfStatPanel().removeAllChart();
        this.normalSelectedObjectSet.clear();
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
    }

    private class ChangeScaleListener
    implements ItemListener {
        private String key = null;

        public ChangeScaleListener(String key) {
            this.key = key;
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getID() == 701 && itemEvent.getStateChange() == 1) {
                JComboBox comboBox = (JComboBox)itemEvent.getSource();
                PerfStatHisDetailFrame.this.changeScale(comboBox, this.key);
            }
        }
    }
}

