/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.xve.monitor.perfstat;

import com.huawei.ism.common.resourcemanager.HisResourceManager;
import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.tool.base.utils.FilePathUtils;
import com.huawei.ism.ui.module.perfhis.pojo.HisPerfStatHisFileInfo;
import com.huawei.ism.ui.module.perfhis.service.PerfStatHisFileService;
import com.huawei.ism.ui.swing.IsmFileChooser;
import com.huawei.ism.ui.swing.dialog.DateChooserDialog;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.text.IsmTextField;
import com.huawei.ism.ui.templets.IsmDialog;
import com.huawei.ism.util.FormatUtil;
import com.huawei.ism.util.SwingUtil;
import com.huawei.ism.util.TimeUtil;
import com.huawei.ism.util.UCD;
import com.huawei.ism.util.Utils;
import com.huawei.xve.MainDialog;
import com.huawei.xve.monitor.perfstat.PerfStatHisOpenFileLayout;
import com.huawei.xve.monitor.perfstat.PerfStatHistoryPane;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.Callable;
import javax.swing.JDialog;
import org.apache.log4j.Logger;
import utils.FilesUtil;

public class PerfStatHisOpenFileDialog
extends IsmDialog {
    private static final Logger LOGGER = Logger.getLogger(PerfStatHisOpenFileDialog.class);
    private static final long serialVersionUID = 1L;
    private PerfStatHisOpenFileLayout layout;
    private DateChooserDialog dateChooser = new DateChooserDialog((JDialog)((Object)this), "");
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private transient HisPerfStatHisFileInfo perfStatHisFileInfo = null;
    private Object callback;
    private transient ActionListener browseButtonListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent arg0) {
            PerfStatHisOpenFileDialog.this.handleBrowse();
        }
    };

    public PerfStatHisOpenFileDialog(Window parent, Object callback) {
        super(parent, "", new IsmDialog.ECommonButton[]{IsmDialog.ECommonButton.Confirm, IsmDialog.ECommonButton.Cancel});
        this.callback = callback;
        this.doLayoutUI();
        this.addHandler();
        this.setTitle(HisResourceManager.getString("PER_HIS_11"));
        this.setPreferredSize(new Dimension(406, 340));
        this.getRootPane().setDefaultButton(this.getButtonBy(IsmDialog.ECommonButton.Confirm));
        this.beforeShow();
    }

    private void doLayoutUI() {
        this.layout = new PerfStatHisOpenFileLayout();
        this.layout.setBorder(UCD.createEmptyBorder());
        this.addContentPane(this.layout);
    }

    private void addHandler() {
        this.layout.getBrowseBtn().addActionListener(this.browseButtonListener);
        this.layout.getStartDrawTimeButton().addActionListener(this.createTimeSelectorListener(this.layout.getStartDrawTimeField()));
        this.layout.getEndDrawTimeButton().addActionListener(this.createTimeSelectorListener(this.layout.getEndDrawTimeField()));
    }

    private void handleBrowse() {
        String filterTGZ = "tgz";
        String filterBZ2 = "bz2";
        IsmFileChooser chooser = new IsmFileChooser(HisResourceManager.getString("PER_HIS_7"));
        chooser.setAcceptAllFileFilterUsed(false);
        chooser.addFileFilter(new String[]{filterTGZ}, HisResourceManager.getString("PER_HIS_13") + "(." + filterTGZ + ')');
        chooser.addFileFilter(new String[]{filterBZ2}, HisResourceManager.getString("PER_HIS_13") + "(." + filterBZ2 + ")");
        chooser.setFileFilter(chooser.getChoosableFileFilters()[0]);
        if (chooser.showOpenDialog((Component)((Object)this)) != 0) {
            return;
        }
        File file = chooser.getSelectedFile();
        File[] files = new File[]{file};
        PerfStatHisFileService.QueryPerfStatHisFileInfoTask task = new PerfStatHisFileService.QueryPerfStatHisFileInfoTask(files);
        AsyncExcutor.execute((Frame)((Object)MainDialog.getDialog()), (boolean)true, (long)0L, (Callable[])new Callable[]{task});
        if (!task.isExecuteSucess()) {
            Exception exception = task.getException();
            DialogUtils.showErrorDialog((Window)((Object)this), (Throwable)exception);
            return;
        }
        this.layout.getPathField().setText(FilesUtil.getCanonicalPath((File)file));
        List listFileInfo = (List)task.getExecuteResult();
        if (null != listFileInfo && !listFileInfo.isEmpty()) {
            this.perfStatHisFileInfo = (HisPerfStatHisFileInfo)listFileInfo.get(0);
        }
        TimeZone timeZone = TimeZone.getDefault();
        String startTime = TimeUtil.gmtToString((long)this.perfStatHisFileInfo.getStartTime(), (TimeZone)timeZone);
        String endTime = TimeUtil.gmtToString((long)this.perfStatHisFileInfo.getEndTime(), (TimeZone)timeZone);
        this.layout.getStartMonitorTimeValueLabel().setText(startTime);
        this.layout.getEndMonitorTimeValueLabel().setText(endTime);
        if (Utils.isNullStr((String)this.layout.getStartMonitorTimeValueLabel().getText()) || Utils.isNullStr((String)this.layout.getEndMonitorTimeValueLabel().getText())) {
            this.layout.getStartDrawTimeButton().setEnabled(false);
            this.layout.getEndDrawTimeButton().setEnabled(false);
            return;
        }
        this.layout.getStartDrawTimeButton().setEnabled(true);
        this.layout.getEndDrawTimeButton().setEnabled(true);
        this.layout.getStartDrawTimeField().setText(startTime);
        this.layout.getEndDrawTimeField().setText(endTime);
    }

    protected void doConfirmTask() {
        Date d2;
        File aFile = new File(FilePathUtils.checkFile((String)this.layout.getPathField().getText()));
        if (!aFile.exists()) {
            LOGGER.error((Object)"Add performance file failed.The file is not exist.");
            this.dispose();
            return;
        }
        PerfStatHistoryPane perfStatHistoryPane = (PerfStatHistoryPane)((Object)this.callback);
        Date d1 = TimeUtil.yYYYMMddmmssToDate2((String)this.layout.getStartDrawTimeField().getText());
        if (d1 != null) {
            long graphicStartTime = d1.getTime();
            this.perfStatHisFileInfo.setGraphicStartTime(graphicStartTime);
        }
        if ((d2 = TimeUtil.yYYYMMddmmssToDate2((String)this.layout.getEndDrawTimeField().getText())) != null) {
            long graphicEndTime = d2.getTime();
            this.perfStatHisFileInfo.setGraphicEndTime(graphicEndTime);
        }
        if (!this.isGraphicTimeValid(this.perfStatHisFileInfo)) {
            LOGGER.error((Object)("Add performance file failed." + HisResourceManager.getString("PER_HIS_18", Locale.ENGLISH)));
            DialogUtils.showErrorDialog((JDialog)((Object)this), (String)HisResourceManager.getString("PER_HIS_18"));
            return;
        }
        if (this.isFileConflict(this.perfStatHisFileInfo)) {
            LOGGER.error((Object)("Add performance " + aFile.getName() + " file failed." + HisResourceManager.getString("PER_HIS_26", Locale.ENGLISH)));
            DialogUtils.showErrorDialog((JDialog)((Object)this), (String)HisResourceManager.getString("PER_HIS_26"));
            return;
        }
        perfStatHistoryPane.addHistoryDataFileToTable(this.perfStatHisFileInfo);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)("Add performance  " + aFile.getName() + " file successfully."));
        }
        this.dispose();
    }

    private boolean isFileConflict(HisPerfStatHisFileInfo perfStatHisFile) {
        PerfStatHistoryPane perfStatHistoryPane = (PerfStatHistoryPane)((Object)this.callback);
        List<HisPerfStatHisFileInfo> allExistedPerfStatHisFileInfos = perfStatHistoryPane.getAddedPerfStatHisFiles();
        for (HisPerfStatHisFileInfo existedPerfStatHisFileInfo : allExistedPerfStatHisFileInfos) {
            if (!existedPerfStatHisFileInfo.getCompressedFileName().equals(perfStatHisFile.getCompressedFileName()) || existedPerfStatHisFileInfo.getGraphicStartTime() != perfStatHisFile.getGraphicStartTime() || existedPerfStatHisFileInfo.getGraphicEndTime() != perfStatHisFile.getGraphicEndTime()) continue;
            return true;
        }
        return false;
    }

    private boolean isGraphicTimeValid(HisPerfStatHisFileInfo perfStatHisFile) {
        return perfStatHisFile.getGraphicStartTime() >= perfStatHisFile.getStartTime() && perfStatHisFile.getGraphicEndTime() <= perfStatHisFile.getEndTime() && perfStatHisFile.getGraphicStartTime() <= perfStatHisFile.getGraphicEndTime();
    }

    private ActionListener createTimeSelectorListener(final IsmTextField textField) {
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String selectDate;
                String time = textField.getText();
                Date date = new Date();
                if (!"".equals(time)) {
                    try {
                        date = FormatUtil.parse(PerfStatHisOpenFileDialog.this.dateFormat, time);
                    }
                    catch (ParseException e1) {
                        DialogUtils.showErrorDialog((Window)((Object)PerfStatHisOpenFileDialog.this), (Throwable)e1);
                    }
                }
                PerfStatHisOpenFileDialog.this.dateChooser.setDate(date);
                PerfStatHisOpenFileDialog.this.dateChooser.setVisible(true);
                SwingUtil.putParentCenter((Window)PerfStatHisOpenFileDialog.this.dateChooser, (Window)((Object)PerfStatHisOpenFileDialog.this));
                TimeZone timeZone = TimeZone.getDefault();
                Date date2 = PerfStatHisOpenFileDialog.this.dateChooser.getDate();
                if (date2 != null && null != (selectDate = TimeUtil.gmtToString((Date)date2, (TimeZone)timeZone))) {
                    textField.setText(selectDate);
                }
            }
        };
        return listener;
    }

    protected String getHelpKey() {
        return "monitor_add_old_performance";
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
    }
}

