/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.xve.monitor.perfstat;

import com.huawei.ism.common.bean.HisPerfStatObjectType;
import com.huawei.ism.common.resourcemanager.HisResourceManager;
import com.huawei.ism.exception.IsmException;
import com.huawei.ism.thread.ThreadPoolManager;
import com.huawei.ism.ui.module.perfhis.HisTimeSeriesChart;
import com.huawei.ism.ui.module.perfhis.HisTools;
import com.huawei.ism.ui.module.perfhis.XYTimeSeriesData;
import com.huawei.ism.ui.module.perfhis.pojo.HisPerfStatHisFileInfo;
import com.huawei.ism.ui.module.perfhis.pojo.HisPerfStatHisObject;
import com.huawei.ism.ui.module.perfhis.proxy.HisPerfStatHisThresholdProxy;
import com.huawei.ism.ui.module.perfhis.service.PerfStatHisFileService;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.table.DefaultTableModel;
import com.huawei.ism.ui.swing.table.DefaultTableRow;
import com.huawei.ism.ui.swing.table.IsmTable;
import com.huawei.ism.ui.swing.table.IsmTableCell;
import com.huawei.ism.ui.swing.table.IsmTableCellRenderer;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.ism.ui.swing.table.TableScrollPane;
import com.huawei.ism.ui2.perfstat.AdvancePerfStatXYToolTipGenerator;
import com.huawei.ism.util.CommonUtil;
import com.huawei.ism.util.Pair;
import com.huawei.ism.util.SwingUtil;
import com.huawei.ism.util.UCD;
import com.huawei.xve.monitor.perfstat.PerfStatHisSurveyInfoDialog;
import com.huawei.xve.monitor.perfstat.PerfStatHisSurveyLayout;
import com.huawei.xve.monitor.perfstat.PerfStatHisThresholdSettingDialog;
import com.huawei.xve.monitor.perfstat.SetFrameOnTopThread;
import com.huawei.xve.utils.TableColumnNamesHolder;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseMotionAdapter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.jfree.chart.event.ChartProgressEvent;
import org.jfree.chart.event.ChartProgressListener;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.data.time.TimeSeries;

public class PerfStatHisSurveyFrame
extends JFrame {
    private static final long serialVersionUID = 1L;
    private static final int PERF_SUMMARY_GRAPHICS_ROW_HEIGHT = 100;
    private static final int DEFAULT_SHOW_COLUMNS_NUM = 6;
    private static final int MAX_SELECTED_ROWS_NUMBER = 32;
    private static final double AXIS_Y_LOWER_VALUE = -1.0E-6;
    private JLayeredPane layeredPane;
    private JPanel maskPanel = new JPanel();
    private transient HisPerfStatHisFileInfo perfStatHisFileInfo = null;
    private PerfStatHisSurveyLayout layout;
    private JLabel loadingLabel;

    public PerfStatHisSurveyFrame(HisPerfStatHisFileInfo perfStatHisFileInfo) {
        this.perfStatHisFileInfo = perfStatHisFileInfo;
        String subName = ' ' + HisTools.getFormatName(this.perfStatHisFileInfo);
        this.setTitle(HisResourceManager.getString("PER_HIS_5") + subName);
        this.setIconImage(HisResourceManager.getImage("performance.png").getImage());
        this.doLayoutUI();
        this.addHandler();
        this.initData();
        this.setMinimumSize(new Dimension(1000, 677));
        this.setPreferredSize(new Dimension(1000, 677));
        SwingUtil.setCloseWhenEscKeyPressed((JFrame)this);
    }

    private void doLayoutUI() {
        this.loadingLabel = new JLabel(HisResourceManager.getImage("loading_center.gif"));
        UCD.setJComponentSize((JComponent)this.loadingLabel, (int)240, (int)240);
        this.layout = new PerfStatHisSurveyLayout();
        this.setLayout(new BorderLayout());
        this.layeredPane = new JLayeredPane();
        this.layeredPane.setOpaque(false);
        this.layeredPane.add((Component)this.layout, (Object)200);
        this.layout.setBounds(0, 0, 1000, 647);
        this.maskPanel.setOpaque(false);
        this.maskPanel.setBounds(0, 0, 1000, 677);
        this.add(this.layeredPane);
    }

    private void addHandler() {
        this.layout.getObjectTypeComboBox().addItemListener(this.createObjectTypeComboBoxListener());
        this.layout.getObjectListTable().addListSelectionListener(this.createobjectListTableListener());
        this.layout.getThresholdSettingButton().addActionListener(this.createThresholdSettingButtonListener());
        this.layout.getViewButton().addActionListener(this.createViewButtonListener());
        this.layout.getCloseButton().addActionListener(this.createCloseButtonListener());
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                PerfStatHisSurveyFrame.this.layout.setBounds(0, 0, e.getComponent().getBounds().width, e.getComponent().getBounds().height - 30);
                PerfStatHisSurveyFrame.this.maskPanel.setBounds(0, 0, e.getComponent().getBounds().width, e.getComponent().getBounds().height - 30);
                PerfStatHisSurveyFrame.this.layout.revalidate();
                PerfStatHisSurveyFrame.this.layout.repaint();
            }
        });
        this.maskPanel.addMouseListener(new MouseAdapter(){});
        this.maskPanel.addKeyListener(new KeyAdapter(){});
        this.maskPanel.addMouseMotionListener(new MouseMotionAdapter(){});
    }

    private ItemListener createObjectTypeComboBoxListener() {
        ItemListener listener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent arg0) {
                PerfStatHisSurveyFrame.this.handleObjectTypeChanged();
            }
        };
        return listener;
    }

    private ListSelectionListener createobjectListTableListener() {
        ListSelectionListener listener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                PerfStatHisSurveyFrame.this.layout.getViewButton().setEnabled(!PerfStatHisSurveyFrame.this.layout.getSelectedObjectNames().isEmpty());
            }
        };
        return listener;
    }

    private ActionListener createThresholdSettingButtonListener() {
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PerfStatHisThresholdSettingDialog perfStatHisThresholdSettingDialog = new PerfStatHisThresholdSettingDialog(PerfStatHisSurveyFrame.this);
                SwingUtil.putParentCenter((Window)((Object)perfStatHisThresholdSettingDialog), (Window)PerfStatHisSurveyFrame.this);
                perfStatHisThresholdSettingDialog.setModal(false);
                perfStatHisThresholdSettingDialog.setVisible(true);
                PerfStatHisSurveyFrame.this.setMask(true);
            }
        };
        return listener;
    }

    public void setMask(boolean isShowMask) {
        if (isShowMask) {
            this.layeredPane.add((Component)this.maskPanel, (Object)2000);
            this.maskPanel.requestFocusInWindow();
        } else {
            this.layeredPane.remove(this.maskPanel);
        }
        this.layeredPane.validate();
        this.layeredPane.repaint();
    }

    private ActionListener createViewButtonListener() {
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PerfStatHisSurveyFrame.this.handleApplybutton();
            }
        };
        return listener;
    }

    private ActionListener createCloseButtonListener() {
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PerfStatHisSurveyFrame.this.dispose();
            }
        };
        return listener;
    }

    private void initData() {
        this.layout.setDeviceName(this.getDeviceName());
        this.layout.setSampleInterval(String.valueOf(this.perfStatHisFileInfo.getPeriod() / 1000));
        List<HisPerfStatObjectType.HisObjectTypeEnum> objectTypes = this.perfStatHisFileInfo.getObjectTypes();
        ArrayList<Pair<HisPerfStatObjectType.HisObjectTypeEnum, String>> objectTypePairs = new ArrayList<Pair<HisPerfStatObjectType.HisObjectTypeEnum, String>>(0);
        Pair pair = null;
        for (HisPerfStatObjectType.HisObjectTypeEnum objectType : objectTypes) {
            pair = new Pair((Object)objectType, (Object)objectType.getDescription());
            if ("--".equals(objectType.getDescription())) continue;
            objectTypePairs.add((Pair<HisPerfStatObjectType.HisObjectTypeEnum, String>)pair);
        }
        this.layout.setObjectTypes(objectTypePairs);
        this.layout.getViewButton().setEnabled(false);
    }

    private void handleObjectTypeChanged() {
        HisPerfStatObjectType.HisObjectTypeEnum objectType = this.layout.getSelectedObjectType();
        Map<HisPerfStatObjectType.HisObjectTypeEnum, List<String>> objectTypeToNamesMapping = this.perfStatHisFileInfo.getObjectTypeToNamesMapping();
        List<String> names = objectTypeToNamesMapping.get((Object)objectType);
        ArrayList<TableRow> rows = new ArrayList<TableRow>(0);
        DefaultTableRow row = null;
        for (String name : names) {
            if ("Default Group".equals(name)) {
                name = HisResourceManager.getString("DefaultGroup");
            }
            row = new DefaultTableRow(TableColumnNamesHolder.getObjectAndDataTypeNameTableColNames().length, (Object)name, (Object)name);
            row.setValueAt(0, name);
            rows.add((TableRow)row);
        }
        this.layout.setObjectNames(rows);
    }

    private void handleApplybutton() {
        List<String> selectedNames = this.layout.getSelectedObjectNames();
        if (selectedNames.size() > 32) {
            DialogUtils.showErrorDialog((Window)this, (String)MessageFormat.format(HisResourceManager.getString("WARNING_TOO_MANY_OBJECTS"), 32));
            return;
        }
        this.drawGraphics();
    }

    private void loading() {
        this.layout.updateDataGraphics(this.loadingLabel);
    }

    private void drawGraphics() {
        Runnable command = new Runnable(){

            @Override
            public void run() {
                PerfStatHisSurveyFrame.this.loading();
                PerfStatHisSurveyFrame.this.handleViewData();
            }
        };
        ThreadPoolManager.getInstance().execute(command);
    }

    private void handleViewData() {
        HisPerfStatObjectType.HisObjectTypeEnum selectedObjectType = this.layout.getSelectedObjectType();
        List<String> statObjNames = this.layout.getSelectedObjectNames();
        try {
            List<HisPerfStatHisObject> perfStatHisObjects = PerfStatHisFileService.queryPerfStatHisObject(this.perfStatHisFileInfo, selectedObjectType, statObjNames, 150L);
            Map<String, List<Component>> showComps = this.handlefrshGraphic(perfStatHisObjects);
            if (!perfStatHisObjects.isEmpty() && showComps != null) {
                this.layout.updateDataGraphics(this.createDataDisplayPanel(showComps, perfStatHisObjects.get(0).getDataTypes()));
            }
        }
        catch (IsmException e) {
            DialogUtils.showErrorDialog((Frame)this, (Throwable)e);
            return;
        }
    }

    private JPanel createDataDisplayPanel(Map<String, List<Component>> showComps, List<HisPerfStatObjectType.HisDataTypeEnum> inDataTypeList) {
        String[] dataTypes = this.convertDataTypeEnumListToArray(inDataTypeList);
        HisPerfStatObjectType.HisObjectTypeEnum objType = this.layout.getSelectedObjectType();
        List<Integer> thresholds = this.getThresholds(objType, inDataTypeList);
        String[] headers = new String[dataTypes.length + 1];
        headers[0] = HisResourceManager.getString("PERFORMANCE_STATISTIC_OBJECT_PANEL_OBJECT");
        Object thresholdString = null;
        this.setHeadersArr(dataTypes, thresholds, headers);
        LinkedList<DefaultTableRow> showRows = new LinkedList<DefaultTableRow>();
        Iterator<Map.Entry<String, List<Component>>> it = showComps.entrySet().iterator();
        Map.Entry<String, List<Component>> entry = null;
        String objectName = null;
        SortLabel objectNameLabel = null;
        List<Component> oneRowComponent = null;
        DefaultTableRow row = null;
        while (it.hasNext()) {
            entry = it.next();
            objectName = entry.getKey();
            objectNameLabel = new SortLabel(objectName);
            if ("Default Group".equals(objectName)) {
                objectNameLabel.setText(HisResourceManager.getString("DefaultGroup"));
            }
            objectNameLabel.setHorizontalAlignment(0);
            oneRowComponent = entry.getValue();
            row = new DefaultTableRow(oneRowComponent.size() + 1, oneRowComponent, (Object)objectName);
            row.setValueAt(0, (Object)new ComponentTableCell(objectNameLabel));
            for (int i = 0; i < oneRowComponent.size(); ++i) {
                row.setValueAt(i + 1, (Object)new ComponentTableCell(oneRowComponent.get(i), new ClickGraphicActionListener()));
            }
            showRows.add(row);
        }
        DefaultTableModel graphicsDisplayTableModel = new DefaultTableModel(headers, new int[0]);
        graphicsDisplayTableModel.setTableData(showRows);
        int showColumnsNum = headers.length < 6 ? headers.length : 6;
        int[] defaultShowColumnsIDArray = new int[showColumnsNum];
        for (int i = 0; i < showColumnsNum; ++i) {
            defaultShowColumnsIDArray[i] = i;
        }
        graphicsDisplayTableModel.setVisibleColumns(defaultShowColumnsIDArray);
        IsmTable graphicsDisplayTable = new IsmTable((TableModel)graphicsDisplayTableModel);
        graphicsDisplayTable.setRowHeight(100);
        graphicsDisplayTable.getRowSorter().toggleSortOrder(0);
        TableScrollPane graphicsDisplayScrollPane = TableScrollPane.createTablePane((IsmTable)graphicsDisplayTable, (boolean)false, (TableScrollPane.CountArea)TableScrollPane.CountArea.NONE, (TableScrollPane.FilterArea)TableScrollPane.FilterArea.NONE, (TableScrollPane.ButtonArea)TableScrollPane.ButtonArea.NONE);
        return graphicsDisplayScrollPane;
    }

    private void setHeadersArr(String[] dataTypes, List<Integer> thresholds, String[] headers) {
        for (int i = 0; i < dataTypes.length; ++i) {
            String thresholdString = thresholds.get(i) == null ? HisResourceManager.getString("perf.threshold.ui.noThreshold") : HisResourceManager.getString("perf.threshold.ui.threshold") + ":" + thresholds.get(i);
            headers[i + 1] = dataTypes[i] + "  " + thresholdString;
        }
    }

    private String[] convertDataTypeEnumListToArray(List<HisPerfStatObjectType.HisDataTypeEnum> dataTypeList) {
        LinkedList<String> dataTypeStringList = new LinkedList<String>();
        String title = null;
        int index = 0;
        for (HisPerfStatObjectType.HisDataTypeEnum dataType : dataTypeList) {
            title = dataType.getDescription() + " (" + dataType.getUnitDesc(CommonUtil.isXVEDevice()) + ')';
            if (title.endsWith("()") && (index = title.lastIndexOf("()")) != -1) {
                title = title.substring(0, index);
            }
            dataTypeStringList.add(title);
        }
        String[] dataTypeStringArray = new String[dataTypeStringList.size()];
        return dataTypeStringList.toArray(dataTypeStringArray);
    }

    private List<Integer> getThresholds(HisPerfStatObjectType.HisObjectTypeEnum objType, List<HisPerfStatObjectType.HisDataTypeEnum> inDataTypeList) {
        if (objType == null || inDataTypeList == null) {
            return new LinkedList<Integer>();
        }
        LinkedList<Integer> thresholds = new LinkedList<Integer>();
        for (HisPerfStatObjectType.HisDataTypeEnum dataType : inDataTypeList) {
            thresholds.add(HisPerfStatHisThresholdProxy.findByObjectTypeAndDataType(objType, dataType));
        }
        return thresholds;
    }

    private Integer findThreshold(List<Integer> thresholds, int index) {
        if (thresholds == null || index < 0 || index >= thresholds.size()) {
            return null;
        }
        return thresholds.get(index);
    }

    private Map<String, List<Component>> handlefrshGraphic(List<HisPerfStatHisObject> perStatObjs) {
        if (null == perStatObjs || perStatObjs.isEmpty()) {
            return null;
        }
        Map<String, List<Collection<XYTimeSeriesData>>> dataMaps = this.initSeriesDatasMap(perStatObjs);
        Map<String, List<Collection<XYTimeSeriesData>>> thresholdDataMaps = this.initSeriesDatasMap(perStatObjs);
        Map<String, List<Integer>> exceedThresholdCountMaps = this.initIntegersMap(perStatObjs);
        Map<String, List<Double>> maxValueMaps = this.initDoublesMap(perStatObjs);
        for (HisPerfStatHisObject hisSimpleObject : perStatObjs) {
            this.populateMaps(hisSimpleObject, dataMaps, thresholdDataMaps, exceedThresholdCountMaps, maxValueMaps);
        }
        HisPerfStatObjectType.HisObjectTypeEnum objectType = perStatObjs.get(0).getObjectType();
        List<HisPerfStatObjectType.HisDataTypeEnum> dataTypes = perStatObjs.get(0).getDataTypes();
        return this.createShowComps(dataMaps, thresholdDataMaps, exceedThresholdCountMaps, maxValueMaps, objectType, dataTypes);
    }

    private Map<String, List<Collection<XYTimeSeriesData>>> initSeriesDatasMap(List<HisPerfStatHisObject> perfStatHisObjects) {
        LinkedHashMap<String, List<Collection<XYTimeSeriesData>>> maps = new LinkedHashMap<String, List<Collection<XYTimeSeriesData>>>();
        String objectName = null;
        List<HisPerfStatObjectType.HisDataTypeEnum> dataTypes = null;
        ArrayList list = null;
        for (HisPerfStatHisObject perfStatHisObject : perfStatHisObjects) {
            objectName = perfStatHisObject.getName();
            dataTypes = perfStatHisObject.getDataTypes();
            if (maps.get(objectName) != null) continue;
            list = new ArrayList(0);
            maps.put(objectName, list);
            for (int i = 0; i < dataTypes.size(); ++i) {
                ((List)maps.get(objectName)).add(new ArrayList(0));
            }
        }
        return maps;
    }

    private Map<String, List<Integer>> initIntegersMap(List<HisPerfStatHisObject> perfStatHisObjects) {
        LinkedHashMap<String, List<Integer>> maps = new LinkedHashMap<String, List<Integer>>();
        String objectName = null;
        List<HisPerfStatObjectType.HisDataTypeEnum> dataTypes = null;
        ArrayList list = null;
        for (HisPerfStatHisObject perfStatHisObject : perfStatHisObjects) {
            objectName = perfStatHisObject.getName();
            dataTypes = perfStatHisObject.getDataTypes();
            if (maps.get(objectName) != null) continue;
            list = new ArrayList(0);
            maps.put(objectName, list);
            for (int i = 0; i < dataTypes.size(); ++i) {
                ((List)maps.get(objectName)).add(0);
            }
        }
        return maps;
    }

    private Map<String, List<Double>> initDoublesMap(List<HisPerfStatHisObject> perfStatHisObjects) {
        LinkedHashMap<String, List<Double>> maps = new LinkedHashMap<String, List<Double>>();
        String objectName = null;
        List<HisPerfStatObjectType.HisDataTypeEnum> dataTypes = null;
        ArrayList list = null;
        for (HisPerfStatHisObject perfStatHisObject : perfStatHisObjects) {
            objectName = perfStatHisObject.getName();
            dataTypes = perfStatHisObject.getDataTypes();
            if (maps.get(objectName) != null) continue;
            list = new ArrayList(0);
            maps.put(objectName, list);
            for (int i = 0; i < dataTypes.size(); ++i) {
                ((List)maps.get(objectName)).add(0.0);
            }
        }
        return maps;
    }

    private void populateMaps(HisPerfStatHisObject perfStatHisObject, Map<String, List<Collection<XYTimeSeriesData>>> dataMaps, Map<String, List<Collection<XYTimeSeriesData>>> thresholdDataMaps, Map<String, List<Integer>> exceedThresholdCountMaps, Map<String, List<Double>> maxValueMaps) {
        HisPerfStatObjectType.HisObjectTypeEnum objType = perfStatHisObject.getObjectType();
        String objectName = perfStatHisObject.getName();
        List<int[]> datas = perfStatHisObject.getData();
        List<HisPerfStatObjectType.HisDataTypeEnum> dataTypes = perfStatHisObject.getDataTypes();
        long iTimePoint = perfStatHisObject.getStartTime();
        int period = perfStatHisObject.getPeriod();
        List<Integer> thresholds = this.getThresholds(objType, dataTypes);
        HisPerfStatObjectType.HisDataTypeEnum dataType = null;
        XYTimeSeriesData data = null;
        Integer threshold = null;
        XYTimeSeriesData thresholdData = null;
        Double maxValue = null;
        Integer exceedThresholdCount = null;
        for (int[] values : datas) {
            int value = 0;
            for (int i = 0; i < dataTypes.size(); ++i) {
                value = values[i];
                if (value == 0xFFFFFF) continue;
                dataType = dataTypes.get(i);
                double doubleValue = this.getDoubleValue(dataType, value);
                data = new XYTimeSeriesData(iTimePoint, Double.valueOf(doubleValue));
                dataMaps.get(objectName).get(i).add(data);
                threshold = this.findThreshold(thresholds, i);
                if (threshold != null) {
                    thresholdData = new XYTimeSeriesData(iTimePoint, Double.valueOf(threshold.intValue()));
                    thresholdDataMaps.get(objectName).get(i).add(thresholdData);
                }
                maxValue = doubleValue > maxValueMaps.get(objectName).get(i) ? Double.valueOf(doubleValue) : maxValueMaps.get(objectName).get(i);
                maxValueMaps.get(objectName).remove(i);
                maxValueMaps.get(objectName).add(i, maxValue);
                if (threshold == null || !(doubleValue > (double)threshold.intValue())) continue;
                Integer n = exceedThresholdCount = exceedThresholdCountMaps.get(objectName).get(i);
                Integer n2 = exceedThresholdCount = Integer.valueOf(exceedThresholdCount + 1);
                exceedThresholdCountMaps.get(objectName).remove(i);
                exceedThresholdCountMaps.get(objectName).add(i, exceedThresholdCount);
            }
            iTimePoint += (long)period;
        }
    }

    private double getDoubleValue(HisPerfStatObjectType.HisDataTypeEnum dataType, int value) {
        double doubleValue = value;
        if (this.checkDataType(dataType)) {
            doubleValue /= 1024.0;
        }
        return doubleValue;
    }

    private boolean checkDataType(HisPerfStatObjectType.HisDataTypeEnum dataType) {
        return dataType.equals((Object)HisPerfStatObjectType.HisDataTypeEnum.AVERAGE_READ_IO) || dataType.equals((Object)HisPerfStatObjectType.HisDataTypeEnum.AVERAGE_WRITE_IO) || dataType.equals((Object)HisPerfStatObjectType.HisDataTypeEnum.AVERAGE_IO_SIZE);
    }

    private Map<String, List<Component>> createShowComps(Map<String, List<Collection<XYTimeSeriesData>>> dataMaps, Map<String, List<Collection<XYTimeSeriesData>>> thresholdDataMaps, Map<String, List<Integer>> exceedThresholdCountMaps, Map<String, List<Double>> maxValueMaps, HisPerfStatObjectType.HisObjectTypeEnum objectType, List<HisPerfStatObjectType.HisDataTypeEnum> dataTypes) {
        HashMap<String, List<Component>> showComps = new HashMap<String, List<Component>>(0);
        Iterator<Map.Entry<String, List<Collection<XYTimeSeriesData>>>> it = dataMaps.entrySet().iterator();
        Map.Entry<String, List<Collection<XYTimeSeriesData>>> entry = null;
        String objectName = null;
        List<Collection<XYTimeSeriesData>> datas = null;
        List<Collection<XYTimeSeriesData>> thresholdDatas = null;
        List<Integer> exceedThresholdCounts = null;
        List<Double> maxValues = null;
        List<Component> oneRowComponent = null;
        while (it.hasNext()) {
            entry = it.next();
            objectName = entry.getKey();
            datas = entry.getValue();
            thresholdDatas = thresholdDataMaps.get(objectName);
            exceedThresholdCounts = exceedThresholdCountMaps.get(objectName);
            maxValues = maxValueMaps.get(objectName);
            oneRowComponent = this.createOneRowComponents(objectName, datas, thresholdDatas, exceedThresholdCounts, maxValues, objectType, dataTypes);
            showComps.put(objectName, oneRowComponent);
        }
        return showComps;
    }

    private List<Component> createOneRowComponents(String objectName, List<Collection<XYTimeSeriesData>> datas, List<Collection<XYTimeSeriesData>> thresholdDatas, List<Integer> exceedThresholdCounts, List<Double> maxValues, HisPerfStatObjectType.HisObjectTypeEnum objectType, List<HisPerfStatObjectType.HisDataTypeEnum> dataTypes) {
        ArrayList<Component> oneRowComponent = new ArrayList<Component>(0);
        Collection<XYTimeSeriesData> data = null;
        Collection<XYTimeSeriesData> thresholdData = null;
        Integer exceedThresholdCount = null;
        Double maxValue = null;
        PerfStatChartPanel tmpPanel = null;
        for (int i = 0; i < datas.size(); ++i) {
            data = datas.get(i);
            thresholdData = thresholdDatas.get(i);
            exceedThresholdCount = exceedThresholdCounts.get(i);
            maxValue = maxValues.get(i);
            tmpPanel = this.createComponent(objectName, data, thresholdData, exceedThresholdCount, maxValue, objectType, dataTypes.get(i));
            oneRowComponent.add(tmpPanel);
        }
        return oneRowComponent;
    }

    private PerfStatChartPanel createComponent(String objectName, Collection<XYTimeSeriesData> data, Collection<XYTimeSeriesData> thresholdData, Integer exceedThresholdCount, Double maxValue, HisPerfStatObjectType.HisObjectTypeEnum objectType, HisPerfStatObjectType.HisDataTypeEnum dataType) {
        HisTimeSeriesChart chart = new HisTimeSeriesChart(HisTimeSeriesChart.initBoolParam(false, false, false, false), false, false, false, false);
        chart.getAxisX().setVisible(false);
        chart.getAxisY().setVisible(false);
        chart.addOrUpdateData(objectName, data);
        if (exceedThresholdCount > 0) {
            chart.addOrUpdateData(HisResourceManager.getString("perf.threshold.ui.threshold"), thresholdData);
            chart.setSeriesColor(1, Color.RED);
        }
        chart.setToolTipGenerator((XYToolTipGenerator)this.generateToolTipGenerator(chart, objectName, objectType, dataType));
        PerfStatChartPanel perfStatChartPanel = new PerfStatChartPanel(chart, exceedThresholdCount, maxValue);
        return perfStatChartPanel;
    }

    private AdvancePerfStatXYToolTipGenerator generateToolTipGenerator(HisTimeSeriesChart chart, String objectName, HisPerfStatObjectType.HisObjectTypeEnum objectType, HisPerfStatObjectType.HisDataTypeEnum dataType) {
        String key = objectName;
        DefaultTableModel tableMode = new DefaultTableModel(null, new int[0]);
        DefaultTableRow row = new DefaultTableRow(6, null, (Object)key);
        row.setValueAt(1, objectType.getDescription());
        row.setValueAt(2, objectName);
        row.setValueAt(4, dataType.getDescription());
        row.setValueAt(5, dataType.getUnitDesc(CommonUtil.isXVEDevice()));
        tableMode.addRow(new TableRow[]{row});
        DefaultTableRow thresholdRow = new DefaultTableRow(6, null, (Object)HisResourceManager.getString("perf.threshold.ui.threshold"));
        thresholdRow.setValueAt(1, objectType.getDescription());
        thresholdRow.setValueAt(2, objectName);
        thresholdRow.setValueAt(4, dataType.getDescription());
        thresholdRow.setValueAt(5, dataType.getUnitDesc(CommonUtil.isXVEDevice()));
        tableMode.addRow(new TableRow[]{thresholdRow});
        HashMap<String, Double> currentScales = new HashMap<String, Double>(0);
        currentScales.put(objectName, 1.0);
        currentScales.put(HisResourceManager.getString("perf.threshold.ui.threshold"), 1.0);
        AdvancePerfStatXYToolTipGenerator generator = new AdvancePerfStatXYToolTipGenerator(HisTools.generateDateFormat(chart.getTimeZone()), NumberFormat.getInstance(), tableMode, currentScales);
        return generator;
    }

    private String getDeviceName() {
        String deviceName = this.perfStatHisFileInfo.getDeviceName();
        return deviceName;
    }

    static class SortLabel
    extends JLabel
    implements Comparable<Object> {
        private static final long serialVersionUID = 243376708947346888L;

        public SortLabel(String text) {
            super(text);
            this.setBorder(UCD.createEtchedBorder());
        }

        @Override
        public int compareTo(Object object) {
            if (!(object instanceof SortLabel)) {
                return -1;
            }
            SortLabel other = (SortLabel)object;
            String thisText = this.getText();
            String otherText = other.getText();
            return thisText.compareTo(otherText);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof SortLabel)) {
                return false;
            }
            return this.compareTo(obj) == 0;
        }

        public int hashCode() {
            return this.getText().hashCode();
        }
    }

    static class PerfStatChartPanel
    extends JPanel
    implements Comparable {
        private static final long serialVersionUID = 1L;
        private HisTimeSeriesChart timeSeriesChart;
        private int exceedThresholdCount = 0;
        private double maxValue = 0.0;

        public PerfStatChartPanel(HisTimeSeriesChart timeSeriesChart) {
            this.timeSeriesChart = timeSeriesChart;
            this.doLayoutPanel();
        }

        public PerfStatChartPanel(HisTimeSeriesChart timeSeriesChart, int exceedThresholdCount, double maxValue) {
            this(timeSeriesChart);
            this.exceedThresholdCount = exceedThresholdCount;
            this.maxValue = maxValue;
        }

        public PerfStatChartPanel() {
            this(new HisTimeSeriesChart(HisTimeSeriesChart.initBoolParam(false, false, false, false), true, false, false, false));
            this.setVisible(false);
        }

        private void doLayoutPanel() {
            this.timeSeriesChart.setBorder(new CompoundBorder(new EtchedBorder(), new EmptyBorder(1, 1, 1, 1)));
            this.setLayout(new BorderLayout());
            this.add((Component)((Object)this.timeSeriesChart), "Center");
        }

        public int compareTo(Object object) {
            if (!(object instanceof PerfStatChartPanel)) {
                return 1;
            }
            PerfStatChartPanel other = (PerfStatChartPanel)object;
            if (this.exceedThresholdCount != other.exceedThresholdCount) {
                return this.exceedThresholdCount - other.exceedThresholdCount;
            }
            double doubleApproach2Zero = 1.0E-4;
            if (Math.abs(this.maxValue - other.maxValue) < 1.0E-4) {
                return 0;
            }
            if (this.maxValue > other.maxValue) {
                return 1;
            }
            return -1;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof PerfStatChartPanel)) {
                return false;
            }
            return this.compareTo(obj) == 0;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.exceedThresholdCount;
            long temp = Double.doubleToLongBits(this.maxValue);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            return result;
        }

        public int getExceedThresholdCount() {
            return this.exceedThresholdCount;
        }

        public void setExceedThresholdCount(int exceedThresholdCount) {
            this.exceedThresholdCount = exceedThresholdCount;
        }

        public double getMaxValue() {
            return this.maxValue;
        }

        public void setMaxValue(double maxValue) {
            this.maxValue = maxValue;
        }

        public HisTimeSeriesChart getHisTimeSeriesChart() {
            return this.timeSeriesChart;
        }

        public void setHisTimeSeriesChart(HisTimeSeriesChart hisTimeSeriesChart) {
            this.timeSeriesChart = hisTimeSeriesChart;
        }
    }

    private class ClickGraphicActionListener
    implements ActionListener {
        private ClickGraphicActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            IsmTable ismTable = (IsmTable)e.getSource();
            ComponentTableCell componentTableCell = this.getSelectedComponentTableCell(ismTable);
            if (componentTableCell == null || componentTableCell.showComponent == null) {
                return;
            }
            String dataType = this.getDataType(ismTable);
            PerfStatChartPanel perfStatChartPanel = (PerfStatChartPanel)componentTableCell.showComponent;
            List<TimeSeries> timeSeriesList = this.getAllSeries(perfStatChartPanel);
            HisTimeSeriesChart timeSeriesChart = new HisTimeSeriesChart(HisTimeSeriesChart.initBoolParam(false, true, false, false), true, true, true, true);
            timeSeriesChart.setToolTipGenerator(this.getToolTipGenerator(perfStatChartPanel));
            timeSeriesChart.setAxisYTitle(dataType);
            if (null == timeSeriesList || timeSeriesList.isEmpty()) {
                return;
            }
            TimeSeries timeSeries = timeSeriesList.get(0);
            this.conditonForTimeSeries(timeSeriesChart, timeSeries);
            timeSeriesChart.addAllTimeSeries(timeSeriesList);
            if (timeSeriesList.size() == 2) {
                timeSeriesChart.setSeriesColor(1, Color.RED);
            }
            this.conditionForChar(timeSeriesChart);
            PerfStatHisSurveyInfoDialog perfStatHisSurveyInfoDialog = new PerfStatHisSurveyInfoDialog(PerfStatHisSurveyFrame.this, timeSeriesChart);
            SwingUtil.putParentCenter((Window)((Object)perfStatHisSurveyInfoDialog), (Window)PerfStatHisSurveyFrame.this);
            perfStatHisSurveyInfoDialog.setModal(false);
            SetFrameOnTopThread frameOnTopThread = new SetFrameOnTopThread(PerfStatHisSurveyFrame.this);
            ThreadPoolManager.getInstance().execute((Runnable)frameOnTopThread);
            perfStatHisSurveyInfoDialog.setVisible(true);
            PerfStatHisSurveyFrame.this.setMask(true);
        }

        private void conditionForChar(final HisTimeSeriesChart timeSeriesChart) {
            timeSeriesChart.getChart().addProgressListener(new ChartProgressListener(){

                public void chartProgress(ChartProgressEvent e) {
                    double lower = timeSeriesChart.getAxisY().getRange().getLowerBound();
                    if (lower == 0.0) {
                        timeSeriesChart.getAxisY().setLowerBound(-1.0E-6);
                    }
                }
            });
        }

        private void conditonForTimeSeries(HisTimeSeriesChart timeSeriesChart, TimeSeries timeSeries) {
            if (timeSeries.getItemCount() > 0) {
                long startTime = timeSeries.getDataItem(0).getPeriod().getFirstMillisecond();
                long endTime = timeSeries.getDataItem(timeSeries.getItemCount() - 1).getPeriod().getLastMillisecond();
                if (endTime - startTime > 172800000L) {
                    SimpleDateFormat dateFormat = new SimpleDateFormat("MM-dd HH:mm:ss");
                    timeSeriesChart.setDateAxisFormat(dateFormat);
                }
            }
        }

        private ComponentTableCell getSelectedComponentTableCell(IsmTable ismTable) {
            Object selectedObject = ismTable.getValueAt(ismTable.getCurRolloverRow(), ismTable.getCurRolloverColumn());
            if (!(selectedObject instanceof ComponentTableCell)) {
                return null;
            }
            return (ComponentTableCell)((Object)selectedObject);
        }

        private String getDataType(IsmTable ismTable) {
            if (ismTable == null) {
                return null;
            }
            return ismTable.getColumnName(ismTable.getCurRolloverColumn());
        }

        private List<TimeSeries> getAllSeries(PerfStatChartPanel perfStatChartPanel) {
            if (perfStatChartPanel == null || perfStatChartPanel.getHisTimeSeriesChart() == null) {
                return new ArrayList<TimeSeries>(0);
            }
            HisTimeSeriesChart chart = perfStatChartPanel.getHisTimeSeriesChart();
            return chart.getAllSeries();
        }

        private XYToolTipGenerator getToolTipGenerator(PerfStatChartPanel perfStatChartPanel) {
            if (perfStatChartPanel == null || perfStatChartPanel.getHisTimeSeriesChart() == null) {
                return null;
            }
            HisTimeSeriesChart chart = perfStatChartPanel.getHisTimeSeriesChart();
            return chart.getToolTipGenerator();
        }
    }

    private static class ComponentTableCell
    extends IsmTableCell {
        private static final long serialVersionUID = -6438876085984576667L;
        private static ComponentCellRender render = new ComponentCellRender();
        private Component showComponent;
        private transient ActionListener action = null;

        public ComponentTableCell(Component tableCellComp) {
            this.showComponent = tableCellComp;
        }

        public ComponentTableCell(Component tableCellComp, ActionListener actionListener) {
            this.showComponent = tableCellComp;
            this.action = actionListener;
        }

        public TableCellRenderer getRender() {
            return render;
        }

        public void setAction(ActionListener actionTemp) {
            this.action = actionTemp;
        }

        public ActionListener getAction() {
            return this.action;
        }

        public String toString() {
            return "";
        }

        public int compareTo(IsmTableCell ismTableCell) {
            if (!(ismTableCell instanceof ComponentTableCell)) {
                return 1;
            }
            ComponentTableCell other = (ComponentTableCell)ismTableCell;
            if (!(this.showComponent instanceof Comparable)) {
                return -1;
            }
            Comparable thisComponent = (Comparable)((Object)this.showComponent);
            return thisComponent.compareTo(other.showComponent);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof IsmTableCell)) {
                return false;
            }
            return this.compareTo((IsmTableCell)obj) == 0;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.showComponent == null ? 0 : this.showComponent.hashCode());
            return result;
        }

        private void writeObject(ObjectOutputStream stream) throws IOException {
            stream.defaultWriteObject();
        }

        private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
            stream.defaultReadObject();
        }

        private static class ComponentCellRender
        extends IsmTableCellRenderer {
            private static final long serialVersionUID = 6339619108224617424L;

            private ComponentCellRender() {
            }

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                if (!(value instanceof ComponentTableCell)) {
                    return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                }
                ComponentTableCell chartTableCell = (ComponentTableCell)((Object)value);
                return chartTableCell.showComponent;
            }
        }
    }
}

