/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.xve.monitor.perfstat;

import com.huawei.ism.common.bean.HisPerfStatObjectType;
import com.huawei.ism.common.resourcemanager.HisResourceManager;
import com.huawei.ism.ui.swing.LayoutConstants;
import com.huawei.ism.ui.swing.control.ImgsAssembledPane;
import com.huawei.ism.ui.swing.table.DefaultTableModel;
import com.huawei.ism.ui.swing.table.IsmTable;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.ism.ui.swing.table.TableScrollPane;
import com.huawei.ism.util.Pair;
import com.huawei.ism.util.UCD;
import com.huawei.ism.util.Utils;
import com.huawei.xve.utils.TableColumnNamesHolder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.RowSorter;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.table.TableModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PerfStatHisSurveyLayout
extends JPanel {
    private static final Logger log = LoggerFactory.getLogger(PerfStatHisSurveyLayout.class);
    private static final long serialVersionUID = 1L;
    private JLabel deviceNameValueLabel;
    private JComboBox objectTypeComboBox;
    private IsmTable objectListTable;
    private JButton thresholdSettingButton;
    private JButton viewButton;
    private JButton closeButton;
    private ImageIcon descImageIcon;
    private JLabel deviceNameLabel;
    private JLabel objectTypeLabel;
    private DefaultTableModel objectListTableModel;
    private TableScrollPane objectListScrollPane;
    private JLabel sampleIntervalLabel;
    private JPanel viewPane;
    private JLabel sampleIntervalValueLabel;

    public PerfStatHisSurveyLayout() {
        this.setLayout(new BorderLayout());
        this.doLayoutUI();
    }

    public JComboBox getObjectTypeComboBox() {
        return this.objectTypeComboBox;
    }

    public IsmTable getObjectListTable() {
        return this.objectListTable;
    }

    public JButton getThresholdSettingButton() {
        return this.thresholdSettingButton;
    }

    public JButton getViewButton() {
        return this.viewButton;
    }

    public JButton getCloseButton() {
        return this.closeButton;
    }

    private void doLayoutUI() {
        this.createComponents();
        this.layoutComponents();
    }

    private void createComponents() {
        this.descImageIcon = HisResourceManager.getImage("performanceStatic.png");
        this.deviceNameLabel = new JLabel(Utils.transferStringToLower((String)HisResourceManager.getString("PERFORMANCE_STATISTIC_OBJECT_PANEL_ARRAY")));
        this.deviceNameValueLabel = new JLabel();
        this.objectTypeLabel = new JLabel(Utils.transferStringToLower((String)HisResourceManager.getString("PERFORMANCE_STATISTIC_OBJECT_PANEL_STYLE")));
        this.objectTypeComboBox = new JComboBox();
        this.objectListTableModel = new DefaultTableModel(TableColumnNamesHolder.getObjectAndDataTypeNameTableColNames(), new int[0]);
        this.objectListTable = new IsmTable((TableModel)this.objectListTableModel);
        this.objectListScrollPane = TableScrollPane.createTablePane((IsmTable)this.objectListTable, (boolean)true, (TableScrollPane.CountArea)TableScrollPane.CountArea.TABLE_LEFT_DOWN, (TableScrollPane.FilterArea)TableScrollPane.FilterArea.TABLE_RIGHT_UP, (TableScrollPane.ButtonArea)TableScrollPane.ButtonArea.NONE);
        this.objectListScrollPane.setPreferredSize(new Dimension(this.objectListScrollPane.getPreferredSize().width, 1024));
        this.objectListScrollPane.setBorder(UCD.createTableTitleBorder((String)HisResourceManager.getString("PERFORMANCE_STATISTIC_OBJECT_LIST_TITLE")));
        this.sampleIntervalLabel = new JLabel(Utils.transferStringToLower((String)HisResourceManager.getStringWithColon("SAMPLE_INTERVAL")));
        this.sampleIntervalValueLabel = new JLabel();
        this.thresholdSettingButton = UCD.createButton((String)HisResourceManager.getString("perf.threshold.ui.threshold"));
        this.viewButton = UCD.createButton((String)HisResourceManager.getString("COMMON.TXT.VIEW"));
        this.viewPane = new JPanel();
        this.viewPane.setLayout(new BorderLayout());
        this.viewPane.setBorder(new CompoundBorder(new EtchedBorder(), new EmptyBorder(5, 4, 6, 5)));
        this.closeButton = new JButton(HisResourceManager.getString("COMMON.TXT.CLOSE"));
    }

    private void layoutComponents() {
        String infoText = HisResourceManager.getString("PER_HIS_27");
        JPanel imagePanel = UCD.newInformationPanel((String)infoText, (ImageIcon)this.descImageIcon);
        Box northBox = UCD.buildVBoxTop((int)LayoutConstants.LINE_MARGIN_PIXEL, (Component[])new Component[]{imagePanel});
        northBox.setBorder(new EmptyBorder(0, 0, LayoutConstants.LINE_MARGIN_PIXEL, 0));
        ArrayList<Pair> nameAndTypePairs = new ArrayList<Pair>(0);
        nameAndTypePairs.add(new Pair((Object)this.deviceNameLabel, (Object)this.deviceNameValueLabel));
        nameAndTypePairs.add(new Pair((Object)this.objectTypeLabel, (Object)this.objectTypeComboBox));
        ArrayList<Pair> sampleIntervalPairs = new ArrayList<Pair>(0);
        sampleIntervalPairs.add(new Pair((Object)this.sampleIntervalLabel, (Object)this.sampleIntervalValueLabel));
        Box westBox = UCD.buildVBoxTop((int)LayoutConstants.LINE_MARGIN_PIXEL, (Component[])new Component[]{UCD.createRightKVPane((int)LayoutConstants.LINE_MARGIN_PIXEL, nameAndTypePairs), this.objectListScrollPane, UCD.createRightKVPane((int)LayoutConstants.LINE_MARGIN_PIXEL, sampleIntervalPairs), UCD.buildHBoxRight((Component[])new Component[]{this.thresholdSettingButton, this.viewButton})});
        westBox.setBorder(new EmptyBorder(0, 0, 0, 8));
        UCD.setJComponentSize((JComponent)westBox, (int)290, (int)westBox.getPreferredSize().height);
        Box southBox = UCD.buildVBoxTop((int)0, (Component[])new Component[]{Box.createVerticalStrut(10), new ImgsAssembledPane.HorizonalSeparator(), UCD.buildButtonBoxRight((JButton[][])new JButton[][]{{this.closeButton}})});
        this.setLayout(new BorderLayout());
        this.add((Component)northBox, "North");
        this.add((Component)westBox, "West");
        this.add((Component)this.viewPane, "Center");
        this.add((Component)southBox, "South");
        this.setBorder(UCD.createEmptyBorder());
    }

    public void setDeviceName(String deviceName) {
        this.deviceNameValueLabel.setText(deviceName);
    }

    public void setSampleInterval(String sampleInterval) {
        this.sampleIntervalValueLabel.setText(sampleInterval);
    }

    public void setObjectTypes(List<Pair<HisPerfStatObjectType.HisObjectTypeEnum, String>> objectTypePairs) {
        this.objectTypeComboBox.removeAllItems();
        for (Pair<HisPerfStatObjectType.HisObjectTypeEnum, String> objectTypePair : objectTypePairs) {
            this.objectTypeComboBox.addItem(objectTypePair);
        }
    }

    public HisPerfStatObjectType.HisObjectTypeEnum getSelectedObjectType() {
        return (HisPerfStatObjectType.HisObjectTypeEnum)((Object)((Pair)this.objectTypeComboBox.getSelectedItem()).getKey());
    }

    public void setObjectNames(List<TableRow> rows) {
        this.objectListTableModel.removeAll();
        this.objectListTableModel.addRow(rows);
        RowSorter rowSorter = this.objectListTable.getRowSorter();
        if (rowSorter == null) {
            log.error("rowSorter is null.");
            return;
        }
        rowSorter.toggleSortOrder(0);
    }

    public List<String> getSelectedObjectNames() {
        List selectedRows = this.objectListTable.getMarkedRows();
        ArrayList<String> objectNames = new ArrayList<String>(selectedRows.size());
        String name = null;
        for (TableRow row : selectedRows) {
            name = (String)row.getUserObject();
            if (HisResourceManager.getString("DefaultGroup").equals(name)) {
                name = "Default Group";
            }
            objectNames.add(name);
        }
        return objectNames;
    }

    public void updateDataGraphics(JComponent comp) {
        this.viewPane.removeAll();
        this.viewPane.add((Component)comp, "Center");
        this.viewPane.updateUI();
    }
}

