/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.xve.monitor.perfstat;

import com.huawei.ism.common.resourcemanager.HisResourceManager;
import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.ui.module.perfhis.HisTools;
import com.huawei.ism.ui.module.perfhis.pojo.HisPerfStatHisThreshold;
import com.huawei.ism.ui.module.perfhis.proxy.HisPerfStatHisThresholdProxy;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.table.IsmTable;
import com.huawei.ism.ui.swing.table.IsmTableCell;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.ism.ui.templets.IsmDialog;
import com.huawei.xve.monitor.perfstat.PerfStatHisSurveyFrame;
import com.huawei.xve.monitor.perfstat.PerfStatHisThresholdSettingLayout;
import com.huawei.xve.utils.PerfStatUtils;
import java.awt.Window;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import javax.swing.DefaultCellEditor;
import javax.swing.JDialog;
import javax.swing.table.TableCellEditor;
import org.apache.log4j.Logger;

public class PerfStatHisThresholdSettingDialog
extends IsmDialog {
    private static final Logger LOGGER = Logger.getLogger(PerfStatHisThresholdSettingDialog.class);
    private static final long serialVersionUID = -3099581382367707710L;
    private PerfStatHisThresholdSettingLayout layout;
    private PerfStatHisSurveyFrame parent;

    public PerfStatHisThresholdSettingDialog(PerfStatHisSurveyFrame parent) {
        super((Window)parent, HisResourceManager.getString("perf.threshold.ui.thresholdSettings"), new IsmDialog.ECommonButton[]{IsmDialog.ECommonButton.Confirm, IsmDialog.ECommonButton.Apply, IsmDialog.ECommonButton.Cancel});
        this.parent = parent;
        this.layout = new PerfStatHisThresholdSettingLayout();
        this.setListenerToThresholdTableEditor(this.layout.getThresholdTable(), new ThresholdEditorKeyAdapter());
        this.add(this.layout);
        this.getButtonBy(IsmDialog.ECommonButton.Apply).setEnabled(false);
        this.beforeShow();
    }

    protected void doApplyTask() {
        if (this.updateThreshold()) {
            this.layout.getValueMonitor().flushValue();
            this.getButtonBy(IsmDialog.ECommonButton.Apply).setEnabled(false);
            LOGGER.info((Object)"Save performance threshold successfully.");
            DialogUtils.showInfoDialog((JDialog)((Object)this), (String)HisResourceManager.getString("INFORMATION_SUCCESS_MSG"));
        } else {
            LOGGER.info((Object)"Save performance threshold failed.");
            DialogUtils.showInfoDialog((JDialog)((Object)this), (String)HisResourceManager.getString("EXECUTE_FAILED"));
        }
    }

    protected void doConfirmTask() {
        if (this.getButtonBy(IsmDialog.ECommonButton.Apply).isEnabled()) {
            this.doApplyTask();
        }
        this.dispose();
    }

    public void dispose() {
        super.dispose();
        this.parent.setMask(false);
    }

    private boolean updateThreshold() {
        final LinkedList<HisPerfStatHisThreshold> perfStatHisThresholds = new LinkedList<HisPerfStatHisThreshold>();
        List tableRows = this.layout.getThresholdTable().getAllRows();
        IsmTableCell.TextCell thresholdValueTextCell = null;
        String thresholdValueString = null;
        Integer thresholdValue = null;
        HisPerfStatHisThreshold perfStatHisThreshold = null;
        for (TableRow tableRow : tableRows) {
            Object cellEditorValue;
            thresholdValueTextCell = (IsmTableCell.TextCell)tableRow.getValueAt(2);
            TableCellEditor editor = thresholdValueTextCell.getEditor();
            if (editor == null || (cellEditorValue = editor.getCellEditorValue()) == null) continue;
            thresholdValueString = (String)cellEditorValue;
            thresholdValue = HisTools.convertStringToInteger(thresholdValueString);
            perfStatHisThreshold = (HisPerfStatHisThreshold)tableRow.getUserObject();
            perfStatHisThreshold.setValue(thresholdValue);
            perfStatHisThresholds.add(perfStatHisThreshold);
        }
        List result = AsyncExcutor.execute((Window)((Object)this), (boolean)true, (long)0L, (Callable[])new Callable[]{new Callable<Boolean>(){

            @Override
            public Boolean call() {
                return HisPerfStatHisThresholdProxy.updateAll(perfStatHisThresholds);
            }
        }});
        PerfStatUtils.checkResult(result);
        return (Boolean)result.get(0);
    }

    private void setListenerToThresholdTableEditor(IsmTable thresholdTable, ThresholdEditorKeyAdapter keyListener) {
        int totalRowsCnt = thresholdTable.getRowCount();
        IsmTableCell.TextCell cell = null;
        DefaultCellEditor editor = null;
        for (int index = 0; index < totalRowsCnt; ++index) {
            cell = (IsmTableCell.TextCell)this.layout.getThresholdTable().getValueAt(index, 2);
            TableCellEditor c = cell.getEditor();
            if (c == null) {
                return;
            }
            editor = (DefaultCellEditor)c;
            editor.getComponent().addKeyListener(keyListener);
        }
    }

    protected String getHelpKey() {
        return "monitor_performance_summary_threshold";
    }

    public class ThresholdEditorKeyAdapter
    extends KeyAdapter {
        @Override
        public void keyReleased(KeyEvent e) {
            PerfStatHisThresholdSettingDialog.this.getButtonBy(IsmDialog.ECommonButton.Apply).setEnabled(PerfStatHisThresholdSettingDialog.this.layout.getValueMonitor().isValueChanged());
            PerfStatHisThresholdSettingDialog.this.layout.getResetButton().setEnabled(!PerfStatHisThresholdSettingDialog.this.layout.isAllDefault());
        }
    }
}

