/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.xve.monitor.perfstat;

import com.huawei.ism.common.resourcemanager.HisResourceManager;
import com.huawei.ism.ui.module.perfhis.HisTools;
import com.huawei.ism.ui.module.perfhis.pojo.HisPerfStatHisThreshold;
import com.huawei.ism.ui.module.perfhis.proxy.HisPerfStatHisThresholdProxy;
import com.huawei.ism.ui.swing.table.DefaultTableModel;
import com.huawei.ism.ui.swing.table.DefaultTableRow;
import com.huawei.ism.ui.swing.table.IsmTable;
import com.huawei.ism.ui.swing.table.IsmTableCell;
import com.huawei.ism.ui.swing.table.TableScrollPane;
import com.huawei.ism.util.UCD;
import com.huawei.ism.util.ValueMonitor;
import com.huawei.xve.utils.PerfStatUtils;
import com.huawei.xve.utils.TableColumnNamesHolder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableModel;

public class PerfStatHisThresholdSettingLayout
extends JPanel {
    private static final int PERCENT_MAX_VALUE = 100;
    private static final String PERCENT_SIGN = "%";
    private IsmTable thresholdTable;
    private ValueMonitor valueMonitor = new ValueMonitor();
    private JButton resetButton;

    public PerfStatHisThresholdSettingLayout() {
        DefaultTableModel thresholdSettingTableModel = new DefaultTableModel(TableColumnNamesHolder.getPerfStatHistoryThresholdTableColNames(), new int[0]);
        LinkedList<DefaultTableRow> rows = new LinkedList<DefaultTableRow>();
        List<HisPerfStatHisThreshold> perfStatHisThresholds = HisPerfStatHisThresholdProxy.getAll();
        String thresholdValue = null;
        JTextField thresholdValueInputField = null;
        IsmTableCell.TextCell textCell = null;
        DefaultTableRow row = null;
        for (HisPerfStatHisThreshold perfStatHisThreshold : perfStatHisThresholds) {
            thresholdValue = HisTools.convertIntegerToString(perfStatHisThreshold.getValue());
            thresholdValueInputField = this.getThresholdValueInputField(perfStatHisThreshold);
            thresholdValueInputField.setText(thresholdValue);
            this.valueMonitor.addCheckpoint((Object)thresholdValueInputField);
            thresholdValueInputField.setHorizontalAlignment(4);
            textCell = new IsmTableCell.TextCell(thresholdValueInputField, thresholdValue, null);
            row = new DefaultTableRow(TableColumnNamesHolder.getPerfStatHistoryThresholdTableColNames().length, (Object)perfStatHisThreshold, (Object)perfStatHisThreshold.getId());
            row.setValueAt(0, perfStatHisThreshold.getObjectType().getDescription());
            row.setValueAt(1, perfStatHisThreshold.getDataType().getDescription());
            row.setValueAt(2, textCell);
            row.setValueAt(3, HisResourceManager.getString(perfStatHisThreshold.getUnit()));
            rows.add(row);
        }
        this.valueMonitor.flushValue();
        thresholdSettingTableModel.setTableData(rows);
        this.thresholdTable = new IsmTable((TableModel)thresholdSettingTableModel);
        TableScrollPane tablescrollPane = TableScrollPane.createTablePane((IsmTable)this.thresholdTable, (boolean)false, (TableScrollPane.CountArea)TableScrollPane.CountArea.TABLE_LEFT_DOWN, (TableScrollPane.FilterArea)TableScrollPane.FilterArea.TABLE_RIGHT_UP, (TableScrollPane.ButtonArea)TableScrollPane.ButtonArea.NONE);
        this.thresholdTable.selectFirstRow();
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.add((Component)tablescrollPane);
        this.resetButton = UCD.createButton((String)HisResourceManager.getString("perf.threshold.ui.restoreDefault"));
        this.resetButton.setEnabled(!this.isAllDefault());
        this.resetButton.setFocusable(false);
        Box buttonsBox = Box.createVerticalBox();
        buttonsBox.add(Box.createVerticalStrut(12));
        this.add((Component)buttonsBox, "South");
    }

    private JTextField getThresholdValueInputField(HisPerfStatHisThreshold perfStatHisThreshold) {
        String unit = HisResourceManager.getString(perfStatHisThreshold.getUnit());
        if (PERCENT_SIGN.equals(unit)) {
            return PerfStatUtils.createCannotStartWithZeroNumberTextField(0L, 100L, String.valueOf(100).length(), 0);
        }
        return PerfStatUtils.createCannotStartWithZeroNumberTextField(0L, Integer.MAX_VALUE, String.valueOf(Integer.MAX_VALUE).length(), 0);
    }

    public boolean isAllDefault() {
        return true;
    }

    public IsmTable getThresholdTable() {
        return this.thresholdTable;
    }

    public ValueMonitor getValueMonitor() {
        return this.valueMonitor;
    }

    public JButton getResetButton() {
        return this.resetButton;
    }
}

