/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.xve.monitor.perfstat;

import com.huawei.ism.common.resourcemanager.HisResourceManager;
import com.huawei.ism.ui.module.perfhis.HisTools;
import com.huawei.ism.ui.module.perfhis.pojo.HisPerfStatHisFileInfo;
import com.huawei.ism.ui.swing.LayoutConstants;
import com.huawei.ism.ui.swing.table.DefaultTableModel;
import com.huawei.ism.ui.swing.table.DefaultTableRow;
import com.huawei.ism.ui.swing.table.IsmTable;
import com.huawei.ism.ui.swing.table.IsmTableCell;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.ism.ui.swing.table.TableScrollPane;
import com.huawei.ism.util.TimeUtil;
import com.huawei.ism.util.UCD;
import com.huawei.ism.util.Unit;
import com.huawei.xve.utils.TableColumnNamesHolder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import java.util.TimeZone;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.table.TableModel;

public class PerfStatHistoryLayout
extends JPanel {
    private static final long serialVersionUID = -3861238856080647457L;
    private JButton exportHistoryDataFileButton;
    private JButton mergeHistoryDataFileButton;
    private JButton addHistoryDataFileButton;
    private JButton removeButton;
    private JButton surveyButton;
    private JButton detailButton;
    private DefaultTableModel historyDataFileTableMode;
    private IsmTable historyDataFileTable;
    private JLabel descLabel;
    private JLabel taskWizardLabel;
    private JLabel wizardSequenceOneLabel;
    private JLabel exportHistoryDataFileDescLabel;
    private JLabel wizardSequenceTwoLabel;
    private JLabel mergeHistoryDataFileDescLabel;
    private JLabel wizardSequenceThreeLabel;
    private JLabel addHistoryDataFileDescLabel;
    private TableScrollPane scrollPane;

    public PerfStatHistoryLayout() {
        this.doLayoutUI();
    }

    private void doLayoutUI() {
        this.createComponents();
        this.layoutComponents();
    }

    private void createComponents() {
        this.descLabel = new JLabel(HisResourceManager.getString("perfstat.history.desc"));
        this.taskWizardLabel = new JLabel("<html><b>" + HisResourceManager.getString("perfstat.history.taskWizard") + "</b></html>");
        this.wizardSequenceThreeLabel = new JLabel(HisResourceManager.getString("perfstat.history.taskWizard.sequence.three"));
        this.addHistoryDataFileButton = UCD.createButton((String)HisResourceManager.getString("perfstat.history.taskWizard.addHistoryDataFile"));
        this.addHistoryDataFileDescLabel = new JLabel(HisResourceManager.getString("perfstat.history.taskWizard.addHistoryDataFile.desc"));
        this.wizardSequenceOneLabel = new JLabel(HisResourceManager.getString("perfstat.history.taskWizard.sequence.one"));
        this.exportHistoryDataFileButton = UCD.createButton((String)HisResourceManager.getString("EXPORT_FILE.TXT.EXPORT"));
        UCD.setJComponentSize((JComponent)this.exportHistoryDataFileButton, (Dimension)this.addHistoryDataFileButton.getPreferredSize());
        this.exportHistoryDataFileDescLabel = new JLabel(HisResourceManager.getString("perfstat.history.taskWizard.exportHistoryDataFile.desc"));
        this.wizardSequenceTwoLabel = new JLabel(HisResourceManager.getString("perfstat.history.taskWizard.sequence.two"));
        this.mergeHistoryDataFileButton = UCD.createButton((String)HisResourceManager.getString("perfstat.mergeDataFile.merge"));
        UCD.setJComponentSize((JComponent)this.mergeHistoryDataFileButton, (Dimension)this.addHistoryDataFileButton.getPreferredSize());
        this.mergeHistoryDataFileDescLabel = new JLabel(HisResourceManager.getString("perfstat.history.taskWizard.mergeHistoryDataFile.desc"));
        JLabel placeholderLabel = new JLabel();
        UCD.setJComponentSize((JComponent)placeholderLabel, (int)25, (int)10);
        this.removeButton = UCD.createButton((String)HisResourceManager.getString("perf.his.ui.remove"));
        this.surveyButton = UCD.createButton((String)HisResourceManager.getString("PER_HIS_5"));
        this.detailButton = UCD.createButton((String)HisResourceManager.getString("PER_HIS_6"));
        this.historyDataFileTableMode = new DefaultTableModel(TableColumnNamesHolder.getHistoryDataFileTableColNames(), new int[0]);
        this.historyDataFileTable = new IsmTable((TableModel)this.historyDataFileTableMode, true);
        this.scrollPane = TableScrollPane.createTablePane((IsmTable)this.historyDataFileTable, (boolean)true, (TableScrollPane.CountArea)TableScrollPane.CountArea.TABLE_LEFT_DOWN, (TableScrollPane.FilterArea)TableScrollPane.FilterArea.TABLE_RIGHT_UP, (TableScrollPane.ButtonArea)TableScrollPane.ButtonArea.TABLE_LEFT_UP);
        this.scrollPane.addComponent2ButtonArea(new JComponent[]{this.removeButton, placeholderLabel, this.surveyButton, this.detailButton});
    }

    public void addHistoryDataFileToTable(HisPerfStatHisFileInfo perfStatHisFileInfo) {
        DefaultTableRow tableRow = new DefaultTableRow(TableColumnNamesHolder.getHistoryDataFileTableColNames().length, (Object)perfStatHisFileInfo, (Object)(perfStatHisFileInfo.getFileName() + ':' + perfStatHisFileInfo.getGraphicStartTime() + ':' + perfStatHisFileInfo.getGraphicEndTime()));
        double fileSize = Math.ceil((double)perfStatHisFileInfo.getCompressedSize() / 1024.0);
        TimeZone timeZone = TimeZone.getDefault();
        tableRow.setValueAt(0, HisTools.removePath(perfStatHisFileInfo.getCompressedFileName()));
        tableRow.setValueAt(1, TimeUtil.gmtToString((long)perfStatHisFileInfo.getStartTime(), (TimeZone)timeZone));
        tableRow.setValueAt(2, TimeUtil.gmtToString((long)perfStatHisFileInfo.getEndTime(), (TimeZone)timeZone));
        tableRow.setValueAt(3, TimeUtil.gmtToString((long)perfStatHisFileInfo.getGraphicStartTime(), (TimeZone)timeZone));
        tableRow.setValueAt(4, TimeUtil.gmtToString((long)perfStatHisFileInfo.getGraphicEndTime(), (TimeZone)timeZone));
        tableRow.setValueAt(5, new IsmTableCell.NumberCell((Number)fileSize, Unit.DataUnit.KB));
        tableRow.setValueAt(6, new IsmTableCell.NumberCell((Number)(perfStatHisFileInfo.getPeriod() / 1000)));
        this.historyDataFileTableMode.addRow(new TableRow[]{tableRow});
    }

    public List<HisPerfStatHisFileInfo> getAddedPerfStatHisFiles() {
        ArrayList<HisPerfStatHisFileInfo> perfStatHisFiles = new ArrayList<HisPerfStatHisFileInfo>(0);
        List rows = this.historyDataFileTable.getAllRows();
        for (TableRow row : rows) {
            perfStatHisFiles.add((HisPerfStatHisFileInfo)row.getUserObject());
        }
        return perfStatHisFiles;
    }

    private void layoutComponents() {
        Box wholeBox = UCD.buildVBoxTop((int)LayoutConstants.LINE_MARGIN_PIXEL, (Component[])new Component[]{UCD.buildHBoxLeft((Component[])new Component[]{this.descLabel}), UCD.buildHBoxLeft((Component[])new Component[]{this.taskWizardLabel}), UCD.buildHBoxLeft((Component[])new Component[]{this.wizardSequenceOneLabel, this.exportHistoryDataFileButton, this.exportHistoryDataFileDescLabel}), UCD.buildHBoxLeft((Component[])new Component[]{this.wizardSequenceTwoLabel, this.mergeHistoryDataFileButton, this.mergeHistoryDataFileDescLabel}), UCD.buildHBoxLeft((Component[])new Component[]{this.wizardSequenceThreeLabel, this.addHistoryDataFileButton, this.addHistoryDataFileDescLabel}), UCD.buildHBoxLeft((Component[])new Component[]{Box.createHorizontalStrut(12), this.scrollPane})});
        this.setLayout(new BorderLayout());
        this.add((Component)wholeBox, "Center");
    }

    public IsmTable getHistoryDataFileTable() {
        return this.historyDataFileTable;
    }

    public DefaultTableModel getHistoryDataFileTableMode() {
        return this.historyDataFileTableMode;
    }

    public JButton getDetailButton() {
        return this.detailButton;
    }

    public JButton getSurveyButton() {
        return this.surveyButton;
    }

    public JButton getRemoveButton() {
        return this.removeButton;
    }

    public JButton getAddHistoryDataFileButton() {
        return this.addHistoryDataFileButton;
    }

    public JButton getMergeHistoryDataFileButton() {
        return this.mergeHistoryDataFileButton;
    }

    public JButton getExportHistoryDataFileButton() {
        return this.exportHistoryDataFileButton;
    }
}

