/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.xve.monitor.perfstat;

import com.huawei.ism.common.resourcemanager.HisResourceManager;
import com.huawei.ism.exception.IsmException;
import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.thread.ThreadPoolManager;
import com.huawei.ism.ui.module.perfhis.HisTools;
import com.huawei.ism.ui.module.perfhis.pojo.HisPerfStatHisFileInfo;
import com.huawei.ism.ui.swing.PropertyPane;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.dialog.HisDialogUtils;
import com.huawei.ism.ui.swing.dialog.PeomptDialog;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.ism.ui.templets.PropertyPaneAction;
import com.huawei.ism.ui.templets.TableMenuHandler;
import com.huawei.ism.ui.widgets.action.SingleChoicePropertyPaneAction;
import com.huawei.ism.util.SwingUtil;
import com.huawei.ism.util.VerifyUtil;
import com.huawei.json.JSONObject;
import com.huawei.sftp.PerfStatHisSftp;
import com.huawei.xve.monitor.perfstat.BatchExportTypeChooseDialog;
import com.huawei.xve.monitor.perfstat.IOTraceExportDialog;
import com.huawei.xve.monitor.perfstat.PerfStatHisDetailFrame;
import com.huawei.xve.monitor.perfstat.PerfStatHisOpenFileDialog;
import com.huawei.xve.monitor.perfstat.PerfStatHisSurveyFrame;
import com.huawei.xve.monitor.perfstat.PerfStatHistoryLayout;
import com.huawei.xve.monitor.perfstat.PerfStatMergeHisFileDialog;
import com.huawei.xve.monitor.perfstat.SetFrameOnTopThread;
import com.huawei.xve.monitor.perfstat.WorkloadBatchExportDialog;
import com.huawei.xve.monitor.perfstat.WorkloadExportDialog;
import com.huawei.xve.ui.BatchExportPerfDialog;
import com.huawei.xve.utils.ConnManager;
import com.huawei.xve.utils.DeviceInfo;
import com.huawei.xve.utils.DeviceVersion;
import com.huawei.xve.utils.HisPerfstatUtil;
import com.huawei.xve.utils.PerfStatUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import utils.Products;

public class PerfStatHistoryPane
extends PropertyPane {
    private static final Logger LOGGER = LoggerFactory.getLogger(PerfStatHistoryPane.class);
    private static final long serialVersionUID = -9214205501472401917L;
    private static final String BEGIN_2200_V3 = "2200";
    private static final String BEGIN_2600_V3 = "2600";
    private static final String WOLOAD_EXPORT_NEW = "woloadExportNew";
    private static final String WOLOAD_EXPORT_OLD = "woloadExportOld";
    private static final String WOLOAD_EXPORT = "woloadExport";
    private static final String NO_WORKLOAD_EXPORT = "noWorkloadExport";
    private PerfStatHistoryLayout layout;
    private List<String> deviceIDs = null;
    private boolean isShowWorkload = true;
    private ArrayList<String> v3r3Dev = null;
    private ArrayList<String> v5r7Dev = null;
    private List<String> v3r3IOTraceDev;
    private List<String> v5r7IOTraceDev;
    private int exportType;

    public PerfStatHistoryPane(List<String> list) {
        this.deviceIDs = list;
        this.doLayoutUI();
        this.addHandler();
        this.setOpaque(false);
    }

    public void updateProperty(int updateMode) {
    }

    public String getDeviceID() {
        return null;
    }

    private void doLayoutUI() {
        this.layout = new PerfStatHistoryLayout();
        this.checkIsShowBWLBtn();
        this.checkIsShowWLBtn();
        this.checkIsV3R3AndShowIOTrace();
        this.checkIsV5R7AndShowIOTrace();
        this.setLayout(new BorderLayout());
        this.add(this.layout, "Center");
        this.setTableButtonStatus();
    }

    private void checkIsV5R7AndShowIOTrace() {
        String v5r7Begin;
        this.v5r7IOTraceDev = new ArrayList<String>();
        String v3r6Begin = HisResourceManager.getCfgProperties().getProperty("IOTRACE_V3R6_BEGIN_VERSION");
        if (VerifyUtil.isMultiEmpty(v3r6Begin, v5r7Begin = HisResourceManager.getCfgProperties().getProperty("IOTRACE_V5R7_BEGIN_VERSION"))) {
            LOGGER.warn("There is not exists show_workload_surrport_version config.");
            return;
        }
        String v3r6Common = v3r6Begin.substring(0, v3r6Begin.length() - 6);
        String v5r7Common = v5r7Begin.substring(0, v5r7Begin.length() - 6);
        DeviceInfo devInfo = null;
        for (String dev : this.deviceIDs) {
            devInfo = ConnManager.getDeviceInfo(dev);
            if (VerifyUtil.isEmpty(devInfo)) continue;
            String deviceVersion = devInfo.getdVersion();
            if (this.checkIsARMDev(devInfo) || !this.isMatchVersion(v3r6Common, deviceVersion, v3r6Begin) && !this.isMatchVersion(v5r7Common, deviceVersion, v5r7Begin)) continue;
            this.v5r7IOTraceDev.add(dev);
        }
    }

    private boolean isMatchVersion(String mainVersion, String deviceVersion, String sptVersion) {
        return deviceVersion.contains(mainVersion) && PerfStatHistoryPane.isVersionAfter(deviceVersion, sptVersion);
    }

    private void checkIsV3R3AndShowIOTrace() {
        this.v3r3IOTraceDev = new ArrayList<String>();
        String v3r3Begin = HisResourceManager.getCfgProperties().getProperty("IOTRACE_V3R3_BEGIN_VERSION");
        if (null == v3r3Begin) {
            LOGGER.warn("There is not exists show_workload_surrport_version config.");
            return;
        }
        String common = v3r3Begin.substring(0, v3r3Begin.length() - 3);
        DeviceInfo devInfo = null;
        for (String dev : this.deviceIDs) {
            devInfo = ConnManager.getDeviceInfo(dev);
            if (VerifyUtil.isEmpty(devInfo)) continue;
            String version = devInfo.getdVersion();
            boolean isARMDev = this.checkIsARMDev(devInfo);
            if (!version.contains(common) || !PerfStatHistoryPane.isVersionAfter(version, v3r3Begin) || isARMDev) continue;
            this.v3r3IOTraceDev.add(dev);
        }
    }

    private boolean checkIsARMDev(DeviceInfo devInfo) {
        String devType = devInfo.getdType();
        if (VerifyUtil.isEmpty(devType)) {
            return false;
        }
        return devType.startsWith(BEGIN_2200_V3) || devType.startsWith(BEGIN_2600_V3);
    }

    public static boolean isVersionAfter(String curVersion, String sptVersion) {
        sptVersion = sptVersion.replace("Kunpeng", "").trim();
        curVersion = curVersion.replace("Kunpeng", "").trim();
        if (sptVersion.contains(".")) {
            return PerfStatHistoryPane.isVersionAfterByPoint(curVersion, sptVersion);
        }
        return PerfStatHistoryPane.isVersionAfterByVRC(curVersion, sptVersion);
    }

    public static boolean isInteger(String str) {
        Pattern pattern = Pattern.compile("^[-\\+]?[\\d]*$");
        return pattern.matcher(str).matches();
    }

    public static boolean isVersionAfterByPoint(String curVersion, String sptVersion) {
        int sptVersionSetlength;
        if (!curVersion.contains(".")) {
            return false;
        }
        String[] curVersionSet = curVersion.split("\\.");
        String[] sptVersionSet = sptVersion.split("\\.");
        int curVersionSetlength = curVersionSet.length;
        int times = sptVersionSetlength = sptVersionSet.length;
        int sub = 0;
        if (curVersionSetlength < sptVersionSetlength) {
            times = curVersionSetlength;
        }
        while (times > 0) {
            --times;
            String cur = curVersionSet[sub];
            String spt = sptVersionSet[sub];
            if (PerfStatHistoryPane.isInteger(spt) && PerfStatHistoryPane.isInteger(cur)) {
                int sptInt;
                int curInt = Integer.parseInt(cur);
                if (curInt > (sptInt = Integer.parseInt(spt))) {
                    return true;
                }
                if (curInt < sptInt) {
                    return false;
                }
            } else {
                if (cur.compareTo(spt) > 0) {
                    return true;
                }
                if (cur.compareTo(spt) < 0) {
                    return true;
                }
            }
            ++sub;
        }
        return true;
    }

    public static boolean isVersionAfterByVRC(String curVersion, String sptVersion) {
        int i;
        if (Products.isDigitalVer((String)curVersion)) {
            return true;
        }
        if (curVersion.equals(sptVersion)) {
            return true;
        }
        String curStr = "";
        String sptStr = "";
        char curDiff = '\u0000';
        char sptDiff = '\u0000';
        int len = curVersion.length();
        for (i = 1; i <= sptVersion.length(); ++i) {
            if (i > len) {
                return false;
            }
            curStr = curVersion.substring(0, i);
            if (curStr.equals(sptStr = sptVersion.substring(0, i))) continue;
            curDiff = curStr.charAt(i - 1);
            return curDiff > (sptDiff = sptStr.charAt(i - 1));
        }
        return i - 1 == sptVersion.length();
    }

    private void checkIsShowBWLBtn() throws IsmException {
        this.v5r7Dev = new ArrayList();
        String wlkShowVersions = HisResourceManager.getCfgProperties().getProperty("BATCHWORKLOAD_SHOW_VERSION");
        if (null == wlkShowVersions) {
            LOGGER.warn("There is not exists show_workload_surrport_version config.");
            return;
        }
        String doradoV6 = HisResourceManager.getCfgProperties().getProperty("DORADO_V6");
        String oceanProtectV1 = HisResourceManager.getCfgProperties().getProperty("OCEANPROTECT_V1");
        this.invalidSpecialDevType(wlkShowVersions, doradoV6);
        this.invalidSpecialDevType(wlkShowVersions, oceanProtectV1);
    }

    private void invalidSpecialDevType(String wlkShowVersions, String type) {
        JSONObject jsonByType = null;
        boolean isSpecialDevByType = false;
        try {
            jsonByType = new JSONObject(type);
            isSpecialDevByType = jsonByType != null && jsonByType.length() > 0;
        }
        catch (Exception e) {
            LOGGER.error("invalid specialDevType config.please check the config file.", (Throwable)e);
        }
        DeviceInfo devInfo = null;
        for (String dev : this.deviceIDs) {
            devInfo = ConnManager.getDeviceInfo(dev);
            if (VerifyUtil.isEmpty(devInfo)) continue;
            if (PerfStatHistoryPane.isVersionAfter(devInfo.getdVersion(), wlkShowVersions)) {
                this.v5r7Dev.add(dev);
            }
            if (!isSpecialDevByType || VerifyUtil.isEmpty(devInfo.getdType())) continue;
            this.conditonForJo(jsonByType, devInfo, dev, this.v5r7Dev);
        }
    }

    private void checkIsShowWLBtn() throws IsmException {
        this.v3r3Dev = new ArrayList();
        String wlkShowVersions = HisResourceManager.getCfgProperties().getProperty("WORKLOAD_SHOW_VERSION");
        String wlkShowVersionsExcept = HisResourceManager.getCfgProperties().getProperty("WORKLOAD_SHOW_VERSION_EXCEPT");
        if (null == wlkShowVersions) {
            LOGGER.warn("There is not exists show_workload_surrport_version config.");
            return;
        }
        String specialDevType = HisResourceManager.getCfgProperties().getProperty("WORKLOAD_SPECIAL_DEVICETYPE_VERSION");
        JSONObject json = null;
        boolean isSpecialDev = false;
        try {
            json = new JSONObject(specialDevType);
            isSpecialDev = json != null && json.length() > 0;
        }
        catch (Exception e) {
            LOGGER.error("invalid specialDevType config.please check the config file.", (Throwable)e);
        }
        DeviceInfo devInfo = null;
        for (String dev : this.deviceIDs) {
            devInfo = ConnManager.getDeviceInfo(dev);
            if (devInfo.getdVersion().contains(wlkShowVersionsExcept)) continue;
            if (json != null && isSpecialDev && !VerifyUtil.isEmpty(devInfo.getdType())) {
                this.conditonForJo(json, devInfo, dev, this.v3r3Dev);
            }
            if (PerfStatHistoryPane.isVersionAfter(devInfo.getdVersion(), wlkShowVersions)) {
                this.v3r3Dev.add(dev);
            }
            if (this.v5r7Dev.isEmpty()) continue;
            this.deleteNewList();
        }
    }

    private void conditonForJo(JSONObject jo, DeviceInfo devInfo, String dev, ArrayList<String> target) {
        Iterator keys = jo.keys();
        String specialDev = null;
        while (keys.hasNext()) {
            specialDev = (String)keys.next();
            try {
                if (!devInfo.getdType().contains(specialDev) || !PerfStatHistoryPane.isVersionAfter(devInfo.getdVersion(), jo.getString(specialDev))) continue;
                target.add(dev);
                break;
            }
            catch (Exception e) {
                LOGGER.error("invalid specialDevType config.check the config file.", (Throwable)e);
            }
        }
    }

    private void deleteNewList() {
        for (int i = 0; i < this.v5r7Dev.size(); ++i) {
            if (!this.v3r3Dev.contains(this.v5r7Dev.get(i))) continue;
            this.v3r3Dev.remove(this.v5r7Dev.get(i));
        }
    }

    private void addHandler() {
        this.layout.getExportHistoryDataFileButton().addActionListener(this.createChooseTypeListener1());
        this.layout.getMergeHistoryDataFileButton().addActionListener(this.createMergeHistoryDataFileButtonListener());
        this.layout.getAddHistoryDataFileButton().addActionListener(this.createAddHistoryDataFileButtonListener());
        this.layout.getRemoveButton().addActionListener(this.createRemoveHistoryDataFileButtonListener());
        this.layout.getSurveyButton().addActionListener(this.createSurveyButtonListener());
        this.layout.getDetailButton().addActionListener(this.createDetailButtonListener());
        this.layout.getHistoryDataFileTable().addListSelectionListener(this.createPerfFilesListSelectionListener());
        this.layout.getHistoryDataFileTable().addMouseListener((MouseListener)this.createPopupMenuAdapter());
    }

    private ActionListener createChooseTypeListener1() {
        ActionListener lis = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LOGGER.info("createChooseTypeListener1().+++");
                if (!PerfStatHistoryPane.this.checkDiviceExist()) {
                    return;
                }
                String workloadExportType = "";
                if (!PerfStatHistoryPane.this.isShowWorkload) {
                    PerfStatHistoryPane.this.showHis();
                    return;
                }
                if (PerfStatHistoryPane.this.v3r3Dev.isEmpty() && PerfStatHistoryPane.this.v5r7Dev.isEmpty()) {
                    PerfStatHistoryPane.this.showHis();
                    return;
                }
                workloadExportType = this.conditonForDev();
                BatchExportTypeChooseDialog etc = new BatchExportTypeChooseDialog(PerfStatHistoryPane.this.getParentWindow(), workloadExportType, PerfStatHistoryPane.this.deviceIDs);
                etc.setVisible(true);
                Integer type = etc.getChooseType();
                while (type == -1) {
                    DialogUtils.showInfoDialog((JDialog)((Object)etc), (String)HisResourceManager.getString("EXPORT_TYPE_SELECT"));
                    etc = new BatchExportTypeChooseDialog(PerfStatHistoryPane.this.getParentWindow(), workloadExportType, PerfStatHistoryPane.this.deviceIDs);
                    etc.setVisible(true);
                    type = etc.getChooseType();
                }
                if (type != -1) {
                    PerfStatHistoryPane.this.exportType = type;
                    PerfStatHistoryPane.this.showDialog();
                }
            }

            private String conditonForDev() {
                if (HisPerfstatUtil.isSupportA800Scene()) {
                    return PerfStatHistoryPane.NO_WORKLOAD_EXPORT;
                }
                if (PerfStatHistoryPane.this.v3r3Dev.isEmpty()) {
                    return PerfStatHistoryPane.this.getRealExportType(PerfStatHistoryPane.WOLOAD_EXPORT_NEW, PerfStatHistoryPane.this.isShowIOTrace(PerfStatHistoryPane.this.v5r7IOTraceDev));
                }
                if (PerfStatHistoryPane.this.v5r7Dev.isEmpty()) {
                    return PerfStatHistoryPane.this.getRealExportType(PerfStatHistoryPane.WOLOAD_EXPORT_OLD, PerfStatHistoryPane.this.isShowIOTrace(PerfStatHistoryPane.this.v3r3IOTraceDev));
                }
                boolean isShowIOTrace = PerfStatHistoryPane.this.isShowIOTrace(PerfStatHistoryPane.this.v3r3IOTraceDev, PerfStatHistoryPane.this.v5r7IOTraceDev);
                return PerfStatHistoryPane.this.getRealExportType(PerfStatHistoryPane.WOLOAD_EXPORT, isShowIOTrace);
            }
        };
        return lis;
    }

    public boolean isShowIOTrace(List<String> ... devListArr) {
        boolean isShow = false;
        if (VerifyUtil.isEmpty(devListArr)) {
            return isShow;
        }
        for (List<String> devs : devListArr) {
            if (VerifyUtil.isEmpty(devs)) continue;
            isShow = true;
            break;
        }
        return isShow;
    }

    private String getRealExportType(String workloadExportType, boolean isShowIOTrace) {
        if (isShowIOTrace) {
            return workloadExportType + "_" + "ioTrace";
        }
        return workloadExportType;
    }

    private void showDialog() {
        if (this.exportType == 0) {
            this.showHis();
        } else if (this.exportType == 1) {
            this.showWorkload();
        } else if (this.exportType == 2) {
            if (this.v5r7Dev.isEmpty()) {
                this.showWorkload();
            } else {
                this.showWBatchExport();
            }
        } else if (this.exportType == 3) {
            this.showIOTrace();
        }
    }

    private void showWBatchExport() {
        WorkloadBatchExportDialog wl = new WorkloadBatchExportDialog(this.v5r7Dev.stream().distinct().collect(Collectors.toList()), this.getParentWindow());
        wl.setVisible(true);
    }

    protected void showWorkload() {
        WorkloadExportDialog wl = new WorkloadExportDialog(this.v3r3Dev.stream().distinct().collect(Collectors.toList()), this.getParentWindow());
        wl.setVisible(true);
    }

    protected void showHis() {
        LOGGER.info("showHis().+++");
        this.checkIpsFor18000();
        BatchExportPerfDialog dialog = new BatchExportPerfDialog(this.deviceIDs, this.getParentWindow());
        dialog.setVisible(true);
    }

    private void checkIpsFor18000() {
        List tasks = this.deviceIDs.stream().map(deviceId -> ConnManager.getDeviceInfo(deviceId)).filter(device -> device.getDeviceVersion() == DeviceVersion.T18000).map(device -> CompletableFuture.supplyAsync(() -> {
            this.checkIps((DeviceInfo)device);
            return true;
        })).collect(Collectors.toList());
        AsyncExcutor.execute((Window)this.getParentWindow(), (boolean)true, (long)0L, (Callable[])new Callable[]{() -> {
            CompletableFuture.allOf(tasks.toArray(new CompletableFuture[0])).join();
            return true;
        }});
    }

    protected void showIOTrace() {
        ArrayList<String> showIOtraceDevList = new ArrayList<String>();
        showIOtraceDevList.addAll(this.v3r3IOTraceDev);
        showIOtraceDevList.addAll(this.v5r7IOTraceDev);
        IOTraceExportDialog dialog = new IOTraceExportDialog(showIOtraceDevList, this.getParentWindow());
        dialog.setVisible(true);
    }

    private void checkIps(DeviceInfo deviceInfo) {
        String ips = deviceInfo.getIp();
        String[] ip = ips.split(",");
        StringBuffer sb = new StringBuffer();
        for (String i : ip) {
            if (!PerfStatHisSftp.isSftpCanConnected(i, deviceInfo.getPort(), 300)) continue;
            sb.append(i);
            sb.append(",");
        }
        LOGGER.info("Reset ip to {} ", (Object)sb);
        deviceInfo.setIp(sb.toString());
    }

    private boolean checkDiviceExist() {
        if (null == this.deviceIDs || this.deviceIDs.isEmpty()) {
            LOGGER.error("Export performance file failed." + HisResourceManager.getString("PERF.NEED.DISCOVERY.DEVICE", Locale.ENGLISH));
            DialogUtils.showErrorDialog((Window)this.getParentWindow(), (String)HisResourceManager.getString("PERF.NEED.DISCOVERY.DEVICE"));
            return false;
        }
        return true;
    }

    private ActionListener createMergeHistoryDataFileButtonListener() {
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean containTV1 = PerfStatHistoryPane.this.queryContainTV1();
                if (containTV1) {
                    PerfStatMergeHisFileDialog dialog = new PerfStatMergeHisFileDialog(PerfStatHistoryPane.this.getParentWindow());
                    SwingUtil.putParentCenter((Window)((Object)dialog), (Window)PerfStatHistoryPane.this.getParentWindow());
                    dialog.setVisible(true);
                } else {
                    String path = HisResourceManager.getString("PRPMPT_JUMP_ESERVIVE");
                    PeomptDialog dialogPrpmpt = HisDialogUtils.showCreatePromptDialog(PerfStatHistoryPane.this.getParentWindow(), path);
                    if (0 == dialogPrpmpt.getValue()) {
                        PerfStatMergeHisFileDialog dialog = new PerfStatMergeHisFileDialog(PerfStatHistoryPane.this.getParentWindow());
                        SwingUtil.putParentCenter((Window)((Object)dialog), (Window)PerfStatHistoryPane.this.getParentWindow());
                        dialog.setVisible(true);
                    }
                }
            }
        };
        return listener;
    }

    private boolean queryContainTV1() {
        for (String string : this.deviceIDs) {
            DeviceVersion deviceVersion = ConnManager.getDeviceInfo(string).getDeviceVersion();
            if (deviceVersion != DeviceVersion.TV1) continue;
            return true;
        }
        return false;
    }

    private ActionListener createAddHistoryDataFileButtonListener() {
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean containTV1 = PerfStatHistoryPane.this.queryContainTV1();
                if (containTV1) {
                    PerfStatHisOpenFileDialog dialog = new PerfStatHisOpenFileDialog(PerfStatHistoryPane.this.getParentWindow(), (Object)PerfStatHistoryPane.this);
                    SwingUtil.putParentCenter((Window)((Object)dialog), (Window)PerfStatHistoryPane.this.getParentWindow());
                    dialog.setVisible(true);
                } else {
                    String path = HisResourceManager.getString("PRPMPT_JUMP_ESERVIVE");
                    PeomptDialog dialogPrpmpt = HisDialogUtils.showCreatePromptDialog(PerfStatHistoryPane.this.getParentWindow(), path);
                    if (0 == dialogPrpmpt.getValue()) {
                        PerfStatHisOpenFileDialog dialog = new PerfStatHisOpenFileDialog(PerfStatHistoryPane.this.getParentWindow(), (Object)PerfStatHistoryPane.this);
                        SwingUtil.putParentCenter((Window)((Object)dialog), (Window)PerfStatHistoryPane.this.getParentWindow());
                        dialog.setVisible(true);
                    }
                }
            }
        };
        return listener;
    }

    private ActionListener createRemoveHistoryDataFileButtonListener() {
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PerfStatHistoryPane.this.removeSelectedHistoryDataFileFromTable();
            }
        };
        return listener;
    }

    private ActionListener createSurveyButtonListener() {
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PerfStatHistoryPane.this.openPerfStatHisSurveyFrame();
            }
        };
        return listener;
    }

    private ActionListener createDetailButtonListener() {
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PerfStatHistoryPane.this.openPerfStatHisDetailFrame();
            }
        };
        return listener;
    }

    private ListSelectionListener createPerfFilesListSelectionListener() {
        ListSelectionListener listener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                PerfStatHistoryPane.this.setTableButtonStatus();
            }
        };
        return listener;
    }

    private MouseAdapter createPopupMenuAdapter() {
        MouseAdapter adapter = new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                TableMenuHandler.popMenu((MouseEvent)e, (Collection)PerfStatHistoryPane.this.getPopupMenuActions());
            }
        };
        return adapter;
    }

    private List<PropertyPaneAction> getPopupMenuActions() {
        ArrayList<PropertyPaneAction> popupMenus = new ArrayList<PropertyPaneAction>(0);
        DisplayHisSurveyFrameAction displayHisSurveyFrameAction = new DisplayHisSurveyFrameAction();
        displayHisSurveyFrameAction.setName(HisResourceManager.getString("PER_HIS_5"));
        popupMenus.add((PropertyPaneAction)displayHisSurveyFrameAction);
        DisplayHisDetailFrameAction displayHisDetailFrameAction = new DisplayHisDetailFrameAction();
        displayHisDetailFrameAction.setName(HisResourceManager.getString("PER_HIS_6"));
        popupMenus.add((PropertyPaneAction)displayHisDetailFrameAction);
        RemovePerfStatFilesAction removePerfStatFilesAction = new RemovePerfStatFilesAction();
        removePerfStatFilesAction.setName(HisResourceManager.getString("REMOVE"));
        popupMenus.add(removePerfStatFilesAction);
        return popupMenus;
    }

    public void addHistoryDataFileToTable(HisPerfStatHisFileInfo perfStatHisFileInfo) {
        this.layout.addHistoryDataFileToTable(perfStatHisFileInfo);
    }

    private void removeSelectedHistoryDataFileFromTable() {
        this.layout.getHistoryDataFileTable().requestFocus();
        this.removeTempFile(this.layout.getHistoryDataFileTable().getMarkedRows());
        this.layout.getHistoryDataFileTableMode().removeRow(this.layout.getHistoryDataFileTable().getMarkedRows());
    }

    private void removeTempFile(List<TableRow> rows) {
        for (TableRow tableRow : rows) {
            if (!(tableRow.getUserObject() instanceof HisPerfStatHisFileInfo)) continue;
            HisPerfStatHisFileInfo fileObj = (HisPerfStatHisFileInfo)tableRow.getUserObject();
            PerfStatUtils.deleteTempPerfHisFile(fileObj);
            if (!LOGGER.isInfoEnabled()) continue;
            LOGGER.info("remove performance file " + fileObj.getCompressedFileName() + " successfully.");
        }
    }

    private void openPerfStatHisSurveyFrame() {
        HisPerfStatHisFileInfo selectedFileInfo = this.getSelectedPerfStatHisFile();
        if (selectedFileInfo == null) {
            return;
        }
        PerfStatUtils.populatePerfStatHisFileInfo(this.getParentWindow(), selectedFileInfo);
        PerfStatHisSurveyFrame frame = new PerfStatHisSurveyFrame(selectedFileInfo);
        SwingUtil.putParentCenter((Window)frame, (Window)this.getParentWindow());
        frame.setAlwaysOnTop(true);
        SetFrameOnTopThread frameThread = new SetFrameOnTopThread(frame);
        ThreadPoolManager.getInstance().execute((Runnable)frameThread);
        frame.setVisible(true);
    }

    private void openPerfStatHisDetailFrame() {
        HisPerfStatHisFileInfo selectedFileInfo = this.getSelectedPerfStatHisFile();
        if (selectedFileInfo == null) {
            return;
        }
        PerfStatUtils.populatePerfStatHisFileInfo(this.getParentWindow(), selectedFileInfo);
        String margin = " ";
        String subName = margin + HisTools.getFormatName(selectedFileInfo);
        PerfStatHisDetailFrame frame = new PerfStatHisDetailFrame(HisResourceManager.getString("PER_HIS_6") + subName, selectedFileInfo);
        SwingUtil.putParentCenter((Window)frame, (Window)this.getParentWindow());
        frame.setAlwaysOnTop(true);
        SetFrameOnTopThread frameThread = new SetFrameOnTopThread(frame);
        ThreadPoolManager.getInstance().execute((Runnable)frameThread);
        frame.setVisible(true);
    }

    private HisPerfStatHisFileInfo getSelectedPerfStatHisFile() {
        TableRow row = this.layout.getHistoryDataFileTable().getMarkedRow();
        if (row == null) {
            return null;
        }
        return (HisPerfStatHisFileInfo)row.getUserObject();
    }

    public List<HisPerfStatHisFileInfo> getAddedPerfStatHisFiles() {
        return this.layout.getAddedPerfStatHisFiles();
    }

    private void setTableButtonStatus() {
        this.setSurveyButtonStatus();
        this.setDetailButtonStatus();
        this.setRemoveButtonStatus();
    }

    private void setSurveyButtonStatus() {
        if (this.layout.getHistoryDataFileTable().getMarkedRows().size() == 1) {
            this.layout.getSurveyButton().setEnabled(true);
        } else {
            this.layout.getSurveyButton().setEnabled(false);
        }
    }

    private void setDetailButtonStatus() {
        if (this.layout.getHistoryDataFileTable().getMarkedRows().size() == 1) {
            this.layout.getDetailButton().setEnabled(true);
        } else {
            this.layout.getDetailButton().setEnabled(false);
        }
    }

    private void setRemoveButtonStatus() {
        if (this.layout.getHistoryDataFileTable().getMarkedRows().isEmpty()) {
            this.layout.getRemoveButton().setEnabled(false);
        } else {
            this.layout.getRemoveButton().setEnabled(true);
        }
    }

    public final Window getParentWindow() {
        return SwingUtilities.getWindowAncestor((Component)((Object)this));
    }

    public String getHelpKey() {
        return "monitor_old_performance";
    }

    public class RemovePerfStatFilesAction
    extends PropertyPaneAction {
        private static final long serialVersionUID = 6614675954662583006L;

        protected PropertyPaneAction.MenuInfo getMenuInfo() {
            return new PropertyPaneAction.MenuInfo(null, "removeHistoryDataFile");
        }

        public void actionPerformed(List<Object> rowUserObject) {
            PerfStatHistoryPane.this.removeSelectedHistoryDataFileFromTable();
        }

        protected boolean isAvailable() {
            List rowUserObject = (List)this.getUserObject();
            if (null == rowUserObject || rowUserObject.isEmpty()) {
                return false;
            }
            return super.isAvailable();
        }
    }

    public class DisplayHisDetailFrameAction
    extends SingleChoicePropertyPaneAction {
        private static final long serialVersionUID = -6592622926398902199L;

        protected PropertyPaneAction.MenuInfo getMenuInfo() {
            return new PropertyPaneAction.MenuInfo(null, "view");
        }

        public String getReason(List<Object> rowUserObject) {
            return null;
        }

        public void actionPerformed(List<Object> rowUserObject) {
            PerfStatHistoryPane.this.openPerfStatHisDetailFrame();
        }
    }

    public class DisplayHisSurveyFrameAction
    extends SingleChoicePropertyPaneAction {
        private static final long serialVersionUID = -6592622926398902199L;

        public String getReason(List<Object> rowUserObject) {
            return null;
        }

        protected PropertyPaneAction.MenuInfo getMenuInfo() {
            return new PropertyPaneAction.MenuInfo(null, "view");
        }

        public void actionPerformed(List<Object> rowUserObject) {
            PerfStatHistoryPane.this.openPerfStatHisSurveyFrame();
        }
    }
}

