/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.xve.monitor.perfstat;

import com.huawei.ism.common.resourcemanager.HisResourceManager;
import com.huawei.ism.exception.IsmException;
import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.thread.ThreadPoolManager;
import com.huawei.ism.ui.module.perfhis.HisTools;
import com.huawei.ism.ui.module.perfhis.pojo.HisPerfStatHisFileInfo;
import com.huawei.ism.ui.module.perfhis.service.PerfStatHisFileService;
import com.huawei.ism.ui.swing.IsmFileChooser;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.table.DefaultTableModel;
import com.huawei.ism.ui.swing.table.DefaultTableRow;
import com.huawei.ism.ui.swing.table.IsmTable;
import com.huawei.ism.ui.swing.table.IsmTableCell;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.ism.ui.templets.IsmDialog;
import com.huawei.ism.util.TimeUtil;
import com.huawei.ism.util.UCD;
import com.huawei.ism.util.Unit;
import com.huawei.xve.MainDialog;
import com.huawei.xve.monitor.perfstat.PerfStatMergeHisFileLayout;
import com.huawei.xve.utils.PerfStatUtils;
import com.huawei.xve.utils.TableColumnNamesHolder;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.TimeZone;
import java.util.concurrent.Callable;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.log4j.Logger;
import utils.FilesUtil;

public class PerfStatMergeHisFileDialog
extends IsmDialog {
    private static final Logger LOGGER = Logger.getLogger(PerfStatMergeHisFileDialog.class);
    private static final long serialVersionUID = -4154125323501397772L;
    private static final String DEFAULT_FILENAME_PREFIX = "mergedFile_";
    private PerfStatMergeHisFileLayout layout = new PerfStatMergeHisFileLayout();

    public PerfStatMergeHisFileDialog(Window parent) throws IsmException {
        super(parent, "", new IsmDialog.ECommonButton[]{IsmDialog.ECommonButton.Close});
        this.doUILayout();
        this.addHandler();
        this.setModal(true);
        this.setPreferredSize(new Dimension(520, 450));
        this.setTitle(HisResourceManager.getString("perfstat.history.taskWizard.mergeHistoryDataFile"));
        this.beforeShow();
        this.getRootPane().setDefaultButton(this.getButtonBy(IsmDialog.ECommonButton.Close));
        this.addWindowListener(this.getWindowListener());
        this.getButtonBy(IsmDialog.ECommonButton.Close).requestFocus();
    }

    private boolean doMergeFileTask(String destFileName) {
        List<HisPerfStatHisFileInfo> perfStatHisFileInfos = this.getSelectionFiles();
        PerfStatHisFileService.MergePerfStatHisFileTask task = new PerfStatHisFileService.MergePerfStatHisFileTask(destFileName, perfStatHisFileInfos);
        AsyncExcutor.execute((Frame)((Object)MainDialog.getDialog()), (boolean)true, (long)0L, (Callable[])new Callable[]{task});
        if (!task.isExecuteSucess()) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)("Merge performance file failed." + destFileName));
            }
            Exception exception = task.getException();
            DialogUtils.showErrorDialog((Window)((Object)this), (Throwable)exception);
            return false;
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)("Merge performance file successfully." + destFileName));
        }
        DialogUtils.showInfoDialog((JDialog)((Object)this), (String)HisResourceManager.getString("INFORMATION_SUCCESS_MSG"));
        return true;
    }

    protected void doCloseTask() {
        this.deleteTempPerfHisFile(this.layout.getTable().getAllRows());
        super.doCloseTask();
    }

    private void deleteTempPerfHisFile(List<TableRow> rows) {
        HisPerfStatHisFileInfo tmpFile = null;
        for (TableRow tableRow : rows) {
            if (!(tableRow.getUserObject() instanceof HisPerfStatHisFileInfo)) continue;
            try {
                tmpFile = (HisPerfStatHisFileInfo)tableRow.getUserObject();
                PerfStatUtils.deleteTempPerfHisFile(tmpFile);
                if (!LOGGER.isInfoEnabled()) continue;
                LOGGER.info((Object)("delete performance temporary file: " + tmpFile.getCompressedFileName() + " succeed."));
            }
            catch (Exception e) {
                LOGGER.error((Object)"delete performance temporary file fail.", (Throwable)e);
            }
        }
    }

    private void doUILayout() {
        this.layout.setBorder(UCD.createEmptyBorder());
        this.getDialogContentPane().add(this.layout);
    }

    private void addPerfStatHisFileInfos(List<HisPerfStatHisFileInfo> perfStatHisFileInfos) {
        DefaultTableRow tr = null;
        TimeZone timeZone = null;
        ArrayList<DefaultTableRow> list = new ArrayList<DefaultTableRow>();
        for (HisPerfStatHisFileInfo perfStatHisFileInfo : perfStatHisFileInfos) {
            tr = new DefaultTableRow(TableColumnNamesHolder.getMergeHistoryDataFileTableColNames().length, (Object)perfStatHisFileInfo, (Object)perfStatHisFileInfo.getFileName());
            double fileSize = Math.ceil((double)perfStatHisFileInfo.getCompressedSize() / 1024.0);
            timeZone = TimeZone.getDefault();
            tr.setValueAt(0, HisTools.removePath(perfStatHisFileInfo.getCompressedFileName()));
            tr.setValueAt(1, TimeUtil.gmtToString((long)perfStatHisFileInfo.getStartTime(), (TimeZone)timeZone));
            tr.setValueAt(2, TimeUtil.gmtToString((long)perfStatHisFileInfo.getEndTime(), (TimeZone)timeZone));
            tr.setValueAt(3, new IsmTableCell.NumberCell((Number)fileSize, Unit.DataUnit.KB));
            tr.setValueAt(4, new IsmTableCell.NumberCell((Number)(perfStatHisFileInfo.getPeriod() / 1000)));
            list.add(tr);
        }
        if (!list.isEmpty()) {
            this.layout.getTableModel().addRow(list);
            int start = this.layout.getTableModel().getRowIndex((TableRow)list.get(0));
            int end = this.layout.getTableModel().getRowIndex((TableRow)list.get(list.size() - 1));
            this.layout.getTable().addRowSelectionInterval(start, end);
        }
    }

    private void addHandler() {
        JButton addBtn = this.layout.getAddBtn();
        addBtn.addActionListener(this.getAddBtnListener());
        JButton removeBtn = this.layout.getRemoveBtn();
        removeBtn.addActionListener(this.getRemoveBtnListener());
        JButton browseBtn = this.layout.getMergeBtn();
        browseBtn.addActionListener(this.getMergeBtnListener());
        IsmTable table = this.layout.getTable();
        table.addListSelectionListener(this.getTableSelectListener(table));
    }

    private ActionListener getAddBtnListener() {
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String filterTGZ = "tgz";
                String filterBZ2 = "bz2";
                IsmFileChooser fileChooser = new IsmFileChooser(HisResourceManager.getString("PER_HIS_7"));
                fileChooser.setMultiSelectionEnabled(true);
                fileChooser.setAcceptAllFileFilterUsed(false);
                fileChooser.addFileFilter(new String[]{filterTGZ}, HisResourceManager.getString("PER_HIS_13") + "(." + filterTGZ + ')');
                fileChooser.addFileFilter(new String[]{filterBZ2}, HisResourceManager.getString("PER_HIS_13") + "(." + filterBZ2 + ")");
                fileChooser.setFileFilter(fileChooser.getChoosableFileFilters()[0]);
                if (fileChooser.showOpenDialog((Component)((Object)PerfStatMergeHisFileDialog.this)) != 0) {
                    return;
                }
                File[] files = fileChooser.getSelectedFiles();
                ThreadPoolManager.getInstance().execute((Runnable)new OpenFileThread(files));
            }
        };
        return listener;
    }

    private ActionListener getRemoveBtnListener() {
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String confirmation = HisResourceManager.getString("perf.prompt.removeHisDataFileConfirmation");
                int choice = DialogUtils.showYesNoDialog((Window)((Object)PerfStatMergeHisFileDialog.this), (String)confirmation).getValue();
                if (choice == 0) {
                    DefaultTableModel model = (DefaultTableModel)PerfStatMergeHisFileDialog.this.layout.getTable().getModel();
                    PerfStatMergeHisFileDialog.this.deleteTempPerfHisFile(PerfStatMergeHisFileDialog.this.layout.getTable().getMarkedRows());
                    model.removeRow(PerfStatMergeHisFileDialog.this.layout.getTable().getMarkedRows());
                }
            }
        };
        return listener;
    }

    private ActionListener getMergeBtnListener() {
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String filterTGZ = "tgz";
                String filterBZ2 = "bz2";
                IsmFileChooser fileChooser = new IsmFileChooser(HisResourceManager.getString("PERF_HS_SAVEFILE_SELECTFILE"));
                fileChooser.setAcceptAllFileFilterUsed(false);
                fileChooser.addFileFilter(new String[]{filterTGZ}, HisResourceManager.getString("PER_HIS_13") + "(." + filterTGZ + ')');
                fileChooser.addFileFilter(new String[]{filterBZ2}, HisResourceManager.getString("PER_HIS_13") + "(." + filterBZ2 + ')');
                fileChooser.setDefaultFileName(PerfStatMergeHisFileDialog.DEFAULT_FILENAME_PREFIX + System.currentTimeMillis());
                fileChooser.setFileFilter(fileChooser.getChoosableFileFilters()[0]);
                if (fileChooser.showSaveDialog((Component)((Object)PerfStatMergeHisFileDialog.this)) != 0) {
                    return;
                }
                File aFile = fileChooser.getSelectedFile();
                if (null == aFile) {
                    return;
                }
                String filePath = aFile.getAbsolutePath().trim();
                if (!fileChooser.withFileType(aFile.getName()).booleanValue()) {
                    filePath = filePath + "." + fileChooser.getSelectedFileType()[0];
                }
                PerfStatMergeHisFileDialog.this.doMergeFileTask(filePath);
            }
        };
        return listener;
    }

    private ListSelectionListener getTableSelectListener(final IsmTable table) {
        ListSelectionListener listener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                JButton removeBtn = PerfStatMergeHisFileDialog.this.layout.getRemoveBtn();
                JButton mergeBtn = PerfStatMergeHisFileDialog.this.layout.getMergeBtn();
                if (table.getMarkedRows().size() > 0) {
                    removeBtn.setEnabled(true);
                } else {
                    removeBtn.setEnabled(false);
                }
                if (table.getMarkedRows().size() >= 2) {
                    mergeBtn.setEnabled(true);
                } else {
                    mergeBtn.setEnabled(false);
                }
            }
        };
        return listener;
    }

    private List<HisPerfStatHisFileInfo> getSelectionFiles() {
        ArrayList<HisPerfStatHisFileInfo> files = new ArrayList<HisPerfStatHisFileInfo>(0);
        List rows = this.layout.getTable().getMarkedRows();
        for (TableRow tableRow : rows) {
            files.add((HisPerfStatHisFileInfo)tableRow.getUserObject());
        }
        return files;
    }

    protected String getHelpKey() {
        return "monitor_amalgamate_old_performance";
    }

    private WindowListener getWindowListener() {
        WindowListener lis = new WindowListener(){

            @Override
            public void windowClosing(WindowEvent e) {
                PerfStatMergeHisFileDialog.this.doCloseTask();
            }

            @Override
            public void windowOpened(WindowEvent e) {
            }

            @Override
            public void windowIconified(WindowEvent e) {
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
            }

            @Override
            public void windowClosed(WindowEvent e) {
            }

            @Override
            public void windowActivated(WindowEvent e) {
            }
        };
        return lis;
    }

    class OpenFileThread
    implements Runnable {
        private File[] files;

        public OpenFileThread(File[] files) {
            this.files = files;
        }

        @Override
        public void run() {
            PerfStatHisFileService.QueryPerfStatHisFileInfoTask task = new PerfStatHisFileService.QueryPerfStatHisFileInfoTask(this.files);
            AsyncExcutor.execute((Frame)((Object)MainDialog.getDialog()), (boolean)true, (long)0L, (Callable[])new Callable[]{task});
            if (!task.isExecuteSucess()) {
                for (File file : this.files) {
                    if (!LOGGER.isInfoEnabled()) continue;
                    LOGGER.info((Object)("add performance temporary file:" + FilesUtil.getCanonicalPath((File)file) + " failed"));
                }
                Exception exception = task.getException();
                DialogUtils.showErrorDialog((Window)((Object)PerfStatMergeHisFileDialog.this), (Throwable)exception);
                return;
            }
            for (File file : this.files) {
                if (!LOGGER.isInfoEnabled()) continue;
                LOGGER.info((Object)("add performance temporary file:" + FilesUtil.getCanonicalPath((File)file) + " succeed"));
            }
            List perfStatHisFileInfos = (List)task.getExecuteResult();
            PerfStatMergeHisFileDialog.this.addPerfStatHisFileInfos(perfStatHisFileInfos);
        }
    }
}

