/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.xve.monitor.perfstat;

import com.huawei.ism.common.resourcemanager.HisResourceManager;
import com.huawei.ism.tool.base.utils.SceneUtils;
import com.huawei.ism.tool.framework.platform.common.data.UserOpTaskResult;
import com.huawei.ism.tool.service.common.ToolThreadFactory;
import com.huawei.ism.ui.swing.IsmDirChooser;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.dialog.HisProgressDialog;
import com.huawei.ism.ui.swing.dialog.WarningDialog;
import com.huawei.ism.ui.templets.IsmDialog;
import com.huawei.ism.util.SwingUtil;
import com.huawei.ism.util.UCD;
import com.huawei.ism.util.Utils;
import com.huawei.sftp.WorkBatchloadSftp;
import com.huawei.xve.monitor.perfstat.ExploreButtonListener;
import com.huawei.xve.monitor.perfstat.WorkloadBatchExportLayout;
import com.huawei.xve.monitor.perfstat.WorkloadBatchPraseNew;
import com.huawei.xve.utils.ConnManager;
import com.huawei.xve.utils.DeviceInfo;
import com.huawei.xve.utils.FileUtil;
import com.huawei.xve.utils.HisUserOpToolData;
import com.huawei.xve.utils.QuerInfo;
import com.huawei.xve.utils.UserBehaviorUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JDialog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkloadBatchExportDialog
extends IsmDialog {
    private static final Logger log = LoggerFactory.getLogger(WorkloadBatchExportDialog.class);
    protected static final String NODE_ID = HisResourceManager.getString("WORKLOAD_NODE_ID");
    protected static final String NODE_RESULT = HisResourceManager.getString("WORKLOAD_NODE_RESULT");
    private static AtomicBoolean isAtomicExport = new AtomicBoolean(false);
    private final List<String> deviceIDList;
    private WorkloadBatchExportLayout layout = null;
    private String errorType;
    private File local = null;
    private Integer errorTimes;
    private Thread export;
    private Thread prase;
    private int exportCounts = 1;
    private int praseCounts = 1;
    private boolean prasing = false;
    private static AtomicBoolean dialogShow = new AtomicBoolean(true);
    private String filePath = null;
    private String filePathWork = null;
    private boolean isExportMaxCounts = false;
    private WorkloadBatchPraseNew batchPraseWindow;

    public WorkloadBatchExportDialog(List<String> deviceIDList, Window parent) {
        super(parent, "", new IsmDialog.ECommonButton[]{IsmDialog.ECommonButton.Close});
        this.deviceIDList = deviceIDList;
        this.doUILayout();
        this.initStates();
        this.initFeliePath();
        this.createThreads();
        this.addHandler();
        this.setResizable(false);
        this.setModal(true);
        this.pack();
        this.initExportCounts();
        this.setSize(new Dimension(520, 500));
        SwingUtil.putParentCenter((Window)((Object)this), (Window)parent);
        SwingUtil.setCloseWhenEscKeyPressed((JDialog)((Object)this));
        this.setTitle(Utils.transferStringToUpper((String)HisResourceManager.getString("WORKLOAD-BATCHDATAFILEMGMT-TITLE")));
        this.getRootPane().setDefaultButton(null);
        this.addWindowListener(new WindowListener(){

            @Override
            public void windowOpened(WindowEvent e) {
            }

            @Override
            public void windowIconified(WindowEvent e) {
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
            }

            @Override
            public void windowClosing(WindowEvent e) {
                dialogShow.compareAndSet(true, false);
                WorkloadBatchExportDialog.this.batchPraseWindow.setDialogShow(false);
            }

            @Override
            public void windowClosed(WindowEvent e) {
            }

            @Override
            public void windowActivated(WindowEvent e) {
            }
        });
    }

    private void initFeliePath() {
        if (SceneUtils.isScene()) {
            this.filePath = QuerInfo.getSceneCollectDir();
            this.local = new File(this.filePath);
        }
    }

    private void initStates() {
        dialogShow.compareAndSet(false, true);
    }

    public void doCloseTask() {
        dialogShow.compareAndSet(true, false);
        this.batchPraseWindow.setDialogShow(false);
        this.setVisible(false);
        this.dispose();
    }

    private void createThreads() {
        this.prase = ToolThreadFactory.newDefaultThread((Runnable)this.batchPraseWindow);
        this.export = ToolThreadFactory.newDefaultThread((Runnable)new Runnable(){

            @Override
            public void run() {
                DeviceInfo deviceInf = ConnManager.getDeviceInfo(WorkloadBatchExportDialog.this.layout.getSelectedDeviceID());
                int errCount = 0;
                while (dialogShow.get()) {
                    errCount = WorkloadBatchExportDialog.this.exportWorkLoad(deviceInf, errCount);
                    WorkloadBatchExportDialog.this.sleepTwoSeconds(deviceInf);
                }
            }
        });
    }

    private int exportWorkLoad(DeviceInfo deviceInf, int errCount) {
        while (isAtomicExport.get()) {
            if (this.local.getUsableSpace() / 0x100000L < 512L) {
                DialogUtils.showErrorDialog((JDialog)((Object)this.getWindow()), (String)HisResourceManager.getString("EXPORT_FILE.TXT.SPACE"));
                this.layout.getSaveToBtn().setEnabled(true);
                isAtomicExport.compareAndSet(true, false);
                this.changeEnabledToTrue();
                this.layout.getFilePraseBtn().setEnabled(true);
                errCount = 0;
                UserBehaviorUtil.recordUserOpData(deviceInf, UserOpTaskResult.FAILED);
                break;
            }
            WorkBatchloadSftp wls = new WorkBatchloadSftp(ConnManager.getDeviceInfo(this.getCurrentDeviceID()), this.getWindow(), this.batchPraseWindow);
            HisProgressDialog progressDialog = new HisProgressDialog((Window)((Object)this.getWindow()));
            this.wait4Query(progressDialog, wls);
            if (!wls.isWrong() && wls.isFinished()) {
                log.info("start to save file to local path.");
                this.doDown(wls);
                if (this.isExportMaxCounts) {
                    DialogUtils.showErrorDialog((JDialog)((Object)this.getWindow()), (String)HisResourceManager.getString("EXPORT_FILE.TXT.EXPORTMAXCOUNTS"));
                    this.layout.getSaveToBtn().setEnabled(true);
                    isAtomicExport.compareAndSet(true, false);
                    this.changeEnabledToTrue();
                    this.layout.getFilePraseBtn().setEnabled(true);
                    errCount = 0;
                    break;
                }
                UserBehaviorUtil.recordUserOpData(deviceInf, UserOpTaskResult.SUCCESS);
            } else {
                errCount = this.doErrorSolution(wls, deviceInf, errCount);
            }
            this.sleepTwoSeconds(deviceInf);
        }
        return errCount;
    }

    private void sleepTwoSeconds(DeviceInfo deviceInf) {
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException e) {
            UserBehaviorUtil.recordUserOpData(deviceInf, UserOpTaskResult.FAILED);
            log.error("actionPerformed thread sleep failed.", (Throwable)e);
        }
    }

    private int doErrorSolution(WorkBatchloadSftp wls, DeviceInfo deviceInf, int errCount) {
        if (null != wls.getErrMsg() && !wls.getErrMsg().equals(HisResourceManager.getString("WORKLOAD_ERROR_1077949118"))) {
            if (null == this.errorType) {
                this.errorType = wls.getErrMsg();
                this.errorTimes = 0;
            }
            errCount = this.doRunningError(deviceInf, errCount, wls);
        } else {
            errCount = 0;
            this.layout.setErrorMessage("");
        }
        return errCount;
    }

    private int doRunningError(DeviceInfo deviceInf, int errCount, WorkBatchloadSftp wls) {
        if (wls.getErrMsg().equals(HisResourceManager.getString("WORKLOAD_ERROR_1077949108"))) {
            if (++errCount <= 10) {
                this.layout.setErrorMessage(HisResourceManager.getString("EXPORT_FILE.TXT.EXPORTBUSYING"));
                try {
                    Thread.sleep(60000L);
                }
                catch (InterruptedException e) {
                    UserBehaviorUtil.recordUserOpData(deviceInf, UserOpTaskResult.FAILED);
                    log.error("actionPerformed thread sleep failed.", (Throwable)e);
                }
            } else {
                DialogUtils.showErrorDialog((JDialog)((Object)this.getWindow()), (String)wls.getErrMsg());
                this.layout.getSaveToBtn().setEnabled(true);
                isAtomicExport.compareAndSet(true, false);
                this.changeEnabledToTrue();
                this.layout.getFilePraseBtn().setEnabled(true);
                errCount = 0;
                isAtomicExport.getAndSet(false);
            }
        } else if (wls.getErrMsg().equals(this.errorType)) {
            errCount = 0;
            this.layout.setErrorMessage("");
            this.errorTimes = this.errorTimes + 1;
            if (this.errorTimes >= 4) {
                DialogUtils.showErrorDialog((JDialog)((Object)this.getWindow()), (String)wls.getErrMsg());
                this.layout.getSaveToBtn().setEnabled(true);
                isAtomicExport.compareAndSet(true, false);
                this.changeEnabledToTrue();
                this.layout.getFilePraseBtn().setEnabled(true);
                UserBehaviorUtil.recordUserOpData(deviceInf, UserOpTaskResult.FAILED);
                isAtomicExport.getAndSet(false);
            }
        } else {
            errCount = 0;
            this.layout.setErrorMessage("");
            this.errorType = wls.getErrMsg();
            this.errorTimes = 0;
        }
        return errCount;
    }

    private void initExportCounts() {
        this.layout.setExportCount("0");
        this.errorType = null;
        this.errorTimes = 0;
    }

    private void addHandler() {
        this.layout.getSaveToBtn().addActionListener(this.getSaveListener());
        this.layout.getStopToBtn().addActionListener(this.getStopListener());
        this.layout.getSaveFileBtn().addActionListener(this.getSaveFileListener());
        this.layout.getFilePraseBtn().addActionListener(this.getFilePraseListener());
        this.layout.getExploreBtn().addActionListener(new ExploreButtonListener());
    }

    private ActionListener getFilePraseListener() {
        ActionListener lis = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (WorkloadBatchExportDialog.this.prasing) {
                    DialogUtils.showInfoDialog((JDialog)((Object)WorkloadBatchExportDialog.this.getWindow()), (String)HisResourceManager.getString("PARASE_FILE.TXT.PRASING"));
                    return;
                }
                WorkloadBatchExportDialog.this.layout.getSaveFileBtn().setEnabled(false);
                WorkloadBatchExportDialog.this.layout.getSaveToBtn().setEnabled(false);
                WorkloadBatchExportDialog.this.layout.getStopToBtn().setEnabled(false);
                WorkloadBatchExportDialog.this.prasing = true;
                WorkloadBatchExportDialog.this.layout.setAnalysisCount("0");
                if (WorkloadBatchExportDialog.this.praseCounts == 1) {
                    WorkloadBatchExportDialog.this.prase.start();
                }
                WorkloadBatchExportDialog.this.praseCounts = WorkloadBatchExportDialog.this.praseCounts + 1;
            }
        };
        return lis;
    }

    private ActionListener getSaveFileListener() {
        ActionListener lis = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WarningDialog choose;
                String title = HisResourceManager.getString("EXPORT_ARCHIVE");
                boolean isExit = false;
                WorkloadBatchExportDialog.this.local = IsmDirChooser.showDialog((Component)((Object)WorkloadBatchExportDialog.this), (String)title);
                if (null == WorkloadBatchExportDialog.this.local && (choose = DialogUtils.showYesNoDialog((Window)((Object)WorkloadBatchExportDialog.this.getWindow()), (String)HisResourceManager.getString("WORKLOAD_EXIT_WARN"))).getValue() == 0) {
                    isExit = true;
                }
                if (isExit) {
                    log.warn("user cancle this export process!");
                    return;
                }
                if (WorkloadBatchExportDialog.this.local == null) {
                    return;
                }
                String localPath = "";
                try {
                    localPath = WorkloadBatchExportDialog.this.local.getCanonicalPath();
                }
                catch (IOException e1) {
                    log.error("get localPath error.", (Throwable)e1);
                }
                if (!WorkloadBatchExportDialog.this.local.exists() && !WorkloadBatchExportDialog.this.local.mkdirs()) {
                    DialogUtils.showErrorDialog((JDialog)((Object)WorkloadBatchExportDialog.this.getWindow()), (String)("create " + localPath + " failed"));
                    return;
                }
                WorkloadBatchExportDialog.this.filePath = localPath;
                WorkloadBatchExportDialog.this.layout.getSaveToBtn().setEnabled(true);
                WorkloadBatchExportDialog.this.layout.getStopToBtn().setEnabled(true);
                WorkloadBatchExportDialog.this.layout.getFilePraseBtn().setEnabled(true);
            }
        };
        return lis;
    }

    private ActionListener getSaveListener() {
        ActionListener lis = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DeviceInfo deviceInf = ConnManager.getDeviceInfo(WorkloadBatchExportDialog.this.layout.getSelectedDeviceID());
                deviceInf.getHisUserData().setExportDataType(HisUserOpToolData.ExportDataTypeEnum.EXPORTWORKLOADDATA.getValue());
                deviceInf.getHisUserData().setTaskStartTime(System.currentTimeMillis());
                deviceInf.getHisUserData().setTaskResult(UserOpTaskResult.FAILED);
                if (WorkloadBatchExportDialog.this.isExportMaxCounts) {
                    DialogUtils.showErrorDialog((JDialog)((Object)WorkloadBatchExportDialog.this.getWindow()), (String)HisResourceManager.getString("EXPORT_FILE.TXT.EXPORTMAXCOUNTS"));
                    WorkloadBatchExportDialog.this.layout.getSaveToBtn().setEnabled(true);
                    isAtomicExport.compareAndSet(true, false);
                    WorkloadBatchExportDialog.this.changeEnabledToTrue();
                    WorkloadBatchExportDialog.this.layout.getFilePraseBtn().setEnabled(true);
                    UserBehaviorUtil.recordUserOpData(deviceInf, UserOpTaskResult.FAILED);
                    return;
                }
                WorkloadBatchExportDialog.this.layout.setErrorMessage("");
                WorkloadBatchExportDialog.this.layout.getSaveFileBtn().setEnabled(false);
                WorkloadBatchExportDialog.this.layout.getSaveToBtn().setEnabled(false);
                WorkloadBatchExportDialog.this.layout.getFilePraseBtn().setEnabled(false);
                isAtomicExport.getAndSet(true);
                WorkloadBatchExportDialog.this.initExportCounts();
                WorkloadBatchExportDialog.this.filePathWork = WorkloadBatchExportDialog.this.filePath + File.separator + "HistoryPerstat" + File.separator + "Workload" + File.separator + FileUtil.formatIpForPath(deviceInf.getIp());
                File file = new File(WorkloadBatchExportDialog.this.filePathWork);
                if (!file.exists() && !file.mkdirs()) {
                    log.info("{},the file already exists", (Object)WorkloadBatchExportDialog.this.filePathWork);
                    DialogUtils.showErrorDialog((JDialog)((Object)WorkloadBatchExportDialog.this.getWindow()), (String)(HisResourceManager.getString("CREATE") + WorkloadBatchExportDialog.this.filePathWork + HisResourceManager.getString("BATCH_DELETE_CONSISTENT_DIALOG_FAILED")));
                    return;
                }
                if (WorkloadBatchExportDialog.this.exportCounts == 1) {
                    WorkloadBatchExportDialog.this.export.start();
                }
                WorkloadBatchExportDialog.this.exportCounts = WorkloadBatchExportDialog.this.exportCounts + 1;
            }
        };
        return lis;
    }

    private ActionListener getStopListener() {
        ActionListener lis = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DeviceInfo deviceInf = ConnManager.getDeviceInfo(WorkloadBatchExportDialog.this.layout.getSelectedDeviceID());
                deviceInf.getHisUserData().setExportDataType(HisUserOpToolData.ExportDataTypeEnum.EXPORTWORKLOADDATA.getValue());
                WorkloadBatchExportDialog.this.changeEnabledToTrue();
                WorkloadBatchExportDialog.this.layout.getFilePraseBtn().setEnabled(true);
                WorkloadBatchExportDialog.this.layout.getSaveToBtn().setEnabled(true);
                isAtomicExport.getAndSet(false);
                DialogUtils.showInfoDialog((JDialog)((Object)WorkloadBatchExportDialog.this.getWindow()), (String)HisResourceManager.getString("EXPORT_FILE.TXT.STOPEXPORTING"));
                try {
                    int downcount = Integer.valueOf(WorkloadBatchExportDialog.this.layout.getDownloadCount().getText());
                    if (downcount > 0) {
                        UserBehaviorUtil.recordUserOpData(deviceInf, UserOpTaskResult.SUCCESS);
                    } else {
                        UserBehaviorUtil.recordUserOpData(deviceInf, UserOpTaskResult.FAILED);
                    }
                }
                catch (NumberFormatException e1) {
                    log.error("NumberFormatException");
                }
            }
        };
        return lis;
    }

    protected void doDown(WorkBatchloadSftp wls) {
        wls.sendBatchExportDownCMD(this.filePathWork, this.getWindow(), this.layout);
    }

    protected void wait4Query(HisProgressDialog progressDialog, WorkBatchloadSftp wls) {
        try {
            wls.batchPkg();
        }
        catch (Exception ep) {
            log.error("pkgLogFile failed.", (Throwable)ep);
        }
    }

    private void doUILayout() {
        List<String> deviceIDLists = this.getDeviceIDList();
        this.layout = new WorkloadBatchExportLayout(deviceIDLists);
        this.layout.setBorder(UCD.createEmptyBorder());
        this.getDialogContentPane().add(this.layout);
        this.batchPraseWindow = new WorkloadBatchPraseNew(this.getWindow(), this.layout);
    }

    private List<String> getDeviceIDList() {
        return this.deviceIDList;
    }

    private WorkloadBatchExportDialog getWindow() {
        return this;
    }

    public String getCurrentDeviceID() {
        return this.layout.getSelectedDeviceID();
    }

    public Boolean getIsExport() {
        return isAtomicExport.get();
    }

    public boolean isDialogShow() {
        return dialogShow.get();
    }

    public void setExportMaxCounts(boolean isExportMaxCountsParam) {
        this.isExportMaxCounts = isExportMaxCountsParam;
    }

    public boolean isPrasing() {
        return this.prasing;
    }

    public void setPrasing(boolean isPrasingParam) {
        this.prasing = isPrasingParam;
    }

    private void changeEnabledToTrue() {
        if (!SceneUtils.isScene()) {
            this.layout.getSaveFileBtn().setEnabled(true);
        }
    }
}

