/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.xve.monitor.perfstat;

import com.huawei.ism.common.resourcemanager.HisResourceManager;
import com.huawei.ism.tool.base.utils.SceneUtils;
import com.huawei.ism.ui.swing.LayoutConstants;
import com.huawei.ism.ui.swing.plaf.IsmFontFactory;
import com.huawei.ism.util.Pair;
import com.huawei.ism.util.UCD;
import com.huawei.xve.utils.ConnManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public class WorkloadBatchExportLayout
extends JPanel {
    private JComboBox selectedDeviceComboBox = null;
    private List<String> deviceIDList;
    private JLabel descLabel;
    private JLabel downloadCount;
    private JLabel praseCount;
    private JLabel errorMessageJL;
    private JButton saveToBtn;
    private JButton stopToBtn;
    private JButton saveFileBtn;
    private JButton filePraseBtn;
    private JButton exploreBtn;
    private String errorMessage = "";
    private String exportCount = "0";
    private String analysisCount = "0";
    private Box progress = null;

    public WorkloadBatchExportLayout(List<String> deviceIDList) {
        this.deviceIDList = deviceIDList;
        this.doLayoutUI();
        this.setDeviceInfo();
    }

    public String getExportCount() {
        return this.exportCount;
    }

    public String getAnalysisCount() {
        return this.analysisCount;
    }

    public void setExportCount(String exportCount) {
        this.downloadCount.setText(exportCount);
        this.exportCount = exportCount;
    }

    public JLabel getDownloadCount() {
        return this.downloadCount;
    }

    public void setDownloadCount(JLabel downloadCount) {
        this.downloadCount = downloadCount;
    }

    public void setAnalysisCount(String analysisCount) {
        this.praseCount.setText(analysisCount);
        this.analysisCount = analysisCount;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessageJL.setText(errorMessage);
        this.errorMessage = errorMessage;
    }

    public JButton getSaveToBtn() {
        return this.saveToBtn;
    }

    public JButton getStopToBtn() {
        return this.stopToBtn;
    }

    public JButton getSaveFileBtn() {
        return this.saveFileBtn;
    }

    public JButton getFilePraseBtn() {
        return this.filePraseBtn;
    }

    public JButton getExploreBtn() {
        return this.exploreBtn;
    }

    public Box getProgress() {
        return this.progress;
    }

    private void doLayoutUI() {
        if (SceneUtils.isScene()) {
            this.createComponentsScene();
        } else {
            this.createComponents();
        }
        this.layoutComponents();
    }

    private void createComponents() {
        this.selectedDeviceComboBox = new JComboBox();
        this.descLabel = new JLabel(HisResourceManager.getString("EXPORT-WORKLOAD-DESC"));
        this.saveToBtn = new JButton(HisResourceManager.getString("EXPORT_FILE.TXT.EXPORT"));
        this.saveToBtn.setEnabled(false);
        this.stopToBtn = new JButton(HisResourceManager.getString("EXPORT_FILE.TXT.STOPEXPORT"));
        this.stopToBtn.setEnabled(false);
        this.saveFileBtn = new JButton(HisResourceManager.getString("EXPORT_FILE.TXT.SAVEFILEPATH"));
        this.saveFileBtn.setEnabled(true);
        this.filePraseBtn = new JButton(HisResourceManager.getString("EXPORT_FILE.TXT.FILEPRASE"));
        this.filePraseBtn.setEnabled(false);
        this.exploreBtn = new JButton(HisResourceManager.getString("EXPORT_FILE.TXT.EXPLORE"));
        this.exploreBtn.setEnabled(true);
    }

    private void createComponentsScene() {
        this.selectedDeviceComboBox = new JComboBox();
        this.descLabel = new JLabel(HisResourceManager.getString("EXPORT-WORKLOAD-DESC"));
        this.saveToBtn = new JButton(HisResourceManager.getString("EXPORT_FILE.TXT.EXPORT"));
        this.saveToBtn.setEnabled(true);
        this.stopToBtn = new JButton(HisResourceManager.getString("EXPORT_FILE.TXT.STOPEXPORT"));
        this.stopToBtn.setEnabled(true);
        this.saveFileBtn = new JButton(HisResourceManager.getString("EXPORT_FILE.TXT.SAVEFILEPATH"));
        this.saveFileBtn.setEnabled(false);
        this.filePraseBtn = new JButton(HisResourceManager.getString("EXPORT_FILE.TXT.FILEPRASE"));
        this.filePraseBtn.setEnabled(false);
        this.exploreBtn = new JButton(HisResourceManager.getString("EXPORT_FILE.TXT.EXPLORE"));
        this.exploreBtn.setEnabled(true);
    }

    private void layoutComponents() {
        UCD.setJComponentWidth((JComponent)this.selectedDeviceComboBox, (int)250);
        JLabel arrayLabel = new JLabel(HisResourceManager.getString("LOGICALARRAYSPROPERTYPANE.ARRAYNAME") + ":");
        arrayLabel.setFont(IsmFontFactory.getBold12Font());
        Box deviceComponent = UCD.buildHBoxLeft((int)0, (Component[])new Component[]{arrayLabel, this.selectedDeviceComboBox, Box.createGlue()});
        deviceComponent.setBorder(UCD.getCompoundBorder((Border)UCD.createTableTitleBorder((String)HisResourceManager.getString("ABSTRACTTABBEDPROPERTYPANE_DEVICEINFO")), (Border)new EmptyBorder(4, 0, 8, 0)));
        this.downloadCount = new JLabel(this.exportCount);
        Box files1 = UCD.buildHBoxLeft((int)0, (Component[])new Component[]{new JLabel(HisResourceManager.getString("EXPORT-FILE.TXT.DOWNLOAD_FILES") + ":"), this.downloadCount});
        this.praseCount = new JLabel(this.analysisCount);
        Box files2 = UCD.buildHBoxLeft((int)0, (Component[])new Component[]{new JLabel(HisResourceManager.getString("EXPORT-FILE.TXT.PRASE_FILES") + ":"), this.praseCount});
        this.errorMessageJL = new JLabel(this.errorMessage);
        Box box = SceneUtils.isScene() ? UCD.buildHBoxRight((Component[])new Component[]{this.saveToBtn, this.stopToBtn, this.filePraseBtn, this.exploreBtn}) : UCD.buildHBoxRight((Component[])new Component[]{this.saveFileBtn, this.saveToBtn, this.stopToBtn, this.filePraseBtn, this.exploreBtn});
        Box wholeBox = UCD.buildVBoxTop((int)LayoutConstants.LINE_MARGIN_PIXEL, (Component[])new Component[]{UCD.buildHBoxLeft((Component[])new Component[]{this.descLabel}), deviceComponent, UCD.buildHBoxRight((Component[])new Component[]{files1, files2}), UCD.buildHBoxCentert((Component[])new Component[]{this.errorMessageJL}), box});
        this.setLayout(new BorderLayout());
        this.add((Component)wholeBox, "Center");
    }

    private void setDeviceInfo() {
        Pair arrayPair = null;
        ArrayList<Pair> temporaryList = new ArrayList<Pair>();
        for (String deviceID : this.deviceIDList) {
            arrayPair = new Pair((Object)deviceID, (Object)ConnManager.getDeviceName(deviceID));
            temporaryList.add(arrayPair);
        }
        Collections.sort(temporaryList, new Comparator<Pair<String, String>>(){

            @Override
            public int compare(Pair<String, String> o1, Pair<String, String> o2) {
                return ((String)o1.getValue()).compareTo((String)o2.getValue());
            }
        });
        for (Pair pair : temporaryList) {
            this.selectedDeviceComboBox.addItem(pair);
        }
    }

    public JComboBox getSelectedDeviceCombBox() {
        return this.selectedDeviceComboBox;
    }

    public String getSelectedDeviceID() {
        Pair selectedPair = (Pair)this.selectedDeviceComboBox.getSelectedItem();
        return (String)selectedPair.getKey();
    }
}

