/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.xve.monitor.perfstat;

import com.huawei.ftdsanalysis.analysis.iorecord.WorkloadParser;
import com.huawei.ism.common.resourcemanager.HisResourceManager;
import com.huawei.ism.tool.base.utils.SceneUtils;
import com.huawei.ism.tool.base.utils.ZipUtils;
import com.huawei.ism.ui.swing.dialog.HisDialogUtils;
import com.huawei.xve.monitor.perfstat.WorkloadBatchExportDialog;
import com.huawei.xve.monitor.perfstat.WorkloadBatchExportLayout;
import com.huawei.xve.utils.FileUtil;
import java.awt.Window;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.swing.JDialog;
import org.apache.log4j.Logger;

public class WorkloadBatchPraseNew
implements Runnable {
    private static final Logger LOGGER = Logger.getLogger(WorkloadBatchPraseNew.class);
    private boolean dialogShow = true;
    private List<List<Object>> errorMessageMap = new ArrayList<List<Object>>();
    private List<List<String>> praseMap = new ArrayList<List<String>>();
    private static final String ZIP = ".zip";
    private static final String VERSION_FILE = "version.nmap";
    private static final String FILEPATH = "/OSM/coffer_data/ftds/record/";
    private WorkloadBatchExportDialog window;
    private WorkloadBatchExportLayout layoutWindow;
    private static final String[] TITLE = new String[]{HisResourceManager.getString("WORKLOAD_PACKAGE_FAILED_NODE_ID"), HisResourceManager.getString("WORKLOAD_PACKAGE_FAILED_FAILREASON")};

    public WorkloadBatchPraseNew(WorkloadBatchExportDialog window, WorkloadBatchExportLayout layoutWindow) {
        this.window = window;
        this.layoutWindow = layoutWindow;
    }

    public void notify(List<String> praseList) {
        this.praseMap.add(praseList);
        if (this.praseMap.size() >= 10000) {
            this.window.setExportMaxCounts(true);
        }
    }

    @Override
    public void run() {
        while (this.window.isDialogShow()) {
            while (this.window.isPrasing()) {
                if (this.praseMap.isEmpty()) {
                    HisDialogUtils.showInfoDialog((JDialog)((Object)this.window), HisResourceManager.getString("PARASE_FILE.TXT.NOFILE"));
                    this.initButtons();
                    break;
                }
                this.initData();
                this.prase();
                this.postCheck();
                this.initButtons();
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                LOGGER.error((Object)"", (Throwable)e);
            }
        }
    }

    private void initData() {
        this.errorMessageMap.clear();
    }

    private void postCheck() {
        String columnNames = HisResourceManager.getString("WORKLOAD_PACKAGE_FAILED_MESSAGELIST");
        if (!this.errorMessageMap.isEmpty()) {
            HisDialogUtils.showMultiErrorDialog((Window)((Object)this.window), columnNames, TITLE, this.errorMessageMap);
        } else {
            HisDialogUtils.showInfoDialog((JDialog)((Object)this.window), HisResourceManager.getString("EXPORT_FILE.TXT.EXPORTSUCCESS"));
        }
    }

    private void prase() {
        while (!this.praseMap.isEmpty()) {
            ArrayList<Object> errorMessageList = new ArrayList<Object>();
            String source = this.praseMap.get(0).get(0);
            String[] sources = source.split("/");
            String sourcesPraseTime = sources[sources.length - 1].substring(0, 20);
            String dest = this.praseMap.get(0).get(1);
            String processTag = this.praseMap.get(0).get(2);
            this.praseMap.remove(0);
            String fileName = source.substring(source.lastIndexOf("/") + 1).trim();
            File file = new File(dest + File.separator + fileName);
            if (!file.exists()) {
                LOGGER.error((Object)String.format(Locale.ROOT, "File %s download failed.", fileName));
                errorMessageList.add(processTag);
                errorMessageList.add(fileName + HisResourceManager.getString("WORKLOAD_DOWNLOAD_FAILED"));
                this.errorMessageMap.add(errorMessageList);
                continue;
            }
            this.parseOneFile(dest, processTag, file, errorMessageList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseOneFile(String dest, String processTag, File file, List<Object> errorMessageList) {
        String tarDest = dest + File.separator + "temp_" + Thread.currentThread().getId() + "_" + System.currentTimeMillis();
        try {
            String csvDest = dest + File.separator + processTag;
            File destFile = new File(tarDest + FILEPATH);
            try {
                ZipUtils.decompressTarGzFile((File)file, (String)tarDest);
            }
            catch (Exception e) {
                LOGGER.error((Object)String.format(Locale.ROOT, "unzip %s to %s failed.", file, tarDest), (Throwable)e);
                errorMessageList.add(processTag);
                errorMessageList.add(file.getName() + HisResourceManager.getString("WORKLOAD_DOWNLOAD_FAILED"));
                this.errorMessageMap.add(errorMessageList);
                FileUtil.deleteDir(tarDest);
                return;
            }
            File[] listFiles = destFile.listFiles();
            File mapFile = new File(destFile + File.separator + VERSION_FILE);
            if (!mapFile.exists()) {
                LOGGER.error((Object)String.format(Locale.ROOT, "%s doesn't contain Map file\uff1a%s", file.getCanonicalPath(), VERSION_FILE));
                return;
            }
            if (listFiles == null) {
                return;
            }
            WorkloadParser.parse(destFile, csvDest, processTag);
            if (WorkloadParser.isParseExcption()) {
                errorMessageList.add(processTag);
                errorMessageList.add(HisResourceManager.getString("WORKLOAD_PARSE_FAILED_RESULT"));
                this.errorMessageMap.add(errorMessageList);
                return;
            }
            String analysisCount = String.valueOf(Integer.parseInt(this.layoutWindow.getAnalysisCount()) + 1);
            this.layoutWindow.setAnalysisCount(analysisCount);
        }
        catch (Exception e) {
            LOGGER.error((Object)"parse file occused a problem.", (Throwable)e);
        }
        finally {
            FileUtil.deleteDir(tarDest);
        }
    }

    private void initButtons() {
        if (!SceneUtils.isScene()) {
            this.layoutWindow.getSaveFileBtn().setEnabled(true);
        }
        this.layoutWindow.getSaveToBtn().setEnabled(true);
        this.layoutWindow.getStopToBtn().setEnabled(true);
        this.window.setPrasing(false);
        this.window.setExportMaxCounts(false);
    }

    public boolean isDialogShow() {
        return this.dialogShow;
    }

    public void setDialogShow(boolean isDialogShowParam) {
        this.dialogShow = isDialogShowParam;
    }
}

