/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.xve.monitor.perfstat;

import com.huawei.ism.common.resourcemanager.HisResourceManager;
import com.huawei.ism.exception.IsmException;
import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.tool.base.utils.SceneUtils;
import com.huawei.ism.tool.framework.platform.common.data.UserOpTaskResult;
import com.huawei.ism.ui.swing.IsmDirChooser;
import com.huawei.ism.ui.swing.dialog.HisDialogUtils;
import com.huawei.ism.ui.swing.dialog.HisProgressDialog;
import com.huawei.ism.ui.swing.dialog.HisWarningDialog;
import com.huawei.ism.ui.templets.IsmDialog;
import com.huawei.ism.util.SwingUtil;
import com.huawei.ism.util.UCD;
import com.huawei.ism.util.Utils;
import com.huawei.sftp.JProgressBarNew;
import com.huawei.sftp.WorkloadSftp;
import com.huawei.xve.monitor.perfstat.ExploreButtonListener;
import com.huawei.xve.monitor.perfstat.WorkloadExportLayout;
import com.huawei.xve.utils.ConnManager;
import com.huawei.xve.utils.DeviceInfo;
import com.huawei.xve.utils.FileUtil;
import com.huawei.xve.utils.HisUserOpToolData;
import com.huawei.xve.utils.QuerInfo;
import com.huawei.xve.utils.UserBehaviorUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.swing.JDialog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkloadExportDialog
extends IsmDialog {
    private static final Logger log = LoggerFactory.getLogger(WorkloadExportDialog.class);
    protected static final String VERSION_FILE = "version.nmap";
    protected static final String SYSTEM_FILE = "system.map";
    protected static final String FILEPATH = "/OSM/coffer_data/ftds/record/";
    protected static final String ZIP = ".zip";
    protected static final String TGZ = "/*.tgz";
    protected static final String NODE_ID = HisResourceManager.getString("WORKLOAD_NODE_ID");
    protected static final String NODE_RESULT = HisResourceManager.getString("WORKLOAD_NODE_RESULT");
    private static final long serialVersionUID = -4154125323501397772L;
    private final List<String> deviceIDList;
    private WorkloadExportLayout layout = null;
    private String deviceIP = null;
    private static int custWidth = 220;

    public WorkloadExportDialog(List<String> deviceIDList, Window parent) throws IsmException {
        super(parent, "", new IsmDialog.ECommonButton[]{IsmDialog.ECommonButton.Close});
        this.deviceIDList = deviceIDList;
        this.doUILayout();
        this.addHandler();
        this.setResizable(false);
        this.setModal(true);
        this.pack();
        this.setSize(new Dimension(520, 500));
        SwingUtil.putParentCenter((Window)((Object)this), (Window)parent);
        SwingUtil.setCloseWhenEscKeyPressed((JDialog)((Object)this));
        this.setTitle(Utils.transferStringToUpper((String)HisResourceManager.getString("WORKLOAD-DATAFILEMGMT-TITLE")));
        this.getRootPane().setDefaultButton(null);
    }

    private void doUILayout() {
        List<String> deviceIDLists = this.getDeviceIDList();
        this.layout = new WorkloadExportLayout(deviceIDLists);
        this.layout.setBorder(UCD.createEmptyBorder());
        this.getDialogContentPane().add(this.layout);
    }

    private List<String> getDeviceIDList() {
        return this.deviceIDList;
    }

    private WorkloadExportDialog getWindow() {
        return this;
    }

    private void addHandler() {
        this.layout.getSaveToBtn().addActionListener(this.getSaveListener());
        this.layout.getExploreBtn().addActionListener(new ExploreButtonListener());
        this.addSelectedDeviceListener();
    }

    private ActionListener getSaveListener() {
        ActionListener lis = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DeviceInfo deviceInf = ConnManager.getDeviceInfo(WorkloadExportDialog.this.layout.getSelectedDeviceID());
                WorkloadExportDialog.this.deviceIP = deviceInf.getIp();
                deviceInf.getHisUserData().setExportDataType(HisUserOpToolData.ExportDataTypeEnum.EXPORTWORKLOADDATA.getValue());
                deviceInf.getHisUserData().setTaskStartTime(System.currentTimeMillis());
                deviceInf.getHisUserData().setTaskResult(UserOpTaskResult.FAILED);
                WorkloadExportDialog.this.layout.getSaveToBtn().setEnabled(false);
                JProgressBarNew jp = WorkloadExportDialog.this.layout.getjProgress();
                WorkloadExportDialog.this.init(jp);
                WorkloadSftp wls = new WorkloadSftp(ConnManager.getDeviceInfo(WorkloadExportDialog.this.getCurrentDeviceID()), jp, WorkloadExportDialog.this.getWindow());
                HisProgressDialog progressDialog = new HisProgressDialog((Window)((Object)WorkloadExportDialog.this.getWindow()));
                progressDialog.getLable().setText(HisResourceManager.getString("PACKING_TEXT"));
                WorkloadExportDialog.this.wait4Query(progressDialog, wls);
                Map<String, String> failedNode = wls.getFailedNode();
                if (!failedNode.isEmpty()) {
                    this.showFailedNodes(failedNode);
                }
                if (wls.isWrong()) {
                    UserBehaviorUtil.recordUserOpData(deviceInf, UserOpTaskResult.FAILED);
                    HisDialogUtils.showErrorDialog((JDialog)((Object)WorkloadExportDialog.this.getWindow()), wls.getErrMsg());
                    WorkloadExportDialog.this.layout.getSaveToBtn().setEnabled(true);
                    jp.init();
                    return;
                }
                UserBehaviorUtil.recordUserOpData(deviceInf, UserOpTaskResult.SUCCESS);
                log.info("start to save file to local path.");
                WorkloadExportDialog.this.doDown(wls, jp);
            }

            private void showFailedNodes(Map<String, String> failedNode) {
                String[] title = new String[]{NODE_ID, NODE_RESULT};
                ArrayList<List<Object>> errMsgs = new ArrayList<List<Object>>();
                ArrayList<String> errMsg = null;
                Set<Map.Entry<String, String>> entrySet = failedNode.entrySet();
                for (Map.Entry<String, String> en : entrySet) {
                    errMsg = new ArrayList<String>();
                    errMsg.add(en.getKey());
                    errMsg.add(en.getValue());
                    errMsgs.add(errMsg);
                }
                HisDialogUtils.showMultiErrorDialog((Window)((Object)WorkloadExportDialog.this.getWindow()), HisResourceManager.getString("WORKLOAD_PACKAGE_FAILED_REASON"), title, errMsgs);
            }
        };
        return lis;
    }

    protected void wait4Query(HisProgressDialog progressDialog, final WorkloadSftp wls) {
        AsyncExcutor.execute((Window)((Object)progressDialog), (boolean)true, (long)0L, (Callable[])new Callable[]{new Callable<Integer>(){

            @Override
            public Integer call() {
                try {
                    wls.pkg();
                }
                catch (IsmException ep) {
                    log.error("pkgLogFile failed.", (Throwable)ep);
                }
                catch (Exception ep) {
                    log.error("pkgLogFile failed.", (Throwable)ep);
                }
                while (!(wls.isFinished() || wls.isWrong() || wls.getPkgPath().containsValue("not_download"))) {
                }
                return null;
            }
        }});
    }

    protected void doDown(WorkloadSftp wls, JProgressBarNew jp) {
        String title = HisResourceManager.getString("EXPORT_ARCHIVE");
        File local = null;
        File selectLocal = null;
        boolean isExit = false;
        while (!isExit && selectLocal == null) {
            HisWarningDialog choose;
            if (SceneUtils.isScene()) {
                String resultSaveDir = QuerInfo.getSceneCollectDir();
                selectLocal = new File(resultSaveDir);
            } else {
                selectLocal = IsmDirChooser.showDialog((Component)((Object)this), (String)title);
            }
            if (null != selectLocal || (choose = HisDialogUtils.showYesNoDialog((Window)((Object)this.getWindow()), HisResourceManager.getString("WORKLOAD_FIVE_MINS_WARM"))).getValue() != 0) continue;
            isExit = true;
        }
        if (isExit) {
            log.warn("user cancle this export process!");
            this.layout.getSaveToBtn().setEnabled(true);
            jp.init();
            return;
        }
        local = new File(selectLocal, "HistoryPerstat" + File.separator + "Workload" + File.separator + FileUtil.formatIpForPath(this.deviceIP));
        String localPath = "";
        try {
            localPath = local.getCanonicalPath();
        }
        catch (Exception e) {
            log.error("get path error.", (Throwable)e);
            return;
        }
        if (!local.exists() && !local.mkdirs()) {
            jp.init();
            HisDialogUtils.showErrorDialog((JDialog)((Object)this.getWindow()), HisResourceManager.getString("CREATE") + localPath + HisResourceManager.getString("BATCH_DELETE_CONSISTENT_DIALOG_FAILED"));
            this.layout.getSaveToBtn().setEnabled(true);
            return;
        }
        wls.sendDownCMD(localPath, this.getWindow(), this.layout);
    }

    private void init(JProgressBarNew jp) {
        jp.setValue(0);
        jp.setString("");
    }

    private void addSelectedDeviceListener() {
        ItemListener listener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1 && WorkloadExportDialog.this.layout.getSaveToBtn().isEnabled()) {
                    WorkloadExportDialog.this.init(WorkloadExportDialog.this.layout.getjProgress());
                }
            }
        };
        this.layout.getSelectedDeviceCombBox().addItemListener(listener);
    }

    public String getCurrentDeviceID() {
        return this.layout.getSelectedDeviceID();
    }
}

