/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.xve.monitor.perfstat;

import com.huawei.ism.common.resourcemanager.HisResourceManager;
import com.huawei.ism.ui.swing.LayoutConstants;
import com.huawei.ism.ui.swing.plaf.IsmFontFactory;
import com.huawei.ism.ui.swing.table.DefaultTableModel;
import com.huawei.ism.ui.swing.table.IsmTable;
import com.huawei.ism.ui.swing.table.TableScrollPane;
import com.huawei.ism.util.Pair;
import com.huawei.ism.util.UCD;
import com.huawei.sftp.JProgressBarNew;
import com.huawei.xve.utils.ConnManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public class WorkloadExportLayout
extends JPanel {
    protected static final long TMOUT = 20000L;
    private static final long serialVersionUID = -6063804719537200992L;
    private JButton saveToBtn;
    private JButton exploreBtn;
    private IsmTable table = null;
    private DefaultTableModel tableModel = null;
    private TableScrollPane scrollPane = null;
    private Box progress;
    private JComboBox selectedDeviceComboBox = null;
    private List<String> deviceIDList;
    private JLabel descLabel;
    private JProgressBarNew jProgress;

    public WorkloadExportLayout(List<String> deviceIDList) {
        this.deviceIDList = deviceIDList;
        this.doLayoutUI();
        this.setDeviceInfo();
    }

    public Box getProgress() {
        return this.progress;
    }

    public void setjProgress(JProgressBarNew jp) {
        this.jProgress = jp;
    }

    public JProgressBarNew getjProgress() {
        return this.jProgress;
    }

    public JButton getSaveToBtn() {
        return this.saveToBtn;
    }

    public JButton getExploreBtn() {
        return this.exploreBtn;
    }

    public IsmTable getTable() {
        return this.table;
    }

    public DefaultTableModel getTableModel() {
        return this.tableModel;
    }

    public TableScrollPane getScrollPane() {
        return this.scrollPane;
    }

    private void doLayoutUI() {
        this.createComponents();
        this.layoutComponents();
    }

    private void createComponents() {
        this.selectedDeviceComboBox = new JComboBox();
        this.descLabel = new JLabel(HisResourceManager.getString("EXPORT-WORKLOAD-DESC"));
        this.saveToBtn = new JButton(HisResourceManager.getString("EXPORT_FILE.TXT.EXPORT"));
        this.saveToBtn.setEnabled(true);
        this.exploreBtn = new JButton(HisResourceManager.getString("EXPORT_FILE.TXT.EXPLORE"));
        this.exploreBtn.setEnabled(true);
        this.jProgress = new JProgressBarNew();
        this.jProgress.setOrientation(0);
        this.jProgress.setMinimum(0);
        this.jProgress.setMaximum(100);
        this.jProgress.setValue(0);
        this.jProgress.setStringPainted(true);
        this.jProgress.setPreferredSize(new Dimension(300, 20));
        this.jProgress.setBorderPainted(true);
        this.jProgress.setBackground(Color.pink);
    }

    private void layoutComponents() {
        UCD.setJComponentWidth((JComponent)this.selectedDeviceComboBox, (int)250);
        JLabel arrayLabel = new JLabel(HisResourceManager.getString("LOGICALARRAYSPROPERTYPANE.ARRAYNAME") + ":");
        arrayLabel.setFont(IsmFontFactory.getBold12Font());
        Box deviceComponent = UCD.buildHBoxLeft((int)0, (Component[])new Component[]{arrayLabel, this.selectedDeviceComboBox, Box.createGlue()});
        deviceComponent.setBorder(UCD.getCompoundBorder((Border)UCD.createTableTitleBorder((String)HisResourceManager.getString("ABSTRACTTABBEDPROPERTYPANE_DEVICEINFO")), (Border)new EmptyBorder(4, 0, 8, 0)));
        Box pro = UCD.buildHBoxLeft((int)0, (Component[])new Component[]{new JLabel(HisResourceManager.getString("EXPORT-FILE.TXT.DOWNLOAD") + ":"), this.jProgress});
        this.progress = UCD.buildVBoxTop((int)LayoutConstants.LINE_MARGIN_PIXEL, (Component[])new Component[]{pro});
        Box wholeBox = null;
        wholeBox = UCD.buildVBoxTop((int)LayoutConstants.LINE_MARGIN_PIXEL, (Component[])new Component[]{UCD.buildHBoxLeft((Component[])new Component[]{this.descLabel}), deviceComponent, this.progress, UCD.buildHBoxRight((Component[])new Component[]{this.saveToBtn, this.exploreBtn})});
        this.setLayout(new BorderLayout());
        this.add((Component)wholeBox, "Center");
    }

    public void setDeviceInfo() {
        Pair arrayPair = null;
        ArrayList<Pair> temporaryList = new ArrayList<Pair>();
        for (String deviceID : this.deviceIDList) {
            arrayPair = new Pair((Object)deviceID, (Object)ConnManager.getDeviceName(deviceID));
            temporaryList.add(arrayPair);
        }
        Collections.sort(temporaryList, new Comparator<Pair<String, String>>(){

            @Override
            public int compare(Pair<String, String> o1, Pair<String, String> o2) {
                return ((String)o1.getValue()).compareTo((String)o2.getValue());
            }
        });
        for (Pair pair : temporaryList) {
            this.selectedDeviceComboBox.addItem(pair);
        }
    }

    public JComboBox getSelectedDeviceCombBox() {
        return this.selectedDeviceComboBox;
    }

    public String getSelectedDeviceID() {
        Pair selectedPair = (Pair)this.selectedDeviceComboBox.getSelectedItem();
        return (String)selectedPair.getKey();
    }
}

