/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.xve.server;

import com.huawei.xve.entity.StepDetail;
import com.huawei.xve.entity.TaskDetail;
import com.huawei.xve.server.IUIObserver;
import com.huawei.xve.ui.BatchExportPerfDialog;
import com.huawei.xve.utils.DeviceInfo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.SwingUtilities;

public class BatchUIObserver
implements IUIObserver {
    private static final DefaultListModel EMPTY_LIST = new DefaultListModel();
    private Map<String, DefaultListModel> models = new HashMap<String, DefaultListModel>();
    private BatchExportPerfDialog dialog;

    public BatchUIObserver(BatchExportPerfDialog batchExportPerfDialog) {
        this.dialog = batchExportPerfDialog;
    }

    @Override
    public void initDetailList(List<DeviceInfo> devs) {
        devs.forEach(dev -> this.models.put(dev.getDeviceID(), new DefaultListModel()));
    }

    @Override
    public void update() {
    }

    @Override
    public void finish(DeviceInfo devNode) {
    }

    @Override
    public void finishAll() {
    }

    @Override
    public void updateWhenDevChange(String id) {
        this.updateDetailUI(id);
    }

    @Override
    public void update(Observable o, Object arg) {
        if (arg instanceof TaskDetail) {
            this.updateDeviceTable((TaskDetail)arg);
        } else if (arg instanceof StepDetail) {
            this.updateDetailList((StepDetail)arg);
        }
    }

    private void updateDetailList(StepDetail detail) {
        DefaultListModel model = this.models.get(detail.getDevId());
        if (!model.contains(detail)) {
            model.addElement(detail);
        }
    }

    private void updateDeviceTable(TaskDetail detail) {
        SwingUtilities.invokeLater(() -> this.dialog.updateDeviceTable(detail));
    }

    private void updateDetailUI(String identifier) {
        DefaultListModel showModel = (DefaultListModel)this.dialog.getDetailList().getModel();
        DefaultListModel model = this.models.getOrDefault(identifier, EMPTY_LIST);
        JList list = this.dialog.getDetailList();
        if (showModel.equals(model)) {
            list.repaint();
            return;
        }
        SwingUtilities.invokeLater(() -> {
            list.setModel(model);
            list.revalidate();
            list.repaint();
        });
    }
}

