/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.xve.server;

import com.huawei.xve.entity.ExportParam;
import com.huawei.xve.entity.TaskEnv;
import com.huawei.xve.server.AbstractTask;
import com.huawei.xve.server.IExportTask;
import com.huawei.xve.server.export.ExportByPackage;
import com.huawei.xve.server.export.ExportOneByOne;
import com.huawei.xve.server.export.ExportTask;
import com.huawei.xve.server.export.PostCollect;
import com.huawei.xve.server.export.PreCollect;
import com.huawei.xve.server.export.a800.ExportDpcFile;
import com.huawei.xve.server.export.a800.ExportGlobalFile;
import com.huawei.xve.server.export.a800.PostDmeCollect;
import com.huawei.xve.server.export.a800.PostDpcCollect;
import com.huawei.xve.server.export.a800.PreDmeCollect;
import com.huawei.xve.server.export.a800.PreDpcCollect;
import com.huawei.xve.utils.DeviceInfo;
import com.huawei.xve.utils.DeviceVersion;
import com.huawei.xve.utils.FileUtil;
import com.huawei.xve.utils.HisPerfstatUtil;
import com.huawei.xve.utils.QuerInfo;
import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportTaskFactory {
    private static final Logger log = LoggerFactory.getLogger(ExportTaskFactory.class);
    public static final ExportTaskFactory INS = new ExportTaskFactory();

    public IExportTask getPerfExportTask(TaskEnv env) {
        if (env.getDeviceInfo().getExportParam() == null) {
            this.setDefaultData(env);
        }
        if (HisPerfstatUtil.isSupportA800Scene() && env.getDeviceInfo().isA800Cluster()) {
            env.getParam().setResultDir(String.join((CharSequence)File.separator, QuerInfo.getA800ClusterPerfExportDir(), "zone"));
        }
        ArrayList<AbstractTask> tasks = new ArrayList<AbstractTask>();
        tasks.add(new PreCollect(env, 0.1));
        tasks.add(this.supportExportByPackage(env.getDeviceInfo()) ? new ExportByPackage(env, 0.8) : new ExportOneByOne(env, 0.8));
        tasks.add(new PostCollect(env, 0.1));
        return new ExportTask(env, tasks);
    }

    public IExportTask getDmeExportTask(TaskEnv env) {
        env.setA800ResultDir(QuerInfo.getA800ClusterPerfExportDir());
        ArrayList<AbstractTask> tasks = new ArrayList<AbstractTask>();
        tasks.add(new PreDmeCollect(env, 0.15));
        tasks.add(new ExportGlobalFile(env, 0.7));
        tasks.add(new PostDmeCollect(env, 0.15));
        return new ExportTask(env, tasks);
    }

    public IExportTask getOmExportTask(TaskEnv env) {
        String dir = env.getDeviceInfo().isA800Cluster() ? QuerInfo.getA800ClusterPerfExportDir() : String.join((CharSequence)File.separator, QuerInfo.getPerfExportDir(), FileUtil.formatIpForPath(env.getDeviceInfo().getIp()));
        env.setA800ResultDir(dir);
        ArrayList<AbstractTask> tasks = new ArrayList<AbstractTask>();
        tasks.add(new PreDpcCollect(env, 0.1));
        tasks.add(new ExportDpcFile(env, 0.8));
        tasks.add(new PostDpcCollect(env, 0.1));
        return new ExportTask(env, tasks);
    }

    private void setDefaultData(TaskEnv env) {
        DeviceInfo deviceInfo = env.getDeviceInfo();
        Calendar sevenDateBefore = Calendar.getInstance();
        this.initSevenDateBefore(sevenDateBefore);
        long startTime = sevenDateBefore.getTime().getTime();
        long endTime = this.initEndDate().getTime().getTime();
        ExportParam param = new ExportParam();
        param.setStartTime(startTime);
        param.setEndTime(endTime);
        param.setCompress(true);
        param.setResultDir(QuerInfo.getPerfExportDir());
        deviceInfo.setExportParam(param);
        env.setParam(param);
        log.info("Dev {} export by default setting : {}", (Object)deviceInfo.getIp(), (Object)param);
    }

    private void initSevenDateBefore(Calendar sevenDateBefore) {
        sevenDateBefore.setTime(new Date());
        sevenDateBefore.add(5, -6);
        sevenDateBefore.set(11, 0);
        sevenDateBefore.set(12, 0);
        sevenDateBefore.set(13, 0);
    }

    private Calendar initEndDate() {
        Calendar endDate = Calendar.getInstance();
        endDate.setTime(new Date());
        endDate.set(11, 23);
        endDate.set(12, 59);
        endDate.set(13, 59);
        return endDate;
    }

    private boolean supportExportByPackage(DeviceInfo di) {
        String version = di.getDevNode().getProductVersion();
        String devType = di.getDevNode().getDeviceType().toString();
        return DeviceVersion.isCollectByPmsDevice(devType) || DeviceVersion.isMayUsePmsCollectDevice(devType) && DeviceVersion.needCollectByPms(version);
    }

    private ExportTaskFactory() {
    }
}

