/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.xve.server;

import com.huawei.ism.common.resourcemanager.HisResourceManager;
import com.huawei.xve.entity.TaskEnv;
import com.huawei.xve.server.ExportTaskFactory;
import com.huawei.xve.server.IExportTask;
import com.huawei.xve.server.IUIObserver;
import com.huawei.xve.utils.DeviceInfo;
import com.huawei.xve.utils.HisPerfstatUtil;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskManager<R> {
    private static final Logger log = LoggerFactory.getLogger(TaskManager.class);
    public static final TaskManager INS = new TaskManager();
    private int maxExportNum = 10;
    private ExecutorService executor;

    private TaskManager() {
        try {
            this.maxExportNum = Integer.parseInt(HisResourceManager.getCfgProperties().getProperty("BATCH_EXPORT_PERF_THREAD_NUM"));
        }
        catch (Exception e) {
            log.error("Init max export num failed.", (Throwable)e);
        }
        log.info("set max export num  {} ", (Object)this.maxExportNum);
        this.executor = Executors.newFixedThreadPool(this.maxExportNum);
    }

    public Object submitTask(DeviceInfo dev, IUIObserver obs) {
        IExportTask task;
        if (HisPerfstatUtil.isa800Dme(dev)) {
            task = ExportTaskFactory.INS.getDmeExportTask(TaskEnv.builder().deviceInfo(dev).obs(obs).build());
        } else if (HisPerfstatUtil.isA800Om(dev)) {
            task = ExportTaskFactory.INS.getOmExportTask(TaskEnv.builder().deviceInfo(dev).obs(obs).build());
        } else {
            TaskEnv env = TaskEnv.builder().deviceInfo(dev).param(dev.getExportParam()).obs(obs).build();
            task = ExportTaskFactory.INS.getPerfExportTask(env);
        }
        task.init();
        return CompletableFuture.supplyAsync(task::doExport, this.executor);
    }
}

