/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.xve.server.a800;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.huawei.ism.common.resourcemanager.HisResourceManager;
import com.huawei.ism.tool.obase.entity.AiDevNode;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.protocol.rest.RestConnection;
import com.huawei.ism.tool.protocol.rest.RestConnectionManager;
import com.huawei.ism.tool.protocol.rest.entity.ResponseInfo;
import com.huawei.ism.tool.protocol.utils.RestUtil;
import com.huawei.ism.util.StringUtils;
import com.huawei.xve.entity.a800.ConfigParam;
import com.huawei.xve.entity.a800.ConfigProgressResponse;
import com.huawei.xve.entity.a800.DMEParam;
import com.huawei.xve.entity.a800.DataTurboParam;
import com.huawei.xve.entity.a800.DpcPreCollectTaskResponse;
import com.huawei.xve.entity.a800.DpcQueryNodesParam;
import com.huawei.xve.entity.a800.ErrorResponse;
import com.huawei.xve.entity.a800.FileSystemListResponse;
import com.huawei.xve.entity.a800.HisPerstatException;
import com.huawei.xve.entity.a800.QueryDpcNodesResponse;
import com.huawei.xve.entity.a800.QueryDpcTaskDetail;
import com.huawei.xve.entity.a800.QueryDpcTaskProgressResponse;
import com.huawei.xve.entity.a800.QueryFileSystemParam;
import com.huawei.xve.entity.a800.RestResponseCode;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectRestUtils {
    private static final Logger log = LoggerFactory.getLogger(CollectRestUtils.class);
    private static final String SELECT_DPC_NODES_URL = "%s/rest/dpc-mgmt/v1/dpcs/query";
    private static final String SELECT_FILE_SYSTEMS_URL = "%s/rest/fileservice/v1/filesystems/query";
    private static final String PACK_FILE_SYSTEMS_PERFORMANCE_URL = "%s/rest/pmmgmt/v1/performance-data/collection-task";
    private static final String SELECT_FILE_SYSTEMS_TASK_PROGRESS_URL = "%s/rest/taskmgmt/v1/tasks/%s";
    private static final String DOWNLOAD_FILE_SYSTEMS_PERFORMANCE_URL = "%s/rest/pmmgmt/v1/performance-data/download/%s";
    private static final String PACK_DPC_PERFORMANCE_URL = "%s/rest/dpc-mgmt/v1/performance-data/collection-task";
    private static final String DOWNLOAD_DPC_PERFORMANCE_URL = "%s/rest/dpc-mgmt/v1/performance-data/download";
    private static final String CLEAR_DPC_PERFORMANCE_RESULT_URL = "%s/rest/dpc-mgmt/v1/performance-data/cleanup";
    private static final String PACK_CONFIG_URL = "%s/rest/storagemgmt/v1/storage-config/collection-task";
    private static final String DOWNLOAD_CONFIG_URL = "%s/rest/storagemgmt/v1/storage-config/download";

    public static QueryDpcNodesResponse queryDpcNodes(AiDevNode aiDevNode, DpcQueryNodesParam param) throws ToolException, HisPerstatException {
        String url;
        RestConnection restConnection = RestConnectionManager.getRestConnection((DevNode)aiDevNode);
        ResponseInfo responseInfo = restConnection.execPost(url = String.format(SELECT_DPC_NODES_URL, RestUtil.getBaseUri((DevNode)aiDevNode)), JSON.toJSONString((Object)param));
        if (Objects.isNull(responseInfo) || Objects.isNull(responseInfo.getStatusLine())) {
            log.error("No response is returned for querying the DPC list.");
            throw new HisPerstatException(HisResourceManager.getString("historydata.a800.query.dpc.no.response"));
        }
        int statusCode = responseInfo.getStatusLine().getStatusCode();
        if (statusCode == RestResponseCode.SUCCESS.getCode()) {
            log.info("Command for querying the DPC list is sent successfully.");
            return (QueryDpcNodesResponse)JSONObject.parseObject((String)responseInfo.getContent(), QueryDpcNodesResponse.class);
        }
        log.error("query dpc nodes fail. Status code is :{}", (Object)statusCode);
        ErrorResponse dpcError = (ErrorResponse)JSONObject.parseObject((String)responseInfo.getContent(), ErrorResponse.class);
        throw new HisPerstatException(statusCode, HisResourceManager.getString("historydata.a800.query.dpc.failed"), dpcError);
    }

    public static FileSystemListResponse queryFileSystems(AiDevNode aiDevNode, QueryFileSystemParam param) throws ToolException, HisPerstatException {
        String url;
        RestConnection restConnection = RestConnectionManager.getRestConnection((DevNode)aiDevNode);
        ResponseInfo responseInfo = restConnection.execPost(url = String.format(SELECT_FILE_SYSTEMS_URL, RestUtil.getBaseUri((DevNode)aiDevNode)), JSON.toJSONString((Object)param));
        if (Objects.isNull(responseInfo) || Objects.isNull(responseInfo.getStatusLine())) {
            log.error("No response is returned for querying the file system list.");
            throw new HisPerstatException(HisResourceManager.getString("historydata.a800.query.file.system.no.response"));
        }
        int statusCode = responseInfo.getStatusLine().getStatusCode();
        if (statusCode == RestResponseCode.SUCCESS.getCode()) {
            log.info("Succeeded in querying the file system list.");
            return (FileSystemListResponse)JSONObject.parseObject((String)responseInfo.getContent(), FileSystemListResponse.class);
        }
        log.error("Failed to query the file system list. Status code is :{}", (Object)statusCode);
        ErrorResponse dpcError = (ErrorResponse)JSONObject.parseObject((String)responseInfo.getContent(), ErrorResponse.class);
        throw new HisPerstatException(statusCode, HisResourceManager.getString("historydata.a800.query.file.system.failed"), dpcError);
    }

    public static DpcPreCollectTaskResponse packFileSystems(AiDevNode aiDevNode, DMEParam param) throws ToolException, HisPerstatException {
        String url;
        RestConnection restConnection = RestConnectionManager.getRestConnection((DevNode)aiDevNode);
        ResponseInfo responseInfo = restConnection.execPost(url = String.format(PACK_FILE_SYSTEMS_PERFORMANCE_URL, RestUtil.getBaseUri((DevNode)aiDevNode)), JSON.toJSONString((Object)param));
        if (Objects.isNull(responseInfo) || Objects.isNull(responseInfo.getStatusLine())) {
            log.error("The system does not respond when creating a performance data file collection task.");
            throw new HisPerstatException(HisResourceManager.getString("historydata.a800.create.file.system.task.no.response"));
        }
        int statusCode = responseInfo.getStatusLine().getStatusCode();
        if (statusCode == RestResponseCode.SUCCESS.getCode()) {
            log.info("The task for collecting performance data files is created successfully.");
            return (DpcPreCollectTaskResponse)JSONObject.parseObject((String)responseInfo.getContent(), DpcPreCollectTaskResponse.class);
        }
        ErrorResponse dpcError = (ErrorResponse)JSONObject.parseObject((String)responseInfo.getContent(), ErrorResponse.class);
        if (statusCode == RestResponseCode.OVER_SPECIFICATION_ERROR.getCode()) {
            log.error("The number of files multiplied by the number of indicators exceeds 2000. Status code is :{}", (Object)statusCode);
            throw new HisPerstatException(statusCode, HisResourceManager.getString("historydata.a800.create.file.system.value.exceeds.2000"), dpcError);
        }
        if (statusCode == RestResponseCode.FAILED.getCode()) {
            log.error("The performance file export task already exists. Status code is :{}", (Object)statusCode);
            throw new HisPerstatException(statusCode, HisResourceManager.getString("historydata.a800.file.system.task.already.exists"), dpcError);
        }
        log.error("Failed to create a task for collecting performance data files. Status code is :{}", (Object)statusCode);
        throw new HisPerstatException(statusCode, HisResourceManager.getString("historydata.a800.create.file.system.task.failed"), dpcError);
    }

    public static List<QueryDpcTaskDetail> queryFileSystemsPackingTask(AiDevNode aiDevNode, String taskId) throws ToolException, HisPerstatException {
        String url;
        RestConnection restConnection = RestConnectionManager.getRestConnection((DevNode)aiDevNode);
        ResponseInfo responseInfo = restConnection.execGet(url = String.format(SELECT_FILE_SYSTEMS_TASK_PROGRESS_URL, RestUtil.getBaseUri((DevNode)aiDevNode), taskId));
        if (Objects.isNull(responseInfo) || Objects.isNull(responseInfo.getStatusLine())) {
            log.error("The system does not respond when querying the progress of the global file system performance data collection task.");
            throw new HisPerstatException(HisResourceManager.getString("historydata.a800.query.task.no.response"));
        }
        int statusCode = responseInfo.getStatusLine().getStatusCode();
        if (statusCode == RestResponseCode.SUCCESS.getCode()) {
            log.info("Succeeded in querying the progress of the global file system performance data collection task.");
            return JSONObject.parseArray((String)responseInfo.getContent(), QueryDpcTaskDetail.class);
        }
        ErrorResponse dpcError = (ErrorResponse)JSONObject.parseObject((String)responseInfo.getContent(), ErrorResponse.class);
        log.error("Failed to query the task progress. Status code is :{}.", (Object)statusCode);
        throw new HisPerstatException(statusCode, HisResourceManager.getString("historydata.a800.query.file.system.task.failed"), dpcError);
    }

    public static boolean downloadFileSystems(AiDevNode aiDevNode, String taskId, String downloadDir) throws ToolException, HisPerstatException {
        String url;
        RestConnection restConnection = RestConnectionManager.getRestConnection((DevNode)aiDevNode);
        ResponseInfo responseInfo = restConnection.execGetFile(url = String.format(DOWNLOAD_FILE_SYSTEMS_PERFORMANCE_URL, RestUtil.getBaseUri((DevNode)aiDevNode), taskId), Collections.emptyMap(), downloadDir);
        if (Objects.isNull(responseInfo) || Objects.isNull(responseInfo.getStatusLine())) {
            log.error("The system does not respond when downloading performance files.");
            throw new HisPerstatException(HisResourceManager.getString("historydata.a800.download.no.response"));
        }
        int statusCode = responseInfo.getStatusLine().getStatusCode();
        if (statusCode == RestResponseCode.SUCCESS.getCode()) {
            log.info("Downloading the performance file succeeded.");
            return true;
        }
        ErrorResponse dpcError = (ErrorResponse)JSONObject.parseObject((String)responseInfo.getContent(), ErrorResponse.class);
        if (statusCode == RestResponseCode.FAILED.getCode()) {
            log.error("Failed to download the performance file. Status code is :{}.", (Object)statusCode);
            throw new HisPerstatException(statusCode, HisResourceManager.getString("historydata.a800.download.failed"), dpcError);
        }
        log.error("Failed to download the performance file. Status code is :{}.", (Object)statusCode);
        throw new HisPerstatException(statusCode, HisResourceManager.getString("historydata.a800.download.failed"), dpcError);
    }

    public static boolean packDpcPerformanceFiles(AiDevNode aiDevNode, DataTurboParam param) throws ToolException, HisPerstatException {
        String url;
        RestConnection restConnection = RestConnectionManager.getRestConnection((DevNode)aiDevNode);
        ResponseInfo responseInfo = restConnection.execPost(url = String.format(PACK_DPC_PERFORMANCE_URL, RestUtil.getBaseUri((DevNode)aiDevNode)), JSON.toJSONString((Object)param));
        if (Objects.isNull(responseInfo) || Objects.isNull(responseInfo.getStatusLine())) {
            log.error("The system does not respond when creating a DPC performance file collection task.");
            throw new HisPerstatException(HisResourceManager.getString("historydata.a800.create.dpc.task.no.response"));
        }
        int statusCode = responseInfo.getStatusLine().getStatusCode();
        if (statusCode == RestResponseCode.SUCCESS.getCode()) {
            log.info("The DPC performance file collection task is created successfully.");
            return true;
        }
        ErrorResponse dpcError = (ErrorResponse)JSONObject.parseObject((String)responseInfo.getContent(), ErrorResponse.class);
        if (statusCode == RestResponseCode.OVER_SPECIFICATION_ERROR.getCode()) {
            log.error("The collection is not supported if the time range exceeds seven days. Status code is :{}.", (Object)statusCode);
            throw new HisPerstatException(statusCode, HisResourceManager.getString("historydata.a800.create.dpc.task.more.than.seven.days"), dpcError);
        }
        if (statusCode == RestResponseCode.DPC_TASK_EXISTS_ERROR.getCode()) {
            log.error("The performance file collection task already exists. Status code is :{}.", (Object)statusCode);
            throw new HisPerstatException(statusCode, HisResourceManager.getString("historydata.a800.file.system.task.already.exists"), dpcError);
        }
        if (statusCode == RestResponseCode.FAILED.getCode()) {
            log.error("This operation is not supported because the performance file is being downloaded. Status code is :{}.", (Object)statusCode);
            throw new HisPerstatException(statusCode, HisResourceManager.getString("historydata.a800.create.dpc.task.is.downloading"), dpcError);
        }
        log.error("Failed to create a DPC performance file collection task. Status code is :{}.", (Object)statusCode);
        throw new HisPerstatException(statusCode, HisResourceManager.getString("historydata.a800.create.dpc.task.failed"), dpcError);
    }

    public static QueryDpcTaskProgressResponse queryDpcPerformanceFilesTask(AiDevNode aiDevNode) throws ToolException, HisPerstatException {
        String url;
        RestConnection restConnection = RestConnectionManager.getRestConnection((DevNode)aiDevNode);
        ResponseInfo responseInfo = restConnection.execGet(url = String.format(PACK_DPC_PERFORMANCE_URL, RestUtil.getBaseUri((DevNode)aiDevNode)));
        if (Objects.isNull(responseInfo) || Objects.isNull(responseInfo.getStatusLine())) {
            log.error("The system does not respond when querying the DPC performance file collection progress.");
            throw new HisPerstatException(HisResourceManager.getString("historydata.a800.query.dpc.task.no.response"));
        }
        int statusCode = responseInfo.getStatusLine().getStatusCode();
        if (statusCode == RestResponseCode.SUCCESS.getCode()) {
            log.info("Succeeded in querying the progress of collecting DPC performance files.");
            return (QueryDpcTaskProgressResponse)JSONObject.parseObject((String)responseInfo.getContent(), QueryDpcTaskProgressResponse.class);
        }
        ErrorResponse dpcError = (ErrorResponse)JSONObject.parseObject((String)responseInfo.getContent(), ErrorResponse.class);
        if (statusCode == RestResponseCode.FAILED.getCode()) {
            log.error("The performance file collection task does not exist or the size of the performance file exceeds the threshold 5 GB. Status code is :{}.", (Object)statusCode);
            throw new HisPerstatException(statusCode, HisResourceManager.getString("historydata.a800.query.dpc.task.not.exist"), dpcError);
        }
        log.error("Failed to query the progress of collecting DPC performance files. Status code is :{}.", (Object)statusCode);
        throw new HisPerstatException(statusCode, HisResourceManager.getString("historydata.a800.query.dpc.task.failed"), dpcError);
    }

    public static boolean downloadDpcPerformanceFiles(AiDevNode aiDevNode, String downloadDir) throws ToolException, HisPerstatException {
        String url;
        RestConnection restConnection = RestConnectionManager.getRestConnection((DevNode)aiDevNode);
        ResponseInfo responseInfo = restConnection.execGetFile(url = String.format(DOWNLOAD_DPC_PERFORMANCE_URL, RestUtil.getBaseUri((DevNode)aiDevNode)), Collections.emptyMap(), downloadDir);
        if (Objects.isNull(responseInfo) || Objects.isNull(responseInfo.getStatusLine())) {
            log.error("No response is received when the DPC performance file is downloaded.");
            throw new HisPerstatException(HisResourceManager.getString("historydata.a800.download.dpc.no.response"));
        }
        int statusCode = responseInfo.getStatusLine().getStatusCode();
        if (statusCode == RestResponseCode.SUCCESS.getCode()) {
            log.info("The DPC performance file is downloaded successfully.");
            return true;
        }
        ErrorResponse dpcError = (ErrorResponse)JSONObject.parseObject((String)responseInfo.getContent(), ErrorResponse.class);
        if (statusCode == RestResponseCode.FAILED.getCode()) {
            log.error("Performance files cannot be downloaded because they have not been collected. Status code is :{}.", (Object)statusCode);
            throw new HisPerstatException(statusCode, HisResourceManager.getString("historydata.a800.download.dpc.unfinished"), dpcError);
        }
        log.error("Failed to download the DPC performance file. Status code is :{}.", (Object)statusCode);
        throw new HisPerstatException(statusCode, HisResourceManager.getString("historydata.a800.download.dpc.failed"), dpcError);
    }

    public static boolean clearDpcPerformanceFiles(AiDevNode aiDevNode) throws ToolException, HisPerstatException {
        String url;
        RestConnection restConnection = RestConnectionManager.getRestConnection((DevNode)aiDevNode);
        ResponseInfo responseInfo = restConnection.execPost(url = String.format(CLEAR_DPC_PERFORMANCE_RESULT_URL, RestUtil.getBaseUri((DevNode)aiDevNode)), new HashMap());
        if (Objects.isNull(responseInfo) || Objects.isNull(responseInfo.getStatusLine())) {
            log.error("No response is returned for clearing DPC performance file collection results.");
            throw new HisPerstatException(HisResourceManager.getString("historydata.a800.clear.dpc.no.response"));
        }
        int statusCode = responseInfo.getStatusLine().getStatusCode();
        if (statusCode == RestResponseCode.SUCCESS.getCode()) {
            log.info("Succeeded in clearing the DPC performance file collection result.");
            return true;
        }
        ErrorResponse dpcError = (ErrorResponse)JSONObject.parseObject((String)responseInfo.getContent(), ErrorResponse.class);
        if (statusCode == RestResponseCode.FAILED.getCode()) {
            log.error("The file is in use and cannot be cleared. Status code is :{}.", (Object)statusCode);
            throw new HisPerstatException(statusCode, HisResourceManager.getString("historydata.a800.clear.dpc.is.used"), dpcError);
        }
        log.error("Failed to clear the DPC performance file collection result. Status code is :{}.", (Object)statusCode);
        throw new HisPerstatException(statusCode, HisResourceManager.getString("historydata.a800.clear.dpc.failed"), dpcError);
    }

    public static boolean packConfig(AiDevNode aiDevNode, ConfigParam param) throws ToolException, HisPerstatException {
        String url;
        RestConnection restConnection = RestConnectionManager.getRestConnection((DevNode)aiDevNode);
        ResponseInfo responseInfo = restConnection.execPost(url = String.format(PACK_CONFIG_URL, RestUtil.getBaseUri((DevNode)aiDevNode)), JSON.toJSONString((Object)param));
        if (Objects.isNull(responseInfo) || Objects.isNull(responseInfo.getStatusLine())) {
            log.error("No response is returned when the config file collection task is created.");
            throw new HisPerstatException(HisResourceManager.getString("historydata.a800.create.config.no.response"));
        }
        int statusCode = responseInfo.getStatusLine().getStatusCode();
        if (statusCode == RestResponseCode.SUCCESS.getCode()) {
            log.info("The task for collecting config files is created successfully.");
            return true;
        }
        ErrorResponse dpcError = (ErrorResponse)JSONObject.parseObject((String)responseInfo.getContent(), ErrorResponse.class);
        if (statusCode == RestResponseCode.DPC_TASK_EXISTS_ERROR.getCode()) {
            log.error("A config file collection task is being executed. Status code is :{}.", (Object)statusCode);
            throw new HisPerstatException(statusCode, HisResourceManager.getString("historydata.a800.config.task.already.exists"), dpcError);
        }
        log.error("Failed to create the task for collecting the config file. Status code is :{}.", (Object)statusCode);
        throw new HisPerstatException(statusCode, HisResourceManager.getString("historydata.a800.create.config.failed"), dpcError);
    }

    public static ConfigProgressResponse queryConfigTask(AiDevNode aiDevNode, ConfigParam param) throws ToolException, HisPerstatException {
        String url;
        RestConnection restConnection = RestConnectionManager.getRestConnection((DevNode)aiDevNode);
        ResponseInfo responseInfo = restConnection.execGet(url = String.format(PACK_CONFIG_URL, RestUtil.getBaseUri((DevNode)aiDevNode)), JSON.toJSONString((Object)param));
        if (Objects.isNull(responseInfo) || Objects.isNull(responseInfo.getStatusLine())) {
            log.error("No response is returned when you query the configuration file collection progress.");
            throw new HisPerstatException(HisResourceManager.getString("historydata.a800.query.config.task.no.response"));
        }
        int statusCode = responseInfo.getStatusLine().getStatusCode();
        if (statusCode == RestResponseCode.SUCCESS.getCode()) {
            log.info("Succeeded in querying the configuration file collection progress.");
            return (ConfigProgressResponse)JSONObject.parseObject((String)responseInfo.getContent(), ConfigProgressResponse.class);
        }
        ErrorResponse dpcError = (ErrorResponse)JSONObject.parseObject((String)responseInfo.getContent(), ErrorResponse.class);
        if (statusCode == RestResponseCode.FAILED.getCode()) {
            log.error("The configuration file collection task does not exist. Status code is :{}.", (Object)statusCode);
            throw new HisPerstatException(statusCode, HisResourceManager.getString("historydata.a800.config.task.not.exist"), dpcError);
        }
        log.error("Failed to query the configuration file collection progress. Status code is :{}.", (Object)statusCode);
        throw new HisPerstatException(statusCode, HisResourceManager.getString("historydata.a800.query.config.task.failed"), dpcError);
    }

    public static boolean downloadConfig(AiDevNode aiDevNode, ConfigParam configParam, String downloadDir) throws ToolException, HisPerstatException {
        String url;
        RestConnection restConnection = RestConnectionManager.getRestConnection((DevNode)aiDevNode);
        ResponseInfo responseInfo = restConnection.execGetFile(url = String.format(DOWNLOAD_CONFIG_URL, RestUtil.getBaseUri((DevNode)aiDevNode)), CollectRestUtils.getParam(configParam), downloadDir);
        if (Objects.isNull(responseInfo) || Objects.isNull(responseInfo.getStatusLine())) {
            log.error("Failed to downloThe system does not respond when downloading the configuration file.");
            throw new HisPerstatException(HisResourceManager.getString("historydata.a800.download.config.no.response"));
        }
        int statusCode = responseInfo.getStatusLine().getStatusCode();
        if (statusCode == RestResponseCode.SUCCESS.getCode()) {
            log.info("The configuration file is downloaded successfully.");
            return true;
        }
        ErrorResponse dpcError = (ErrorResponse)JSONObject.parseObject((String)responseInfo.getContent(), ErrorResponse.class);
        if (statusCode == RestResponseCode.COLLECTION_NOT_COMPLETED.getCode()) {
            log.error("The configuration file cannot be downloaded because it has not been collected. Status code is :{}.", (Object)statusCode);
            throw new HisPerstatException(statusCode, HisResourceManager.getString("historydata.a800.config.unfinished"), dpcError);
        }
        log.error("Failed to download the configuration file. Status code is :{}.", (Object)statusCode);
        throw new HisPerstatException(statusCode, HisResourceManager.getString("historydata.a800.download.config.failed"), dpcError);
    }

    private static Map<String, String> getParam(ConfigParam configParam) {
        String storageSn;
        HashMap<String, String> reqParam = new HashMap<String, String>();
        String storageId = configParam.getStorageId();
        if (!StringUtils.isNULLStr(storageId)) {
            reqParam.put("storage_id", storageId);
        }
        if (!StringUtils.isNULLStr(storageSn = configParam.getStorageSn())) {
            reqParam.put("storage_sn", storageSn);
        }
        return reqParam;
    }
}

