/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.xve.server.a800;

import com.huawei.ism.common.resourcemanager.HisResourceManager;
import com.huawei.ism.tool.devicemanager.service.implement.DefaultNodeProviderImpl;
import com.huawei.ism.tool.obase.entity.AiDevNode;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.DmeNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.ui.swing.dialog.ProgressDialog;
import com.huawei.ism.util.SwingUtil;
import com.huawei.ism.util.Utils;
import com.huawei.xve.entity.a800.DataTurboSettingInfo;
import com.huawei.xve.entity.a800.DpcClusterNode;
import com.huawei.xve.entity.a800.DpcNodeStatus;
import com.huawei.xve.entity.a800.DpcQueryNodesParam;
import com.huawei.xve.entity.a800.DpcResponse;
import com.huawei.xve.entity.a800.HisPerstatException;
import com.huawei.xve.entity.a800.QueryDpcNodesResponse;
import com.huawei.xve.server.a800.CollectRestUtils;
import com.huawei.xve.ui.a800.OmSettingParamDialog;
import com.huawei.xve.utils.DeviceInfo;
import com.huawei.xve.utils.HisPerfstatUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryDpcNodesTask
implements Callable<Optional<DataTurboSettingInfo>> {
    private static final Logger log = LoggerFactory.getLogger(QueryDpcNodesTask.class);
    private final ProgressDialog progressDialog;
    private final OmSettingParamDialog omSettingParamDialog;
    private final DeviceInfo device;

    public QueryDpcNodesTask(ProgressDialog progressDialog, OmSettingParamDialog omSettingParamDialog) {
        this.progressDialog = progressDialog;
        this.omSettingParamDialog = omSettingParamDialog;
        this.device = omSettingParamDialog.getDevice();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<DataTurboSettingInfo> call() {
        try {
            if (Objects.isNull(this.device.getDevNode()) || !(this.device.getDevNode() instanceof DmeNode)) {
                log.error("om node is null or is not om node,can not get dpc nodes.");
                Optional<DataTurboSettingInfo> optional = Optional.empty();
                return optional;
            }
            if (Objects.nonNull(this.device.getDataTurboSettingInfo())) {
                Optional<DataTurboSettingInfo> optional = Optional.of(this.device.getDataTurboSettingInfo());
                return optional;
            }
            Optional<AiDevNode> aiDevNode = this.getAiDevNode(this.device.getDevNode());
            if (!aiDevNode.isPresent()) {
                log.error("can not get AiDevNode for current om node. Om ip is {}", (Object)this.device.getIp());
                Optional<DataTurboSettingInfo> optional = Optional.empty();
                return optional;
            }
            log.info("Start init dataTurboSettingInfo. Device ip is {}", (Object)this.device.getIp());
            Optional<DataTurboSettingInfo> optional = Optional.of(this.createSettingInfo(aiDevNode.get()));
            return optional;
        }
        catch (HisPerstatException e) {
            String errorInfo = HisPerfstatUtil.spliceErrorInfo(e);
            log.error(errorInfo);
            this.omSettingParamDialog.setQueryDpsErrorMsg(errorInfo);
            Optional<DataTurboSettingInfo> optional = Optional.empty();
            return optional;
        }
        catch (ToolException e) {
            log.error("Failed to query the DPC node list.", (Throwable)e);
            this.omSettingParamDialog.setQueryDpsErrorMsg(HisResourceManager.getString("historydata.setup.options.error"));
            Optional<DataTurboSettingInfo> optional = Optional.empty();
            return optional;
        }
        finally {
            if (Objects.nonNull(this.progressDialog)) {
                SwingUtil.disPoseDialg((ProgressDialog)this.progressDialog);
            }
        }
    }

    private DataTurboSettingInfo createSettingInfo(AiDevNode aiDevNode) throws HisPerstatException, ToolException {
        DataTurboSettingInfo settingInfo = new DataTurboSettingInfo();
        List<DpcResponse> dpcResponses = this.queryAllDpcNodes(aiDevNode);
        settingInfo.setDpcClusterNodes(this.convertToClusterNodes(dpcResponses));
        settingInfo.setAiDevNode(aiDevNode);
        return settingInfo;
    }

    private List<DpcClusterNode> convertToClusterNodes(List<DpcResponse> dpcResponses) {
        if (CollectionUtils.isEmpty(dpcResponses)) {
            return Collections.emptyList();
        }
        AtomicInteger idIndex = new AtomicInteger(0);
        return dpcResponses.stream().map(dpcResponse -> this.convertToClusterNode((DpcResponse)dpcResponse, idIndex)).collect(Collectors.toList());
    }

    private DpcClusterNode convertToClusterNode(DpcResponse dpcResponse, AtomicInteger idIndex) {
        DpcClusterNode dpcClusterNode = new DpcClusterNode();
        dpcClusterNode.setSelected(false);
        dpcClusterNode.setDpcNodeId(dpcResponse.getId());
        dpcClusterNode.setManagementIp(dpcResponse.getIp());
        dpcClusterNode.setOmNodeIp(dpcResponse.getAssociatedDpcOm().getIp());
        dpcClusterNode.setManageStatus(DpcNodeStatus.of(dpcResponse.getMgmtStatus()));
        dpcClusterNode.setServiceStatus(DpcNodeStatus.of(dpcResponse.getStatus()));
        dpcClusterNode.setId(idIndex.getAndIncrement());
        dpcClusterNode.setSerialNumber(dpcResponse.getSn());
        dpcClusterNode.setName(dpcResponse.getHostname());
        return dpcClusterNode;
    }

    private List<DpcResponse> queryAllDpcNodes(AiDevNode aiDevNode) throws ToolException, HisPerstatException {
        QueryDpcNodesResponse response = CollectRestUtils.queryDpcNodes(aiDevNode, DpcQueryNodesParam.builder().build());
        int totalNumber = response.getTotal();
        log.info("Querying the first batch of DPC nodes succeeded. The dpc total number is {}.", (Object)totalNumber);
        if (totalNumber <= 1000) {
            return response.getDatas();
        }
        return this.batchQueryAllDpcNodes(aiDevNode, totalNumber);
    }

    private List<DpcResponse> batchQueryAllDpcNodes(AiDevNode aiDevNode, int totalNumber) throws HisPerstatException, ToolException {
        ArrayList<DpcResponse> dpcResponses = new ArrayList<DpcResponse>();
        DpcQueryNodesParam param = DpcQueryNodesParam.builder().pageSize(1000).build();
        int maxPageNum = totalNumber / 1000 + (totalNumber % 1000 == 0 ? 0 : 1);
        for (int pageNo = 1; pageNo <= maxPageNum; ++pageNo) {
            param.setPageNo(pageNo);
            QueryDpcNodesResponse response = CollectRestUtils.queryDpcNodes(aiDevNode, param);
            List<DpcResponse> datas = response.getDatas();
            if (Utils.isNullList(datas)) {
                log.error("Failed to query the node list of the {}th batch of DPC. The node information is empty.", (Object)pageNo);
                return Collections.emptyList();
            }
            dpcResponses.addAll(datas);
            log.info("Querying the {}th batch of DPC nodes succeeded.", (Object)pageNo);
        }
        return dpcResponses;
    }

    private Optional<AiDevNode> getAiDevNode(DevNode devNode) {
        String omIp = devNode.getIp();
        return DefaultNodeProviderImpl.getInstance().getNodeList().stream().filter(AiDevNode.class::isInstance).map(AiDevNode.class::cast).filter(dev -> dev.getOmNodes().stream().map(DevNode::getIp).anyMatch(ip -> ip.equals(omIp))).findAny();
    }
}

