/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.xve.server.export;

import com.huawei.ism.common.resourcemanager.HisResourceManager;
import com.huawei.ism.connection.HisRESTConnection;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.FileAssistant;
import com.huawei.ism.tool.obase.utils.FileUtils;
import com.huawei.ism.tool.protocol.rest.RestConnection;
import com.huawei.ism.tool.protocol.rest.RestConnectionManager;
import com.huawei.ism.tool.protocol.rest.entity.ResponseInfo;
import com.huawei.ism.tool.protocol.utils.RestUtil;
import com.huawei.json.JSONObject;
import com.huawei.sftp.AbstractSftp;
import com.huawei.sftp.PerfStatHisSftp;
import com.huawei.sftp.ProgressUpdateByDownload;
import com.huawei.xve.entity.StepDetail;
import com.huawei.xve.entity.TaskEnv;
import com.huawei.xve.server.AbstractTask;
import com.huawei.xve.server.IStepTask;
import com.huawei.xve.utils.DeviceInfo;
import com.huawei.xve.utils.FileUtil;
import com.huawei.xve.utils.HisPerfstatUtil;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportByPackage
extends AbstractTask
implements IStepTask {
    private static final Logger log = LoggerFactory.getLogger(ExportByPackage.class);
    private static final String DESC = HisResourceManager.getString("exporting.performance.files");
    private static final int MAX_FAILED_FILE_NUM_PER_CONTROLLER = 3;
    private static final String SCHEME_HTTPS = "https";
    private static final int REST_PORT = 8088;
    private static final String PACKAGE_FILES_BY_DAY_URL = "/api/v2/pms/package_files";
    private static final String PACKAGE_FILES_BY_SECOND_URL = "/api/v2/pms/package_files?exportPeriodType=1";
    private final String completeURL;
    private final transient PerfStatHisSftp perfStatHisSftp;
    private final Map<String, String> headerParam = new HashMap<String, String>();
    private final DeviceInfo di;
    private ProgressUpdateByDownload autoProUpdater;

    public ExportByPackage(TaskEnv env, double factor) {
        super(env, factor);
        this.initDetail(DESC);
        this.di = env.getDeviceInfo();
        this.perfStatHisSftp = new PerfStatHisSftp(env.getDeviceInfo());
        this.completeURL = "https://" + RestUtil.processIPByURL((String)this.di.getIp()) + ":" + 8088;
        this.headerParam.put("Content-Type", "application/json");
    }

    public Object doTask() {
        try {
            this.init();
            this.uiDetail.running();
            if (this.exportPerFileByPackage()) {
                this.uiDetail.success();
                StepDetail stepDetail = this.uiDetail;
                return stepDetail;
            }
            this.perfStatHisSftp.exportAll(this.env, this.uiDetail);
            this.waitSftpExportTaskFinished();
            this.updateStatus();
        }
        catch (ToolException e) {
            log.error("Export perf file failed.", (Throwable)e);
            this.uiDetail.fail(e.getErrorLocaleDescription());
        }
        catch (Exception e) {
            log.error("Export perf file failed.", (Throwable)e);
            this.uiDetail.fail(HisResourceManager.getString("REST_IO_EXCEPTION"));
        }
        finally {
            this.perfStatHisSftp.releaseConn();
        }
        return this.uiDetail;
    }

    private boolean exePackageURL(RestConnection conn, long beginTime, long endTime) throws ToolException {
        HashMap<String, Long> param = new HashMap<String, Long>();
        param.put("startTime", beginTime);
        param.put("endTime", endTime);
        ResponseInfo resp = conn.execPost(this.completeURL + this.getPackageURL(), new JSONObject(param).toString(), null, this.headerParam);
        return !this.responseError(resp);
    }

    String getPackageURL() {
        return HisPerfstatUtil.isSupportA800Scene() ? PACKAGE_FILES_BY_SECOND_URL : PACKAGE_FILES_BY_DAY_URL;
    }

    private boolean download(RestConnection conn, String tempPath) throws ToolException {
        this.autoProUpdater.reset(this.autoProUpdater.getCurrentMaxPro(), 60);
        ResponseInfo resp = conn.execGetFile(this.completeURL + "/api/v2/pms/download", null, tempPath);
        if (this.responseError(resp)) {
            return false;
        }
        Map restContentMap = resp.getContentMap();
        boolean result = false;
        for (Map.Entry contentEntry : restContentMap.entrySet()) {
            String key = (String)contentEntry.getKey();
            if (null == key || !key.contains(".tar.gz")) continue;
            result = true;
            break;
        }
        this.autoProUpdater.setTaskFinish(true);
        this.downloadFileOneByOneIfNeeded(tempPath);
        return result;
    }

    private ExportStatus queryPackageStatus(RestConnection conn) throws ToolException {
        ResponseInfo resp = conn.execGet(this.completeURL + "/api/v2/pms/package_status", null, null, this.headerParam);
        if (this.responseError(resp)) {
            return ExportStatus.ERROR;
        }
        JSONObject contentJson = new JSONObject(resp.getContent());
        return ExportStatus.of(contentJson.getJSONObject("data").getString("status"));
    }

    private boolean responseError(ResponseInfo resp) {
        if (null == resp) {
            return true;
        }
        if (resp.getContentMap().containsKey("errorCode")) {
            return (Long)resp.getContentMap().get("errorCode") != 0L;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean exportPerFileByPackage() throws ToolException {
        this.autoProUpdater = new ProgressUpdateByDownload(this.uiDetail, 0, 20);
        this.autoProUpdater.start();
        RestConnection conn = null;
        try {
            conn = RestConnectionManager.getRestConnectionThrowLoginError((DevNode)this.di.getDevNode());
            if (this.startExportTask(conn)) {
                this.autoProUpdater.setTaskFinish(true);
                boolean bl = false;
                return bl;
            }
            boolean bl = this.downloadPackage(conn, this.waitPackageFinished(conn));
            return bl;
        }
        catch (Exception e) {
            log.error("Export perFile by package failed.", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.closeConn(conn);
            this.autoProUpdater.setTaskFinish(true);
        }
    }

    private boolean startExportTask(RestConnection conn) throws ToolException {
        ExportStatus status = this.queryPackageStatus(Objects.requireNonNull(conn));
        if (status.isSystemBusy()) {
            this.uiDetail.fail(HisResourceManager.getString("SYSTEM_EXPORTING"));
            return true;
        }
        if (!status.isSystemFree()) {
            return true;
        }
        if (!this.exePackageURL(conn, this.env.getParam().getStartTime(), this.env.getParam().getEndTime())) {
            log.error("Start exec package failed.");
            return true;
        }
        return false;
    }

    private ExportStatus waitPackageFinished(RestConnection conn) throws ToolException {
        ExportStatus status;
        do {
            this.sleep();
        } while (ExportStatus.PACKAGING == (status = this.queryPackageStatus(conn)));
        return status;
    }

    private boolean downloadPackage(RestConnection conn, ExportStatus status) throws ToolException {
        if (ExportStatus.IDLE != status) {
            log.error("Download file failed. export status {} .", (Object)status);
            return false;
        }
        String tempPath = this.env.getResultDir() + File.separator + "temp";
        File temp = new File(tempPath);
        FileUtils.createDir((File)temp);
        return this.download(conn, tempPath);
    }

    private void downloadFileOneByOneIfNeeded(String tempPath) {
        Map<String, List<String>> notDownloadedFile = this.countNotDownloadedFiles(tempPath);
        if (notDownloadedFile.isEmpty()) {
            return;
        }
        log.info("{} files not download by package ,try export one by one", (Object)this.getFileCount(notDownloadedFile));
        this.perfStatHisSftp.exportAll(notDownloadedFile, (int)this.getFileCount(notDownloadedFile), this.env.getResultDir(), this.uiDetail, (int)this.env.getFileCount());
        this.waitSftpExportTaskFinished();
        this.perfStatHisSftp.rmTempFile();
    }

    private void waitSftpExportTaskFinished() {
        while (this.perfStatHisSftp.getDownloadThreadNum().get() != 0) {
            this.sleep();
        }
        this.perfStatHisSftp.getTaskPool().interrupt();
    }

    private void sleep() {
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException ignore) {
            log.warn("sleep error");
        }
    }

    private long getFileCount(Map<String, List<String>> notDownloadedFile) {
        if (notDownloadedFile == null) {
            return 0L;
        }
        return notDownloadedFile.values().stream().mapToLong(List::size).sum();
    }

    private Map<String, List<String>> countNotDownloadedFiles(String tempPath) {
        String tarTemp = HisPerfstatUtil.getAndClearTempFile(this.di.getIp());
        FileAssistant.batchDeCompressByFilter((String)tarTemp, (String)tempPath, (String)"*.gz");
        FileUtils.deleteFile((File)new File(tempPath));
        String perfFileDir = this.env.getResultDir() + File.separator + FileUtil.formatIpForPath(this.di.getIp());
        FileAssistant.batchDeCompressByFilter((String)perfFileDir, (String)tarTemp, (String)"*.tar");
        FileUtils.deleteFile((File)new File(tarTemp));
        List downloadedFileList = Arrays.stream((Object[])Objects.requireNonNull(new File(perfFileDir).listFiles())).map(this::getFileNameOrDeleteDir).filter(Objects::nonNull).collect(Collectors.toList());
        Map<String, List<String>> needDownloadFile = this.env.getPerfFiles();
        HashMap<String, List<String>> notDownloadedFile = new HashMap<String, List<String>>();
        needDownloadFile.keySet().forEach(controlIp -> {
            List<String> fileList = this.findNotDownloadFile(downloadedFileList, (List)needDownloadFile.get(controlIp));
            if (!fileList.isEmpty()) {
                notDownloadedFile.put((String)controlIp, fileList);
            }
        });
        return notDownloadedFile;
    }

    private String getFileNameOrDeleteDir(File file) {
        if (file.isDirectory()) {
            FileUtils.deleteFile((File)file);
            return null;
        }
        return file.getName();
    }

    private void updateStatus() {
        int maxFaultNum = this.env.getDeviceInfo().getControllerNum() * 3;
        int downloadNum = this.perfStatHisSftp.getDownloaded().get();
        int failedFileNum = (int)(this.env.getFileCount() - (long)downloadNum);
        if (downloadNum == 0) {
            log.error("Download file is empty,download failed.");
            this.uiDetail.fail(HisResourceManager.getString("REST_IO_EXCEPTION"));
            return;
        }
        if (failedFileNum <= maxFaultNum) {
            log.info("Download failed num {} less than max fault num {} .", (Object)failedFileNum, (Object)maxFaultNum);
            this.uiDetail.success();
            return;
        }
        if ((long)failedFileNum == this.env.getFileCount()) {
            log.error("All file download failed.");
            this.uiDetail.fail(HisResourceManager.getString("REST_IO_EXCEPTION"));
            return;
        }
        log.info("File count {} , failed num {} update to part success.", (Object)this.env.getFileCount(), (Object)failedFileNum);
        this.uiDetail.partSuccess(HisResourceManager.getString("CHANGE_MAINCTL"));
    }

    private List<String> findNotDownloadFile(List<String> downloadedFiles, List<String> needDownloads) {
        return needDownloads.stream().filter(file -> {
            String[] pathTemp = file.split("/");
            String foundFileName = pathTemp[pathTemp.length - 1];
            return !downloadedFiles.contains(foundFileName);
        }).collect(Collectors.toList());
    }

    private void closeConn(RestConnection conn) {
        if (null == conn) {
            return;
        }
        if (!AbstractSftp.getConnCache().containsKey(this.di.getDeviceID())) {
            conn.closeSession();
            return;
        }
        if (AbstractSftp.getConnCache().get(this.di.getDeviceID()) instanceof HisRESTConnection) {
            HisRESTConnection cacheConn = (HisRESTConnection)AbstractSftp.getConnCache().get(this.di.getDeviceID());
            if (cacheConn.getConn() != conn) {
                conn.closeSession();
                return;
            }
            try {
                RestConnectionManager.releaseConn((DevNode)this.di.getDevNode());
            }
            catch (Exception e) {
                log.error("release conn failed", (Throwable)e);
            }
            AbstractSftp.getConnCache().remove(this.di.getDeviceID());
        }
        conn.closeSession();
    }

    static enum ExportStatus {
        PACKAGING("packaging"),
        DOWNLOADING("downloading"),
        IDLE("--"),
        FAILED("failed"),
        FAULT("fault"),
        NONE("none"),
        ERROR("error");

        String status;

        private ExportStatus(String key) {
            this.status = key;
        }

        public static ExportStatus of(String statusStr) {
            return Arrays.stream(ExportStatus.values()).filter(status -> status.status.equals(statusStr)).findFirst().orElse(NONE);
        }

        public boolean isSystemBusy() {
            return this == PACKAGING || this == DOWNLOADING;
        }

        public boolean isSystemFree() {
            return this == IDLE || this == FAILED || this == NONE;
        }
    }
}

