/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.xve.server.export;

import com.huawei.ism.common.resourcemanager.HisResourceManager;
import com.huawei.sftp.PerfStatHisSftp;
import com.huawei.xve.entity.TaskEnv;
import com.huawei.xve.server.AbstractTask;
import com.huawei.xve.server.IStepTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportOneByOne
extends AbstractTask
implements IStepTask {
    private static final Logger log = LoggerFactory.getLogger(ExportOneByOne.class);
    private static final int MAX_FAILED_FILE_NUM_PER_CONTROLLER = 3;
    private static final String DESC = HisResourceManager.getString("exporting.performance.files");
    private transient PerfStatHisSftp perfStatHisSftp;

    public ExportOneByOne(TaskEnv env, double factor) {
        super(env, factor);
        this.initDetail(DESC);
        this.perfStatHisSftp = new PerfStatHisSftp(env.getDeviceInfo());
    }

    public Object doTask() {
        this.init();
        this.uiDetail.running();
        try {
            this.export();
            this.updateStatus();
        }
        catch (Exception e) {
            log.error("Export perf file failed.", (Throwable)e);
            this.uiDetail.fail(HisResourceManager.getString("REST_IO_EXCEPTION"));
        }
        finally {
            this.perfStatHisSftp.releaseConn();
        }
        return this.uiDetail;
    }

    private void updateStatus() {
        int maxFaultNum = this.env.getDeviceInfo().getControllerNum() * 3;
        int downloadNum = this.perfStatHisSftp.getDownloaded().get();
        int failedFileNum = (int)(this.env.getFileCount() - (long)downloadNum);
        if (downloadNum == 0) {
            log.error("Download file is empty,download failed.");
            this.uiDetail.fail(HisResourceManager.getString("REST_IO_EXCEPTION"));
            return;
        }
        if (failedFileNum <= maxFaultNum) {
            log.info("Download failed num {} less than max fault num {} .", (Object)failedFileNum, (Object)maxFaultNum);
            this.uiDetail.success();
            return;
        }
        if ((long)failedFileNum == this.env.getFileCount()) {
            log.error("All file download failed.");
            this.uiDetail.fail(HisResourceManager.getString("REST_IO_EXCEPTION"));
            return;
        }
        log.info("File count {} , failed num {} update to part success.", (Object)this.env.getFileCount(), (Object)failedFileNum);
        this.uiDetail.partSuccess(HisResourceManager.getString("CHANGE_MAINCTL"));
    }

    private void export() {
        this.perfStatHisSftp.exportAll(this.env, this.uiDetail);
        while (this.perfStatHisSftp.getDownloadThreadNum().get() != 0) {
            this.sleep(5000);
        }
        this.perfStatHisSftp.rmTempFile();
        this.perfStatHisSftp.getTaskPool().interrupt();
    }

    private void sleep(int time) {
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException ignore) {
            log.warn("sleep error");
        }
    }
}

