/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.xve.server.export;

import com.huawei.ism.common.resourcemanager.HisResourceManager;
import com.huawei.ism.tool.framework.platform.common.data.UserOpTaskResult;
import com.huawei.xve.entity.Status;
import com.huawei.xve.entity.StepDetail;
import com.huawei.xve.entity.TaskDetail;
import com.huawei.xve.entity.TaskEnv;
import com.huawei.xve.server.AbstractTask;
import com.huawei.xve.server.IExportTask;
import com.huawei.xve.server.IStepTask;
import com.huawei.xve.utils.UserBehaviorUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportTask
implements IExportTask {
    private static final Logger log = LoggerFactory.getLogger(ExportTask.class);
    private List<? extends IStepTask> tasks;
    private TaskDetail detail;
    private TaskEnv env;

    public ExportTask(TaskEnv env, List<? extends AbstractTask> tasks) {
        this.tasks = tasks;
        this.env = env;
        this.detail = new TaskDetail(env, tasks.stream().map(AbstractTask::getUiDetail).collect(Collectors.toList()));
    }

    @Override
    public void init() {
        this.detail.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object doExport() {
        String name = Thread.currentThread().getName();
        this.detail.running();
        ArrayList<StepDetail> details = new ArrayList<StepDetail>();
        try {
            Thread.currentThread().setName("ExportPerf_" + this.env.getDeviceInfo().getIp());
            for (IStepTask taskDetail : this.tasks) {
                StepDetail stepDetail = (StepDetail)taskDetail.doTask();
                details.add(stepDetail);
                if (stepDetail.getStatus() != Status.FAILED) continue;
                log.error("Task {} pause exec", (Object)stepDetail);
                UserBehaviorUtil.recordUserOpData(this.env.getDeviceInfo(), UserOpTaskResult.FAILED);
                this.detail.fail(stepDetail.getErrMsg());
                TaskDetail taskDetail2 = this.detail;
                return taskDetail2;
            }
        }
        catch (Throwable tx) {
            log.error("Exec task unknown error.", tx);
            this.detail.fail(HisResourceManager.getString("unknown.error"));
            TaskDetail taskDetail = this.detail;
            return taskDetail;
        }
        finally {
            Thread.currentThread().setName(name);
        }
        this.updateDetail(details);
        return this.detail;
    }

    private void updateDetail(List<StepDetail> details) {
        if (details.stream().map(StepDetail::getStatus).anyMatch(status -> Status.PART_SUCCESS == status)) {
            this.detail.partSuccess("");
            return;
        }
        this.detail.success();
    }
}

