/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.xve.server.export;

import com.huawei.ism.common.resourcemanager.HisResourceManager;
import com.huawei.ism.tool.base.utils.ZipUtils;
import com.huawei.xve.entity.TaskEnv;
import com.huawei.xve.server.AbstractTask;
import com.huawei.xve.server.IStepTask;
import com.huawei.xve.utils.DeviceInfo;
import com.huawei.xve.utils.FileUtil;
import com.huawei.xve.utils.RunningDataCollect;
import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import utils.FilesUtil;

public class PostCollect
extends AbstractTask
implements IStepTask {
    private static final Logger log = LoggerFactory.getLogger(PostCollect.class);
    private static final String DESC = HisResourceManager.getString("export.postHandle");
    private static final String PERF = "_Perf_";
    private static final String ZIP_SUFF = ".zip";
    private static final String TGZ = "/*.tgz";
    private static final String BZ2 = "/*.bz2";

    public PostCollect(TaskEnv env, double factor) {
        super(env, factor);
        this.initDetail(DESC);
    }

    public Object doTask() {
        this.init();
        this.uiDetail.running();
        try {
            this.collectConfig();
            this.clearEmptyDir(this.env.getResultDir());
            this.compressResult(this.env.getDeviceInfo(), this.env.getResultDir());
        }
        catch (Exception e) {
            log.error("Unknown error.", (Throwable)e);
        }
        finally {
            this.uiDetail.success();
        }
        return this.uiDetail;
    }

    private void clearEmptyDir(String resultDir) {
        File result = new File(resultDir);
        File[] files = result.listFiles();
        if (files == null) {
            return;
        }
        Arrays.stream(files).filter(subFile -> subFile != null && subFile.isDirectory()).forEach(subDir -> {
            File[] children = subDir.listFiles();
            if (children != null && children.length == 0) {
                log.info("Sub dir {} is empty,delete it.", (Object)FilesUtil.getCanonicalPath((File)subDir));
                subDir.delete();
            }
        });
    }

    private void collectConfig() {
        try {
            RunningDataCollect.collect(this.env.getDeviceInfo(), this.env.getResultDir());
        }
        catch (Exception e) {
            log.error("Collect config failed.", (Throwable)e);
        }
    }

    private void compressResult(DeviceInfo di, String srcPath) {
        if (!(this.env.getParam().isCompress() || di.isA800Cluster() && di.isCompressA800())) {
            return;
        }
        String destName = FileUtil.formatIpForPath(di.getDeviceName() + PERF + System.currentTimeMillis() + ZIP_SUFF);
        Set<String> set = this.env.getPerfFiles().keySet();
        HashSet<String> filter = new HashSet<String>();
        for (String ip : set) {
            filter.add(FileUtil.formatIpForPath(ip) + TGZ);
            filter.add(FileUtil.formatIpForPath(ip) + BZ2);
        }
        filter.add("Running_Data/*.txt");
        ZipUtils.compressByAnt((String)srcPath, (String)destName, filter);
        this.clearSrc(this.env.getResultDir());
    }

    private void clearSrc(String filePath) {
        this.env.getPerfFiles().keySet().stream().map(ip -> new File(filePath + File.separator + FileUtil.formatIpForPath(ip))).filter(File::exists).forEach(file -> FileUtil.deleteDir(FilesUtil.getCanonicalPath((File)file)));
        File runningData = new File(filePath + File.separator + "Running_Data");
        if (runningData.exists()) {
            FileUtil.deleteDir(FilesUtil.getCanonicalPath((File)runningData));
        }
    }
}

