/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.xve.server.export;

import com.huawei.ism.common.resourcemanager.HisResourceManager;
import com.huawei.ism.exception.IsmException;
import com.huawei.ism.tool.base.utils.FileUtils;
import com.huawei.ism.tool.framework.platform.common.data.UserOpTaskResult;
import com.huawei.sftp.AbstractSftp;
import com.huawei.sftp.PerfStatHisSftp;
import com.huawei.xve.entity.TaskEnv;
import com.huawei.xve.server.AbstractTask;
import com.huawei.xve.server.IStepTask;
import com.huawei.xve.utils.DeviceInfo;
import com.huawei.xve.utils.DeviceVersion;
import com.huawei.xve.utils.HisUserOpToolData;
import com.huawei.xve.utils.UserBehaviorUtil;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreCollect
extends AbstractTask
implements IStepTask {
    private static final Logger log = LoggerFactory.getLogger(PreCollect.class);
    private static final String DESC = HisResourceManager.getString("export.pretreatment");

    public PreCollect(TaskEnv env, double factor) {
        super(env, factor);
        this.initDetail(DESC);
    }

    public Object doTask() {
        this.init();
        this.uiDetail.running();
        DeviceInfo deviceInfo = this.env.getDeviceInfo();
        long begin = this.env.getParam().getStartTime();
        long end = this.env.getParam().getEndTime();
        try {
            FileUtils.clearDir((String)this.env.getResultDir());
            AbstractSftp.releaseConn(this.env.getDeviceInfo());
            this.roleCheck(deviceInfo);
            this.initUserData(deviceInfo);
            Map<String, List<String>> files = PerfStatHisSftp.queryStatFiles(deviceInfo.getDeviceID(), begin, end);
            this.diskSpaceCheck(deviceInfo, this.env.getResultDir(), files);
            this.syncData(files);
            this.uiDetail.success();
        }
        catch (IsmException e) {
            UserBehaviorUtil.recordUserOpData(deviceInfo, UserOpTaskResult.FAILED);
            this.uiDetail.fail(e.getErrorMessage());
            return this.uiDetail;
        }
        catch (Exception e) {
            UserBehaviorUtil.recordUserOpData(deviceInfo, UserOpTaskResult.FAILED);
            this.uiDetail.fail(HisResourceManager.getString("unknown.error"));
            return this.uiDetail;
        }
        return this.uiDetail;
    }

    private void syncData(Map<String, List<String>> files) {
        this.env.setPerfFiles(files);
        log.info("sync data {} ", files.keySet());
    }

    private void diskSpaceCheck(DeviceInfo deviceInfo, String resultDir, Map<String, List<String>> queryFiles) {
        if (queryFiles == null || queryFiles.isEmpty()) {
            throw new IsmException(HisResourceManager.getString("EXPORT-FILE.TXT.CURR_WARN_NOFILE"));
        }
        File result = new File(resultDir);
        if (!result.exists()) {
            result.mkdirs();
        }
        long fileNum = this.getFileCount(queryFiles);
        long minSpace = fileNum * 100L / 1024L;
        long maxSpace = (long)deviceInfo.getControllerNum() * 1024L;
        long freeSpace = new File(resultDir).getFreeSpace() / 0x100000L;
        if (freeSpace < minSpace) {
            throw new IsmException(HisResourceManager.getString("SPACE_NOT_FREE_FIRST") + minSpace + "MB~" + maxSpace + "MB " + HisResourceManager.getString("SPACE_NOT_FREE_SECOND"));
        }
    }

    private long getFileCount(Map<String, List<String>> queryFiles) {
        return queryFiles.values().stream().mapToLong(List::size).sum();
    }

    private void initUserData(DeviceInfo deviceInfo) {
        deviceInfo.getHisUserData().setExportDataType(HisUserOpToolData.ExportDataTypeEnum.EXPORTPERFDATA.getValue());
        deviceInfo.getHisUserData().setTaskStartTime(System.currentTimeMillis());
        deviceInfo.getHisUserData().setTaskResult(UserOpTaskResult.FAILED);
    }

    private void roleCheck(DeviceInfo deviceInfo) {
        if (deviceInfo.isBelongSuperAdmin().booleanValue()) {
            return;
        }
        String errMsg = deviceInfo.getDeviceVersion() == DeviceVersion.TV1 ? "PERMISSION_NOT_SUPERADMIN_TV1" : "PERMISSION_NOT_SUPERADMIN";
        throw new IsmException(HisResourceManager.getString(errMsg));
    }
}

