/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.xve.server.export.a800;

import com.google.common.collect.Lists;
import com.huawei.ism.common.resourcemanager.HisResourceManager;
import com.huawei.ism.tool.obase.entity.AiDevNode;
import com.huawei.ism.tool.obase.entity.ClusterNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.util.StringUtils;
import com.huawei.ism.util.Utils;
import com.huawei.xve.entity.StepDetail;
import com.huawei.xve.entity.TaskEnv;
import com.huawei.xve.entity.a800.DataTurboParam;
import com.huawei.xve.entity.a800.DataTurboSettingInfo;
import com.huawei.xve.entity.a800.DpcClusterNode;
import com.huawei.xve.entity.a800.HisPerstatException;
import com.huawei.xve.entity.a800.QueryDpcTaskProgressResponse;
import com.huawei.xve.entity.a800.QueryTaskDetailStatus;
import com.huawei.xve.server.AbstractTask;
import com.huawei.xve.server.IStepTask;
import com.huawei.xve.server.a800.CollectRestUtils;
import com.huawei.xve.utils.DeviceInfo;
import com.huawei.xve.utils.HisPerfstatUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import utils.ThreadUtils;

public class ExportDpcFile
extends AbstractTask
implements IStepTask {
    private static final Logger log = LoggerFactory.getLogger(ExportDpcFile.class);
    private static final String EXPORT_DESC = HisResourceManager.getString("exporting.performance.files");
    private static final int MAX_ONE_BATCH_COLLECT_NODE_SIZE = 100;
    private static final int TOTAL_PROGRESS = 90;
    private final DeviceInfo deviceInfo;
    private final AiDevNode aiDevNode;
    private long taskStartTime;
    private int successBatch = 0;
    private int partSuccessBatch = 0;
    private int totalBatch;
    private boolean lastClearResult = true;
    private StringJoiner errorMsg = new StringJoiner(System.lineSeparator());

    public ExportDpcFile(TaskEnv env, double factor) {
        super(env, factor);
        this.initDetail(EXPORT_DESC);
        this.deviceInfo = env.getDeviceInfo();
        this.aiDevNode = this.deviceInfo.getDataTurboSettingInfo().getAiDevNode();
    }

    public StepDetail doTask() {
        this.init();
        this.uiDetail.running();
        try {
            this.exportPerFile();
            this.handleResult();
        }
        catch (Exception e) {
            log.error("Export perf file failed.", (Throwable)e);
            this.uiDetail.fail(HisResourceManager.getString("REST_IO_EXCEPTION"));
        }
        return this.uiDetail;
    }

    private void handleResult() {
        int failBatch = this.totalBatch - this.successBatch - this.partSuccessBatch;
        log.info("failBatch is {}, successBatch is {}, partSuccessBatch is {}", new Object[]{failBatch, this.successBatch, this.partSuccessBatch});
        if (failBatch == this.totalBatch) {
            log.error("Failed to collect DPC performance data. errorMsg is {}", (Object)this.errorMsg.toString());
            this.uiDetail.fail(this.errorMsg.toString());
            return;
        }
        if (this.totalBatch == this.successBatch && this.lastClearResult && this.totalBatch != 0) {
            log.info("The DPC performance data is collected successfully.");
            this.uiDetail.success();
            return;
        }
        log.warn("Part of the DPC performance data is collected successfully. errorMsg is {}", (Object)this.errorMsg.toString());
        this.uiDetail.partSuccess(this.errorMsg.toString());
    }

    private void exportPerFile() {
        this.uiDetail.update(0);
        DataTurboSettingInfo settingInfo = this.deviceInfo.getDataTurboSettingInfo();
        List<DpcClusterNode> selectDpcNodes = HisPerfstatUtil.getDpcSelectNodes(settingInfo);
        List dpcPartitions = Lists.partition(selectDpcNodes, (int)100);
        this.totalBatch = dpcPartitions.size();
        log.info("Start collect per file. Dme is {}, dpc num is {}, total batch is {}.", new Object[]{this.deviceInfo.getIp(), selectDpcNodes.size(), this.totalBatch});
        for (int i = 1; i <= this.totalBatch; ++i) {
            this.taskStartTime = System.currentTimeMillis();
            this.exportOneBatch(i, (List)dpcPartitions.get(i - 1), settingInfo);
            this.uiDetail.update(90 / this.totalBatch * i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportOneBatch(int currentBatch, List<DpcClusterNode> dpcNodes, DataTurboSettingInfo settingInfo) {
        StringBuilder currentErrorBuilder = new StringBuilder();
        ArrayList<String> failedDpcIds = new ArrayList<String>();
        boolean isDownload = false;
        try {
            boolean isPackSuccess = this.startPackage(currentBatch, dpcNodes, settingInfo);
            this.uiDetail.update(90 / this.totalBatch * (currentBatch - 1) + 10 / this.totalBatch);
            if (!isPackSuccess) {
                log.error("Packing the {}th batch failed.", (Object)currentBatch);
                currentErrorBuilder.append(HisResourceManager.getString("historydata.a800.export.package.dpc.failed"));
                return;
            }
            QueryTaskDetailStatus status = this.pollingQueryTask(currentErrorBuilder, currentBatch, failedDpcIds);
            this.uiDetail.update(90 / this.totalBatch * (currentBatch - 1) + 80 / this.totalBatch);
            if (status == QueryTaskDetailStatus.FAIL) {
                log.info("The {}th batch of data is packed failed.", (Object)currentBatch);
                this.clearResult(currentBatch, currentErrorBuilder);
                return;
            }
            isDownload = this.downloadPerFile(status);
            this.clearResult(currentBatch, currentErrorBuilder);
        }
        catch (ToolException e) {
            log.error("Failed to export the {}th batch of dpc performance files.", (Object)currentBatch, (Object)e);
            currentErrorBuilder.append(HisResourceManager.getString("historydata.a800.export.error"));
            this.clearResult(currentBatch, currentErrorBuilder);
        }
        catch (HisPerstatException e) {
            String errorInfo = HisPerfstatUtil.spliceErrorInfo(e);
            currentErrorBuilder.append(errorInfo);
            log.error(errorInfo);
            this.clearResult(currentBatch, currentErrorBuilder);
        }
        finally {
            if (currentErrorBuilder.length() > 0) {
                List<String> selectDpcIps = dpcNodes.stream().map(ClusterNode::getManagementIp).collect(Collectors.toList());
                this.saveErrorMsg(currentErrorBuilder, currentBatch, selectDpcIps, false);
            }
            if (isDownload && !Utils.isNullList(failedDpcIds)) {
                currentErrorBuilder.append(HisResourceManager.getString("historydata.a800.export.dpc.failed"));
                this.saveErrorMsg(currentErrorBuilder, currentBatch, failedDpcIds, true);
            }
        }
    }

    private void clearResult(int currentBatch, StringBuilder errMsg) {
        try {
            boolean isClear = CollectRestUtils.clearDpcPerformanceFiles(this.aiDevNode);
            if (isClear) {
                log.info("Succeeded in clearing the {}th batch of performance files.", (Object)currentBatch);
                return;
            }
            log.error("Failed to clear DPC performance files. currentBatch is {}", (Object)currentBatch);
            if (currentBatch == this.totalBatch) {
                this.lastClearResult = false;
                errMsg.append(HisResourceManager.getString("historydata.a800.export.clear.dpc.error"));
            }
        }
        catch (ToolException e) {
            log.error("Failed to clear DPC performance files.", (Throwable)e);
            if (currentBatch == this.totalBatch) {
                this.lastClearResult = false;
                errMsg.append(HisResourceManager.getString("historydata.a800.export.clear.dpc.error"));
            }
        }
        catch (HisPerstatException e) {
            String errorInfo = HisPerfstatUtil.spliceErrorInfo(e);
            if (currentBatch == this.totalBatch) {
                this.lastClearResult = false;
                errMsg.append(e);
            }
            log.error(errorInfo);
        }
    }

    private boolean downloadPerFile(QueryTaskDetailStatus status) throws HisPerstatException, ToolException {
        boolean isDownload = CollectRestUtils.downloadDpcPerformanceFiles(this.aiDevNode, this.env.getDpcResultDir());
        if (!isDownload) {
            log.error("Failed to download the DPC performance data.");
            return false;
        }
        if (status == QueryTaskDetailStatus.SUCCESS) {
            log.info("The DPC performance file is collected successfully.");
            ++this.successBatch;
            return true;
        }
        log.info("Part of the DPC performance files are successfully collected.");
        ++this.partSuccessBatch;
        return true;
    }

    private QueryTaskDetailStatus pollingQueryTask(StringBuilder errMsg, int currentBatch, List<String> failedDpcIds) throws HisPerstatException, ToolException {
        int progress;
        do {
            ThreadUtils.sleepSeconds((long)30L);
            QueryDpcTaskProgressResponse response = CollectRestUtils.queryDpcPerformanceFilesTask(this.aiDevNode);
            progress = response.getProgress();
            this.uiDetail.update(90 / this.totalBatch * (currentBatch - 1) + (10 + 6 * progress / 100) / this.totalBatch);
            if (progress == 100 && !StringUtils.isNULLStr(response.getChecksum())) {
                log.info("The DPC performance data is packaged successfully.");
                failedDpcIds.addAll(response.getFailedDpcIds());
                if (Utils.isNullList(failedDpcIds)) {
                    return QueryTaskDetailStatus.SUCCESS;
                }
                log.error("failed dpc ids: {}", failedDpcIds);
                return QueryTaskDetailStatus.PART_SUCCESS;
            }
            if (progress != 100 || !StringUtils.isNULLStr(response.getChecksum())) continue;
            log.error("Failed to pack DPC performance data.");
            errMsg.append(HisResourceManager.getString("historydata.a800.export.dpc.failed"));
            return QueryTaskDetailStatus.FAIL;
        } while (System.currentTimeMillis() - this.taskStartTime <= HisPerfstatUtil.QUERY_DETAIL_OVERTIME_MILLS);
        log.error("Collect dpc performance files timed out. progress is {}.", (Object)progress);
        errMsg.append(HisResourceManager.getString("historydata.a800.export.time.out.error"));
        return QueryTaskDetailStatus.FAIL;
    }

    private boolean startPackage(int currentBatch, List<DpcClusterNode> dpcNodes, DataTurboSettingInfo settingInfo) throws ToolException, HisPerstatException {
        String start = settingInfo.getStartTime().format(HisPerfstatUtil.DATE_TIME_FORMATTER_YMD);
        String end = settingInfo.getEndTime().format(HisPerfstatUtil.DATE_TIME_FORMATTER_YMD);
        List<String> dpcIds = this.getDpcIds(dpcNodes);
        log.info("Start packing the {}th batch. start is {}, end is {}, dpc ids are {}.", new Object[]{currentBatch, start, end, dpcIds});
        return CollectRestUtils.packDpcPerformanceFiles(this.aiDevNode, new DataTurboParam(dpcIds, start, end));
    }

    private List<String> getDpcIds(List<DpcClusterNode> dpcNodes) {
        return dpcNodes.stream().map(DpcClusterNode::getDpcNodeId).collect(Collectors.toList());
    }

    private void saveErrorMsg(StringBuilder currentErrorBuilder, int currentBatch, List<String> dpcNodes, boolean isPartSuccess) {
        log.error("The information collected in the {}th batch is incomplete. Error msg: {}. Failed DPC nodes are {}.", new Object[]{currentBatch, currentErrorBuilder, dpcNodes});
        this.errorMsg.add(HisResourceManager.getStringWithParams(this.getDescription(isPartSuccess), dpcNodes));
        this.errorMsg.add(HisResourceManager.getString("historydata.a800.export.dpc.failed.title") + currentErrorBuilder.toString());
        this.errorMsg.add("");
    }

    private String getDescription(boolean isPartSuccess) {
        return isPartSuccess ? "historydata.a800.export.dpc.id.batch" : "historydata.a800.export.dpc.batch";
    }
}

